/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.financialservices.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.financialservices.v1.AMLSettings;
import com.google.cloud.financialservices.v1.BacktestResult;
import com.google.cloud.financialservices.v1.BacktestResultName;
import com.google.cloud.financialservices.v1.BigQueryDestination;
import com.google.cloud.financialservices.v1.CreateBacktestResultRequest;
import com.google.cloud.financialservices.v1.CreateDatasetRequest;
import com.google.cloud.financialservices.v1.CreateEngineConfigRequest;
import com.google.cloud.financialservices.v1.CreateInstanceRequest;
import com.google.cloud.financialservices.v1.CreateModelRequest;
import com.google.cloud.financialservices.v1.CreatePredictionResultRequest;
import com.google.cloud.financialservices.v1.Dataset;
import com.google.cloud.financialservices.v1.DatasetName;
import com.google.cloud.financialservices.v1.DeleteBacktestResultRequest;
import com.google.cloud.financialservices.v1.DeleteDatasetRequest;
import com.google.cloud.financialservices.v1.DeleteEngineConfigRequest;
import com.google.cloud.financialservices.v1.DeleteInstanceRequest;
import com.google.cloud.financialservices.v1.DeleteModelRequest;
import com.google.cloud.financialservices.v1.DeletePredictionResultRequest;
import com.google.cloud.financialservices.v1.EngineConfig;
import com.google.cloud.financialservices.v1.EngineConfigName;
import com.google.cloud.financialservices.v1.EngineVersion;
import com.google.cloud.financialservices.v1.EngineVersionName;
import com.google.cloud.financialservices.v1.ExportBacktestResultMetadataRequest;
import com.google.cloud.financialservices.v1.ExportBacktestResultMetadataResponse;
import com.google.cloud.financialservices.v1.ExportEngineConfigMetadataRequest;
import com.google.cloud.financialservices.v1.ExportEngineConfigMetadataResponse;
import com.google.cloud.financialservices.v1.ExportModelMetadataRequest;
import com.google.cloud.financialservices.v1.ExportModelMetadataResponse;
import com.google.cloud.financialservices.v1.ExportPredictionResultMetadataRequest;
import com.google.cloud.financialservices.v1.ExportPredictionResultMetadataResponse;
import com.google.cloud.financialservices.v1.ExportRegisteredPartiesRequest;
import com.google.cloud.financialservices.v1.ExportRegisteredPartiesResponse;
import com.google.cloud.financialservices.v1.GetBacktestResultRequest;
import com.google.cloud.financialservices.v1.GetDatasetRequest;
import com.google.cloud.financialservices.v1.GetEngineConfigRequest;
import com.google.cloud.financialservices.v1.GetEngineVersionRequest;
import com.google.cloud.financialservices.v1.GetInstanceRequest;
import com.google.cloud.financialservices.v1.GetModelRequest;
import com.google.cloud.financialservices.v1.GetPredictionResultRequest;
import com.google.cloud.financialservices.v1.ImportRegisteredPartiesRequest;
import com.google.cloud.financialservices.v1.ImportRegisteredPartiesResponse;
import com.google.cloud.financialservices.v1.Instance;
import com.google.cloud.financialservices.v1.InstanceName;
import com.google.cloud.financialservices.v1.LineOfBusiness;
import com.google.cloud.financialservices.v1.ListBacktestResultsRequest;
import com.google.cloud.financialservices.v1.ListBacktestResultsResponse;
import com.google.cloud.financialservices.v1.ListDatasetsRequest;
import com.google.cloud.financialservices.v1.ListDatasetsResponse;
import com.google.cloud.financialservices.v1.ListEngineConfigsRequest;
import com.google.cloud.financialservices.v1.ListEngineConfigsResponse;
import com.google.cloud.financialservices.v1.ListEngineVersionsRequest;
import com.google.cloud.financialservices.v1.ListEngineVersionsResponse;
import com.google.cloud.financialservices.v1.ListInstancesRequest;
import com.google.cloud.financialservices.v1.ListInstancesResponse;
import com.google.cloud.financialservices.v1.ListModelsRequest;
import com.google.cloud.financialservices.v1.ListModelsResponse;
import com.google.cloud.financialservices.v1.ListPredictionResultsRequest;
import com.google.cloud.financialservices.v1.ListPredictionResultsResponse;
import com.google.cloud.financialservices.v1.LocationName;
import com.google.cloud.financialservices.v1.Model;
import com.google.cloud.financialservices.v1.ModelName;
import com.google.cloud.financialservices.v1.OperationMetadata;
import com.google.cloud.financialservices.v1.PredictionResult;
import com.google.cloud.financialservices.v1.PredictionResultName;
import com.google.cloud.financialservices.v1.UpdateBacktestResultRequest;
import com.google.cloud.financialservices.v1.UpdateDatasetRequest;
import com.google.cloud.financialservices.v1.UpdateEngineConfigRequest;
import com.google.cloud.financialservices.v1.UpdateInstanceRequest;
import com.google.cloud.financialservices.v1.UpdateModelRequest;
import com.google.cloud.financialservices.v1.UpdatePredictionResultRequest;
import com.google.cloud.financialservices.v1.stub.AMLStub;
import com.google.cloud.financialservices.v1.stub.AMLStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AMLClient
implements BackgroundResource {
    private final AMLSettings settings;
    private final AMLStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final AMLClient create() throws IOException {
        return AMLClient.create(AMLSettings.newBuilder().build());
    }

    public static final AMLClient create(AMLSettings settings) throws IOException {
        return new AMLClient(settings);
    }

    public static final AMLClient create(AMLStub stub) {
        return new AMLClient(stub);
    }

    protected AMLClient(AMLSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AMLStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected AMLClient(AMLStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final AMLSettings getSettings() {
        return this.settings;
    }

    public AMLStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListInstancesPagedResponse listInstances(LocationName parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(String parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(ListInstancesRequest request) {
        return (ListInstancesPagedResponse)((Object)this.listInstancesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.stub.listInstancesPagedCallable();
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.stub.listInstancesCallable();
    }

    public final Instance getInstance(InstanceName name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(String name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(GetInstanceRequest request) {
        return (Instance)this.getInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.stub.getInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> createInstanceAsync(LocationName parent, Instance instance, String instanceId) {
        CreateInstanceRequest request = CreateInstanceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setInstance(instance).setInstanceId(instanceId).build();
        return this.createInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> createInstanceAsync(String parent, Instance instance, String instanceId) {
        CreateInstanceRequest request = CreateInstanceRequest.newBuilder().setParent(parent).setInstance(instance).setInstanceId(instanceId).build();
        return this.createInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> createInstanceAsync(CreateInstanceRequest request) {
        return this.createInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationCallable() {
        return this.stub.createInstanceOperationCallable();
    }

    public final UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable() {
        return this.stub.createInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> updateInstanceAsync(Instance instance, FieldMask updateMask) {
        UpdateInstanceRequest request = UpdateInstanceRequest.newBuilder().setInstance(instance).setUpdateMask(updateMask).build();
        return this.updateInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> updateInstanceAsync(UpdateInstanceRequest request) {
        return this.updateInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationCallable() {
        return this.stub.updateInstanceOperationCallable();
    }

    public final UnaryCallable<UpdateInstanceRequest, Operation> updateInstanceCallable() {
        return this.stub.updateInstanceCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInstanceAsync(InstanceName name) {
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteInstanceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInstanceAsync(String name) {
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(name).build();
        return this.deleteInstanceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInstanceAsync(DeleteInstanceRequest request) {
        return this.deleteInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationCallable() {
        return this.stub.deleteInstanceOperationCallable();
    }

    public final UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable() {
        return this.stub.deleteInstanceCallable();
    }

    public final OperationFuture<ImportRegisteredPartiesResponse, OperationMetadata> importRegisteredPartiesAsync(InstanceName name, ImportRegisteredPartiesRequest.UpdateMode mode, LineOfBusiness lineOfBusiness, List<String> partyTables) {
        ImportRegisteredPartiesRequest request = ImportRegisteredPartiesRequest.newBuilder().setName(name == null ? null : name.toString()).setMode(mode).setLineOfBusiness(lineOfBusiness).addAllPartyTables(partyTables).build();
        return this.importRegisteredPartiesAsync(request);
    }

    public final OperationFuture<ImportRegisteredPartiesResponse, OperationMetadata> importRegisteredPartiesAsync(String name, ImportRegisteredPartiesRequest.UpdateMode mode, LineOfBusiness lineOfBusiness, List<String> partyTables) {
        ImportRegisteredPartiesRequest request = ImportRegisteredPartiesRequest.newBuilder().setName(name).setMode(mode).setLineOfBusiness(lineOfBusiness).addAllPartyTables(partyTables).build();
        return this.importRegisteredPartiesAsync(request);
    }

    public final OperationFuture<ImportRegisteredPartiesResponse, OperationMetadata> importRegisteredPartiesAsync(ImportRegisteredPartiesRequest request) {
        return this.importRegisteredPartiesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportRegisteredPartiesRequest, ImportRegisteredPartiesResponse, OperationMetadata> importRegisteredPartiesOperationCallable() {
        return this.stub.importRegisteredPartiesOperationCallable();
    }

    public final UnaryCallable<ImportRegisteredPartiesRequest, Operation> importRegisteredPartiesCallable() {
        return this.stub.importRegisteredPartiesCallable();
    }

    public final OperationFuture<ExportRegisteredPartiesResponse, OperationMetadata> exportRegisteredPartiesAsync(InstanceName name, BigQueryDestination dataset, LineOfBusiness lineOfBusiness) {
        ExportRegisteredPartiesRequest request = ExportRegisteredPartiesRequest.newBuilder().setName(name == null ? null : name.toString()).setDataset(dataset).setLineOfBusiness(lineOfBusiness).build();
        return this.exportRegisteredPartiesAsync(request);
    }

    public final OperationFuture<ExportRegisteredPartiesResponse, OperationMetadata> exportRegisteredPartiesAsync(String name, BigQueryDestination dataset, LineOfBusiness lineOfBusiness) {
        ExportRegisteredPartiesRequest request = ExportRegisteredPartiesRequest.newBuilder().setName(name).setDataset(dataset).setLineOfBusiness(lineOfBusiness).build();
        return this.exportRegisteredPartiesAsync(request);
    }

    public final OperationFuture<ExportRegisteredPartiesResponse, OperationMetadata> exportRegisteredPartiesAsync(ExportRegisteredPartiesRequest request) {
        return this.exportRegisteredPartiesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportRegisteredPartiesRequest, ExportRegisteredPartiesResponse, OperationMetadata> exportRegisteredPartiesOperationCallable() {
        return this.stub.exportRegisteredPartiesOperationCallable();
    }

    public final UnaryCallable<ExportRegisteredPartiesRequest, Operation> exportRegisteredPartiesCallable() {
        return this.stub.exportRegisteredPartiesCallable();
    }

    public final ListDatasetsPagedResponse listDatasets(InstanceName parent) {
        ListDatasetsRequest request = ListDatasetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDatasets(request);
    }

    public final ListDatasetsPagedResponse listDatasets(String parent) {
        ListDatasetsRequest request = ListDatasetsRequest.newBuilder().setParent(parent).build();
        return this.listDatasets(request);
    }

    public final ListDatasetsPagedResponse listDatasets(ListDatasetsRequest request) {
        return (ListDatasetsPagedResponse)((Object)this.listDatasetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDatasetsRequest, ListDatasetsPagedResponse> listDatasetsPagedCallable() {
        return this.stub.listDatasetsPagedCallable();
    }

    public final UnaryCallable<ListDatasetsRequest, ListDatasetsResponse> listDatasetsCallable() {
        return this.stub.listDatasetsCallable();
    }

    public final Dataset getDataset(DatasetName name) {
        GetDatasetRequest request = GetDatasetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDataset(request);
    }

    public final Dataset getDataset(String name) {
        GetDatasetRequest request = GetDatasetRequest.newBuilder().setName(name).build();
        return this.getDataset(request);
    }

    public final Dataset getDataset(GetDatasetRequest request) {
        return (Dataset)this.getDatasetCallable().call((Object)request);
    }

    public final UnaryCallable<GetDatasetRequest, Dataset> getDatasetCallable() {
        return this.stub.getDatasetCallable();
    }

    public final OperationFuture<Dataset, OperationMetadata> createDatasetAsync(InstanceName parent, Dataset dataset, String datasetId) {
        CreateDatasetRequest request = CreateDatasetRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDataset(dataset).setDatasetId(datasetId).build();
        return this.createDatasetAsync(request);
    }

    public final OperationFuture<Dataset, OperationMetadata> createDatasetAsync(String parent, Dataset dataset, String datasetId) {
        CreateDatasetRequest request = CreateDatasetRequest.newBuilder().setParent(parent).setDataset(dataset).setDatasetId(datasetId).build();
        return this.createDatasetAsync(request);
    }

    public final OperationFuture<Dataset, OperationMetadata> createDatasetAsync(CreateDatasetRequest request) {
        return this.createDatasetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateDatasetRequest, Dataset, OperationMetadata> createDatasetOperationCallable() {
        return this.stub.createDatasetOperationCallable();
    }

    public final UnaryCallable<CreateDatasetRequest, Operation> createDatasetCallable() {
        return this.stub.createDatasetCallable();
    }

    public final OperationFuture<Dataset, OperationMetadata> updateDatasetAsync(Dataset dataset, FieldMask updateMask) {
        UpdateDatasetRequest request = UpdateDatasetRequest.newBuilder().setDataset(dataset).setUpdateMask(updateMask).build();
        return this.updateDatasetAsync(request);
    }

    public final OperationFuture<Dataset, OperationMetadata> updateDatasetAsync(UpdateDatasetRequest request) {
        return this.updateDatasetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateDatasetRequest, Dataset, OperationMetadata> updateDatasetOperationCallable() {
        return this.stub.updateDatasetOperationCallable();
    }

    public final UnaryCallable<UpdateDatasetRequest, Operation> updateDatasetCallable() {
        return this.stub.updateDatasetCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDatasetAsync(DatasetName name) {
        DeleteDatasetRequest request = DeleteDatasetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDatasetAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDatasetAsync(String name) {
        DeleteDatasetRequest request = DeleteDatasetRequest.newBuilder().setName(name).build();
        return this.deleteDatasetAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDatasetAsync(DeleteDatasetRequest request) {
        return this.deleteDatasetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteDatasetRequest, Empty, OperationMetadata> deleteDatasetOperationCallable() {
        return this.stub.deleteDatasetOperationCallable();
    }

    public final UnaryCallable<DeleteDatasetRequest, Operation> deleteDatasetCallable() {
        return this.stub.deleteDatasetCallable();
    }

    public final ListModelsPagedResponse listModels(InstanceName parent) {
        ListModelsRequest request = ListModelsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listModels(request);
    }

    public final ListModelsPagedResponse listModels(String parent) {
        ListModelsRequest request = ListModelsRequest.newBuilder().setParent(parent).build();
        return this.listModels(request);
    }

    public final ListModelsPagedResponse listModels(ListModelsRequest request) {
        return (ListModelsPagedResponse)((Object)this.listModelsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListModelsRequest, ListModelsPagedResponse> listModelsPagedCallable() {
        return this.stub.listModelsPagedCallable();
    }

    public final UnaryCallable<ListModelsRequest, ListModelsResponse> listModelsCallable() {
        return this.stub.listModelsCallable();
    }

    public final Model getModel(ModelName name) {
        GetModelRequest request = GetModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getModel(request);
    }

    public final Model getModel(String name) {
        GetModelRequest request = GetModelRequest.newBuilder().setName(name).build();
        return this.getModel(request);
    }

    public final Model getModel(GetModelRequest request) {
        return (Model)this.getModelCallable().call((Object)request);
    }

    public final UnaryCallable<GetModelRequest, Model> getModelCallable() {
        return this.stub.getModelCallable();
    }

    public final OperationFuture<Model, OperationMetadata> createModelAsync(InstanceName parent, Model model, String modelId) {
        CreateModelRequest request = CreateModelRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setModel(model).setModelId(modelId).build();
        return this.createModelAsync(request);
    }

    public final OperationFuture<Model, OperationMetadata> createModelAsync(String parent, Model model, String modelId) {
        CreateModelRequest request = CreateModelRequest.newBuilder().setParent(parent).setModel(model).setModelId(modelId).build();
        return this.createModelAsync(request);
    }

    public final OperationFuture<Model, OperationMetadata> createModelAsync(CreateModelRequest request) {
        return this.createModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateModelRequest, Model, OperationMetadata> createModelOperationCallable() {
        return this.stub.createModelOperationCallable();
    }

    public final UnaryCallable<CreateModelRequest, Operation> createModelCallable() {
        return this.stub.createModelCallable();
    }

    public final OperationFuture<Model, OperationMetadata> updateModelAsync(Model model, FieldMask updateMask) {
        UpdateModelRequest request = UpdateModelRequest.newBuilder().setModel(model).setUpdateMask(updateMask).build();
        return this.updateModelAsync(request);
    }

    public final OperationFuture<Model, OperationMetadata> updateModelAsync(UpdateModelRequest request) {
        return this.updateModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateModelRequest, Model, OperationMetadata> updateModelOperationCallable() {
        return this.stub.updateModelOperationCallable();
    }

    public final UnaryCallable<UpdateModelRequest, Operation> updateModelCallable() {
        return this.stub.updateModelCallable();
    }

    public final OperationFuture<ExportModelMetadataResponse, OperationMetadata> exportModelMetadataAsync(ModelName model, BigQueryDestination structuredMetadataDestination) {
        ExportModelMetadataRequest request = ExportModelMetadataRequest.newBuilder().setModel(model == null ? null : model.toString()).setStructuredMetadataDestination(structuredMetadataDestination).build();
        return this.exportModelMetadataAsync(request);
    }

    public final OperationFuture<ExportModelMetadataResponse, OperationMetadata> exportModelMetadataAsync(String model, BigQueryDestination structuredMetadataDestination) {
        ExportModelMetadataRequest request = ExportModelMetadataRequest.newBuilder().setModel(model).setStructuredMetadataDestination(structuredMetadataDestination).build();
        return this.exportModelMetadataAsync(request);
    }

    public final OperationFuture<ExportModelMetadataResponse, OperationMetadata> exportModelMetadataAsync(ExportModelMetadataRequest request) {
        return this.exportModelMetadataOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportModelMetadataRequest, ExportModelMetadataResponse, OperationMetadata> exportModelMetadataOperationCallable() {
        return this.stub.exportModelMetadataOperationCallable();
    }

    public final UnaryCallable<ExportModelMetadataRequest, Operation> exportModelMetadataCallable() {
        return this.stub.exportModelMetadataCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteModelAsync(ModelName name) {
        DeleteModelRequest request = DeleteModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteModelAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteModelAsync(String name) {
        DeleteModelRequest request = DeleteModelRequest.newBuilder().setName(name).build();
        return this.deleteModelAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteModelAsync(DeleteModelRequest request) {
        return this.deleteModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteModelRequest, Empty, OperationMetadata> deleteModelOperationCallable() {
        return this.stub.deleteModelOperationCallable();
    }

    public final UnaryCallable<DeleteModelRequest, Operation> deleteModelCallable() {
        return this.stub.deleteModelCallable();
    }

    public final ListEngineConfigsPagedResponse listEngineConfigs(InstanceName parent) {
        ListEngineConfigsRequest request = ListEngineConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEngineConfigs(request);
    }

    public final ListEngineConfigsPagedResponse listEngineConfigs(String parent) {
        ListEngineConfigsRequest request = ListEngineConfigsRequest.newBuilder().setParent(parent).build();
        return this.listEngineConfigs(request);
    }

    public final ListEngineConfigsPagedResponse listEngineConfigs(ListEngineConfigsRequest request) {
        return (ListEngineConfigsPagedResponse)((Object)this.listEngineConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEngineConfigsRequest, ListEngineConfigsPagedResponse> listEngineConfigsPagedCallable() {
        return this.stub.listEngineConfigsPagedCallable();
    }

    public final UnaryCallable<ListEngineConfigsRequest, ListEngineConfigsResponse> listEngineConfigsCallable() {
        return this.stub.listEngineConfigsCallable();
    }

    public final EngineConfig getEngineConfig(EngineConfigName name) {
        GetEngineConfigRequest request = GetEngineConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEngineConfig(request);
    }

    public final EngineConfig getEngineConfig(String name) {
        GetEngineConfigRequest request = GetEngineConfigRequest.newBuilder().setName(name).build();
        return this.getEngineConfig(request);
    }

    public final EngineConfig getEngineConfig(GetEngineConfigRequest request) {
        return (EngineConfig)this.getEngineConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetEngineConfigRequest, EngineConfig> getEngineConfigCallable() {
        return this.stub.getEngineConfigCallable();
    }

    public final OperationFuture<EngineConfig, OperationMetadata> createEngineConfigAsync(InstanceName parent, EngineConfig engineConfig, String engineConfigId) {
        CreateEngineConfigRequest request = CreateEngineConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEngineConfig(engineConfig).setEngineConfigId(engineConfigId).build();
        return this.createEngineConfigAsync(request);
    }

    public final OperationFuture<EngineConfig, OperationMetadata> createEngineConfigAsync(String parent, EngineConfig engineConfig, String engineConfigId) {
        CreateEngineConfigRequest request = CreateEngineConfigRequest.newBuilder().setParent(parent).setEngineConfig(engineConfig).setEngineConfigId(engineConfigId).build();
        return this.createEngineConfigAsync(request);
    }

    public final OperationFuture<EngineConfig, OperationMetadata> createEngineConfigAsync(CreateEngineConfigRequest request) {
        return this.createEngineConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateEngineConfigRequest, EngineConfig, OperationMetadata> createEngineConfigOperationCallable() {
        return this.stub.createEngineConfigOperationCallable();
    }

    public final UnaryCallable<CreateEngineConfigRequest, Operation> createEngineConfigCallable() {
        return this.stub.createEngineConfigCallable();
    }

    public final OperationFuture<EngineConfig, OperationMetadata> updateEngineConfigAsync(EngineConfig engineConfig, FieldMask updateMask) {
        UpdateEngineConfigRequest request = UpdateEngineConfigRequest.newBuilder().setEngineConfig(engineConfig).setUpdateMask(updateMask).build();
        return this.updateEngineConfigAsync(request);
    }

    public final OperationFuture<EngineConfig, OperationMetadata> updateEngineConfigAsync(UpdateEngineConfigRequest request) {
        return this.updateEngineConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateEngineConfigRequest, EngineConfig, OperationMetadata> updateEngineConfigOperationCallable() {
        return this.stub.updateEngineConfigOperationCallable();
    }

    public final UnaryCallable<UpdateEngineConfigRequest, Operation> updateEngineConfigCallable() {
        return this.stub.updateEngineConfigCallable();
    }

    public final OperationFuture<ExportEngineConfigMetadataResponse, OperationMetadata> exportEngineConfigMetadataAsync(EngineConfigName engineConfig, BigQueryDestination structuredMetadataDestination) {
        ExportEngineConfigMetadataRequest request = ExportEngineConfigMetadataRequest.newBuilder().setEngineConfig(engineConfig == null ? null : engineConfig.toString()).setStructuredMetadataDestination(structuredMetadataDestination).build();
        return this.exportEngineConfigMetadataAsync(request);
    }

    public final OperationFuture<ExportEngineConfigMetadataResponse, OperationMetadata> exportEngineConfigMetadataAsync(String engineConfig, BigQueryDestination structuredMetadataDestination) {
        ExportEngineConfigMetadataRequest request = ExportEngineConfigMetadataRequest.newBuilder().setEngineConfig(engineConfig).setStructuredMetadataDestination(structuredMetadataDestination).build();
        return this.exportEngineConfigMetadataAsync(request);
    }

    public final OperationFuture<ExportEngineConfigMetadataResponse, OperationMetadata> exportEngineConfigMetadataAsync(ExportEngineConfigMetadataRequest request) {
        return this.exportEngineConfigMetadataOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportEngineConfigMetadataRequest, ExportEngineConfigMetadataResponse, OperationMetadata> exportEngineConfigMetadataOperationCallable() {
        return this.stub.exportEngineConfigMetadataOperationCallable();
    }

    public final UnaryCallable<ExportEngineConfigMetadataRequest, Operation> exportEngineConfigMetadataCallable() {
        return this.stub.exportEngineConfigMetadataCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEngineConfigAsync(EngineConfigName name) {
        DeleteEngineConfigRequest request = DeleteEngineConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteEngineConfigAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEngineConfigAsync(String name) {
        DeleteEngineConfigRequest request = DeleteEngineConfigRequest.newBuilder().setName(name).build();
        return this.deleteEngineConfigAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEngineConfigAsync(DeleteEngineConfigRequest request) {
        return this.deleteEngineConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteEngineConfigRequest, Empty, OperationMetadata> deleteEngineConfigOperationCallable() {
        return this.stub.deleteEngineConfigOperationCallable();
    }

    public final UnaryCallable<DeleteEngineConfigRequest, Operation> deleteEngineConfigCallable() {
        return this.stub.deleteEngineConfigCallable();
    }

    public final EngineVersion getEngineVersion(EngineVersionName name) {
        GetEngineVersionRequest request = GetEngineVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEngineVersion(request);
    }

    public final EngineVersion getEngineVersion(String name) {
        GetEngineVersionRequest request = GetEngineVersionRequest.newBuilder().setName(name).build();
        return this.getEngineVersion(request);
    }

    public final EngineVersion getEngineVersion(GetEngineVersionRequest request) {
        return (EngineVersion)this.getEngineVersionCallable().call((Object)request);
    }

    public final UnaryCallable<GetEngineVersionRequest, EngineVersion> getEngineVersionCallable() {
        return this.stub.getEngineVersionCallable();
    }

    public final ListEngineVersionsPagedResponse listEngineVersions(InstanceName parent) {
        ListEngineVersionsRequest request = ListEngineVersionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEngineVersions(request);
    }

    public final ListEngineVersionsPagedResponse listEngineVersions(String parent) {
        ListEngineVersionsRequest request = ListEngineVersionsRequest.newBuilder().setParent(parent).build();
        return this.listEngineVersions(request);
    }

    public final ListEngineVersionsPagedResponse listEngineVersions(ListEngineVersionsRequest request) {
        return (ListEngineVersionsPagedResponse)((Object)this.listEngineVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEngineVersionsRequest, ListEngineVersionsPagedResponse> listEngineVersionsPagedCallable() {
        return this.stub.listEngineVersionsPagedCallable();
    }

    public final UnaryCallable<ListEngineVersionsRequest, ListEngineVersionsResponse> listEngineVersionsCallable() {
        return this.stub.listEngineVersionsCallable();
    }

    public final ListPredictionResultsPagedResponse listPredictionResults(InstanceName parent) {
        ListPredictionResultsRequest request = ListPredictionResultsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPredictionResults(request);
    }

    public final ListPredictionResultsPagedResponse listPredictionResults(String parent) {
        ListPredictionResultsRequest request = ListPredictionResultsRequest.newBuilder().setParent(parent).build();
        return this.listPredictionResults(request);
    }

    public final ListPredictionResultsPagedResponse listPredictionResults(ListPredictionResultsRequest request) {
        return (ListPredictionResultsPagedResponse)((Object)this.listPredictionResultsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPredictionResultsRequest, ListPredictionResultsPagedResponse> listPredictionResultsPagedCallable() {
        return this.stub.listPredictionResultsPagedCallable();
    }

    public final UnaryCallable<ListPredictionResultsRequest, ListPredictionResultsResponse> listPredictionResultsCallable() {
        return this.stub.listPredictionResultsCallable();
    }

    public final PredictionResult getPredictionResult(PredictionResultName name) {
        GetPredictionResultRequest request = GetPredictionResultRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPredictionResult(request);
    }

    public final PredictionResult getPredictionResult(String name) {
        GetPredictionResultRequest request = GetPredictionResultRequest.newBuilder().setName(name).build();
        return this.getPredictionResult(request);
    }

    public final PredictionResult getPredictionResult(GetPredictionResultRequest request) {
        return (PredictionResult)this.getPredictionResultCallable().call((Object)request);
    }

    public final UnaryCallable<GetPredictionResultRequest, PredictionResult> getPredictionResultCallable() {
        return this.stub.getPredictionResultCallable();
    }

    public final OperationFuture<PredictionResult, OperationMetadata> createPredictionResultAsync(InstanceName parent, PredictionResult predictionResult, String predictionResultId) {
        CreatePredictionResultRequest request = CreatePredictionResultRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPredictionResult(predictionResult).setPredictionResultId(predictionResultId).build();
        return this.createPredictionResultAsync(request);
    }

    public final OperationFuture<PredictionResult, OperationMetadata> createPredictionResultAsync(String parent, PredictionResult predictionResult, String predictionResultId) {
        CreatePredictionResultRequest request = CreatePredictionResultRequest.newBuilder().setParent(parent).setPredictionResult(predictionResult).setPredictionResultId(predictionResultId).build();
        return this.createPredictionResultAsync(request);
    }

    public final OperationFuture<PredictionResult, OperationMetadata> createPredictionResultAsync(CreatePredictionResultRequest request) {
        return this.createPredictionResultOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreatePredictionResultRequest, PredictionResult, OperationMetadata> createPredictionResultOperationCallable() {
        return this.stub.createPredictionResultOperationCallable();
    }

    public final UnaryCallable<CreatePredictionResultRequest, Operation> createPredictionResultCallable() {
        return this.stub.createPredictionResultCallable();
    }

    public final OperationFuture<PredictionResult, OperationMetadata> updatePredictionResultAsync(PredictionResult predictionResult, FieldMask updateMask) {
        UpdatePredictionResultRequest request = UpdatePredictionResultRequest.newBuilder().setPredictionResult(predictionResult).setUpdateMask(updateMask).build();
        return this.updatePredictionResultAsync(request);
    }

    public final OperationFuture<PredictionResult, OperationMetadata> updatePredictionResultAsync(UpdatePredictionResultRequest request) {
        return this.updatePredictionResultOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdatePredictionResultRequest, PredictionResult, OperationMetadata> updatePredictionResultOperationCallable() {
        return this.stub.updatePredictionResultOperationCallable();
    }

    public final UnaryCallable<UpdatePredictionResultRequest, Operation> updatePredictionResultCallable() {
        return this.stub.updatePredictionResultCallable();
    }

    public final OperationFuture<ExportPredictionResultMetadataResponse, OperationMetadata> exportPredictionResultMetadataAsync(PredictionResultName predictionResult, BigQueryDestination structuredMetadataDestination) {
        ExportPredictionResultMetadataRequest request = ExportPredictionResultMetadataRequest.newBuilder().setPredictionResult(predictionResult == null ? null : predictionResult.toString()).setStructuredMetadataDestination(structuredMetadataDestination).build();
        return this.exportPredictionResultMetadataAsync(request);
    }

    public final OperationFuture<ExportPredictionResultMetadataResponse, OperationMetadata> exportPredictionResultMetadataAsync(String predictionResult, BigQueryDestination structuredMetadataDestination) {
        ExportPredictionResultMetadataRequest request = ExportPredictionResultMetadataRequest.newBuilder().setPredictionResult(predictionResult).setStructuredMetadataDestination(structuredMetadataDestination).build();
        return this.exportPredictionResultMetadataAsync(request);
    }

    public final OperationFuture<ExportPredictionResultMetadataResponse, OperationMetadata> exportPredictionResultMetadataAsync(ExportPredictionResultMetadataRequest request) {
        return this.exportPredictionResultMetadataOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportPredictionResultMetadataRequest, ExportPredictionResultMetadataResponse, OperationMetadata> exportPredictionResultMetadataOperationCallable() {
        return this.stub.exportPredictionResultMetadataOperationCallable();
    }

    public final UnaryCallable<ExportPredictionResultMetadataRequest, Operation> exportPredictionResultMetadataCallable() {
        return this.stub.exportPredictionResultMetadataCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deletePredictionResultAsync(PredictionResultName name) {
        DeletePredictionResultRequest request = DeletePredictionResultRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deletePredictionResultAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePredictionResultAsync(String name) {
        DeletePredictionResultRequest request = DeletePredictionResultRequest.newBuilder().setName(name).build();
        return this.deletePredictionResultAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePredictionResultAsync(DeletePredictionResultRequest request) {
        return this.deletePredictionResultOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeletePredictionResultRequest, Empty, OperationMetadata> deletePredictionResultOperationCallable() {
        return this.stub.deletePredictionResultOperationCallable();
    }

    public final UnaryCallable<DeletePredictionResultRequest, Operation> deletePredictionResultCallable() {
        return this.stub.deletePredictionResultCallable();
    }

    public final ListBacktestResultsPagedResponse listBacktestResults(InstanceName parent) {
        ListBacktestResultsRequest request = ListBacktestResultsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBacktestResults(request);
    }

    public final ListBacktestResultsPagedResponse listBacktestResults(String parent) {
        ListBacktestResultsRequest request = ListBacktestResultsRequest.newBuilder().setParent(parent).build();
        return this.listBacktestResults(request);
    }

    public final ListBacktestResultsPagedResponse listBacktestResults(ListBacktestResultsRequest request) {
        return (ListBacktestResultsPagedResponse)((Object)this.listBacktestResultsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBacktestResultsRequest, ListBacktestResultsPagedResponse> listBacktestResultsPagedCallable() {
        return this.stub.listBacktestResultsPagedCallable();
    }

    public final UnaryCallable<ListBacktestResultsRequest, ListBacktestResultsResponse> listBacktestResultsCallable() {
        return this.stub.listBacktestResultsCallable();
    }

    public final BacktestResult getBacktestResult(BacktestResultName name) {
        GetBacktestResultRequest request = GetBacktestResultRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBacktestResult(request);
    }

    public final BacktestResult getBacktestResult(String name) {
        GetBacktestResultRequest request = GetBacktestResultRequest.newBuilder().setName(name).build();
        return this.getBacktestResult(request);
    }

    public final BacktestResult getBacktestResult(GetBacktestResultRequest request) {
        return (BacktestResult)this.getBacktestResultCallable().call((Object)request);
    }

    public final UnaryCallable<GetBacktestResultRequest, BacktestResult> getBacktestResultCallable() {
        return this.stub.getBacktestResultCallable();
    }

    public final OperationFuture<BacktestResult, OperationMetadata> createBacktestResultAsync(InstanceName parent, BacktestResult backtestResult, String backtestResultId) {
        CreateBacktestResultRequest request = CreateBacktestResultRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setBacktestResult(backtestResult).setBacktestResultId(backtestResultId).build();
        return this.createBacktestResultAsync(request);
    }

    public final OperationFuture<BacktestResult, OperationMetadata> createBacktestResultAsync(String parent, BacktestResult backtestResult, String backtestResultId) {
        CreateBacktestResultRequest request = CreateBacktestResultRequest.newBuilder().setParent(parent).setBacktestResult(backtestResult).setBacktestResultId(backtestResultId).build();
        return this.createBacktestResultAsync(request);
    }

    public final OperationFuture<BacktestResult, OperationMetadata> createBacktestResultAsync(CreateBacktestResultRequest request) {
        return this.createBacktestResultOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateBacktestResultRequest, BacktestResult, OperationMetadata> createBacktestResultOperationCallable() {
        return this.stub.createBacktestResultOperationCallable();
    }

    public final UnaryCallable<CreateBacktestResultRequest, Operation> createBacktestResultCallable() {
        return this.stub.createBacktestResultCallable();
    }

    public final OperationFuture<BacktestResult, OperationMetadata> updateBacktestResultAsync(BacktestResult backtestResult, FieldMask updateMask) {
        UpdateBacktestResultRequest request = UpdateBacktestResultRequest.newBuilder().setBacktestResult(backtestResult).setUpdateMask(updateMask).build();
        return this.updateBacktestResultAsync(request);
    }

    public final OperationFuture<BacktestResult, OperationMetadata> updateBacktestResultAsync(UpdateBacktestResultRequest request) {
        return this.updateBacktestResultOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateBacktestResultRequest, BacktestResult, OperationMetadata> updateBacktestResultOperationCallable() {
        return this.stub.updateBacktestResultOperationCallable();
    }

    public final UnaryCallable<UpdateBacktestResultRequest, Operation> updateBacktestResultCallable() {
        return this.stub.updateBacktestResultCallable();
    }

    public final OperationFuture<ExportBacktestResultMetadataResponse, OperationMetadata> exportBacktestResultMetadataAsync(BacktestResultName backtestResult, BigQueryDestination structuredMetadataDestination) {
        ExportBacktestResultMetadataRequest request = ExportBacktestResultMetadataRequest.newBuilder().setBacktestResult(backtestResult == null ? null : backtestResult.toString()).setStructuredMetadataDestination(structuredMetadataDestination).build();
        return this.exportBacktestResultMetadataAsync(request);
    }

    public final OperationFuture<ExportBacktestResultMetadataResponse, OperationMetadata> exportBacktestResultMetadataAsync(String backtestResult, BigQueryDestination structuredMetadataDestination) {
        ExportBacktestResultMetadataRequest request = ExportBacktestResultMetadataRequest.newBuilder().setBacktestResult(backtestResult).setStructuredMetadataDestination(structuredMetadataDestination).build();
        return this.exportBacktestResultMetadataAsync(request);
    }

    public final OperationFuture<ExportBacktestResultMetadataResponse, OperationMetadata> exportBacktestResultMetadataAsync(ExportBacktestResultMetadataRequest request) {
        return this.exportBacktestResultMetadataOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportBacktestResultMetadataRequest, ExportBacktestResultMetadataResponse, OperationMetadata> exportBacktestResultMetadataOperationCallable() {
        return this.stub.exportBacktestResultMetadataOperationCallable();
    }

    public final UnaryCallable<ExportBacktestResultMetadataRequest, Operation> exportBacktestResultMetadataCallable() {
        return this.stub.exportBacktestResultMetadataCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBacktestResultAsync(BacktestResultName name) {
        DeleteBacktestResultRequest request = DeleteBacktestResultRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteBacktestResultAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBacktestResultAsync(String name) {
        DeleteBacktestResultRequest request = DeleteBacktestResultRequest.newBuilder().setName(name).build();
        return this.deleteBacktestResultAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBacktestResultAsync(DeleteBacktestResultRequest request) {
        return this.deleteBacktestResultOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteBacktestResultRequest, Empty, OperationMetadata> deleteBacktestResultOperationCallable() {
        return this.stub.deleteBacktestResultOperationCallable();
    }

    public final UnaryCallable<DeleteBacktestResultRequest, Operation> deleteBacktestResultCallable() {
        return this.stub.deleteBacktestResultCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListBacktestResultsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBacktestResultsRequest, ListBacktestResultsResponse, BacktestResult, ListBacktestResultsPage, ListBacktestResultsFixedSizeCollection> {
        private ListBacktestResultsFixedSizeCollection(List<ListBacktestResultsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBacktestResultsFixedSizeCollection createEmptyCollection() {
            return new ListBacktestResultsFixedSizeCollection(null, 0);
        }

        protected ListBacktestResultsFixedSizeCollection createCollection(List<ListBacktestResultsPage> pages, int collectionSize) {
            return new ListBacktestResultsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBacktestResultsPage
    extends AbstractPage<ListBacktestResultsRequest, ListBacktestResultsResponse, BacktestResult, ListBacktestResultsPage> {
        private ListBacktestResultsPage(PageContext<ListBacktestResultsRequest, ListBacktestResultsResponse, BacktestResult> context, ListBacktestResultsResponse response) {
            super(context, (Object)response);
        }

        private static ListBacktestResultsPage createEmptyPage() {
            return new ListBacktestResultsPage(null, null);
        }

        protected ListBacktestResultsPage createPage(PageContext<ListBacktestResultsRequest, ListBacktestResultsResponse, BacktestResult> context, ListBacktestResultsResponse response) {
            return new ListBacktestResultsPage(context, response);
        }

        public ApiFuture<ListBacktestResultsPage> createPageAsync(PageContext<ListBacktestResultsRequest, ListBacktestResultsResponse, BacktestResult> context, ApiFuture<ListBacktestResultsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBacktestResultsPagedResponse
    extends AbstractPagedListResponse<ListBacktestResultsRequest, ListBacktestResultsResponse, BacktestResult, ListBacktestResultsPage, ListBacktestResultsFixedSizeCollection> {
        public static ApiFuture<ListBacktestResultsPagedResponse> createAsync(PageContext<ListBacktestResultsRequest, ListBacktestResultsResponse, BacktestResult> context, ApiFuture<ListBacktestResultsResponse> futureResponse) {
            ApiFuture<ListBacktestResultsPage> futurePage = ListBacktestResultsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBacktestResultsPagedResponse((ListBacktestResultsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBacktestResultsPagedResponse(ListBacktestResultsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBacktestResultsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPredictionResultsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPredictionResultsRequest, ListPredictionResultsResponse, PredictionResult, ListPredictionResultsPage, ListPredictionResultsFixedSizeCollection> {
        private ListPredictionResultsFixedSizeCollection(List<ListPredictionResultsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPredictionResultsFixedSizeCollection createEmptyCollection() {
            return new ListPredictionResultsFixedSizeCollection(null, 0);
        }

        protected ListPredictionResultsFixedSizeCollection createCollection(List<ListPredictionResultsPage> pages, int collectionSize) {
            return new ListPredictionResultsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPredictionResultsPage
    extends AbstractPage<ListPredictionResultsRequest, ListPredictionResultsResponse, PredictionResult, ListPredictionResultsPage> {
        private ListPredictionResultsPage(PageContext<ListPredictionResultsRequest, ListPredictionResultsResponse, PredictionResult> context, ListPredictionResultsResponse response) {
            super(context, (Object)response);
        }

        private static ListPredictionResultsPage createEmptyPage() {
            return new ListPredictionResultsPage(null, null);
        }

        protected ListPredictionResultsPage createPage(PageContext<ListPredictionResultsRequest, ListPredictionResultsResponse, PredictionResult> context, ListPredictionResultsResponse response) {
            return new ListPredictionResultsPage(context, response);
        }

        public ApiFuture<ListPredictionResultsPage> createPageAsync(PageContext<ListPredictionResultsRequest, ListPredictionResultsResponse, PredictionResult> context, ApiFuture<ListPredictionResultsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPredictionResultsPagedResponse
    extends AbstractPagedListResponse<ListPredictionResultsRequest, ListPredictionResultsResponse, PredictionResult, ListPredictionResultsPage, ListPredictionResultsFixedSizeCollection> {
        public static ApiFuture<ListPredictionResultsPagedResponse> createAsync(PageContext<ListPredictionResultsRequest, ListPredictionResultsResponse, PredictionResult> context, ApiFuture<ListPredictionResultsResponse> futureResponse) {
            ApiFuture<ListPredictionResultsPage> futurePage = ListPredictionResultsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPredictionResultsPagedResponse((ListPredictionResultsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPredictionResultsPagedResponse(ListPredictionResultsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPredictionResultsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEngineVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEngineVersionsRequest, ListEngineVersionsResponse, EngineVersion, ListEngineVersionsPage, ListEngineVersionsFixedSizeCollection> {
        private ListEngineVersionsFixedSizeCollection(List<ListEngineVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEngineVersionsFixedSizeCollection createEmptyCollection() {
            return new ListEngineVersionsFixedSizeCollection(null, 0);
        }

        protected ListEngineVersionsFixedSizeCollection createCollection(List<ListEngineVersionsPage> pages, int collectionSize) {
            return new ListEngineVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEngineVersionsPage
    extends AbstractPage<ListEngineVersionsRequest, ListEngineVersionsResponse, EngineVersion, ListEngineVersionsPage> {
        private ListEngineVersionsPage(PageContext<ListEngineVersionsRequest, ListEngineVersionsResponse, EngineVersion> context, ListEngineVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListEngineVersionsPage createEmptyPage() {
            return new ListEngineVersionsPage(null, null);
        }

        protected ListEngineVersionsPage createPage(PageContext<ListEngineVersionsRequest, ListEngineVersionsResponse, EngineVersion> context, ListEngineVersionsResponse response) {
            return new ListEngineVersionsPage(context, response);
        }

        public ApiFuture<ListEngineVersionsPage> createPageAsync(PageContext<ListEngineVersionsRequest, ListEngineVersionsResponse, EngineVersion> context, ApiFuture<ListEngineVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEngineVersionsPagedResponse
    extends AbstractPagedListResponse<ListEngineVersionsRequest, ListEngineVersionsResponse, EngineVersion, ListEngineVersionsPage, ListEngineVersionsFixedSizeCollection> {
        public static ApiFuture<ListEngineVersionsPagedResponse> createAsync(PageContext<ListEngineVersionsRequest, ListEngineVersionsResponse, EngineVersion> context, ApiFuture<ListEngineVersionsResponse> futureResponse) {
            ApiFuture<ListEngineVersionsPage> futurePage = ListEngineVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEngineVersionsPagedResponse((ListEngineVersionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEngineVersionsPagedResponse(ListEngineVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEngineVersionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEngineConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEngineConfigsRequest, ListEngineConfigsResponse, EngineConfig, ListEngineConfigsPage, ListEngineConfigsFixedSizeCollection> {
        private ListEngineConfigsFixedSizeCollection(List<ListEngineConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEngineConfigsFixedSizeCollection createEmptyCollection() {
            return new ListEngineConfigsFixedSizeCollection(null, 0);
        }

        protected ListEngineConfigsFixedSizeCollection createCollection(List<ListEngineConfigsPage> pages, int collectionSize) {
            return new ListEngineConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEngineConfigsPage
    extends AbstractPage<ListEngineConfigsRequest, ListEngineConfigsResponse, EngineConfig, ListEngineConfigsPage> {
        private ListEngineConfigsPage(PageContext<ListEngineConfigsRequest, ListEngineConfigsResponse, EngineConfig> context, ListEngineConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListEngineConfigsPage createEmptyPage() {
            return new ListEngineConfigsPage(null, null);
        }

        protected ListEngineConfigsPage createPage(PageContext<ListEngineConfigsRequest, ListEngineConfigsResponse, EngineConfig> context, ListEngineConfigsResponse response) {
            return new ListEngineConfigsPage(context, response);
        }

        public ApiFuture<ListEngineConfigsPage> createPageAsync(PageContext<ListEngineConfigsRequest, ListEngineConfigsResponse, EngineConfig> context, ApiFuture<ListEngineConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEngineConfigsPagedResponse
    extends AbstractPagedListResponse<ListEngineConfigsRequest, ListEngineConfigsResponse, EngineConfig, ListEngineConfigsPage, ListEngineConfigsFixedSizeCollection> {
        public static ApiFuture<ListEngineConfigsPagedResponse> createAsync(PageContext<ListEngineConfigsRequest, ListEngineConfigsResponse, EngineConfig> context, ApiFuture<ListEngineConfigsResponse> futureResponse) {
            ApiFuture<ListEngineConfigsPage> futurePage = ListEngineConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEngineConfigsPagedResponse((ListEngineConfigsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEngineConfigsPagedResponse(ListEngineConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEngineConfigsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListModelsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListModelsRequest, ListModelsResponse, Model, ListModelsPage, ListModelsFixedSizeCollection> {
        private ListModelsFixedSizeCollection(List<ListModelsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListModelsFixedSizeCollection createEmptyCollection() {
            return new ListModelsFixedSizeCollection(null, 0);
        }

        protected ListModelsFixedSizeCollection createCollection(List<ListModelsPage> pages, int collectionSize) {
            return new ListModelsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListModelsPage
    extends AbstractPage<ListModelsRequest, ListModelsResponse, Model, ListModelsPage> {
        private ListModelsPage(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ListModelsResponse response) {
            super(context, (Object)response);
        }

        private static ListModelsPage createEmptyPage() {
            return new ListModelsPage(null, null);
        }

        protected ListModelsPage createPage(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ListModelsResponse response) {
            return new ListModelsPage(context, response);
        }

        public ApiFuture<ListModelsPage> createPageAsync(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ApiFuture<ListModelsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListModelsPagedResponse
    extends AbstractPagedListResponse<ListModelsRequest, ListModelsResponse, Model, ListModelsPage, ListModelsFixedSizeCollection> {
        public static ApiFuture<ListModelsPagedResponse> createAsync(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ApiFuture<ListModelsResponse> futureResponse) {
            ApiFuture<ListModelsPage> futurePage = ListModelsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListModelsPagedResponse((ListModelsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListModelsPagedResponse(ListModelsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListModelsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDatasetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDatasetsRequest, ListDatasetsResponse, Dataset, ListDatasetsPage, ListDatasetsFixedSizeCollection> {
        private ListDatasetsFixedSizeCollection(List<ListDatasetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDatasetsFixedSizeCollection createEmptyCollection() {
            return new ListDatasetsFixedSizeCollection(null, 0);
        }

        protected ListDatasetsFixedSizeCollection createCollection(List<ListDatasetsPage> pages, int collectionSize) {
            return new ListDatasetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDatasetsPage
    extends AbstractPage<ListDatasetsRequest, ListDatasetsResponse, Dataset, ListDatasetsPage> {
        private ListDatasetsPage(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ListDatasetsResponse response) {
            super(context, (Object)response);
        }

        private static ListDatasetsPage createEmptyPage() {
            return new ListDatasetsPage(null, null);
        }

        protected ListDatasetsPage createPage(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ListDatasetsResponse response) {
            return new ListDatasetsPage(context, response);
        }

        public ApiFuture<ListDatasetsPage> createPageAsync(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ApiFuture<ListDatasetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDatasetsPagedResponse
    extends AbstractPagedListResponse<ListDatasetsRequest, ListDatasetsResponse, Dataset, ListDatasetsPage, ListDatasetsFixedSizeCollection> {
        public static ApiFuture<ListDatasetsPagedResponse> createAsync(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ApiFuture<ListDatasetsResponse> futureResponse) {
            ApiFuture<ListDatasetsPage> futurePage = ListDatasetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDatasetsPagedResponse((ListDatasetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDatasetsPagedResponse(ListDatasetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDatasetsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInstancesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        private ListInstancesFixedSizeCollection(List<ListInstancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstancesFixedSizeCollection createEmptyCollection() {
            return new ListInstancesFixedSizeCollection(null, 0);
        }

        protected ListInstancesFixedSizeCollection createCollection(List<ListInstancesPage> pages, int collectionSize) {
            return new ListInstancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstancesPage
    extends AbstractPage<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage> {
        private ListInstancesPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            super(context, (Object)response);
        }

        private static ListInstancesPage createEmptyPage() {
            return new ListInstancesPage(null, null);
        }

        protected ListInstancesPage createPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            return new ListInstancesPage(context, response);
        }

        public ApiFuture<ListInstancesPage> createPageAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstancesPagedResponse
    extends AbstractPagedListResponse<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        public static ApiFuture<ListInstancesPagedResponse> createAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            ApiFuture<ListInstancesPage> futurePage = ListInstancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInstancesPagedResponse((ListInstancesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInstancesPagedResponse(ListInstancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstancesFixedSizeCollection.createEmptyCollection());
        }
    }
}

