/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.financialservices.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.financialservices.v1.AMLClient;
import com.google.cloud.financialservices.v1.BacktestResult;
import com.google.cloud.financialservices.v1.CreateBacktestResultRequest;
import com.google.cloud.financialservices.v1.CreateDatasetRequest;
import com.google.cloud.financialservices.v1.CreateEngineConfigRequest;
import com.google.cloud.financialservices.v1.CreateInstanceRequest;
import com.google.cloud.financialservices.v1.CreateModelRequest;
import com.google.cloud.financialservices.v1.CreatePredictionResultRequest;
import com.google.cloud.financialservices.v1.Dataset;
import com.google.cloud.financialservices.v1.DeleteBacktestResultRequest;
import com.google.cloud.financialservices.v1.DeleteDatasetRequest;
import com.google.cloud.financialservices.v1.DeleteEngineConfigRequest;
import com.google.cloud.financialservices.v1.DeleteInstanceRequest;
import com.google.cloud.financialservices.v1.DeleteModelRequest;
import com.google.cloud.financialservices.v1.DeletePredictionResultRequest;
import com.google.cloud.financialservices.v1.EngineConfig;
import com.google.cloud.financialservices.v1.EngineVersion;
import com.google.cloud.financialservices.v1.ExportBacktestResultMetadataRequest;
import com.google.cloud.financialservices.v1.ExportBacktestResultMetadataResponse;
import com.google.cloud.financialservices.v1.ExportEngineConfigMetadataRequest;
import com.google.cloud.financialservices.v1.ExportEngineConfigMetadataResponse;
import com.google.cloud.financialservices.v1.ExportModelMetadataRequest;
import com.google.cloud.financialservices.v1.ExportModelMetadataResponse;
import com.google.cloud.financialservices.v1.ExportPredictionResultMetadataRequest;
import com.google.cloud.financialservices.v1.ExportPredictionResultMetadataResponse;
import com.google.cloud.financialservices.v1.ExportRegisteredPartiesRequest;
import com.google.cloud.financialservices.v1.ExportRegisteredPartiesResponse;
import com.google.cloud.financialservices.v1.GetBacktestResultRequest;
import com.google.cloud.financialservices.v1.GetDatasetRequest;
import com.google.cloud.financialservices.v1.GetEngineConfigRequest;
import com.google.cloud.financialservices.v1.GetEngineVersionRequest;
import com.google.cloud.financialservices.v1.GetInstanceRequest;
import com.google.cloud.financialservices.v1.GetModelRequest;
import com.google.cloud.financialservices.v1.GetPredictionResultRequest;
import com.google.cloud.financialservices.v1.ImportRegisteredPartiesRequest;
import com.google.cloud.financialservices.v1.ImportRegisteredPartiesResponse;
import com.google.cloud.financialservices.v1.Instance;
import com.google.cloud.financialservices.v1.ListBacktestResultsRequest;
import com.google.cloud.financialservices.v1.ListBacktestResultsResponse;
import com.google.cloud.financialservices.v1.ListDatasetsRequest;
import com.google.cloud.financialservices.v1.ListDatasetsResponse;
import com.google.cloud.financialservices.v1.ListEngineConfigsRequest;
import com.google.cloud.financialservices.v1.ListEngineConfigsResponse;
import com.google.cloud.financialservices.v1.ListEngineVersionsRequest;
import com.google.cloud.financialservices.v1.ListEngineVersionsResponse;
import com.google.cloud.financialservices.v1.ListInstancesRequest;
import com.google.cloud.financialservices.v1.ListInstancesResponse;
import com.google.cloud.financialservices.v1.ListModelsRequest;
import com.google.cloud.financialservices.v1.ListModelsResponse;
import com.google.cloud.financialservices.v1.ListPredictionResultsRequest;
import com.google.cloud.financialservices.v1.ListPredictionResultsResponse;
import com.google.cloud.financialservices.v1.Model;
import com.google.cloud.financialservices.v1.OperationMetadata;
import com.google.cloud.financialservices.v1.PredictionResult;
import com.google.cloud.financialservices.v1.UpdateBacktestResultRequest;
import com.google.cloud.financialservices.v1.UpdateDatasetRequest;
import com.google.cloud.financialservices.v1.UpdateEngineConfigRequest;
import com.google.cloud.financialservices.v1.UpdateInstanceRequest;
import com.google.cloud.financialservices.v1.UpdateModelRequest;
import com.google.cloud.financialservices.v1.UpdatePredictionResultRequest;
import com.google.cloud.financialservices.v1.stub.AMLStub;
import com.google.cloud.financialservices.v1.stub.GrpcAMLStub;
import com.google.cloud.financialservices.v1.stub.HttpJsonAMLStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class AMLStubSettings
extends StubSettings<AMLStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListInstancesRequest, ListInstancesResponse, AMLClient.ListInstancesPagedResponse> listInstancesSettings;
    private final UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings;
    private final UnaryCallSettings<CreateInstanceRequest, Operation> createInstanceSettings;
    private final OperationCallSettings<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings;
    private final UnaryCallSettings<UpdateInstanceRequest, Operation> updateInstanceSettings;
    private final OperationCallSettings<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings;
    private final UnaryCallSettings<DeleteInstanceRequest, Operation> deleteInstanceSettings;
    private final OperationCallSettings<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings;
    private final UnaryCallSettings<ImportRegisteredPartiesRequest, Operation> importRegisteredPartiesSettings;
    private final OperationCallSettings<ImportRegisteredPartiesRequest, ImportRegisteredPartiesResponse, OperationMetadata> importRegisteredPartiesOperationSettings;
    private final UnaryCallSettings<ExportRegisteredPartiesRequest, Operation> exportRegisteredPartiesSettings;
    private final OperationCallSettings<ExportRegisteredPartiesRequest, ExportRegisteredPartiesResponse, OperationMetadata> exportRegisteredPartiesOperationSettings;
    private final PagedCallSettings<ListDatasetsRequest, ListDatasetsResponse, AMLClient.ListDatasetsPagedResponse> listDatasetsSettings;
    private final UnaryCallSettings<GetDatasetRequest, Dataset> getDatasetSettings;
    private final UnaryCallSettings<CreateDatasetRequest, Operation> createDatasetSettings;
    private final OperationCallSettings<CreateDatasetRequest, Dataset, OperationMetadata> createDatasetOperationSettings;
    private final UnaryCallSettings<UpdateDatasetRequest, Operation> updateDatasetSettings;
    private final OperationCallSettings<UpdateDatasetRequest, Dataset, OperationMetadata> updateDatasetOperationSettings;
    private final UnaryCallSettings<DeleteDatasetRequest, Operation> deleteDatasetSettings;
    private final OperationCallSettings<DeleteDatasetRequest, Empty, OperationMetadata> deleteDatasetOperationSettings;
    private final PagedCallSettings<ListModelsRequest, ListModelsResponse, AMLClient.ListModelsPagedResponse> listModelsSettings;
    private final UnaryCallSettings<GetModelRequest, Model> getModelSettings;
    private final UnaryCallSettings<CreateModelRequest, Operation> createModelSettings;
    private final OperationCallSettings<CreateModelRequest, Model, OperationMetadata> createModelOperationSettings;
    private final UnaryCallSettings<UpdateModelRequest, Operation> updateModelSettings;
    private final OperationCallSettings<UpdateModelRequest, Model, OperationMetadata> updateModelOperationSettings;
    private final UnaryCallSettings<ExportModelMetadataRequest, Operation> exportModelMetadataSettings;
    private final OperationCallSettings<ExportModelMetadataRequest, ExportModelMetadataResponse, OperationMetadata> exportModelMetadataOperationSettings;
    private final UnaryCallSettings<DeleteModelRequest, Operation> deleteModelSettings;
    private final OperationCallSettings<DeleteModelRequest, Empty, OperationMetadata> deleteModelOperationSettings;
    private final PagedCallSettings<ListEngineConfigsRequest, ListEngineConfigsResponse, AMLClient.ListEngineConfigsPagedResponse> listEngineConfigsSettings;
    private final UnaryCallSettings<GetEngineConfigRequest, EngineConfig> getEngineConfigSettings;
    private final UnaryCallSettings<CreateEngineConfigRequest, Operation> createEngineConfigSettings;
    private final OperationCallSettings<CreateEngineConfigRequest, EngineConfig, OperationMetadata> createEngineConfigOperationSettings;
    private final UnaryCallSettings<UpdateEngineConfigRequest, Operation> updateEngineConfigSettings;
    private final OperationCallSettings<UpdateEngineConfigRequest, EngineConfig, OperationMetadata> updateEngineConfigOperationSettings;
    private final UnaryCallSettings<ExportEngineConfigMetadataRequest, Operation> exportEngineConfigMetadataSettings;
    private final OperationCallSettings<ExportEngineConfigMetadataRequest, ExportEngineConfigMetadataResponse, OperationMetadata> exportEngineConfigMetadataOperationSettings;
    private final UnaryCallSettings<DeleteEngineConfigRequest, Operation> deleteEngineConfigSettings;
    private final OperationCallSettings<DeleteEngineConfigRequest, Empty, OperationMetadata> deleteEngineConfigOperationSettings;
    private final UnaryCallSettings<GetEngineVersionRequest, EngineVersion> getEngineVersionSettings;
    private final PagedCallSettings<ListEngineVersionsRequest, ListEngineVersionsResponse, AMLClient.ListEngineVersionsPagedResponse> listEngineVersionsSettings;
    private final PagedCallSettings<ListPredictionResultsRequest, ListPredictionResultsResponse, AMLClient.ListPredictionResultsPagedResponse> listPredictionResultsSettings;
    private final UnaryCallSettings<GetPredictionResultRequest, PredictionResult> getPredictionResultSettings;
    private final UnaryCallSettings<CreatePredictionResultRequest, Operation> createPredictionResultSettings;
    private final OperationCallSettings<CreatePredictionResultRequest, PredictionResult, OperationMetadata> createPredictionResultOperationSettings;
    private final UnaryCallSettings<UpdatePredictionResultRequest, Operation> updatePredictionResultSettings;
    private final OperationCallSettings<UpdatePredictionResultRequest, PredictionResult, OperationMetadata> updatePredictionResultOperationSettings;
    private final UnaryCallSettings<ExportPredictionResultMetadataRequest, Operation> exportPredictionResultMetadataSettings;
    private final OperationCallSettings<ExportPredictionResultMetadataRequest, ExportPredictionResultMetadataResponse, OperationMetadata> exportPredictionResultMetadataOperationSettings;
    private final UnaryCallSettings<DeletePredictionResultRequest, Operation> deletePredictionResultSettings;
    private final OperationCallSettings<DeletePredictionResultRequest, Empty, OperationMetadata> deletePredictionResultOperationSettings;
    private final PagedCallSettings<ListBacktestResultsRequest, ListBacktestResultsResponse, AMLClient.ListBacktestResultsPagedResponse> listBacktestResultsSettings;
    private final UnaryCallSettings<GetBacktestResultRequest, BacktestResult> getBacktestResultSettings;
    private final UnaryCallSettings<CreateBacktestResultRequest, Operation> createBacktestResultSettings;
    private final OperationCallSettings<CreateBacktestResultRequest, BacktestResult, OperationMetadata> createBacktestResultOperationSettings;
    private final UnaryCallSettings<UpdateBacktestResultRequest, Operation> updateBacktestResultSettings;
    private final OperationCallSettings<UpdateBacktestResultRequest, BacktestResult, OperationMetadata> updateBacktestResultOperationSettings;
    private final UnaryCallSettings<ExportBacktestResultMetadataRequest, Operation> exportBacktestResultMetadataSettings;
    private final OperationCallSettings<ExportBacktestResultMetadataRequest, ExportBacktestResultMetadataResponse, OperationMetadata> exportBacktestResultMetadataOperationSettings;
    private final UnaryCallSettings<DeleteBacktestResultRequest, Operation> deleteBacktestResultSettings;
    private final OperationCallSettings<DeleteBacktestResultRequest, Empty, OperationMetadata> deleteBacktestResultOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, AMLClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListInstancesRequest, ListInstancesResponse, Instance> LIST_INSTANCES_PAGE_STR_DESC = new PagedListDescriptor<ListInstancesRequest, ListInstancesResponse, Instance>(){

        public String emptyToken() {
            return "";
        }

        public ListInstancesRequest injectToken(ListInstancesRequest payload, String token) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setPageToken(token).build();
        }

        public ListInstancesRequest injectPageSize(ListInstancesRequest payload, int pageSize) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListInstancesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListInstancesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Instance> extractResources(ListInstancesResponse payload) {
            return payload.getInstancesList();
        }
    };
    private static final PagedListDescriptor<ListDatasetsRequest, ListDatasetsResponse, Dataset> LIST_DATASETS_PAGE_STR_DESC = new PagedListDescriptor<ListDatasetsRequest, ListDatasetsResponse, Dataset>(){

        public String emptyToken() {
            return "";
        }

        public ListDatasetsRequest injectToken(ListDatasetsRequest payload, String token) {
            return ListDatasetsRequest.newBuilder((ListDatasetsRequest)payload).setPageToken(token).build();
        }

        public ListDatasetsRequest injectPageSize(ListDatasetsRequest payload, int pageSize) {
            return ListDatasetsRequest.newBuilder((ListDatasetsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDatasetsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDatasetsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Dataset> extractResources(ListDatasetsResponse payload) {
            return payload.getDatasetsList();
        }
    };
    private static final PagedListDescriptor<ListModelsRequest, ListModelsResponse, Model> LIST_MODELS_PAGE_STR_DESC = new PagedListDescriptor<ListModelsRequest, ListModelsResponse, Model>(){

        public String emptyToken() {
            return "";
        }

        public ListModelsRequest injectToken(ListModelsRequest payload, String token) {
            return ListModelsRequest.newBuilder((ListModelsRequest)payload).setPageToken(token).build();
        }

        public ListModelsRequest injectPageSize(ListModelsRequest payload, int pageSize) {
            return ListModelsRequest.newBuilder((ListModelsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListModelsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListModelsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Model> extractResources(ListModelsResponse payload) {
            return payload.getModelsList();
        }
    };
    private static final PagedListDescriptor<ListEngineConfigsRequest, ListEngineConfigsResponse, EngineConfig> LIST_ENGINE_CONFIGS_PAGE_STR_DESC = new PagedListDescriptor<ListEngineConfigsRequest, ListEngineConfigsResponse, EngineConfig>(){

        public String emptyToken() {
            return "";
        }

        public ListEngineConfigsRequest injectToken(ListEngineConfigsRequest payload, String token) {
            return ListEngineConfigsRequest.newBuilder((ListEngineConfigsRequest)payload).setPageToken(token).build();
        }

        public ListEngineConfigsRequest injectPageSize(ListEngineConfigsRequest payload, int pageSize) {
            return ListEngineConfigsRequest.newBuilder((ListEngineConfigsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEngineConfigsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEngineConfigsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<EngineConfig> extractResources(ListEngineConfigsResponse payload) {
            return payload.getEngineConfigsList();
        }
    };
    private static final PagedListDescriptor<ListEngineVersionsRequest, ListEngineVersionsResponse, EngineVersion> LIST_ENGINE_VERSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListEngineVersionsRequest, ListEngineVersionsResponse, EngineVersion>(){

        public String emptyToken() {
            return "";
        }

        public ListEngineVersionsRequest injectToken(ListEngineVersionsRequest payload, String token) {
            return ListEngineVersionsRequest.newBuilder((ListEngineVersionsRequest)payload).setPageToken(token).build();
        }

        public ListEngineVersionsRequest injectPageSize(ListEngineVersionsRequest payload, int pageSize) {
            return ListEngineVersionsRequest.newBuilder((ListEngineVersionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEngineVersionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEngineVersionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<EngineVersion> extractResources(ListEngineVersionsResponse payload) {
            return payload.getEngineVersionsList();
        }
    };
    private static final PagedListDescriptor<ListPredictionResultsRequest, ListPredictionResultsResponse, PredictionResult> LIST_PREDICTION_RESULTS_PAGE_STR_DESC = new PagedListDescriptor<ListPredictionResultsRequest, ListPredictionResultsResponse, PredictionResult>(){

        public String emptyToken() {
            return "";
        }

        public ListPredictionResultsRequest injectToken(ListPredictionResultsRequest payload, String token) {
            return ListPredictionResultsRequest.newBuilder((ListPredictionResultsRequest)payload).setPageToken(token).build();
        }

        public ListPredictionResultsRequest injectPageSize(ListPredictionResultsRequest payload, int pageSize) {
            return ListPredictionResultsRequest.newBuilder((ListPredictionResultsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPredictionResultsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPredictionResultsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PredictionResult> extractResources(ListPredictionResultsResponse payload) {
            return payload.getPredictionResultsList();
        }
    };
    private static final PagedListDescriptor<ListBacktestResultsRequest, ListBacktestResultsResponse, BacktestResult> LIST_BACKTEST_RESULTS_PAGE_STR_DESC = new PagedListDescriptor<ListBacktestResultsRequest, ListBacktestResultsResponse, BacktestResult>(){

        public String emptyToken() {
            return "";
        }

        public ListBacktestResultsRequest injectToken(ListBacktestResultsRequest payload, String token) {
            return ListBacktestResultsRequest.newBuilder((ListBacktestResultsRequest)payload).setPageToken(token).build();
        }

        public ListBacktestResultsRequest injectPageSize(ListBacktestResultsRequest payload, int pageSize) {
            return ListBacktestResultsRequest.newBuilder((ListBacktestResultsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListBacktestResultsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListBacktestResultsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<BacktestResult> extractResources(ListBacktestResultsResponse payload) {
            return payload.getBacktestResultsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListInstancesRequest, ListInstancesResponse, AMLClient.ListInstancesPagedResponse> LIST_INSTANCES_PAGE_STR_FACT = new PagedListResponseFactory<ListInstancesRequest, ListInstancesResponse, AMLClient.ListInstancesPagedResponse>(){

        public ApiFuture<AMLClient.ListInstancesPagedResponse> getFuturePagedResponse(UnaryCallable<ListInstancesRequest, ListInstancesResponse> callable, ListInstancesRequest request, ApiCallContext context, ApiFuture<ListInstancesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INSTANCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AMLClient.ListInstancesPagedResponse.createAsync((PageContext<ListInstancesRequest, ListInstancesResponse, Instance>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDatasetsRequest, ListDatasetsResponse, AMLClient.ListDatasetsPagedResponse> LIST_DATASETS_PAGE_STR_FACT = new PagedListResponseFactory<ListDatasetsRequest, ListDatasetsResponse, AMLClient.ListDatasetsPagedResponse>(){

        public ApiFuture<AMLClient.ListDatasetsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDatasetsRequest, ListDatasetsResponse> callable, ListDatasetsRequest request, ApiCallContext context, ApiFuture<ListDatasetsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATASETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AMLClient.ListDatasetsPagedResponse.createAsync((PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListModelsRequest, ListModelsResponse, AMLClient.ListModelsPagedResponse> LIST_MODELS_PAGE_STR_FACT = new PagedListResponseFactory<ListModelsRequest, ListModelsResponse, AMLClient.ListModelsPagedResponse>(){

        public ApiFuture<AMLClient.ListModelsPagedResponse> getFuturePagedResponse(UnaryCallable<ListModelsRequest, ListModelsResponse> callable, ListModelsRequest request, ApiCallContext context, ApiFuture<ListModelsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MODELS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AMLClient.ListModelsPagedResponse.createAsync((PageContext<ListModelsRequest, ListModelsResponse, Model>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListEngineConfigsRequest, ListEngineConfigsResponse, AMLClient.ListEngineConfigsPagedResponse> LIST_ENGINE_CONFIGS_PAGE_STR_FACT = new PagedListResponseFactory<ListEngineConfigsRequest, ListEngineConfigsResponse, AMLClient.ListEngineConfigsPagedResponse>(){

        public ApiFuture<AMLClient.ListEngineConfigsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEngineConfigsRequest, ListEngineConfigsResponse> callable, ListEngineConfigsRequest request, ApiCallContext context, ApiFuture<ListEngineConfigsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENGINE_CONFIGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AMLClient.ListEngineConfigsPagedResponse.createAsync((PageContext<ListEngineConfigsRequest, ListEngineConfigsResponse, EngineConfig>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListEngineVersionsRequest, ListEngineVersionsResponse, AMLClient.ListEngineVersionsPagedResponse> LIST_ENGINE_VERSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListEngineVersionsRequest, ListEngineVersionsResponse, AMLClient.ListEngineVersionsPagedResponse>(){

        public ApiFuture<AMLClient.ListEngineVersionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEngineVersionsRequest, ListEngineVersionsResponse> callable, ListEngineVersionsRequest request, ApiCallContext context, ApiFuture<ListEngineVersionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENGINE_VERSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AMLClient.ListEngineVersionsPagedResponse.createAsync((PageContext<ListEngineVersionsRequest, ListEngineVersionsResponse, EngineVersion>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListPredictionResultsRequest, ListPredictionResultsResponse, AMLClient.ListPredictionResultsPagedResponse> LIST_PREDICTION_RESULTS_PAGE_STR_FACT = new PagedListResponseFactory<ListPredictionResultsRequest, ListPredictionResultsResponse, AMLClient.ListPredictionResultsPagedResponse>(){

        public ApiFuture<AMLClient.ListPredictionResultsPagedResponse> getFuturePagedResponse(UnaryCallable<ListPredictionResultsRequest, ListPredictionResultsResponse> callable, ListPredictionResultsRequest request, ApiCallContext context, ApiFuture<ListPredictionResultsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PREDICTION_RESULTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AMLClient.ListPredictionResultsPagedResponse.createAsync((PageContext<ListPredictionResultsRequest, ListPredictionResultsResponse, PredictionResult>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListBacktestResultsRequest, ListBacktestResultsResponse, AMLClient.ListBacktestResultsPagedResponse> LIST_BACKTEST_RESULTS_PAGE_STR_FACT = new PagedListResponseFactory<ListBacktestResultsRequest, ListBacktestResultsResponse, AMLClient.ListBacktestResultsPagedResponse>(){

        public ApiFuture<AMLClient.ListBacktestResultsPagedResponse> getFuturePagedResponse(UnaryCallable<ListBacktestResultsRequest, ListBacktestResultsResponse> callable, ListBacktestResultsRequest request, ApiCallContext context, ApiFuture<ListBacktestResultsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BACKTEST_RESULTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AMLClient.ListBacktestResultsPagedResponse.createAsync((PageContext<ListBacktestResultsRequest, ListBacktestResultsResponse, BacktestResult>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, AMLClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, AMLClient.ListLocationsPagedResponse>(){

        public ApiFuture<AMLClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AMLClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListInstancesRequest, ListInstancesResponse, AMLClient.ListInstancesPagedResponse> listInstancesSettings() {
        return this.listInstancesSettings;
    }

    public UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings() {
        return this.getInstanceSettings;
    }

    public UnaryCallSettings<CreateInstanceRequest, Operation> createInstanceSettings() {
        return this.createInstanceSettings;
    }

    public OperationCallSettings<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings() {
        return this.createInstanceOperationSettings;
    }

    public UnaryCallSettings<UpdateInstanceRequest, Operation> updateInstanceSettings() {
        return this.updateInstanceSettings;
    }

    public OperationCallSettings<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings() {
        return this.updateInstanceOperationSettings;
    }

    public UnaryCallSettings<DeleteInstanceRequest, Operation> deleteInstanceSettings() {
        return this.deleteInstanceSettings;
    }

    public OperationCallSettings<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings() {
        return this.deleteInstanceOperationSettings;
    }

    public UnaryCallSettings<ImportRegisteredPartiesRequest, Operation> importRegisteredPartiesSettings() {
        return this.importRegisteredPartiesSettings;
    }

    public OperationCallSettings<ImportRegisteredPartiesRequest, ImportRegisteredPartiesResponse, OperationMetadata> importRegisteredPartiesOperationSettings() {
        return this.importRegisteredPartiesOperationSettings;
    }

    public UnaryCallSettings<ExportRegisteredPartiesRequest, Operation> exportRegisteredPartiesSettings() {
        return this.exportRegisteredPartiesSettings;
    }

    public OperationCallSettings<ExportRegisteredPartiesRequest, ExportRegisteredPartiesResponse, OperationMetadata> exportRegisteredPartiesOperationSettings() {
        return this.exportRegisteredPartiesOperationSettings;
    }

    public PagedCallSettings<ListDatasetsRequest, ListDatasetsResponse, AMLClient.ListDatasetsPagedResponse> listDatasetsSettings() {
        return this.listDatasetsSettings;
    }

    public UnaryCallSettings<GetDatasetRequest, Dataset> getDatasetSettings() {
        return this.getDatasetSettings;
    }

    public UnaryCallSettings<CreateDatasetRequest, Operation> createDatasetSettings() {
        return this.createDatasetSettings;
    }

    public OperationCallSettings<CreateDatasetRequest, Dataset, OperationMetadata> createDatasetOperationSettings() {
        return this.createDatasetOperationSettings;
    }

    public UnaryCallSettings<UpdateDatasetRequest, Operation> updateDatasetSettings() {
        return this.updateDatasetSettings;
    }

    public OperationCallSettings<UpdateDatasetRequest, Dataset, OperationMetadata> updateDatasetOperationSettings() {
        return this.updateDatasetOperationSettings;
    }

    public UnaryCallSettings<DeleteDatasetRequest, Operation> deleteDatasetSettings() {
        return this.deleteDatasetSettings;
    }

    public OperationCallSettings<DeleteDatasetRequest, Empty, OperationMetadata> deleteDatasetOperationSettings() {
        return this.deleteDatasetOperationSettings;
    }

    public PagedCallSettings<ListModelsRequest, ListModelsResponse, AMLClient.ListModelsPagedResponse> listModelsSettings() {
        return this.listModelsSettings;
    }

    public UnaryCallSettings<GetModelRequest, Model> getModelSettings() {
        return this.getModelSettings;
    }

    public UnaryCallSettings<CreateModelRequest, Operation> createModelSettings() {
        return this.createModelSettings;
    }

    public OperationCallSettings<CreateModelRequest, Model, OperationMetadata> createModelOperationSettings() {
        return this.createModelOperationSettings;
    }

    public UnaryCallSettings<UpdateModelRequest, Operation> updateModelSettings() {
        return this.updateModelSettings;
    }

    public OperationCallSettings<UpdateModelRequest, Model, OperationMetadata> updateModelOperationSettings() {
        return this.updateModelOperationSettings;
    }

    public UnaryCallSettings<ExportModelMetadataRequest, Operation> exportModelMetadataSettings() {
        return this.exportModelMetadataSettings;
    }

    public OperationCallSettings<ExportModelMetadataRequest, ExportModelMetadataResponse, OperationMetadata> exportModelMetadataOperationSettings() {
        return this.exportModelMetadataOperationSettings;
    }

    public UnaryCallSettings<DeleteModelRequest, Operation> deleteModelSettings() {
        return this.deleteModelSettings;
    }

    public OperationCallSettings<DeleteModelRequest, Empty, OperationMetadata> deleteModelOperationSettings() {
        return this.deleteModelOperationSettings;
    }

    public PagedCallSettings<ListEngineConfigsRequest, ListEngineConfigsResponse, AMLClient.ListEngineConfigsPagedResponse> listEngineConfigsSettings() {
        return this.listEngineConfigsSettings;
    }

    public UnaryCallSettings<GetEngineConfigRequest, EngineConfig> getEngineConfigSettings() {
        return this.getEngineConfigSettings;
    }

    public UnaryCallSettings<CreateEngineConfigRequest, Operation> createEngineConfigSettings() {
        return this.createEngineConfigSettings;
    }

    public OperationCallSettings<CreateEngineConfigRequest, EngineConfig, OperationMetadata> createEngineConfigOperationSettings() {
        return this.createEngineConfigOperationSettings;
    }

    public UnaryCallSettings<UpdateEngineConfigRequest, Operation> updateEngineConfigSettings() {
        return this.updateEngineConfigSettings;
    }

    public OperationCallSettings<UpdateEngineConfigRequest, EngineConfig, OperationMetadata> updateEngineConfigOperationSettings() {
        return this.updateEngineConfigOperationSettings;
    }

    public UnaryCallSettings<ExportEngineConfigMetadataRequest, Operation> exportEngineConfigMetadataSettings() {
        return this.exportEngineConfigMetadataSettings;
    }

    public OperationCallSettings<ExportEngineConfigMetadataRequest, ExportEngineConfigMetadataResponse, OperationMetadata> exportEngineConfigMetadataOperationSettings() {
        return this.exportEngineConfigMetadataOperationSettings;
    }

    public UnaryCallSettings<DeleteEngineConfigRequest, Operation> deleteEngineConfigSettings() {
        return this.deleteEngineConfigSettings;
    }

    public OperationCallSettings<DeleteEngineConfigRequest, Empty, OperationMetadata> deleteEngineConfigOperationSettings() {
        return this.deleteEngineConfigOperationSettings;
    }

    public UnaryCallSettings<GetEngineVersionRequest, EngineVersion> getEngineVersionSettings() {
        return this.getEngineVersionSettings;
    }

    public PagedCallSettings<ListEngineVersionsRequest, ListEngineVersionsResponse, AMLClient.ListEngineVersionsPagedResponse> listEngineVersionsSettings() {
        return this.listEngineVersionsSettings;
    }

    public PagedCallSettings<ListPredictionResultsRequest, ListPredictionResultsResponse, AMLClient.ListPredictionResultsPagedResponse> listPredictionResultsSettings() {
        return this.listPredictionResultsSettings;
    }

    public UnaryCallSettings<GetPredictionResultRequest, PredictionResult> getPredictionResultSettings() {
        return this.getPredictionResultSettings;
    }

    public UnaryCallSettings<CreatePredictionResultRequest, Operation> createPredictionResultSettings() {
        return this.createPredictionResultSettings;
    }

    public OperationCallSettings<CreatePredictionResultRequest, PredictionResult, OperationMetadata> createPredictionResultOperationSettings() {
        return this.createPredictionResultOperationSettings;
    }

    public UnaryCallSettings<UpdatePredictionResultRequest, Operation> updatePredictionResultSettings() {
        return this.updatePredictionResultSettings;
    }

    public OperationCallSettings<UpdatePredictionResultRequest, PredictionResult, OperationMetadata> updatePredictionResultOperationSettings() {
        return this.updatePredictionResultOperationSettings;
    }

    public UnaryCallSettings<ExportPredictionResultMetadataRequest, Operation> exportPredictionResultMetadataSettings() {
        return this.exportPredictionResultMetadataSettings;
    }

    public OperationCallSettings<ExportPredictionResultMetadataRequest, ExportPredictionResultMetadataResponse, OperationMetadata> exportPredictionResultMetadataOperationSettings() {
        return this.exportPredictionResultMetadataOperationSettings;
    }

    public UnaryCallSettings<DeletePredictionResultRequest, Operation> deletePredictionResultSettings() {
        return this.deletePredictionResultSettings;
    }

    public OperationCallSettings<DeletePredictionResultRequest, Empty, OperationMetadata> deletePredictionResultOperationSettings() {
        return this.deletePredictionResultOperationSettings;
    }

    public PagedCallSettings<ListBacktestResultsRequest, ListBacktestResultsResponse, AMLClient.ListBacktestResultsPagedResponse> listBacktestResultsSettings() {
        return this.listBacktestResultsSettings;
    }

    public UnaryCallSettings<GetBacktestResultRequest, BacktestResult> getBacktestResultSettings() {
        return this.getBacktestResultSettings;
    }

    public UnaryCallSettings<CreateBacktestResultRequest, Operation> createBacktestResultSettings() {
        return this.createBacktestResultSettings;
    }

    public OperationCallSettings<CreateBacktestResultRequest, BacktestResult, OperationMetadata> createBacktestResultOperationSettings() {
        return this.createBacktestResultOperationSettings;
    }

    public UnaryCallSettings<UpdateBacktestResultRequest, Operation> updateBacktestResultSettings() {
        return this.updateBacktestResultSettings;
    }

    public OperationCallSettings<UpdateBacktestResultRequest, BacktestResult, OperationMetadata> updateBacktestResultOperationSettings() {
        return this.updateBacktestResultOperationSettings;
    }

    public UnaryCallSettings<ExportBacktestResultMetadataRequest, Operation> exportBacktestResultMetadataSettings() {
        return this.exportBacktestResultMetadataSettings;
    }

    public OperationCallSettings<ExportBacktestResultMetadataRequest, ExportBacktestResultMetadataResponse, OperationMetadata> exportBacktestResultMetadataOperationSettings() {
        return this.exportBacktestResultMetadataOperationSettings;
    }

    public UnaryCallSettings<DeleteBacktestResultRequest, Operation> deleteBacktestResultSettings() {
        return this.deleteBacktestResultSettings;
    }

    public OperationCallSettings<DeleteBacktestResultRequest, Empty, OperationMetadata> deleteBacktestResultOperationSettings() {
        return this.deleteBacktestResultOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, AMLClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public AMLStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAMLStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAMLStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "financialservices";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "financialservices.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "financialservices.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AMLStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AMLStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AMLStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return AMLStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AMLStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listInstancesSettings = settingsBuilder.listInstancesSettings().build();
        this.getInstanceSettings = settingsBuilder.getInstanceSettings().build();
        this.createInstanceSettings = settingsBuilder.createInstanceSettings().build();
        this.createInstanceOperationSettings = settingsBuilder.createInstanceOperationSettings().build();
        this.updateInstanceSettings = settingsBuilder.updateInstanceSettings().build();
        this.updateInstanceOperationSettings = settingsBuilder.updateInstanceOperationSettings().build();
        this.deleteInstanceSettings = settingsBuilder.deleteInstanceSettings().build();
        this.deleteInstanceOperationSettings = settingsBuilder.deleteInstanceOperationSettings().build();
        this.importRegisteredPartiesSettings = settingsBuilder.importRegisteredPartiesSettings().build();
        this.importRegisteredPartiesOperationSettings = settingsBuilder.importRegisteredPartiesOperationSettings().build();
        this.exportRegisteredPartiesSettings = settingsBuilder.exportRegisteredPartiesSettings().build();
        this.exportRegisteredPartiesOperationSettings = settingsBuilder.exportRegisteredPartiesOperationSettings().build();
        this.listDatasetsSettings = settingsBuilder.listDatasetsSettings().build();
        this.getDatasetSettings = settingsBuilder.getDatasetSettings().build();
        this.createDatasetSettings = settingsBuilder.createDatasetSettings().build();
        this.createDatasetOperationSettings = settingsBuilder.createDatasetOperationSettings().build();
        this.updateDatasetSettings = settingsBuilder.updateDatasetSettings().build();
        this.updateDatasetOperationSettings = settingsBuilder.updateDatasetOperationSettings().build();
        this.deleteDatasetSettings = settingsBuilder.deleteDatasetSettings().build();
        this.deleteDatasetOperationSettings = settingsBuilder.deleteDatasetOperationSettings().build();
        this.listModelsSettings = settingsBuilder.listModelsSettings().build();
        this.getModelSettings = settingsBuilder.getModelSettings().build();
        this.createModelSettings = settingsBuilder.createModelSettings().build();
        this.createModelOperationSettings = settingsBuilder.createModelOperationSettings().build();
        this.updateModelSettings = settingsBuilder.updateModelSettings().build();
        this.updateModelOperationSettings = settingsBuilder.updateModelOperationSettings().build();
        this.exportModelMetadataSettings = settingsBuilder.exportModelMetadataSettings().build();
        this.exportModelMetadataOperationSettings = settingsBuilder.exportModelMetadataOperationSettings().build();
        this.deleteModelSettings = settingsBuilder.deleteModelSettings().build();
        this.deleteModelOperationSettings = settingsBuilder.deleteModelOperationSettings().build();
        this.listEngineConfigsSettings = settingsBuilder.listEngineConfigsSettings().build();
        this.getEngineConfigSettings = settingsBuilder.getEngineConfigSettings().build();
        this.createEngineConfigSettings = settingsBuilder.createEngineConfigSettings().build();
        this.createEngineConfigOperationSettings = settingsBuilder.createEngineConfigOperationSettings().build();
        this.updateEngineConfigSettings = settingsBuilder.updateEngineConfigSettings().build();
        this.updateEngineConfigOperationSettings = settingsBuilder.updateEngineConfigOperationSettings().build();
        this.exportEngineConfigMetadataSettings = settingsBuilder.exportEngineConfigMetadataSettings().build();
        this.exportEngineConfigMetadataOperationSettings = settingsBuilder.exportEngineConfigMetadataOperationSettings().build();
        this.deleteEngineConfigSettings = settingsBuilder.deleteEngineConfigSettings().build();
        this.deleteEngineConfigOperationSettings = settingsBuilder.deleteEngineConfigOperationSettings().build();
        this.getEngineVersionSettings = settingsBuilder.getEngineVersionSettings().build();
        this.listEngineVersionsSettings = settingsBuilder.listEngineVersionsSettings().build();
        this.listPredictionResultsSettings = settingsBuilder.listPredictionResultsSettings().build();
        this.getPredictionResultSettings = settingsBuilder.getPredictionResultSettings().build();
        this.createPredictionResultSettings = settingsBuilder.createPredictionResultSettings().build();
        this.createPredictionResultOperationSettings = settingsBuilder.createPredictionResultOperationSettings().build();
        this.updatePredictionResultSettings = settingsBuilder.updatePredictionResultSettings().build();
        this.updatePredictionResultOperationSettings = settingsBuilder.updatePredictionResultOperationSettings().build();
        this.exportPredictionResultMetadataSettings = settingsBuilder.exportPredictionResultMetadataSettings().build();
        this.exportPredictionResultMetadataOperationSettings = settingsBuilder.exportPredictionResultMetadataOperationSettings().build();
        this.deletePredictionResultSettings = settingsBuilder.deletePredictionResultSettings().build();
        this.deletePredictionResultOperationSettings = settingsBuilder.deletePredictionResultOperationSettings().build();
        this.listBacktestResultsSettings = settingsBuilder.listBacktestResultsSettings().build();
        this.getBacktestResultSettings = settingsBuilder.getBacktestResultSettings().build();
        this.createBacktestResultSettings = settingsBuilder.createBacktestResultSettings().build();
        this.createBacktestResultOperationSettings = settingsBuilder.createBacktestResultOperationSettings().build();
        this.updateBacktestResultSettings = settingsBuilder.updateBacktestResultSettings().build();
        this.updateBacktestResultOperationSettings = settingsBuilder.updateBacktestResultOperationSettings().build();
        this.exportBacktestResultMetadataSettings = settingsBuilder.exportBacktestResultMetadataSettings().build();
        this.exportBacktestResultMetadataOperationSettings = settingsBuilder.exportBacktestResultMetadataOperationSettings().build();
        this.deleteBacktestResultSettings = settingsBuilder.deleteBacktestResultSettings().build();
        this.deleteBacktestResultOperationSettings = settingsBuilder.deleteBacktestResultOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AMLStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListInstancesRequest, ListInstancesResponse, AMLClient.ListInstancesPagedResponse> listInstancesSettings;
        private final UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings;
        private final UnaryCallSettings.Builder<CreateInstanceRequest, Operation> createInstanceSettings;
        private final OperationCallSettings.Builder<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings;
        private final UnaryCallSettings.Builder<UpdateInstanceRequest, Operation> updateInstanceSettings;
        private final OperationCallSettings.Builder<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings;
        private final UnaryCallSettings.Builder<DeleteInstanceRequest, Operation> deleteInstanceSettings;
        private final OperationCallSettings.Builder<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings;
        private final UnaryCallSettings.Builder<ImportRegisteredPartiesRequest, Operation> importRegisteredPartiesSettings;
        private final OperationCallSettings.Builder<ImportRegisteredPartiesRequest, ImportRegisteredPartiesResponse, OperationMetadata> importRegisteredPartiesOperationSettings;
        private final UnaryCallSettings.Builder<ExportRegisteredPartiesRequest, Operation> exportRegisteredPartiesSettings;
        private final OperationCallSettings.Builder<ExportRegisteredPartiesRequest, ExportRegisteredPartiesResponse, OperationMetadata> exportRegisteredPartiesOperationSettings;
        private final PagedCallSettings.Builder<ListDatasetsRequest, ListDatasetsResponse, AMLClient.ListDatasetsPagedResponse> listDatasetsSettings;
        private final UnaryCallSettings.Builder<GetDatasetRequest, Dataset> getDatasetSettings;
        private final UnaryCallSettings.Builder<CreateDatasetRequest, Operation> createDatasetSettings;
        private final OperationCallSettings.Builder<CreateDatasetRequest, Dataset, OperationMetadata> createDatasetOperationSettings;
        private final UnaryCallSettings.Builder<UpdateDatasetRequest, Operation> updateDatasetSettings;
        private final OperationCallSettings.Builder<UpdateDatasetRequest, Dataset, OperationMetadata> updateDatasetOperationSettings;
        private final UnaryCallSettings.Builder<DeleteDatasetRequest, Operation> deleteDatasetSettings;
        private final OperationCallSettings.Builder<DeleteDatasetRequest, Empty, OperationMetadata> deleteDatasetOperationSettings;
        private final PagedCallSettings.Builder<ListModelsRequest, ListModelsResponse, AMLClient.ListModelsPagedResponse> listModelsSettings;
        private final UnaryCallSettings.Builder<GetModelRequest, Model> getModelSettings;
        private final UnaryCallSettings.Builder<CreateModelRequest, Operation> createModelSettings;
        private final OperationCallSettings.Builder<CreateModelRequest, Model, OperationMetadata> createModelOperationSettings;
        private final UnaryCallSettings.Builder<UpdateModelRequest, Operation> updateModelSettings;
        private final OperationCallSettings.Builder<UpdateModelRequest, Model, OperationMetadata> updateModelOperationSettings;
        private final UnaryCallSettings.Builder<ExportModelMetadataRequest, Operation> exportModelMetadataSettings;
        private final OperationCallSettings.Builder<ExportModelMetadataRequest, ExportModelMetadataResponse, OperationMetadata> exportModelMetadataOperationSettings;
        private final UnaryCallSettings.Builder<DeleteModelRequest, Operation> deleteModelSettings;
        private final OperationCallSettings.Builder<DeleteModelRequest, Empty, OperationMetadata> deleteModelOperationSettings;
        private final PagedCallSettings.Builder<ListEngineConfigsRequest, ListEngineConfigsResponse, AMLClient.ListEngineConfigsPagedResponse> listEngineConfigsSettings;
        private final UnaryCallSettings.Builder<GetEngineConfigRequest, EngineConfig> getEngineConfigSettings;
        private final UnaryCallSettings.Builder<CreateEngineConfigRequest, Operation> createEngineConfigSettings;
        private final OperationCallSettings.Builder<CreateEngineConfigRequest, EngineConfig, OperationMetadata> createEngineConfigOperationSettings;
        private final UnaryCallSettings.Builder<UpdateEngineConfigRequest, Operation> updateEngineConfigSettings;
        private final OperationCallSettings.Builder<UpdateEngineConfigRequest, EngineConfig, OperationMetadata> updateEngineConfigOperationSettings;
        private final UnaryCallSettings.Builder<ExportEngineConfigMetadataRequest, Operation> exportEngineConfigMetadataSettings;
        private final OperationCallSettings.Builder<ExportEngineConfigMetadataRequest, ExportEngineConfigMetadataResponse, OperationMetadata> exportEngineConfigMetadataOperationSettings;
        private final UnaryCallSettings.Builder<DeleteEngineConfigRequest, Operation> deleteEngineConfigSettings;
        private final OperationCallSettings.Builder<DeleteEngineConfigRequest, Empty, OperationMetadata> deleteEngineConfigOperationSettings;
        private final UnaryCallSettings.Builder<GetEngineVersionRequest, EngineVersion> getEngineVersionSettings;
        private final PagedCallSettings.Builder<ListEngineVersionsRequest, ListEngineVersionsResponse, AMLClient.ListEngineVersionsPagedResponse> listEngineVersionsSettings;
        private final PagedCallSettings.Builder<ListPredictionResultsRequest, ListPredictionResultsResponse, AMLClient.ListPredictionResultsPagedResponse> listPredictionResultsSettings;
        private final UnaryCallSettings.Builder<GetPredictionResultRequest, PredictionResult> getPredictionResultSettings;
        private final UnaryCallSettings.Builder<CreatePredictionResultRequest, Operation> createPredictionResultSettings;
        private final OperationCallSettings.Builder<CreatePredictionResultRequest, PredictionResult, OperationMetadata> createPredictionResultOperationSettings;
        private final UnaryCallSettings.Builder<UpdatePredictionResultRequest, Operation> updatePredictionResultSettings;
        private final OperationCallSettings.Builder<UpdatePredictionResultRequest, PredictionResult, OperationMetadata> updatePredictionResultOperationSettings;
        private final UnaryCallSettings.Builder<ExportPredictionResultMetadataRequest, Operation> exportPredictionResultMetadataSettings;
        private final OperationCallSettings.Builder<ExportPredictionResultMetadataRequest, ExportPredictionResultMetadataResponse, OperationMetadata> exportPredictionResultMetadataOperationSettings;
        private final UnaryCallSettings.Builder<DeletePredictionResultRequest, Operation> deletePredictionResultSettings;
        private final OperationCallSettings.Builder<DeletePredictionResultRequest, Empty, OperationMetadata> deletePredictionResultOperationSettings;
        private final PagedCallSettings.Builder<ListBacktestResultsRequest, ListBacktestResultsResponse, AMLClient.ListBacktestResultsPagedResponse> listBacktestResultsSettings;
        private final UnaryCallSettings.Builder<GetBacktestResultRequest, BacktestResult> getBacktestResultSettings;
        private final UnaryCallSettings.Builder<CreateBacktestResultRequest, Operation> createBacktestResultSettings;
        private final OperationCallSettings.Builder<CreateBacktestResultRequest, BacktestResult, OperationMetadata> createBacktestResultOperationSettings;
        private final UnaryCallSettings.Builder<UpdateBacktestResultRequest, Operation> updateBacktestResultSettings;
        private final OperationCallSettings.Builder<UpdateBacktestResultRequest, BacktestResult, OperationMetadata> updateBacktestResultOperationSettings;
        private final UnaryCallSettings.Builder<ExportBacktestResultMetadataRequest, Operation> exportBacktestResultMetadataSettings;
        private final OperationCallSettings.Builder<ExportBacktestResultMetadataRequest, ExportBacktestResultMetadataResponse, OperationMetadata> exportBacktestResultMetadataOperationSettings;
        private final UnaryCallSettings.Builder<DeleteBacktestResultRequest, Operation> deleteBacktestResultSettings;
        private final OperationCallSettings.Builder<DeleteBacktestResultRequest, Empty, OperationMetadata> deleteBacktestResultOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, AMLClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listInstancesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INSTANCES_PAGE_STR_FACT);
            this.getInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.updateInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.deleteInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.importRegisteredPartiesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importRegisteredPartiesOperationSettings = OperationCallSettings.newBuilder();
            this.exportRegisteredPartiesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportRegisteredPartiesOperationSettings = OperationCallSettings.newBuilder();
            this.listDatasetsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATASETS_PAGE_STR_FACT);
            this.getDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDatasetOperationSettings = OperationCallSettings.newBuilder();
            this.updateDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDatasetOperationSettings = OperationCallSettings.newBuilder();
            this.deleteDatasetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDatasetOperationSettings = OperationCallSettings.newBuilder();
            this.listModelsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MODELS_PAGE_STR_FACT);
            this.getModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createModelOperationSettings = OperationCallSettings.newBuilder();
            this.updateModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateModelOperationSettings = OperationCallSettings.newBuilder();
            this.exportModelMetadataSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportModelMetadataOperationSettings = OperationCallSettings.newBuilder();
            this.deleteModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteModelOperationSettings = OperationCallSettings.newBuilder();
            this.listEngineConfigsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENGINE_CONFIGS_PAGE_STR_FACT);
            this.getEngineConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEngineConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEngineConfigOperationSettings = OperationCallSettings.newBuilder();
            this.updateEngineConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateEngineConfigOperationSettings = OperationCallSettings.newBuilder();
            this.exportEngineConfigMetadataSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportEngineConfigMetadataOperationSettings = OperationCallSettings.newBuilder();
            this.deleteEngineConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEngineConfigOperationSettings = OperationCallSettings.newBuilder();
            this.getEngineVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listEngineVersionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENGINE_VERSIONS_PAGE_STR_FACT);
            this.listPredictionResultsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PREDICTION_RESULTS_PAGE_STR_FACT);
            this.getPredictionResultSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createPredictionResultSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createPredictionResultOperationSettings = OperationCallSettings.newBuilder();
            this.updatePredictionResultSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updatePredictionResultOperationSettings = OperationCallSettings.newBuilder();
            this.exportPredictionResultMetadataSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportPredictionResultMetadataOperationSettings = OperationCallSettings.newBuilder();
            this.deletePredictionResultSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deletePredictionResultOperationSettings = OperationCallSettings.newBuilder();
            this.listBacktestResultsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BACKTEST_RESULTS_PAGE_STR_FACT);
            this.getBacktestResultSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createBacktestResultSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createBacktestResultOperationSettings = OperationCallSettings.newBuilder();
            this.updateBacktestResultSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateBacktestResultOperationSettings = OperationCallSettings.newBuilder();
            this.exportBacktestResultMetadataSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportBacktestResultMetadataOperationSettings = OperationCallSettings.newBuilder();
            this.deleteBacktestResultSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteBacktestResultOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listInstancesSettings, this.getInstanceSettings, this.createInstanceSettings, this.updateInstanceSettings, this.deleteInstanceSettings, this.importRegisteredPartiesSettings, this.exportRegisteredPartiesSettings, this.listDatasetsSettings, this.getDatasetSettings, this.createDatasetSettings, this.updateDatasetSettings, this.deleteDatasetSettings, (Object[])new UnaryCallSettings.Builder[]{this.listModelsSettings, this.getModelSettings, this.createModelSettings, this.updateModelSettings, this.exportModelMetadataSettings, this.deleteModelSettings, this.listEngineConfigsSettings, this.getEngineConfigSettings, this.createEngineConfigSettings, this.updateEngineConfigSettings, this.exportEngineConfigMetadataSettings, this.deleteEngineConfigSettings, this.getEngineVersionSettings, this.listEngineVersionsSettings, this.listPredictionResultsSettings, this.getPredictionResultSettings, this.createPredictionResultSettings, this.updatePredictionResultSettings, this.exportPredictionResultMetadataSettings, this.deletePredictionResultSettings, this.listBacktestResultsSettings, this.getBacktestResultSettings, this.createBacktestResultSettings, this.updateBacktestResultSettings, this.exportBacktestResultMetadataSettings, this.deleteBacktestResultSettings, this.listLocationsSettings, this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(AMLStubSettings settings) {
            super((StubSettings)settings);
            this.listInstancesSettings = settings.listInstancesSettings.toBuilder();
            this.getInstanceSettings = settings.getInstanceSettings.toBuilder();
            this.createInstanceSettings = settings.createInstanceSettings.toBuilder();
            this.createInstanceOperationSettings = settings.createInstanceOperationSettings.toBuilder();
            this.updateInstanceSettings = settings.updateInstanceSettings.toBuilder();
            this.updateInstanceOperationSettings = settings.updateInstanceOperationSettings.toBuilder();
            this.deleteInstanceSettings = settings.deleteInstanceSettings.toBuilder();
            this.deleteInstanceOperationSettings = settings.deleteInstanceOperationSettings.toBuilder();
            this.importRegisteredPartiesSettings = settings.importRegisteredPartiesSettings.toBuilder();
            this.importRegisteredPartiesOperationSettings = settings.importRegisteredPartiesOperationSettings.toBuilder();
            this.exportRegisteredPartiesSettings = settings.exportRegisteredPartiesSettings.toBuilder();
            this.exportRegisteredPartiesOperationSettings = settings.exportRegisteredPartiesOperationSettings.toBuilder();
            this.listDatasetsSettings = settings.listDatasetsSettings.toBuilder();
            this.getDatasetSettings = settings.getDatasetSettings.toBuilder();
            this.createDatasetSettings = settings.createDatasetSettings.toBuilder();
            this.createDatasetOperationSettings = settings.createDatasetOperationSettings.toBuilder();
            this.updateDatasetSettings = settings.updateDatasetSettings.toBuilder();
            this.updateDatasetOperationSettings = settings.updateDatasetOperationSettings.toBuilder();
            this.deleteDatasetSettings = settings.deleteDatasetSettings.toBuilder();
            this.deleteDatasetOperationSettings = settings.deleteDatasetOperationSettings.toBuilder();
            this.listModelsSettings = settings.listModelsSettings.toBuilder();
            this.getModelSettings = settings.getModelSettings.toBuilder();
            this.createModelSettings = settings.createModelSettings.toBuilder();
            this.createModelOperationSettings = settings.createModelOperationSettings.toBuilder();
            this.updateModelSettings = settings.updateModelSettings.toBuilder();
            this.updateModelOperationSettings = settings.updateModelOperationSettings.toBuilder();
            this.exportModelMetadataSettings = settings.exportModelMetadataSettings.toBuilder();
            this.exportModelMetadataOperationSettings = settings.exportModelMetadataOperationSettings.toBuilder();
            this.deleteModelSettings = settings.deleteModelSettings.toBuilder();
            this.deleteModelOperationSettings = settings.deleteModelOperationSettings.toBuilder();
            this.listEngineConfigsSettings = settings.listEngineConfigsSettings.toBuilder();
            this.getEngineConfigSettings = settings.getEngineConfigSettings.toBuilder();
            this.createEngineConfigSettings = settings.createEngineConfigSettings.toBuilder();
            this.createEngineConfigOperationSettings = settings.createEngineConfigOperationSettings.toBuilder();
            this.updateEngineConfigSettings = settings.updateEngineConfigSettings.toBuilder();
            this.updateEngineConfigOperationSettings = settings.updateEngineConfigOperationSettings.toBuilder();
            this.exportEngineConfigMetadataSettings = settings.exportEngineConfigMetadataSettings.toBuilder();
            this.exportEngineConfigMetadataOperationSettings = settings.exportEngineConfigMetadataOperationSettings.toBuilder();
            this.deleteEngineConfigSettings = settings.deleteEngineConfigSettings.toBuilder();
            this.deleteEngineConfigOperationSettings = settings.deleteEngineConfigOperationSettings.toBuilder();
            this.getEngineVersionSettings = settings.getEngineVersionSettings.toBuilder();
            this.listEngineVersionsSettings = settings.listEngineVersionsSettings.toBuilder();
            this.listPredictionResultsSettings = settings.listPredictionResultsSettings.toBuilder();
            this.getPredictionResultSettings = settings.getPredictionResultSettings.toBuilder();
            this.createPredictionResultSettings = settings.createPredictionResultSettings.toBuilder();
            this.createPredictionResultOperationSettings = settings.createPredictionResultOperationSettings.toBuilder();
            this.updatePredictionResultSettings = settings.updatePredictionResultSettings.toBuilder();
            this.updatePredictionResultOperationSettings = settings.updatePredictionResultOperationSettings.toBuilder();
            this.exportPredictionResultMetadataSettings = settings.exportPredictionResultMetadataSettings.toBuilder();
            this.exportPredictionResultMetadataOperationSettings = settings.exportPredictionResultMetadataOperationSettings.toBuilder();
            this.deletePredictionResultSettings = settings.deletePredictionResultSettings.toBuilder();
            this.deletePredictionResultOperationSettings = settings.deletePredictionResultOperationSettings.toBuilder();
            this.listBacktestResultsSettings = settings.listBacktestResultsSettings.toBuilder();
            this.getBacktestResultSettings = settings.getBacktestResultSettings.toBuilder();
            this.createBacktestResultSettings = settings.createBacktestResultSettings.toBuilder();
            this.createBacktestResultOperationSettings = settings.createBacktestResultOperationSettings.toBuilder();
            this.updateBacktestResultSettings = settings.updateBacktestResultSettings.toBuilder();
            this.updateBacktestResultOperationSettings = settings.updateBacktestResultOperationSettings.toBuilder();
            this.exportBacktestResultMetadataSettings = settings.exportBacktestResultMetadataSettings.toBuilder();
            this.exportBacktestResultMetadataOperationSettings = settings.exportBacktestResultMetadataOperationSettings.toBuilder();
            this.deleteBacktestResultSettings = settings.deleteBacktestResultSettings.toBuilder();
            this.deleteBacktestResultOperationSettings = settings.deleteBacktestResultOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listInstancesSettings, this.getInstanceSettings, this.createInstanceSettings, this.updateInstanceSettings, this.deleteInstanceSettings, this.importRegisteredPartiesSettings, this.exportRegisteredPartiesSettings, this.listDatasetsSettings, this.getDatasetSettings, this.createDatasetSettings, this.updateDatasetSettings, this.deleteDatasetSettings, (Object[])new UnaryCallSettings.Builder[]{this.listModelsSettings, this.getModelSettings, this.createModelSettings, this.updateModelSettings, this.exportModelMetadataSettings, this.deleteModelSettings, this.listEngineConfigsSettings, this.getEngineConfigSettings, this.createEngineConfigSettings, this.updateEngineConfigSettings, this.exportEngineConfigMetadataSettings, this.deleteEngineConfigSettings, this.getEngineVersionSettings, this.listEngineVersionsSettings, this.listPredictionResultsSettings, this.getPredictionResultSettings, this.createPredictionResultSettings, this.updatePredictionResultSettings, this.exportPredictionResultMetadataSettings, this.deletePredictionResultSettings, this.listBacktestResultsSettings, this.getBacktestResultSettings, this.createBacktestResultSettings, this.updateBacktestResultSettings, this.exportBacktestResultMetadataSettings, this.deleteBacktestResultSettings, this.listLocationsSettings, this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AMLStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AMLStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AMLStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AMLStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)AMLStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)AMLStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AMLStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AMLStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.importRegisteredPartiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.exportRegisteredPartiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listDatasetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteDatasetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listModelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.exportModelMetadataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listEngineConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getEngineConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createEngineConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateEngineConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.exportEngineConfigMetadataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteEngineConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getEngineVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listEngineVersionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listPredictionResultsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getPredictionResultSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createPredictionResultSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updatePredictionResultSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.exportPredictionResultMetadataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deletePredictionResultSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listBacktestResultsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getBacktestResultSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createBacktestResultSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateBacktestResultSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.exportBacktestResultMetadataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteBacktestResultSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(600000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(0x6DDD00L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(259200000L)).build()));
            builder.importRegisteredPartiesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ImportRegisteredPartiesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(30000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(180000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(1200000L)).build()));
            builder.exportRegisteredPartiesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ExportRegisteredPartiesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(30000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(180000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(1200000L)).build()));
            builder.createDatasetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Dataset.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(30000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(180000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(1200000L)).build()));
            builder.updateDatasetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Dataset.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(300000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(1800000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(86400000L)).build()));
            builder.deleteDatasetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(300000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(1800000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(86400000L)).build()));
            builder.createModelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Model.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(600000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(0x6DDD00L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(259200000L)).build()));
            builder.updateModelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Model.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.exportModelMetadataOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ExportModelMetadataResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(30000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(180000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(1200000L)).build()));
            builder.deleteModelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createEngineConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(EngineConfig.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(600000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(0x6DDD00L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(259200000L)).build()));
            builder.updateEngineConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(EngineConfig.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.exportEngineConfigMetadataOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ExportEngineConfigMetadataResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(30000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(180000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(1200000L)).build()));
            builder.deleteEngineConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createPredictionResultOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(PredictionResult.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(600000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(0x6DDD00L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(172800000L)).build()));
            builder.updatePredictionResultOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(PredictionResult.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.exportPredictionResultMetadataOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ExportPredictionResultMetadataResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(60000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(300000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(0x6DDD00L)).build()));
            builder.deletePredictionResultOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(30000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(180000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(1200000L)).build()));
            builder.createBacktestResultOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BacktestResult.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(600000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(0x6DDD00L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(172800000L)).build()));
            builder.updateBacktestResultOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BacktestResult.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.exportBacktestResultMetadataOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ExportBacktestResultMetadataResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(60000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(300000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(0x6DDD00L)).build()));
            builder.deleteBacktestResultOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(30000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(180000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(1200000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListInstancesRequest, ListInstancesResponse, AMLClient.ListInstancesPagedResponse> listInstancesSettings() {
            return this.listInstancesSettings;
        }

        public UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings() {
            return this.getInstanceSettings;
        }

        public UnaryCallSettings.Builder<CreateInstanceRequest, Operation> createInstanceSettings() {
            return this.createInstanceSettings;
        }

        public OperationCallSettings.Builder<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings() {
            return this.createInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateInstanceRequest, Operation> updateInstanceSettings() {
            return this.updateInstanceSettings;
        }

        public OperationCallSettings.Builder<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings() {
            return this.updateInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteInstanceRequest, Operation> deleteInstanceSettings() {
            return this.deleteInstanceSettings;
        }

        public OperationCallSettings.Builder<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings() {
            return this.deleteInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<ImportRegisteredPartiesRequest, Operation> importRegisteredPartiesSettings() {
            return this.importRegisteredPartiesSettings;
        }

        public OperationCallSettings.Builder<ImportRegisteredPartiesRequest, ImportRegisteredPartiesResponse, OperationMetadata> importRegisteredPartiesOperationSettings() {
            return this.importRegisteredPartiesOperationSettings;
        }

        public UnaryCallSettings.Builder<ExportRegisteredPartiesRequest, Operation> exportRegisteredPartiesSettings() {
            return this.exportRegisteredPartiesSettings;
        }

        public OperationCallSettings.Builder<ExportRegisteredPartiesRequest, ExportRegisteredPartiesResponse, OperationMetadata> exportRegisteredPartiesOperationSettings() {
            return this.exportRegisteredPartiesOperationSettings;
        }

        public PagedCallSettings.Builder<ListDatasetsRequest, ListDatasetsResponse, AMLClient.ListDatasetsPagedResponse> listDatasetsSettings() {
            return this.listDatasetsSettings;
        }

        public UnaryCallSettings.Builder<GetDatasetRequest, Dataset> getDatasetSettings() {
            return this.getDatasetSettings;
        }

        public UnaryCallSettings.Builder<CreateDatasetRequest, Operation> createDatasetSettings() {
            return this.createDatasetSettings;
        }

        public OperationCallSettings.Builder<CreateDatasetRequest, Dataset, OperationMetadata> createDatasetOperationSettings() {
            return this.createDatasetOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateDatasetRequest, Operation> updateDatasetSettings() {
            return this.updateDatasetSettings;
        }

        public OperationCallSettings.Builder<UpdateDatasetRequest, Dataset, OperationMetadata> updateDatasetOperationSettings() {
            return this.updateDatasetOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteDatasetRequest, Operation> deleteDatasetSettings() {
            return this.deleteDatasetSettings;
        }

        public OperationCallSettings.Builder<DeleteDatasetRequest, Empty, OperationMetadata> deleteDatasetOperationSettings() {
            return this.deleteDatasetOperationSettings;
        }

        public PagedCallSettings.Builder<ListModelsRequest, ListModelsResponse, AMLClient.ListModelsPagedResponse> listModelsSettings() {
            return this.listModelsSettings;
        }

        public UnaryCallSettings.Builder<GetModelRequest, Model> getModelSettings() {
            return this.getModelSettings;
        }

        public UnaryCallSettings.Builder<CreateModelRequest, Operation> createModelSettings() {
            return this.createModelSettings;
        }

        public OperationCallSettings.Builder<CreateModelRequest, Model, OperationMetadata> createModelOperationSettings() {
            return this.createModelOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateModelRequest, Operation> updateModelSettings() {
            return this.updateModelSettings;
        }

        public OperationCallSettings.Builder<UpdateModelRequest, Model, OperationMetadata> updateModelOperationSettings() {
            return this.updateModelOperationSettings;
        }

        public UnaryCallSettings.Builder<ExportModelMetadataRequest, Operation> exportModelMetadataSettings() {
            return this.exportModelMetadataSettings;
        }

        public OperationCallSettings.Builder<ExportModelMetadataRequest, ExportModelMetadataResponse, OperationMetadata> exportModelMetadataOperationSettings() {
            return this.exportModelMetadataOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteModelRequest, Operation> deleteModelSettings() {
            return this.deleteModelSettings;
        }

        public OperationCallSettings.Builder<DeleteModelRequest, Empty, OperationMetadata> deleteModelOperationSettings() {
            return this.deleteModelOperationSettings;
        }

        public PagedCallSettings.Builder<ListEngineConfigsRequest, ListEngineConfigsResponse, AMLClient.ListEngineConfigsPagedResponse> listEngineConfigsSettings() {
            return this.listEngineConfigsSettings;
        }

        public UnaryCallSettings.Builder<GetEngineConfigRequest, EngineConfig> getEngineConfigSettings() {
            return this.getEngineConfigSettings;
        }

        public UnaryCallSettings.Builder<CreateEngineConfigRequest, Operation> createEngineConfigSettings() {
            return this.createEngineConfigSettings;
        }

        public OperationCallSettings.Builder<CreateEngineConfigRequest, EngineConfig, OperationMetadata> createEngineConfigOperationSettings() {
            return this.createEngineConfigOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateEngineConfigRequest, Operation> updateEngineConfigSettings() {
            return this.updateEngineConfigSettings;
        }

        public OperationCallSettings.Builder<UpdateEngineConfigRequest, EngineConfig, OperationMetadata> updateEngineConfigOperationSettings() {
            return this.updateEngineConfigOperationSettings;
        }

        public UnaryCallSettings.Builder<ExportEngineConfigMetadataRequest, Operation> exportEngineConfigMetadataSettings() {
            return this.exportEngineConfigMetadataSettings;
        }

        public OperationCallSettings.Builder<ExportEngineConfigMetadataRequest, ExportEngineConfigMetadataResponse, OperationMetadata> exportEngineConfigMetadataOperationSettings() {
            return this.exportEngineConfigMetadataOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteEngineConfigRequest, Operation> deleteEngineConfigSettings() {
            return this.deleteEngineConfigSettings;
        }

        public OperationCallSettings.Builder<DeleteEngineConfigRequest, Empty, OperationMetadata> deleteEngineConfigOperationSettings() {
            return this.deleteEngineConfigOperationSettings;
        }

        public UnaryCallSettings.Builder<GetEngineVersionRequest, EngineVersion> getEngineVersionSettings() {
            return this.getEngineVersionSettings;
        }

        public PagedCallSettings.Builder<ListEngineVersionsRequest, ListEngineVersionsResponse, AMLClient.ListEngineVersionsPagedResponse> listEngineVersionsSettings() {
            return this.listEngineVersionsSettings;
        }

        public PagedCallSettings.Builder<ListPredictionResultsRequest, ListPredictionResultsResponse, AMLClient.ListPredictionResultsPagedResponse> listPredictionResultsSettings() {
            return this.listPredictionResultsSettings;
        }

        public UnaryCallSettings.Builder<GetPredictionResultRequest, PredictionResult> getPredictionResultSettings() {
            return this.getPredictionResultSettings;
        }

        public UnaryCallSettings.Builder<CreatePredictionResultRequest, Operation> createPredictionResultSettings() {
            return this.createPredictionResultSettings;
        }

        public OperationCallSettings.Builder<CreatePredictionResultRequest, PredictionResult, OperationMetadata> createPredictionResultOperationSettings() {
            return this.createPredictionResultOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdatePredictionResultRequest, Operation> updatePredictionResultSettings() {
            return this.updatePredictionResultSettings;
        }

        public OperationCallSettings.Builder<UpdatePredictionResultRequest, PredictionResult, OperationMetadata> updatePredictionResultOperationSettings() {
            return this.updatePredictionResultOperationSettings;
        }

        public UnaryCallSettings.Builder<ExportPredictionResultMetadataRequest, Operation> exportPredictionResultMetadataSettings() {
            return this.exportPredictionResultMetadataSettings;
        }

        public OperationCallSettings.Builder<ExportPredictionResultMetadataRequest, ExportPredictionResultMetadataResponse, OperationMetadata> exportPredictionResultMetadataOperationSettings() {
            return this.exportPredictionResultMetadataOperationSettings;
        }

        public UnaryCallSettings.Builder<DeletePredictionResultRequest, Operation> deletePredictionResultSettings() {
            return this.deletePredictionResultSettings;
        }

        public OperationCallSettings.Builder<DeletePredictionResultRequest, Empty, OperationMetadata> deletePredictionResultOperationSettings() {
            return this.deletePredictionResultOperationSettings;
        }

        public PagedCallSettings.Builder<ListBacktestResultsRequest, ListBacktestResultsResponse, AMLClient.ListBacktestResultsPagedResponse> listBacktestResultsSettings() {
            return this.listBacktestResultsSettings;
        }

        public UnaryCallSettings.Builder<GetBacktestResultRequest, BacktestResult> getBacktestResultSettings() {
            return this.getBacktestResultSettings;
        }

        public UnaryCallSettings.Builder<CreateBacktestResultRequest, Operation> createBacktestResultSettings() {
            return this.createBacktestResultSettings;
        }

        public OperationCallSettings.Builder<CreateBacktestResultRequest, BacktestResult, OperationMetadata> createBacktestResultOperationSettings() {
            return this.createBacktestResultOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateBacktestResultRequest, Operation> updateBacktestResultSettings() {
            return this.updateBacktestResultSettings;
        }

        public OperationCallSettings.Builder<UpdateBacktestResultRequest, BacktestResult, OperationMetadata> updateBacktestResultOperationSettings() {
            return this.updateBacktestResultOperationSettings;
        }

        public UnaryCallSettings.Builder<ExportBacktestResultMetadataRequest, Operation> exportBacktestResultMetadataSettings() {
            return this.exportBacktestResultMetadataSettings;
        }

        public OperationCallSettings.Builder<ExportBacktestResultMetadataRequest, ExportBacktestResultMetadataResponse, OperationMetadata> exportBacktestResultMetadataOperationSettings() {
            return this.exportBacktestResultMetadataOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteBacktestResultRequest, Operation> deleteBacktestResultSettings() {
            return this.deleteBacktestResultSettings;
        }

        public OperationCallSettings.Builder<DeleteBacktestResultRequest, Empty, OperationMetadata> deleteBacktestResultOperationSettings() {
            return this.deleteBacktestResultOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, AMLClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public AMLStubSettings build() throws IOException {
            return new AMLStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(10000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(10000L)).setTotalTimeoutDuration(Duration.ofMillis(10000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(120000L)).setTotalTimeoutDuration(Duration.ofMillis(120000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

