/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.filestore.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.common.OperationMetadata;
import com.google.cloud.filestore.v1.Backup;
import com.google.cloud.filestore.v1.CloudFilestoreManagerClient;
import com.google.cloud.filestore.v1.CreateBackupRequest;
import com.google.cloud.filestore.v1.CreateInstanceRequest;
import com.google.cloud.filestore.v1.CreateSnapshotRequest;
import com.google.cloud.filestore.v1.DeleteBackupRequest;
import com.google.cloud.filestore.v1.DeleteInstanceRequest;
import com.google.cloud.filestore.v1.DeleteSnapshotRequest;
import com.google.cloud.filestore.v1.GetBackupRequest;
import com.google.cloud.filestore.v1.GetInstanceRequest;
import com.google.cloud.filestore.v1.GetSnapshotRequest;
import com.google.cloud.filestore.v1.Instance;
import com.google.cloud.filestore.v1.ListBackupsRequest;
import com.google.cloud.filestore.v1.ListBackupsResponse;
import com.google.cloud.filestore.v1.ListInstancesRequest;
import com.google.cloud.filestore.v1.ListInstancesResponse;
import com.google.cloud.filestore.v1.ListSnapshotsRequest;
import com.google.cloud.filestore.v1.ListSnapshotsResponse;
import com.google.cloud.filestore.v1.RestoreInstanceRequest;
import com.google.cloud.filestore.v1.RevertInstanceRequest;
import com.google.cloud.filestore.v1.Snapshot;
import com.google.cloud.filestore.v1.UpdateBackupRequest;
import com.google.cloud.filestore.v1.UpdateInstanceRequest;
import com.google.cloud.filestore.v1.UpdateSnapshotRequest;
import com.google.cloud.filestore.v1.stub.CloudFilestoreManagerStub;
import com.google.cloud.filestore.v1.stub.GrpcCloudFilestoreManagerStub;
import com.google.cloud.filestore.v1.stub.HttpJsonCloudFilestoreManagerStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class CloudFilestoreManagerStubSettings
extends StubSettings<CloudFilestoreManagerStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListInstancesRequest, ListInstancesResponse, CloudFilestoreManagerClient.ListInstancesPagedResponse> listInstancesSettings;
    private final UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings;
    private final UnaryCallSettings<CreateInstanceRequest, Operation> createInstanceSettings;
    private final OperationCallSettings<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings;
    private final UnaryCallSettings<UpdateInstanceRequest, Operation> updateInstanceSettings;
    private final OperationCallSettings<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings;
    private final UnaryCallSettings<RestoreInstanceRequest, Operation> restoreInstanceSettings;
    private final OperationCallSettings<RestoreInstanceRequest, Instance, OperationMetadata> restoreInstanceOperationSettings;
    private final UnaryCallSettings<RevertInstanceRequest, Operation> revertInstanceSettings;
    private final OperationCallSettings<RevertInstanceRequest, Instance, OperationMetadata> revertInstanceOperationSettings;
    private final UnaryCallSettings<DeleteInstanceRequest, Operation> deleteInstanceSettings;
    private final OperationCallSettings<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings;
    private final PagedCallSettings<ListSnapshotsRequest, ListSnapshotsResponse, CloudFilestoreManagerClient.ListSnapshotsPagedResponse> listSnapshotsSettings;
    private final UnaryCallSettings<GetSnapshotRequest, Snapshot> getSnapshotSettings;
    private final UnaryCallSettings<CreateSnapshotRequest, Operation> createSnapshotSettings;
    private final OperationCallSettings<CreateSnapshotRequest, Snapshot, OperationMetadata> createSnapshotOperationSettings;
    private final UnaryCallSettings<DeleteSnapshotRequest, Operation> deleteSnapshotSettings;
    private final OperationCallSettings<DeleteSnapshotRequest, Empty, OperationMetadata> deleteSnapshotOperationSettings;
    private final UnaryCallSettings<UpdateSnapshotRequest, Operation> updateSnapshotSettings;
    private final OperationCallSettings<UpdateSnapshotRequest, Snapshot, OperationMetadata> updateSnapshotOperationSettings;
    private final PagedCallSettings<ListBackupsRequest, ListBackupsResponse, CloudFilestoreManagerClient.ListBackupsPagedResponse> listBackupsSettings;
    private final UnaryCallSettings<GetBackupRequest, Backup> getBackupSettings;
    private final UnaryCallSettings<CreateBackupRequest, Operation> createBackupSettings;
    private final OperationCallSettings<CreateBackupRequest, Backup, OperationMetadata> createBackupOperationSettings;
    private final UnaryCallSettings<DeleteBackupRequest, Operation> deleteBackupSettings;
    private final OperationCallSettings<DeleteBackupRequest, Empty, OperationMetadata> deleteBackupOperationSettings;
    private final UnaryCallSettings<UpdateBackupRequest, Operation> updateBackupSettings;
    private final OperationCallSettings<UpdateBackupRequest, Backup, OperationMetadata> updateBackupOperationSettings;
    private static final PagedListDescriptor<ListInstancesRequest, ListInstancesResponse, Instance> LIST_INSTANCES_PAGE_STR_DESC = new PagedListDescriptor<ListInstancesRequest, ListInstancesResponse, Instance>(){

        public String emptyToken() {
            return "";
        }

        public ListInstancesRequest injectToken(ListInstancesRequest payload, String token) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setPageToken(token).build();
        }

        public ListInstancesRequest injectPageSize(ListInstancesRequest payload, int pageSize) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListInstancesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListInstancesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Instance> extractResources(ListInstancesResponse payload) {
            return payload.getInstancesList() == null ? ImmutableList.of() : payload.getInstancesList();
        }
    };
    private static final PagedListDescriptor<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot> LIST_SNAPSHOTS_PAGE_STR_DESC = new PagedListDescriptor<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot>(){

        public String emptyToken() {
            return "";
        }

        public ListSnapshotsRequest injectToken(ListSnapshotsRequest payload, String token) {
            return ListSnapshotsRequest.newBuilder((ListSnapshotsRequest)payload).setPageToken(token).build();
        }

        public ListSnapshotsRequest injectPageSize(ListSnapshotsRequest payload, int pageSize) {
            return ListSnapshotsRequest.newBuilder((ListSnapshotsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSnapshotsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSnapshotsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Snapshot> extractResources(ListSnapshotsResponse payload) {
            return payload.getSnapshotsList() == null ? ImmutableList.of() : payload.getSnapshotsList();
        }
    };
    private static final PagedListDescriptor<ListBackupsRequest, ListBackupsResponse, Backup> LIST_BACKUPS_PAGE_STR_DESC = new PagedListDescriptor<ListBackupsRequest, ListBackupsResponse, Backup>(){

        public String emptyToken() {
            return "";
        }

        public ListBackupsRequest injectToken(ListBackupsRequest payload, String token) {
            return ListBackupsRequest.newBuilder((ListBackupsRequest)payload).setPageToken(token).build();
        }

        public ListBackupsRequest injectPageSize(ListBackupsRequest payload, int pageSize) {
            return ListBackupsRequest.newBuilder((ListBackupsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListBackupsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListBackupsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Backup> extractResources(ListBackupsResponse payload) {
            return payload.getBackupsList() == null ? ImmutableList.of() : payload.getBackupsList();
        }
    };
    private static final PagedListResponseFactory<ListInstancesRequest, ListInstancesResponse, CloudFilestoreManagerClient.ListInstancesPagedResponse> LIST_INSTANCES_PAGE_STR_FACT = new PagedListResponseFactory<ListInstancesRequest, ListInstancesResponse, CloudFilestoreManagerClient.ListInstancesPagedResponse>(){

        public ApiFuture<CloudFilestoreManagerClient.ListInstancesPagedResponse> getFuturePagedResponse(UnaryCallable<ListInstancesRequest, ListInstancesResponse> callable, ListInstancesRequest request, ApiCallContext context, ApiFuture<ListInstancesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INSTANCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudFilestoreManagerClient.ListInstancesPagedResponse.createAsync((PageContext<ListInstancesRequest, ListInstancesResponse, Instance>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSnapshotsRequest, ListSnapshotsResponse, CloudFilestoreManagerClient.ListSnapshotsPagedResponse> LIST_SNAPSHOTS_PAGE_STR_FACT = new PagedListResponseFactory<ListSnapshotsRequest, ListSnapshotsResponse, CloudFilestoreManagerClient.ListSnapshotsPagedResponse>(){

        public ApiFuture<CloudFilestoreManagerClient.ListSnapshotsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSnapshotsRequest, ListSnapshotsResponse> callable, ListSnapshotsRequest request, ApiCallContext context, ApiFuture<ListSnapshotsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SNAPSHOTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudFilestoreManagerClient.ListSnapshotsPagedResponse.createAsync((PageContext<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListBackupsRequest, ListBackupsResponse, CloudFilestoreManagerClient.ListBackupsPagedResponse> LIST_BACKUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListBackupsRequest, ListBackupsResponse, CloudFilestoreManagerClient.ListBackupsPagedResponse>(){

        public ApiFuture<CloudFilestoreManagerClient.ListBackupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListBackupsRequest, ListBackupsResponse> callable, ListBackupsRequest request, ApiCallContext context, ApiFuture<ListBackupsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BACKUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudFilestoreManagerClient.ListBackupsPagedResponse.createAsync((PageContext<ListBackupsRequest, ListBackupsResponse, Backup>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListInstancesRequest, ListInstancesResponse, CloudFilestoreManagerClient.ListInstancesPagedResponse> listInstancesSettings() {
        return this.listInstancesSettings;
    }

    public UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings() {
        return this.getInstanceSettings;
    }

    public UnaryCallSettings<CreateInstanceRequest, Operation> createInstanceSettings() {
        return this.createInstanceSettings;
    }

    public OperationCallSettings<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings() {
        return this.createInstanceOperationSettings;
    }

    public UnaryCallSettings<UpdateInstanceRequest, Operation> updateInstanceSettings() {
        return this.updateInstanceSettings;
    }

    public OperationCallSettings<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings() {
        return this.updateInstanceOperationSettings;
    }

    public UnaryCallSettings<RestoreInstanceRequest, Operation> restoreInstanceSettings() {
        return this.restoreInstanceSettings;
    }

    public OperationCallSettings<RestoreInstanceRequest, Instance, OperationMetadata> restoreInstanceOperationSettings() {
        return this.restoreInstanceOperationSettings;
    }

    public UnaryCallSettings<RevertInstanceRequest, Operation> revertInstanceSettings() {
        return this.revertInstanceSettings;
    }

    public OperationCallSettings<RevertInstanceRequest, Instance, OperationMetadata> revertInstanceOperationSettings() {
        return this.revertInstanceOperationSettings;
    }

    public UnaryCallSettings<DeleteInstanceRequest, Operation> deleteInstanceSettings() {
        return this.deleteInstanceSettings;
    }

    public OperationCallSettings<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings() {
        return this.deleteInstanceOperationSettings;
    }

    public PagedCallSettings<ListSnapshotsRequest, ListSnapshotsResponse, CloudFilestoreManagerClient.ListSnapshotsPagedResponse> listSnapshotsSettings() {
        return this.listSnapshotsSettings;
    }

    public UnaryCallSettings<GetSnapshotRequest, Snapshot> getSnapshotSettings() {
        return this.getSnapshotSettings;
    }

    public UnaryCallSettings<CreateSnapshotRequest, Operation> createSnapshotSettings() {
        return this.createSnapshotSettings;
    }

    public OperationCallSettings<CreateSnapshotRequest, Snapshot, OperationMetadata> createSnapshotOperationSettings() {
        return this.createSnapshotOperationSettings;
    }

    public UnaryCallSettings<DeleteSnapshotRequest, Operation> deleteSnapshotSettings() {
        return this.deleteSnapshotSettings;
    }

    public OperationCallSettings<DeleteSnapshotRequest, Empty, OperationMetadata> deleteSnapshotOperationSettings() {
        return this.deleteSnapshotOperationSettings;
    }

    public UnaryCallSettings<UpdateSnapshotRequest, Operation> updateSnapshotSettings() {
        return this.updateSnapshotSettings;
    }

    public OperationCallSettings<UpdateSnapshotRequest, Snapshot, OperationMetadata> updateSnapshotOperationSettings() {
        return this.updateSnapshotOperationSettings;
    }

    public PagedCallSettings<ListBackupsRequest, ListBackupsResponse, CloudFilestoreManagerClient.ListBackupsPagedResponse> listBackupsSettings() {
        return this.listBackupsSettings;
    }

    public UnaryCallSettings<GetBackupRequest, Backup> getBackupSettings() {
        return this.getBackupSettings;
    }

    public UnaryCallSettings<CreateBackupRequest, Operation> createBackupSettings() {
        return this.createBackupSettings;
    }

    public OperationCallSettings<CreateBackupRequest, Backup, OperationMetadata> createBackupOperationSettings() {
        return this.createBackupOperationSettings;
    }

    public UnaryCallSettings<DeleteBackupRequest, Operation> deleteBackupSettings() {
        return this.deleteBackupSettings;
    }

    public OperationCallSettings<DeleteBackupRequest, Empty, OperationMetadata> deleteBackupOperationSettings() {
        return this.deleteBackupOperationSettings;
    }

    public UnaryCallSettings<UpdateBackupRequest, Operation> updateBackupSettings() {
        return this.updateBackupSettings;
    }

    public OperationCallSettings<UpdateBackupRequest, Backup, OperationMetadata> updateBackupOperationSettings() {
        return this.updateBackupOperationSettings;
    }

    public CloudFilestoreManagerStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCloudFilestoreManagerStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCloudFilestoreManagerStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "file";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "file.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "file.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CloudFilestoreManagerStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudFilestoreManagerStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudFilestoreManagerStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return CloudFilestoreManagerStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CloudFilestoreManagerStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listInstancesSettings = settingsBuilder.listInstancesSettings().build();
        this.getInstanceSettings = settingsBuilder.getInstanceSettings().build();
        this.createInstanceSettings = settingsBuilder.createInstanceSettings().build();
        this.createInstanceOperationSettings = settingsBuilder.createInstanceOperationSettings().build();
        this.updateInstanceSettings = settingsBuilder.updateInstanceSettings().build();
        this.updateInstanceOperationSettings = settingsBuilder.updateInstanceOperationSettings().build();
        this.restoreInstanceSettings = settingsBuilder.restoreInstanceSettings().build();
        this.restoreInstanceOperationSettings = settingsBuilder.restoreInstanceOperationSettings().build();
        this.revertInstanceSettings = settingsBuilder.revertInstanceSettings().build();
        this.revertInstanceOperationSettings = settingsBuilder.revertInstanceOperationSettings().build();
        this.deleteInstanceSettings = settingsBuilder.deleteInstanceSettings().build();
        this.deleteInstanceOperationSettings = settingsBuilder.deleteInstanceOperationSettings().build();
        this.listSnapshotsSettings = settingsBuilder.listSnapshotsSettings().build();
        this.getSnapshotSettings = settingsBuilder.getSnapshotSettings().build();
        this.createSnapshotSettings = settingsBuilder.createSnapshotSettings().build();
        this.createSnapshotOperationSettings = settingsBuilder.createSnapshotOperationSettings().build();
        this.deleteSnapshotSettings = settingsBuilder.deleteSnapshotSettings().build();
        this.deleteSnapshotOperationSettings = settingsBuilder.deleteSnapshotOperationSettings().build();
        this.updateSnapshotSettings = settingsBuilder.updateSnapshotSettings().build();
        this.updateSnapshotOperationSettings = settingsBuilder.updateSnapshotOperationSettings().build();
        this.listBackupsSettings = settingsBuilder.listBackupsSettings().build();
        this.getBackupSettings = settingsBuilder.getBackupSettings().build();
        this.createBackupSettings = settingsBuilder.createBackupSettings().build();
        this.createBackupOperationSettings = settingsBuilder.createBackupOperationSettings().build();
        this.deleteBackupSettings = settingsBuilder.deleteBackupSettings().build();
        this.deleteBackupOperationSettings = settingsBuilder.deleteBackupOperationSettings().build();
        this.updateBackupSettings = settingsBuilder.updateBackupSettings().build();
        this.updateBackupOperationSettings = settingsBuilder.updateBackupOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CloudFilestoreManagerStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListInstancesRequest, ListInstancesResponse, CloudFilestoreManagerClient.ListInstancesPagedResponse> listInstancesSettings;
        private final UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings;
        private final UnaryCallSettings.Builder<CreateInstanceRequest, Operation> createInstanceSettings;
        private final OperationCallSettings.Builder<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings;
        private final UnaryCallSettings.Builder<UpdateInstanceRequest, Operation> updateInstanceSettings;
        private final OperationCallSettings.Builder<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings;
        private final UnaryCallSettings.Builder<RestoreInstanceRequest, Operation> restoreInstanceSettings;
        private final OperationCallSettings.Builder<RestoreInstanceRequest, Instance, OperationMetadata> restoreInstanceOperationSettings;
        private final UnaryCallSettings.Builder<RevertInstanceRequest, Operation> revertInstanceSettings;
        private final OperationCallSettings.Builder<RevertInstanceRequest, Instance, OperationMetadata> revertInstanceOperationSettings;
        private final UnaryCallSettings.Builder<DeleteInstanceRequest, Operation> deleteInstanceSettings;
        private final OperationCallSettings.Builder<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings;
        private final PagedCallSettings.Builder<ListSnapshotsRequest, ListSnapshotsResponse, CloudFilestoreManagerClient.ListSnapshotsPagedResponse> listSnapshotsSettings;
        private final UnaryCallSettings.Builder<GetSnapshotRequest, Snapshot> getSnapshotSettings;
        private final UnaryCallSettings.Builder<CreateSnapshotRequest, Operation> createSnapshotSettings;
        private final OperationCallSettings.Builder<CreateSnapshotRequest, Snapshot, OperationMetadata> createSnapshotOperationSettings;
        private final UnaryCallSettings.Builder<DeleteSnapshotRequest, Operation> deleteSnapshotSettings;
        private final OperationCallSettings.Builder<DeleteSnapshotRequest, Empty, OperationMetadata> deleteSnapshotOperationSettings;
        private final UnaryCallSettings.Builder<UpdateSnapshotRequest, Operation> updateSnapshotSettings;
        private final OperationCallSettings.Builder<UpdateSnapshotRequest, Snapshot, OperationMetadata> updateSnapshotOperationSettings;
        private final PagedCallSettings.Builder<ListBackupsRequest, ListBackupsResponse, CloudFilestoreManagerClient.ListBackupsPagedResponse> listBackupsSettings;
        private final UnaryCallSettings.Builder<GetBackupRequest, Backup> getBackupSettings;
        private final UnaryCallSettings.Builder<CreateBackupRequest, Operation> createBackupSettings;
        private final OperationCallSettings.Builder<CreateBackupRequest, Backup, OperationMetadata> createBackupOperationSettings;
        private final UnaryCallSettings.Builder<DeleteBackupRequest, Operation> deleteBackupSettings;
        private final OperationCallSettings.Builder<DeleteBackupRequest, Empty, OperationMetadata> deleteBackupOperationSettings;
        private final UnaryCallSettings.Builder<UpdateBackupRequest, Operation> updateBackupSettings;
        private final OperationCallSettings.Builder<UpdateBackupRequest, Backup, OperationMetadata> updateBackupOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listInstancesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INSTANCES_PAGE_STR_FACT);
            this.getInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.updateInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.restoreInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.restoreInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.revertInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.revertInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.deleteInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.listSnapshotsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SNAPSHOTS_PAGE_STR_FACT);
            this.getSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSnapshotOperationSettings = OperationCallSettings.newBuilder();
            this.deleteSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSnapshotOperationSettings = OperationCallSettings.newBuilder();
            this.updateSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSnapshotOperationSettings = OperationCallSettings.newBuilder();
            this.listBackupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BACKUPS_PAGE_STR_FACT);
            this.getBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createBackupOperationSettings = OperationCallSettings.newBuilder();
            this.deleteBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteBackupOperationSettings = OperationCallSettings.newBuilder();
            this.updateBackupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateBackupOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listInstancesSettings, this.getInstanceSettings, this.createInstanceSettings, this.updateInstanceSettings, this.restoreInstanceSettings, this.revertInstanceSettings, this.deleteInstanceSettings, this.listSnapshotsSettings, this.getSnapshotSettings, this.createSnapshotSettings, this.deleteSnapshotSettings, this.updateSnapshotSettings, (Object[])new UnaryCallSettings.Builder[]{this.listBackupsSettings, this.getBackupSettings, this.createBackupSettings, this.deleteBackupSettings, this.updateBackupSettings});
            Builder.initDefaults(this);
        }

        protected Builder(CloudFilestoreManagerStubSettings settings) {
            super((StubSettings)settings);
            this.listInstancesSettings = settings.listInstancesSettings.toBuilder();
            this.getInstanceSettings = settings.getInstanceSettings.toBuilder();
            this.createInstanceSettings = settings.createInstanceSettings.toBuilder();
            this.createInstanceOperationSettings = settings.createInstanceOperationSettings.toBuilder();
            this.updateInstanceSettings = settings.updateInstanceSettings.toBuilder();
            this.updateInstanceOperationSettings = settings.updateInstanceOperationSettings.toBuilder();
            this.restoreInstanceSettings = settings.restoreInstanceSettings.toBuilder();
            this.restoreInstanceOperationSettings = settings.restoreInstanceOperationSettings.toBuilder();
            this.revertInstanceSettings = settings.revertInstanceSettings.toBuilder();
            this.revertInstanceOperationSettings = settings.revertInstanceOperationSettings.toBuilder();
            this.deleteInstanceSettings = settings.deleteInstanceSettings.toBuilder();
            this.deleteInstanceOperationSettings = settings.deleteInstanceOperationSettings.toBuilder();
            this.listSnapshotsSettings = settings.listSnapshotsSettings.toBuilder();
            this.getSnapshotSettings = settings.getSnapshotSettings.toBuilder();
            this.createSnapshotSettings = settings.createSnapshotSettings.toBuilder();
            this.createSnapshotOperationSettings = settings.createSnapshotOperationSettings.toBuilder();
            this.deleteSnapshotSettings = settings.deleteSnapshotSettings.toBuilder();
            this.deleteSnapshotOperationSettings = settings.deleteSnapshotOperationSettings.toBuilder();
            this.updateSnapshotSettings = settings.updateSnapshotSettings.toBuilder();
            this.updateSnapshotOperationSettings = settings.updateSnapshotOperationSettings.toBuilder();
            this.listBackupsSettings = settings.listBackupsSettings.toBuilder();
            this.getBackupSettings = settings.getBackupSettings.toBuilder();
            this.createBackupSettings = settings.createBackupSettings.toBuilder();
            this.createBackupOperationSettings = settings.createBackupOperationSettings.toBuilder();
            this.deleteBackupSettings = settings.deleteBackupSettings.toBuilder();
            this.deleteBackupOperationSettings = settings.deleteBackupOperationSettings.toBuilder();
            this.updateBackupSettings = settings.updateBackupSettings.toBuilder();
            this.updateBackupOperationSettings = settings.updateBackupOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listInstancesSettings, this.getInstanceSettings, this.createInstanceSettings, this.updateInstanceSettings, this.restoreInstanceSettings, this.revertInstanceSettings, this.deleteInstanceSettings, this.listSnapshotsSettings, this.getSnapshotSettings, this.createSnapshotSettings, this.deleteSnapshotSettings, this.updateSnapshotSettings, (Object[])new UnaryCallSettings.Builder[]{this.listBackupsSettings, this.getBackupSettings, this.createBackupSettings, this.deleteBackupSettings, this.updateBackupSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CloudFilestoreManagerStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CloudFilestoreManagerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudFilestoreManagerStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CloudFilestoreManagerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)CloudFilestoreManagerStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)CloudFilestoreManagerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudFilestoreManagerStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CloudFilestoreManagerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.restoreInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.revertInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.listSnapshotsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listBackupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.updateBackupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.createInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.restoreInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.revertInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createSnapshotOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Snapshot.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteSnapshotOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateSnapshotOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Snapshot.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createBackupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Backup.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteBackupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateBackupOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Backup.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListInstancesRequest, ListInstancesResponse, CloudFilestoreManagerClient.ListInstancesPagedResponse> listInstancesSettings() {
            return this.listInstancesSettings;
        }

        public UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings() {
            return this.getInstanceSettings;
        }

        public UnaryCallSettings.Builder<CreateInstanceRequest, Operation> createInstanceSettings() {
            return this.createInstanceSettings;
        }

        public OperationCallSettings.Builder<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings() {
            return this.createInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateInstanceRequest, Operation> updateInstanceSettings() {
            return this.updateInstanceSettings;
        }

        public OperationCallSettings.Builder<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings() {
            return this.updateInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<RestoreInstanceRequest, Operation> restoreInstanceSettings() {
            return this.restoreInstanceSettings;
        }

        public OperationCallSettings.Builder<RestoreInstanceRequest, Instance, OperationMetadata> restoreInstanceOperationSettings() {
            return this.restoreInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<RevertInstanceRequest, Operation> revertInstanceSettings() {
            return this.revertInstanceSettings;
        }

        public OperationCallSettings.Builder<RevertInstanceRequest, Instance, OperationMetadata> revertInstanceOperationSettings() {
            return this.revertInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteInstanceRequest, Operation> deleteInstanceSettings() {
            return this.deleteInstanceSettings;
        }

        public OperationCallSettings.Builder<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings() {
            return this.deleteInstanceOperationSettings;
        }

        public PagedCallSettings.Builder<ListSnapshotsRequest, ListSnapshotsResponse, CloudFilestoreManagerClient.ListSnapshotsPagedResponse> listSnapshotsSettings() {
            return this.listSnapshotsSettings;
        }

        public UnaryCallSettings.Builder<GetSnapshotRequest, Snapshot> getSnapshotSettings() {
            return this.getSnapshotSettings;
        }

        public UnaryCallSettings.Builder<CreateSnapshotRequest, Operation> createSnapshotSettings() {
            return this.createSnapshotSettings;
        }

        public OperationCallSettings.Builder<CreateSnapshotRequest, Snapshot, OperationMetadata> createSnapshotOperationSettings() {
            return this.createSnapshotOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteSnapshotRequest, Operation> deleteSnapshotSettings() {
            return this.deleteSnapshotSettings;
        }

        public OperationCallSettings.Builder<DeleteSnapshotRequest, Empty, OperationMetadata> deleteSnapshotOperationSettings() {
            return this.deleteSnapshotOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateSnapshotRequest, Operation> updateSnapshotSettings() {
            return this.updateSnapshotSettings;
        }

        public OperationCallSettings.Builder<UpdateSnapshotRequest, Snapshot, OperationMetadata> updateSnapshotOperationSettings() {
            return this.updateSnapshotOperationSettings;
        }

        public PagedCallSettings.Builder<ListBackupsRequest, ListBackupsResponse, CloudFilestoreManagerClient.ListBackupsPagedResponse> listBackupsSettings() {
            return this.listBackupsSettings;
        }

        public UnaryCallSettings.Builder<GetBackupRequest, Backup> getBackupSettings() {
            return this.getBackupSettings;
        }

        public UnaryCallSettings.Builder<CreateBackupRequest, Operation> createBackupSettings() {
            return this.createBackupSettings;
        }

        public OperationCallSettings.Builder<CreateBackupRequest, Backup, OperationMetadata> createBackupOperationSettings() {
            return this.createBackupOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteBackupRequest, Operation> deleteBackupSettings() {
            return this.deleteBackupSettings;
        }

        public OperationCallSettings.Builder<DeleteBackupRequest, Empty, OperationMetadata> deleteBackupOperationSettings() {
            return this.deleteBackupOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateBackupRequest, Operation> updateBackupSettings() {
            return this.updateBackupSettings;
        }

        public OperationCallSettings.Builder<UpdateBackupRequest, Backup, OperationMetadata> updateBackupOperationSettings() {
            return this.updateBackupOperationSettings;
        }

        public CloudFilestoreManagerStubSettings build() throws IOException {
            return new CloudFilestoreManagerStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_3_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)250L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)32000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000000L)).setTotalTimeout(Duration.ofMillis((long)60000000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)14400000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)14400000L)).setTotalTimeout(Duration.ofMillis((long)14400000L)).build();
            definitions.put((Object)"no_retry_2_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_3_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

