/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.eventarc.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.eventarc.v1.Channel;
import com.google.cloud.eventarc.v1.ChannelConnection;
import com.google.cloud.eventarc.v1.CreateChannelConnectionRequest;
import com.google.cloud.eventarc.v1.CreateChannelRequest;
import com.google.cloud.eventarc.v1.CreateEnrollmentRequest;
import com.google.cloud.eventarc.v1.CreateGoogleApiSourceRequest;
import com.google.cloud.eventarc.v1.CreateMessageBusRequest;
import com.google.cloud.eventarc.v1.CreatePipelineRequest;
import com.google.cloud.eventarc.v1.CreateTriggerRequest;
import com.google.cloud.eventarc.v1.DeleteChannelConnectionRequest;
import com.google.cloud.eventarc.v1.DeleteChannelRequest;
import com.google.cloud.eventarc.v1.DeleteEnrollmentRequest;
import com.google.cloud.eventarc.v1.DeleteGoogleApiSourceRequest;
import com.google.cloud.eventarc.v1.DeleteMessageBusRequest;
import com.google.cloud.eventarc.v1.DeletePipelineRequest;
import com.google.cloud.eventarc.v1.DeleteTriggerRequest;
import com.google.cloud.eventarc.v1.Enrollment;
import com.google.cloud.eventarc.v1.EventarcClient;
import com.google.cloud.eventarc.v1.GetChannelConnectionRequest;
import com.google.cloud.eventarc.v1.GetChannelRequest;
import com.google.cloud.eventarc.v1.GetEnrollmentRequest;
import com.google.cloud.eventarc.v1.GetGoogleApiSourceRequest;
import com.google.cloud.eventarc.v1.GetGoogleChannelConfigRequest;
import com.google.cloud.eventarc.v1.GetMessageBusRequest;
import com.google.cloud.eventarc.v1.GetPipelineRequest;
import com.google.cloud.eventarc.v1.GetProviderRequest;
import com.google.cloud.eventarc.v1.GetTriggerRequest;
import com.google.cloud.eventarc.v1.GoogleApiSource;
import com.google.cloud.eventarc.v1.GoogleChannelConfig;
import com.google.cloud.eventarc.v1.ListChannelConnectionsRequest;
import com.google.cloud.eventarc.v1.ListChannelConnectionsResponse;
import com.google.cloud.eventarc.v1.ListChannelsRequest;
import com.google.cloud.eventarc.v1.ListChannelsResponse;
import com.google.cloud.eventarc.v1.ListEnrollmentsRequest;
import com.google.cloud.eventarc.v1.ListEnrollmentsResponse;
import com.google.cloud.eventarc.v1.ListGoogleApiSourcesRequest;
import com.google.cloud.eventarc.v1.ListGoogleApiSourcesResponse;
import com.google.cloud.eventarc.v1.ListMessageBusEnrollmentsRequest;
import com.google.cloud.eventarc.v1.ListMessageBusEnrollmentsResponse;
import com.google.cloud.eventarc.v1.ListMessageBusesRequest;
import com.google.cloud.eventarc.v1.ListMessageBusesResponse;
import com.google.cloud.eventarc.v1.ListPipelinesRequest;
import com.google.cloud.eventarc.v1.ListPipelinesResponse;
import com.google.cloud.eventarc.v1.ListProvidersRequest;
import com.google.cloud.eventarc.v1.ListProvidersResponse;
import com.google.cloud.eventarc.v1.ListTriggersRequest;
import com.google.cloud.eventarc.v1.ListTriggersResponse;
import com.google.cloud.eventarc.v1.MessageBus;
import com.google.cloud.eventarc.v1.OperationMetadata;
import com.google.cloud.eventarc.v1.Pipeline;
import com.google.cloud.eventarc.v1.Provider;
import com.google.cloud.eventarc.v1.Trigger;
import com.google.cloud.eventarc.v1.UpdateChannelRequest;
import com.google.cloud.eventarc.v1.UpdateEnrollmentRequest;
import com.google.cloud.eventarc.v1.UpdateGoogleApiSourceRequest;
import com.google.cloud.eventarc.v1.UpdateGoogleChannelConfigRequest;
import com.google.cloud.eventarc.v1.UpdateMessageBusRequest;
import com.google.cloud.eventarc.v1.UpdatePipelineRequest;
import com.google.cloud.eventarc.v1.UpdateTriggerRequest;
import com.google.cloud.eventarc.v1.stub.EventarcStub;
import com.google.cloud.eventarc.v1.stub.GrpcEventarcStub;
import com.google.cloud.eventarc.v1.stub.HttpJsonEventarcStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class EventarcStubSettings
extends StubSettings<EventarcStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetTriggerRequest, Trigger> getTriggerSettings;
    private final PagedCallSettings<ListTriggersRequest, ListTriggersResponse, EventarcClient.ListTriggersPagedResponse> listTriggersSettings;
    private final UnaryCallSettings<CreateTriggerRequest, Operation> createTriggerSettings;
    private final OperationCallSettings<CreateTriggerRequest, Trigger, OperationMetadata> createTriggerOperationSettings;
    private final UnaryCallSettings<UpdateTriggerRequest, Operation> updateTriggerSettings;
    private final OperationCallSettings<UpdateTriggerRequest, Trigger, OperationMetadata> updateTriggerOperationSettings;
    private final UnaryCallSettings<DeleteTriggerRequest, Operation> deleteTriggerSettings;
    private final OperationCallSettings<DeleteTriggerRequest, Trigger, OperationMetadata> deleteTriggerOperationSettings;
    private final UnaryCallSettings<GetChannelRequest, Channel> getChannelSettings;
    private final PagedCallSettings<ListChannelsRequest, ListChannelsResponse, EventarcClient.ListChannelsPagedResponse> listChannelsSettings;
    private final UnaryCallSettings<CreateChannelRequest, Operation> createChannelSettings;
    private final OperationCallSettings<CreateChannelRequest, Channel, OperationMetadata> createChannelOperationSettings;
    private final UnaryCallSettings<UpdateChannelRequest, Operation> updateChannelSettings;
    private final OperationCallSettings<UpdateChannelRequest, Channel, OperationMetadata> updateChannelOperationSettings;
    private final UnaryCallSettings<DeleteChannelRequest, Operation> deleteChannelSettings;
    private final OperationCallSettings<DeleteChannelRequest, Channel, OperationMetadata> deleteChannelOperationSettings;
    private final UnaryCallSettings<GetProviderRequest, Provider> getProviderSettings;
    private final PagedCallSettings<ListProvidersRequest, ListProvidersResponse, EventarcClient.ListProvidersPagedResponse> listProvidersSettings;
    private final UnaryCallSettings<GetChannelConnectionRequest, ChannelConnection> getChannelConnectionSettings;
    private final PagedCallSettings<ListChannelConnectionsRequest, ListChannelConnectionsResponse, EventarcClient.ListChannelConnectionsPagedResponse> listChannelConnectionsSettings;
    private final UnaryCallSettings<CreateChannelConnectionRequest, Operation> createChannelConnectionSettings;
    private final OperationCallSettings<CreateChannelConnectionRequest, ChannelConnection, OperationMetadata> createChannelConnectionOperationSettings;
    private final UnaryCallSettings<DeleteChannelConnectionRequest, Operation> deleteChannelConnectionSettings;
    private final OperationCallSettings<DeleteChannelConnectionRequest, ChannelConnection, OperationMetadata> deleteChannelConnectionOperationSettings;
    private final UnaryCallSettings<GetGoogleChannelConfigRequest, GoogleChannelConfig> getGoogleChannelConfigSettings;
    private final UnaryCallSettings<UpdateGoogleChannelConfigRequest, GoogleChannelConfig> updateGoogleChannelConfigSettings;
    private final UnaryCallSettings<GetMessageBusRequest, MessageBus> getMessageBusSettings;
    private final PagedCallSettings<ListMessageBusesRequest, ListMessageBusesResponse, EventarcClient.ListMessageBusesPagedResponse> listMessageBusesSettings;
    private final PagedCallSettings<ListMessageBusEnrollmentsRequest, ListMessageBusEnrollmentsResponse, EventarcClient.ListMessageBusEnrollmentsPagedResponse> listMessageBusEnrollmentsSettings;
    private final UnaryCallSettings<CreateMessageBusRequest, Operation> createMessageBusSettings;
    private final OperationCallSettings<CreateMessageBusRequest, MessageBus, OperationMetadata> createMessageBusOperationSettings;
    private final UnaryCallSettings<UpdateMessageBusRequest, Operation> updateMessageBusSettings;
    private final OperationCallSettings<UpdateMessageBusRequest, MessageBus, OperationMetadata> updateMessageBusOperationSettings;
    private final UnaryCallSettings<DeleteMessageBusRequest, Operation> deleteMessageBusSettings;
    private final OperationCallSettings<DeleteMessageBusRequest, MessageBus, OperationMetadata> deleteMessageBusOperationSettings;
    private final UnaryCallSettings<GetEnrollmentRequest, Enrollment> getEnrollmentSettings;
    private final PagedCallSettings<ListEnrollmentsRequest, ListEnrollmentsResponse, EventarcClient.ListEnrollmentsPagedResponse> listEnrollmentsSettings;
    private final UnaryCallSettings<CreateEnrollmentRequest, Operation> createEnrollmentSettings;
    private final OperationCallSettings<CreateEnrollmentRequest, Enrollment, OperationMetadata> createEnrollmentOperationSettings;
    private final UnaryCallSettings<UpdateEnrollmentRequest, Operation> updateEnrollmentSettings;
    private final OperationCallSettings<UpdateEnrollmentRequest, Enrollment, OperationMetadata> updateEnrollmentOperationSettings;
    private final UnaryCallSettings<DeleteEnrollmentRequest, Operation> deleteEnrollmentSettings;
    private final OperationCallSettings<DeleteEnrollmentRequest, Enrollment, OperationMetadata> deleteEnrollmentOperationSettings;
    private final UnaryCallSettings<GetPipelineRequest, Pipeline> getPipelineSettings;
    private final PagedCallSettings<ListPipelinesRequest, ListPipelinesResponse, EventarcClient.ListPipelinesPagedResponse> listPipelinesSettings;
    private final UnaryCallSettings<CreatePipelineRequest, Operation> createPipelineSettings;
    private final OperationCallSettings<CreatePipelineRequest, Pipeline, OperationMetadata> createPipelineOperationSettings;
    private final UnaryCallSettings<UpdatePipelineRequest, Operation> updatePipelineSettings;
    private final OperationCallSettings<UpdatePipelineRequest, Pipeline, OperationMetadata> updatePipelineOperationSettings;
    private final UnaryCallSettings<DeletePipelineRequest, Operation> deletePipelineSettings;
    private final OperationCallSettings<DeletePipelineRequest, Pipeline, OperationMetadata> deletePipelineOperationSettings;
    private final UnaryCallSettings<GetGoogleApiSourceRequest, GoogleApiSource> getGoogleApiSourceSettings;
    private final PagedCallSettings<ListGoogleApiSourcesRequest, ListGoogleApiSourcesResponse, EventarcClient.ListGoogleApiSourcesPagedResponse> listGoogleApiSourcesSettings;
    private final UnaryCallSettings<CreateGoogleApiSourceRequest, Operation> createGoogleApiSourceSettings;
    private final OperationCallSettings<CreateGoogleApiSourceRequest, GoogleApiSource, OperationMetadata> createGoogleApiSourceOperationSettings;
    private final UnaryCallSettings<UpdateGoogleApiSourceRequest, Operation> updateGoogleApiSourceSettings;
    private final OperationCallSettings<UpdateGoogleApiSourceRequest, GoogleApiSource, OperationMetadata> updateGoogleApiSourceOperationSettings;
    private final UnaryCallSettings<DeleteGoogleApiSourceRequest, Operation> deleteGoogleApiSourceSettings;
    private final OperationCallSettings<DeleteGoogleApiSourceRequest, GoogleApiSource, OperationMetadata> deleteGoogleApiSourceOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, EventarcClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListTriggersRequest, ListTriggersResponse, Trigger> LIST_TRIGGERS_PAGE_STR_DESC = new PagedListDescriptor<ListTriggersRequest, ListTriggersResponse, Trigger>(){

        public String emptyToken() {
            return "";
        }

        public ListTriggersRequest injectToken(ListTriggersRequest payload, String token) {
            return ListTriggersRequest.newBuilder((ListTriggersRequest)payload).setPageToken(token).build();
        }

        public ListTriggersRequest injectPageSize(ListTriggersRequest payload, int pageSize) {
            return ListTriggersRequest.newBuilder((ListTriggersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTriggersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTriggersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Trigger> extractResources(ListTriggersResponse payload) {
            return payload.getTriggersList();
        }
    };
    private static final PagedListDescriptor<ListChannelsRequest, ListChannelsResponse, Channel> LIST_CHANNELS_PAGE_STR_DESC = new PagedListDescriptor<ListChannelsRequest, ListChannelsResponse, Channel>(){

        public String emptyToken() {
            return "";
        }

        public ListChannelsRequest injectToken(ListChannelsRequest payload, String token) {
            return ListChannelsRequest.newBuilder((ListChannelsRequest)payload).setPageToken(token).build();
        }

        public ListChannelsRequest injectPageSize(ListChannelsRequest payload, int pageSize) {
            return ListChannelsRequest.newBuilder((ListChannelsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListChannelsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListChannelsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Channel> extractResources(ListChannelsResponse payload) {
            return payload.getChannelsList();
        }
    };
    private static final PagedListDescriptor<ListProvidersRequest, ListProvidersResponse, Provider> LIST_PROVIDERS_PAGE_STR_DESC = new PagedListDescriptor<ListProvidersRequest, ListProvidersResponse, Provider>(){

        public String emptyToken() {
            return "";
        }

        public ListProvidersRequest injectToken(ListProvidersRequest payload, String token) {
            return ListProvidersRequest.newBuilder((ListProvidersRequest)payload).setPageToken(token).build();
        }

        public ListProvidersRequest injectPageSize(ListProvidersRequest payload, int pageSize) {
            return ListProvidersRequest.newBuilder((ListProvidersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListProvidersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListProvidersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Provider> extractResources(ListProvidersResponse payload) {
            return payload.getProvidersList();
        }
    };
    private static final PagedListDescriptor<ListChannelConnectionsRequest, ListChannelConnectionsResponse, ChannelConnection> LIST_CHANNEL_CONNECTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListChannelConnectionsRequest, ListChannelConnectionsResponse, ChannelConnection>(){

        public String emptyToken() {
            return "";
        }

        public ListChannelConnectionsRequest injectToken(ListChannelConnectionsRequest payload, String token) {
            return ListChannelConnectionsRequest.newBuilder((ListChannelConnectionsRequest)payload).setPageToken(token).build();
        }

        public ListChannelConnectionsRequest injectPageSize(ListChannelConnectionsRequest payload, int pageSize) {
            return ListChannelConnectionsRequest.newBuilder((ListChannelConnectionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListChannelConnectionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListChannelConnectionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ChannelConnection> extractResources(ListChannelConnectionsResponse payload) {
            return payload.getChannelConnectionsList();
        }
    };
    private static final PagedListDescriptor<ListMessageBusesRequest, ListMessageBusesResponse, MessageBus> LIST_MESSAGE_BUSES_PAGE_STR_DESC = new PagedListDescriptor<ListMessageBusesRequest, ListMessageBusesResponse, MessageBus>(){

        public String emptyToken() {
            return "";
        }

        public ListMessageBusesRequest injectToken(ListMessageBusesRequest payload, String token) {
            return ListMessageBusesRequest.newBuilder((ListMessageBusesRequest)payload).setPageToken(token).build();
        }

        public ListMessageBusesRequest injectPageSize(ListMessageBusesRequest payload, int pageSize) {
            return ListMessageBusesRequest.newBuilder((ListMessageBusesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMessageBusesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListMessageBusesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MessageBus> extractResources(ListMessageBusesResponse payload) {
            return payload.getMessageBusesList();
        }
    };
    private static final PagedListDescriptor<ListMessageBusEnrollmentsRequest, ListMessageBusEnrollmentsResponse, String> LIST_MESSAGE_BUS_ENROLLMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListMessageBusEnrollmentsRequest, ListMessageBusEnrollmentsResponse, String>(){

        public String emptyToken() {
            return "";
        }

        public ListMessageBusEnrollmentsRequest injectToken(ListMessageBusEnrollmentsRequest payload, String token) {
            return ListMessageBusEnrollmentsRequest.newBuilder((ListMessageBusEnrollmentsRequest)payload).setPageToken(token).build();
        }

        public ListMessageBusEnrollmentsRequest injectPageSize(ListMessageBusEnrollmentsRequest payload, int pageSize) {
            return ListMessageBusEnrollmentsRequest.newBuilder((ListMessageBusEnrollmentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMessageBusEnrollmentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListMessageBusEnrollmentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<String> extractResources(ListMessageBusEnrollmentsResponse payload) {
            return payload.getEnrollmentsList();
        }
    };
    private static final PagedListDescriptor<ListEnrollmentsRequest, ListEnrollmentsResponse, Enrollment> LIST_ENROLLMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListEnrollmentsRequest, ListEnrollmentsResponse, Enrollment>(){

        public String emptyToken() {
            return "";
        }

        public ListEnrollmentsRequest injectToken(ListEnrollmentsRequest payload, String token) {
            return ListEnrollmentsRequest.newBuilder((ListEnrollmentsRequest)payload).setPageToken(token).build();
        }

        public ListEnrollmentsRequest injectPageSize(ListEnrollmentsRequest payload, int pageSize) {
            return ListEnrollmentsRequest.newBuilder((ListEnrollmentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEnrollmentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEnrollmentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Enrollment> extractResources(ListEnrollmentsResponse payload) {
            return payload.getEnrollmentsList();
        }
    };
    private static final PagedListDescriptor<ListPipelinesRequest, ListPipelinesResponse, Pipeline> LIST_PIPELINES_PAGE_STR_DESC = new PagedListDescriptor<ListPipelinesRequest, ListPipelinesResponse, Pipeline>(){

        public String emptyToken() {
            return "";
        }

        public ListPipelinesRequest injectToken(ListPipelinesRequest payload, String token) {
            return ListPipelinesRequest.newBuilder((ListPipelinesRequest)payload).setPageToken(token).build();
        }

        public ListPipelinesRequest injectPageSize(ListPipelinesRequest payload, int pageSize) {
            return ListPipelinesRequest.newBuilder((ListPipelinesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPipelinesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPipelinesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Pipeline> extractResources(ListPipelinesResponse payload) {
            return payload.getPipelinesList();
        }
    };
    private static final PagedListDescriptor<ListGoogleApiSourcesRequest, ListGoogleApiSourcesResponse, GoogleApiSource> LIST_GOOGLE_API_SOURCES_PAGE_STR_DESC = new PagedListDescriptor<ListGoogleApiSourcesRequest, ListGoogleApiSourcesResponse, GoogleApiSource>(){

        public String emptyToken() {
            return "";
        }

        public ListGoogleApiSourcesRequest injectToken(ListGoogleApiSourcesRequest payload, String token) {
            return ListGoogleApiSourcesRequest.newBuilder((ListGoogleApiSourcesRequest)payload).setPageToken(token).build();
        }

        public ListGoogleApiSourcesRequest injectPageSize(ListGoogleApiSourcesRequest payload, int pageSize) {
            return ListGoogleApiSourcesRequest.newBuilder((ListGoogleApiSourcesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGoogleApiSourcesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListGoogleApiSourcesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<GoogleApiSource> extractResources(ListGoogleApiSourcesResponse payload) {
            return payload.getGoogleApiSourcesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListTriggersRequest, ListTriggersResponse, EventarcClient.ListTriggersPagedResponse> LIST_TRIGGERS_PAGE_STR_FACT = new PagedListResponseFactory<ListTriggersRequest, ListTriggersResponse, EventarcClient.ListTriggersPagedResponse>(){

        public ApiFuture<EventarcClient.ListTriggersPagedResponse> getFuturePagedResponse(UnaryCallable<ListTriggersRequest, ListTriggersResponse> callable, ListTriggersRequest request, ApiCallContext context, ApiFuture<ListTriggersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TRIGGERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EventarcClient.ListTriggersPagedResponse.createAsync((PageContext<ListTriggersRequest, ListTriggersResponse, Trigger>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListChannelsRequest, ListChannelsResponse, EventarcClient.ListChannelsPagedResponse> LIST_CHANNELS_PAGE_STR_FACT = new PagedListResponseFactory<ListChannelsRequest, ListChannelsResponse, EventarcClient.ListChannelsPagedResponse>(){

        public ApiFuture<EventarcClient.ListChannelsPagedResponse> getFuturePagedResponse(UnaryCallable<ListChannelsRequest, ListChannelsResponse> callable, ListChannelsRequest request, ApiCallContext context, ApiFuture<ListChannelsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CHANNELS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EventarcClient.ListChannelsPagedResponse.createAsync((PageContext<ListChannelsRequest, ListChannelsResponse, Channel>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListProvidersRequest, ListProvidersResponse, EventarcClient.ListProvidersPagedResponse> LIST_PROVIDERS_PAGE_STR_FACT = new PagedListResponseFactory<ListProvidersRequest, ListProvidersResponse, EventarcClient.ListProvidersPagedResponse>(){

        public ApiFuture<EventarcClient.ListProvidersPagedResponse> getFuturePagedResponse(UnaryCallable<ListProvidersRequest, ListProvidersResponse> callable, ListProvidersRequest request, ApiCallContext context, ApiFuture<ListProvidersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PROVIDERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EventarcClient.ListProvidersPagedResponse.createAsync((PageContext<ListProvidersRequest, ListProvidersResponse, Provider>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListChannelConnectionsRequest, ListChannelConnectionsResponse, EventarcClient.ListChannelConnectionsPagedResponse> LIST_CHANNEL_CONNECTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListChannelConnectionsRequest, ListChannelConnectionsResponse, EventarcClient.ListChannelConnectionsPagedResponse>(){

        public ApiFuture<EventarcClient.ListChannelConnectionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListChannelConnectionsRequest, ListChannelConnectionsResponse> callable, ListChannelConnectionsRequest request, ApiCallContext context, ApiFuture<ListChannelConnectionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CHANNEL_CONNECTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EventarcClient.ListChannelConnectionsPagedResponse.createAsync((PageContext<ListChannelConnectionsRequest, ListChannelConnectionsResponse, ChannelConnection>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListMessageBusesRequest, ListMessageBusesResponse, EventarcClient.ListMessageBusesPagedResponse> LIST_MESSAGE_BUSES_PAGE_STR_FACT = new PagedListResponseFactory<ListMessageBusesRequest, ListMessageBusesResponse, EventarcClient.ListMessageBusesPagedResponse>(){

        public ApiFuture<EventarcClient.ListMessageBusesPagedResponse> getFuturePagedResponse(UnaryCallable<ListMessageBusesRequest, ListMessageBusesResponse> callable, ListMessageBusesRequest request, ApiCallContext context, ApiFuture<ListMessageBusesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MESSAGE_BUSES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EventarcClient.ListMessageBusesPagedResponse.createAsync((PageContext<ListMessageBusesRequest, ListMessageBusesResponse, MessageBus>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListMessageBusEnrollmentsRequest, ListMessageBusEnrollmentsResponse, EventarcClient.ListMessageBusEnrollmentsPagedResponse> LIST_MESSAGE_BUS_ENROLLMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListMessageBusEnrollmentsRequest, ListMessageBusEnrollmentsResponse, EventarcClient.ListMessageBusEnrollmentsPagedResponse>(){

        public ApiFuture<EventarcClient.ListMessageBusEnrollmentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListMessageBusEnrollmentsRequest, ListMessageBusEnrollmentsResponse> callable, ListMessageBusEnrollmentsRequest request, ApiCallContext context, ApiFuture<ListMessageBusEnrollmentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MESSAGE_BUS_ENROLLMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EventarcClient.ListMessageBusEnrollmentsPagedResponse.createAsync((PageContext<ListMessageBusEnrollmentsRequest, ListMessageBusEnrollmentsResponse, String>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListEnrollmentsRequest, ListEnrollmentsResponse, EventarcClient.ListEnrollmentsPagedResponse> LIST_ENROLLMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListEnrollmentsRequest, ListEnrollmentsResponse, EventarcClient.ListEnrollmentsPagedResponse>(){

        public ApiFuture<EventarcClient.ListEnrollmentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEnrollmentsRequest, ListEnrollmentsResponse> callable, ListEnrollmentsRequest request, ApiCallContext context, ApiFuture<ListEnrollmentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENROLLMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EventarcClient.ListEnrollmentsPagedResponse.createAsync((PageContext<ListEnrollmentsRequest, ListEnrollmentsResponse, Enrollment>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListPipelinesRequest, ListPipelinesResponse, EventarcClient.ListPipelinesPagedResponse> LIST_PIPELINES_PAGE_STR_FACT = new PagedListResponseFactory<ListPipelinesRequest, ListPipelinesResponse, EventarcClient.ListPipelinesPagedResponse>(){

        public ApiFuture<EventarcClient.ListPipelinesPagedResponse> getFuturePagedResponse(UnaryCallable<ListPipelinesRequest, ListPipelinesResponse> callable, ListPipelinesRequest request, ApiCallContext context, ApiFuture<ListPipelinesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PIPELINES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EventarcClient.ListPipelinesPagedResponse.createAsync((PageContext<ListPipelinesRequest, ListPipelinesResponse, Pipeline>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListGoogleApiSourcesRequest, ListGoogleApiSourcesResponse, EventarcClient.ListGoogleApiSourcesPagedResponse> LIST_GOOGLE_API_SOURCES_PAGE_STR_FACT = new PagedListResponseFactory<ListGoogleApiSourcesRequest, ListGoogleApiSourcesResponse, EventarcClient.ListGoogleApiSourcesPagedResponse>(){

        public ApiFuture<EventarcClient.ListGoogleApiSourcesPagedResponse> getFuturePagedResponse(UnaryCallable<ListGoogleApiSourcesRequest, ListGoogleApiSourcesResponse> callable, ListGoogleApiSourcesRequest request, ApiCallContext context, ApiFuture<ListGoogleApiSourcesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GOOGLE_API_SOURCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EventarcClient.ListGoogleApiSourcesPagedResponse.createAsync((PageContext<ListGoogleApiSourcesRequest, ListGoogleApiSourcesResponse, GoogleApiSource>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, EventarcClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, EventarcClient.ListLocationsPagedResponse>(){

        public ApiFuture<EventarcClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EventarcClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetTriggerRequest, Trigger> getTriggerSettings() {
        return this.getTriggerSettings;
    }

    public PagedCallSettings<ListTriggersRequest, ListTriggersResponse, EventarcClient.ListTriggersPagedResponse> listTriggersSettings() {
        return this.listTriggersSettings;
    }

    public UnaryCallSettings<CreateTriggerRequest, Operation> createTriggerSettings() {
        return this.createTriggerSettings;
    }

    public OperationCallSettings<CreateTriggerRequest, Trigger, OperationMetadata> createTriggerOperationSettings() {
        return this.createTriggerOperationSettings;
    }

    public UnaryCallSettings<UpdateTriggerRequest, Operation> updateTriggerSettings() {
        return this.updateTriggerSettings;
    }

    public OperationCallSettings<UpdateTriggerRequest, Trigger, OperationMetadata> updateTriggerOperationSettings() {
        return this.updateTriggerOperationSettings;
    }

    public UnaryCallSettings<DeleteTriggerRequest, Operation> deleteTriggerSettings() {
        return this.deleteTriggerSettings;
    }

    public OperationCallSettings<DeleteTriggerRequest, Trigger, OperationMetadata> deleteTriggerOperationSettings() {
        return this.deleteTriggerOperationSettings;
    }

    public UnaryCallSettings<GetChannelRequest, Channel> getChannelSettings() {
        return this.getChannelSettings;
    }

    public PagedCallSettings<ListChannelsRequest, ListChannelsResponse, EventarcClient.ListChannelsPagedResponse> listChannelsSettings() {
        return this.listChannelsSettings;
    }

    public UnaryCallSettings<CreateChannelRequest, Operation> createChannelSettings() {
        return this.createChannelSettings;
    }

    public OperationCallSettings<CreateChannelRequest, Channel, OperationMetadata> createChannelOperationSettings() {
        return this.createChannelOperationSettings;
    }

    public UnaryCallSettings<UpdateChannelRequest, Operation> updateChannelSettings() {
        return this.updateChannelSettings;
    }

    public OperationCallSettings<UpdateChannelRequest, Channel, OperationMetadata> updateChannelOperationSettings() {
        return this.updateChannelOperationSettings;
    }

    public UnaryCallSettings<DeleteChannelRequest, Operation> deleteChannelSettings() {
        return this.deleteChannelSettings;
    }

    public OperationCallSettings<DeleteChannelRequest, Channel, OperationMetadata> deleteChannelOperationSettings() {
        return this.deleteChannelOperationSettings;
    }

    public UnaryCallSettings<GetProviderRequest, Provider> getProviderSettings() {
        return this.getProviderSettings;
    }

    public PagedCallSettings<ListProvidersRequest, ListProvidersResponse, EventarcClient.ListProvidersPagedResponse> listProvidersSettings() {
        return this.listProvidersSettings;
    }

    public UnaryCallSettings<GetChannelConnectionRequest, ChannelConnection> getChannelConnectionSettings() {
        return this.getChannelConnectionSettings;
    }

    public PagedCallSettings<ListChannelConnectionsRequest, ListChannelConnectionsResponse, EventarcClient.ListChannelConnectionsPagedResponse> listChannelConnectionsSettings() {
        return this.listChannelConnectionsSettings;
    }

    public UnaryCallSettings<CreateChannelConnectionRequest, Operation> createChannelConnectionSettings() {
        return this.createChannelConnectionSettings;
    }

    public OperationCallSettings<CreateChannelConnectionRequest, ChannelConnection, OperationMetadata> createChannelConnectionOperationSettings() {
        return this.createChannelConnectionOperationSettings;
    }

    public UnaryCallSettings<DeleteChannelConnectionRequest, Operation> deleteChannelConnectionSettings() {
        return this.deleteChannelConnectionSettings;
    }

    public OperationCallSettings<DeleteChannelConnectionRequest, ChannelConnection, OperationMetadata> deleteChannelConnectionOperationSettings() {
        return this.deleteChannelConnectionOperationSettings;
    }

    public UnaryCallSettings<GetGoogleChannelConfigRequest, GoogleChannelConfig> getGoogleChannelConfigSettings() {
        return this.getGoogleChannelConfigSettings;
    }

    public UnaryCallSettings<UpdateGoogleChannelConfigRequest, GoogleChannelConfig> updateGoogleChannelConfigSettings() {
        return this.updateGoogleChannelConfigSettings;
    }

    public UnaryCallSettings<GetMessageBusRequest, MessageBus> getMessageBusSettings() {
        return this.getMessageBusSettings;
    }

    public PagedCallSettings<ListMessageBusesRequest, ListMessageBusesResponse, EventarcClient.ListMessageBusesPagedResponse> listMessageBusesSettings() {
        return this.listMessageBusesSettings;
    }

    public PagedCallSettings<ListMessageBusEnrollmentsRequest, ListMessageBusEnrollmentsResponse, EventarcClient.ListMessageBusEnrollmentsPagedResponse> listMessageBusEnrollmentsSettings() {
        return this.listMessageBusEnrollmentsSettings;
    }

    public UnaryCallSettings<CreateMessageBusRequest, Operation> createMessageBusSettings() {
        return this.createMessageBusSettings;
    }

    public OperationCallSettings<CreateMessageBusRequest, MessageBus, OperationMetadata> createMessageBusOperationSettings() {
        return this.createMessageBusOperationSettings;
    }

    public UnaryCallSettings<UpdateMessageBusRequest, Operation> updateMessageBusSettings() {
        return this.updateMessageBusSettings;
    }

    public OperationCallSettings<UpdateMessageBusRequest, MessageBus, OperationMetadata> updateMessageBusOperationSettings() {
        return this.updateMessageBusOperationSettings;
    }

    public UnaryCallSettings<DeleteMessageBusRequest, Operation> deleteMessageBusSettings() {
        return this.deleteMessageBusSettings;
    }

    public OperationCallSettings<DeleteMessageBusRequest, MessageBus, OperationMetadata> deleteMessageBusOperationSettings() {
        return this.deleteMessageBusOperationSettings;
    }

    public UnaryCallSettings<GetEnrollmentRequest, Enrollment> getEnrollmentSettings() {
        return this.getEnrollmentSettings;
    }

    public PagedCallSettings<ListEnrollmentsRequest, ListEnrollmentsResponse, EventarcClient.ListEnrollmentsPagedResponse> listEnrollmentsSettings() {
        return this.listEnrollmentsSettings;
    }

    public UnaryCallSettings<CreateEnrollmentRequest, Operation> createEnrollmentSettings() {
        return this.createEnrollmentSettings;
    }

    public OperationCallSettings<CreateEnrollmentRequest, Enrollment, OperationMetadata> createEnrollmentOperationSettings() {
        return this.createEnrollmentOperationSettings;
    }

    public UnaryCallSettings<UpdateEnrollmentRequest, Operation> updateEnrollmentSettings() {
        return this.updateEnrollmentSettings;
    }

    public OperationCallSettings<UpdateEnrollmentRequest, Enrollment, OperationMetadata> updateEnrollmentOperationSettings() {
        return this.updateEnrollmentOperationSettings;
    }

    public UnaryCallSettings<DeleteEnrollmentRequest, Operation> deleteEnrollmentSettings() {
        return this.deleteEnrollmentSettings;
    }

    public OperationCallSettings<DeleteEnrollmentRequest, Enrollment, OperationMetadata> deleteEnrollmentOperationSettings() {
        return this.deleteEnrollmentOperationSettings;
    }

    public UnaryCallSettings<GetPipelineRequest, Pipeline> getPipelineSettings() {
        return this.getPipelineSettings;
    }

    public PagedCallSettings<ListPipelinesRequest, ListPipelinesResponse, EventarcClient.ListPipelinesPagedResponse> listPipelinesSettings() {
        return this.listPipelinesSettings;
    }

    public UnaryCallSettings<CreatePipelineRequest, Operation> createPipelineSettings() {
        return this.createPipelineSettings;
    }

    public OperationCallSettings<CreatePipelineRequest, Pipeline, OperationMetadata> createPipelineOperationSettings() {
        return this.createPipelineOperationSettings;
    }

    public UnaryCallSettings<UpdatePipelineRequest, Operation> updatePipelineSettings() {
        return this.updatePipelineSettings;
    }

    public OperationCallSettings<UpdatePipelineRequest, Pipeline, OperationMetadata> updatePipelineOperationSettings() {
        return this.updatePipelineOperationSettings;
    }

    public UnaryCallSettings<DeletePipelineRequest, Operation> deletePipelineSettings() {
        return this.deletePipelineSettings;
    }

    public OperationCallSettings<DeletePipelineRequest, Pipeline, OperationMetadata> deletePipelineOperationSettings() {
        return this.deletePipelineOperationSettings;
    }

    public UnaryCallSettings<GetGoogleApiSourceRequest, GoogleApiSource> getGoogleApiSourceSettings() {
        return this.getGoogleApiSourceSettings;
    }

    public PagedCallSettings<ListGoogleApiSourcesRequest, ListGoogleApiSourcesResponse, EventarcClient.ListGoogleApiSourcesPagedResponse> listGoogleApiSourcesSettings() {
        return this.listGoogleApiSourcesSettings;
    }

    public UnaryCallSettings<CreateGoogleApiSourceRequest, Operation> createGoogleApiSourceSettings() {
        return this.createGoogleApiSourceSettings;
    }

    public OperationCallSettings<CreateGoogleApiSourceRequest, GoogleApiSource, OperationMetadata> createGoogleApiSourceOperationSettings() {
        return this.createGoogleApiSourceOperationSettings;
    }

    public UnaryCallSettings<UpdateGoogleApiSourceRequest, Operation> updateGoogleApiSourceSettings() {
        return this.updateGoogleApiSourceSettings;
    }

    public OperationCallSettings<UpdateGoogleApiSourceRequest, GoogleApiSource, OperationMetadata> updateGoogleApiSourceOperationSettings() {
        return this.updateGoogleApiSourceOperationSettings;
    }

    public UnaryCallSettings<DeleteGoogleApiSourceRequest, Operation> deleteGoogleApiSourceSettings() {
        return this.deleteGoogleApiSourceSettings;
    }

    public OperationCallSettings<DeleteGoogleApiSourceRequest, GoogleApiSource, OperationMetadata> deleteGoogleApiSourceOperationSettings() {
        return this.deleteGoogleApiSourceOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, EventarcClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public EventarcStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcEventarcStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonEventarcStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "eventarc";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "eventarc.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "eventarc.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return EventarcStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EventarcStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EventarcStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return EventarcStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected EventarcStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getTriggerSettings = settingsBuilder.getTriggerSettings().build();
        this.listTriggersSettings = settingsBuilder.listTriggersSettings().build();
        this.createTriggerSettings = settingsBuilder.createTriggerSettings().build();
        this.createTriggerOperationSettings = settingsBuilder.createTriggerOperationSettings().build();
        this.updateTriggerSettings = settingsBuilder.updateTriggerSettings().build();
        this.updateTriggerOperationSettings = settingsBuilder.updateTriggerOperationSettings().build();
        this.deleteTriggerSettings = settingsBuilder.deleteTriggerSettings().build();
        this.deleteTriggerOperationSettings = settingsBuilder.deleteTriggerOperationSettings().build();
        this.getChannelSettings = settingsBuilder.getChannelSettings().build();
        this.listChannelsSettings = settingsBuilder.listChannelsSettings().build();
        this.createChannelSettings = settingsBuilder.createChannelSettings().build();
        this.createChannelOperationSettings = settingsBuilder.createChannelOperationSettings().build();
        this.updateChannelSettings = settingsBuilder.updateChannelSettings().build();
        this.updateChannelOperationSettings = settingsBuilder.updateChannelOperationSettings().build();
        this.deleteChannelSettings = settingsBuilder.deleteChannelSettings().build();
        this.deleteChannelOperationSettings = settingsBuilder.deleteChannelOperationSettings().build();
        this.getProviderSettings = settingsBuilder.getProviderSettings().build();
        this.listProvidersSettings = settingsBuilder.listProvidersSettings().build();
        this.getChannelConnectionSettings = settingsBuilder.getChannelConnectionSettings().build();
        this.listChannelConnectionsSettings = settingsBuilder.listChannelConnectionsSettings().build();
        this.createChannelConnectionSettings = settingsBuilder.createChannelConnectionSettings().build();
        this.createChannelConnectionOperationSettings = settingsBuilder.createChannelConnectionOperationSettings().build();
        this.deleteChannelConnectionSettings = settingsBuilder.deleteChannelConnectionSettings().build();
        this.deleteChannelConnectionOperationSettings = settingsBuilder.deleteChannelConnectionOperationSettings().build();
        this.getGoogleChannelConfigSettings = settingsBuilder.getGoogleChannelConfigSettings().build();
        this.updateGoogleChannelConfigSettings = settingsBuilder.updateGoogleChannelConfigSettings().build();
        this.getMessageBusSettings = settingsBuilder.getMessageBusSettings().build();
        this.listMessageBusesSettings = settingsBuilder.listMessageBusesSettings().build();
        this.listMessageBusEnrollmentsSettings = settingsBuilder.listMessageBusEnrollmentsSettings().build();
        this.createMessageBusSettings = settingsBuilder.createMessageBusSettings().build();
        this.createMessageBusOperationSettings = settingsBuilder.createMessageBusOperationSettings().build();
        this.updateMessageBusSettings = settingsBuilder.updateMessageBusSettings().build();
        this.updateMessageBusOperationSettings = settingsBuilder.updateMessageBusOperationSettings().build();
        this.deleteMessageBusSettings = settingsBuilder.deleteMessageBusSettings().build();
        this.deleteMessageBusOperationSettings = settingsBuilder.deleteMessageBusOperationSettings().build();
        this.getEnrollmentSettings = settingsBuilder.getEnrollmentSettings().build();
        this.listEnrollmentsSettings = settingsBuilder.listEnrollmentsSettings().build();
        this.createEnrollmentSettings = settingsBuilder.createEnrollmentSettings().build();
        this.createEnrollmentOperationSettings = settingsBuilder.createEnrollmentOperationSettings().build();
        this.updateEnrollmentSettings = settingsBuilder.updateEnrollmentSettings().build();
        this.updateEnrollmentOperationSettings = settingsBuilder.updateEnrollmentOperationSettings().build();
        this.deleteEnrollmentSettings = settingsBuilder.deleteEnrollmentSettings().build();
        this.deleteEnrollmentOperationSettings = settingsBuilder.deleteEnrollmentOperationSettings().build();
        this.getPipelineSettings = settingsBuilder.getPipelineSettings().build();
        this.listPipelinesSettings = settingsBuilder.listPipelinesSettings().build();
        this.createPipelineSettings = settingsBuilder.createPipelineSettings().build();
        this.createPipelineOperationSettings = settingsBuilder.createPipelineOperationSettings().build();
        this.updatePipelineSettings = settingsBuilder.updatePipelineSettings().build();
        this.updatePipelineOperationSettings = settingsBuilder.updatePipelineOperationSettings().build();
        this.deletePipelineSettings = settingsBuilder.deletePipelineSettings().build();
        this.deletePipelineOperationSettings = settingsBuilder.deletePipelineOperationSettings().build();
        this.getGoogleApiSourceSettings = settingsBuilder.getGoogleApiSourceSettings().build();
        this.listGoogleApiSourcesSettings = settingsBuilder.listGoogleApiSourcesSettings().build();
        this.createGoogleApiSourceSettings = settingsBuilder.createGoogleApiSourceSettings().build();
        this.createGoogleApiSourceOperationSettings = settingsBuilder.createGoogleApiSourceOperationSettings().build();
        this.updateGoogleApiSourceSettings = settingsBuilder.updateGoogleApiSourceSettings().build();
        this.updateGoogleApiSourceOperationSettings = settingsBuilder.updateGoogleApiSourceOperationSettings().build();
        this.deleteGoogleApiSourceSettings = settingsBuilder.deleteGoogleApiSourceSettings().build();
        this.deleteGoogleApiSourceOperationSettings = settingsBuilder.deleteGoogleApiSourceOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<EventarcStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetTriggerRequest, Trigger> getTriggerSettings;
        private final PagedCallSettings.Builder<ListTriggersRequest, ListTriggersResponse, EventarcClient.ListTriggersPagedResponse> listTriggersSettings;
        private final UnaryCallSettings.Builder<CreateTriggerRequest, Operation> createTriggerSettings;
        private final OperationCallSettings.Builder<CreateTriggerRequest, Trigger, OperationMetadata> createTriggerOperationSettings;
        private final UnaryCallSettings.Builder<UpdateTriggerRequest, Operation> updateTriggerSettings;
        private final OperationCallSettings.Builder<UpdateTriggerRequest, Trigger, OperationMetadata> updateTriggerOperationSettings;
        private final UnaryCallSettings.Builder<DeleteTriggerRequest, Operation> deleteTriggerSettings;
        private final OperationCallSettings.Builder<DeleteTriggerRequest, Trigger, OperationMetadata> deleteTriggerOperationSettings;
        private final UnaryCallSettings.Builder<GetChannelRequest, Channel> getChannelSettings;
        private final PagedCallSettings.Builder<ListChannelsRequest, ListChannelsResponse, EventarcClient.ListChannelsPagedResponse> listChannelsSettings;
        private final UnaryCallSettings.Builder<CreateChannelRequest, Operation> createChannelSettings;
        private final OperationCallSettings.Builder<CreateChannelRequest, Channel, OperationMetadata> createChannelOperationSettings;
        private final UnaryCallSettings.Builder<UpdateChannelRequest, Operation> updateChannelSettings;
        private final OperationCallSettings.Builder<UpdateChannelRequest, Channel, OperationMetadata> updateChannelOperationSettings;
        private final UnaryCallSettings.Builder<DeleteChannelRequest, Operation> deleteChannelSettings;
        private final OperationCallSettings.Builder<DeleteChannelRequest, Channel, OperationMetadata> deleteChannelOperationSettings;
        private final UnaryCallSettings.Builder<GetProviderRequest, Provider> getProviderSettings;
        private final PagedCallSettings.Builder<ListProvidersRequest, ListProvidersResponse, EventarcClient.ListProvidersPagedResponse> listProvidersSettings;
        private final UnaryCallSettings.Builder<GetChannelConnectionRequest, ChannelConnection> getChannelConnectionSettings;
        private final PagedCallSettings.Builder<ListChannelConnectionsRequest, ListChannelConnectionsResponse, EventarcClient.ListChannelConnectionsPagedResponse> listChannelConnectionsSettings;
        private final UnaryCallSettings.Builder<CreateChannelConnectionRequest, Operation> createChannelConnectionSettings;
        private final OperationCallSettings.Builder<CreateChannelConnectionRequest, ChannelConnection, OperationMetadata> createChannelConnectionOperationSettings;
        private final UnaryCallSettings.Builder<DeleteChannelConnectionRequest, Operation> deleteChannelConnectionSettings;
        private final OperationCallSettings.Builder<DeleteChannelConnectionRequest, ChannelConnection, OperationMetadata> deleteChannelConnectionOperationSettings;
        private final UnaryCallSettings.Builder<GetGoogleChannelConfigRequest, GoogleChannelConfig> getGoogleChannelConfigSettings;
        private final UnaryCallSettings.Builder<UpdateGoogleChannelConfigRequest, GoogleChannelConfig> updateGoogleChannelConfigSettings;
        private final UnaryCallSettings.Builder<GetMessageBusRequest, MessageBus> getMessageBusSettings;
        private final PagedCallSettings.Builder<ListMessageBusesRequest, ListMessageBusesResponse, EventarcClient.ListMessageBusesPagedResponse> listMessageBusesSettings;
        private final PagedCallSettings.Builder<ListMessageBusEnrollmentsRequest, ListMessageBusEnrollmentsResponse, EventarcClient.ListMessageBusEnrollmentsPagedResponse> listMessageBusEnrollmentsSettings;
        private final UnaryCallSettings.Builder<CreateMessageBusRequest, Operation> createMessageBusSettings;
        private final OperationCallSettings.Builder<CreateMessageBusRequest, MessageBus, OperationMetadata> createMessageBusOperationSettings;
        private final UnaryCallSettings.Builder<UpdateMessageBusRequest, Operation> updateMessageBusSettings;
        private final OperationCallSettings.Builder<UpdateMessageBusRequest, MessageBus, OperationMetadata> updateMessageBusOperationSettings;
        private final UnaryCallSettings.Builder<DeleteMessageBusRequest, Operation> deleteMessageBusSettings;
        private final OperationCallSettings.Builder<DeleteMessageBusRequest, MessageBus, OperationMetadata> deleteMessageBusOperationSettings;
        private final UnaryCallSettings.Builder<GetEnrollmentRequest, Enrollment> getEnrollmentSettings;
        private final PagedCallSettings.Builder<ListEnrollmentsRequest, ListEnrollmentsResponse, EventarcClient.ListEnrollmentsPagedResponse> listEnrollmentsSettings;
        private final UnaryCallSettings.Builder<CreateEnrollmentRequest, Operation> createEnrollmentSettings;
        private final OperationCallSettings.Builder<CreateEnrollmentRequest, Enrollment, OperationMetadata> createEnrollmentOperationSettings;
        private final UnaryCallSettings.Builder<UpdateEnrollmentRequest, Operation> updateEnrollmentSettings;
        private final OperationCallSettings.Builder<UpdateEnrollmentRequest, Enrollment, OperationMetadata> updateEnrollmentOperationSettings;
        private final UnaryCallSettings.Builder<DeleteEnrollmentRequest, Operation> deleteEnrollmentSettings;
        private final OperationCallSettings.Builder<DeleteEnrollmentRequest, Enrollment, OperationMetadata> deleteEnrollmentOperationSettings;
        private final UnaryCallSettings.Builder<GetPipelineRequest, Pipeline> getPipelineSettings;
        private final PagedCallSettings.Builder<ListPipelinesRequest, ListPipelinesResponse, EventarcClient.ListPipelinesPagedResponse> listPipelinesSettings;
        private final UnaryCallSettings.Builder<CreatePipelineRequest, Operation> createPipelineSettings;
        private final OperationCallSettings.Builder<CreatePipelineRequest, Pipeline, OperationMetadata> createPipelineOperationSettings;
        private final UnaryCallSettings.Builder<UpdatePipelineRequest, Operation> updatePipelineSettings;
        private final OperationCallSettings.Builder<UpdatePipelineRequest, Pipeline, OperationMetadata> updatePipelineOperationSettings;
        private final UnaryCallSettings.Builder<DeletePipelineRequest, Operation> deletePipelineSettings;
        private final OperationCallSettings.Builder<DeletePipelineRequest, Pipeline, OperationMetadata> deletePipelineOperationSettings;
        private final UnaryCallSettings.Builder<GetGoogleApiSourceRequest, GoogleApiSource> getGoogleApiSourceSettings;
        private final PagedCallSettings.Builder<ListGoogleApiSourcesRequest, ListGoogleApiSourcesResponse, EventarcClient.ListGoogleApiSourcesPagedResponse> listGoogleApiSourcesSettings;
        private final UnaryCallSettings.Builder<CreateGoogleApiSourceRequest, Operation> createGoogleApiSourceSettings;
        private final OperationCallSettings.Builder<CreateGoogleApiSourceRequest, GoogleApiSource, OperationMetadata> createGoogleApiSourceOperationSettings;
        private final UnaryCallSettings.Builder<UpdateGoogleApiSourceRequest, Operation> updateGoogleApiSourceSettings;
        private final OperationCallSettings.Builder<UpdateGoogleApiSourceRequest, GoogleApiSource, OperationMetadata> updateGoogleApiSourceOperationSettings;
        private final UnaryCallSettings.Builder<DeleteGoogleApiSourceRequest, Operation> deleteGoogleApiSourceSettings;
        private final OperationCallSettings.Builder<DeleteGoogleApiSourceRequest, GoogleApiSource, OperationMetadata> deleteGoogleApiSourceOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, EventarcClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTriggersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TRIGGERS_PAGE_STR_FACT);
            this.createTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTriggerOperationSettings = OperationCallSettings.newBuilder();
            this.updateTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTriggerOperationSettings = OperationCallSettings.newBuilder();
            this.deleteTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTriggerOperationSettings = OperationCallSettings.newBuilder();
            this.getChannelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listChannelsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CHANNELS_PAGE_STR_FACT);
            this.createChannelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createChannelOperationSettings = OperationCallSettings.newBuilder();
            this.updateChannelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateChannelOperationSettings = OperationCallSettings.newBuilder();
            this.deleteChannelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteChannelOperationSettings = OperationCallSettings.newBuilder();
            this.getProviderSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listProvidersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PROVIDERS_PAGE_STR_FACT);
            this.getChannelConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listChannelConnectionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CHANNEL_CONNECTIONS_PAGE_STR_FACT);
            this.createChannelConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createChannelConnectionOperationSettings = OperationCallSettings.newBuilder();
            this.deleteChannelConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteChannelConnectionOperationSettings = OperationCallSettings.newBuilder();
            this.getGoogleChannelConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateGoogleChannelConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getMessageBusSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listMessageBusesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MESSAGE_BUSES_PAGE_STR_FACT);
            this.listMessageBusEnrollmentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MESSAGE_BUS_ENROLLMENTS_PAGE_STR_FACT);
            this.createMessageBusSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createMessageBusOperationSettings = OperationCallSettings.newBuilder();
            this.updateMessageBusSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateMessageBusOperationSettings = OperationCallSettings.newBuilder();
            this.deleteMessageBusSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteMessageBusOperationSettings = OperationCallSettings.newBuilder();
            this.getEnrollmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listEnrollmentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENROLLMENTS_PAGE_STR_FACT);
            this.createEnrollmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEnrollmentOperationSettings = OperationCallSettings.newBuilder();
            this.updateEnrollmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateEnrollmentOperationSettings = OperationCallSettings.newBuilder();
            this.deleteEnrollmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEnrollmentOperationSettings = OperationCallSettings.newBuilder();
            this.getPipelineSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listPipelinesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PIPELINES_PAGE_STR_FACT);
            this.createPipelineSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createPipelineOperationSettings = OperationCallSettings.newBuilder();
            this.updatePipelineSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updatePipelineOperationSettings = OperationCallSettings.newBuilder();
            this.deletePipelineSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deletePipelineOperationSettings = OperationCallSettings.newBuilder();
            this.getGoogleApiSourceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listGoogleApiSourcesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GOOGLE_API_SOURCES_PAGE_STR_FACT);
            this.createGoogleApiSourceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGoogleApiSourceOperationSettings = OperationCallSettings.newBuilder();
            this.updateGoogleApiSourceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateGoogleApiSourceOperationSettings = OperationCallSettings.newBuilder();
            this.deleteGoogleApiSourceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteGoogleApiSourceOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getTriggerSettings, this.listTriggersSettings, this.createTriggerSettings, this.updateTriggerSettings, this.deleteTriggerSettings, this.getChannelSettings, this.listChannelsSettings, this.createChannelSettings, this.updateChannelSettings, this.deleteChannelSettings, this.getProviderSettings, this.listProvidersSettings, (Object[])new UnaryCallSettings.Builder[]{this.getChannelConnectionSettings, this.listChannelConnectionsSettings, this.createChannelConnectionSettings, this.deleteChannelConnectionSettings, this.getGoogleChannelConfigSettings, this.updateGoogleChannelConfigSettings, this.getMessageBusSettings, this.listMessageBusesSettings, this.listMessageBusEnrollmentsSettings, this.createMessageBusSettings, this.updateMessageBusSettings, this.deleteMessageBusSettings, this.getEnrollmentSettings, this.listEnrollmentsSettings, this.createEnrollmentSettings, this.updateEnrollmentSettings, this.deleteEnrollmentSettings, this.getPipelineSettings, this.listPipelinesSettings, this.createPipelineSettings, this.updatePipelineSettings, this.deletePipelineSettings, this.getGoogleApiSourceSettings, this.listGoogleApiSourcesSettings, this.createGoogleApiSourceSettings, this.updateGoogleApiSourceSettings, this.deleteGoogleApiSourceSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(EventarcStubSettings settings) {
            super((StubSettings)settings);
            this.getTriggerSettings = settings.getTriggerSettings.toBuilder();
            this.listTriggersSettings = settings.listTriggersSettings.toBuilder();
            this.createTriggerSettings = settings.createTriggerSettings.toBuilder();
            this.createTriggerOperationSettings = settings.createTriggerOperationSettings.toBuilder();
            this.updateTriggerSettings = settings.updateTriggerSettings.toBuilder();
            this.updateTriggerOperationSettings = settings.updateTriggerOperationSettings.toBuilder();
            this.deleteTriggerSettings = settings.deleteTriggerSettings.toBuilder();
            this.deleteTriggerOperationSettings = settings.deleteTriggerOperationSettings.toBuilder();
            this.getChannelSettings = settings.getChannelSettings.toBuilder();
            this.listChannelsSettings = settings.listChannelsSettings.toBuilder();
            this.createChannelSettings = settings.createChannelSettings.toBuilder();
            this.createChannelOperationSettings = settings.createChannelOperationSettings.toBuilder();
            this.updateChannelSettings = settings.updateChannelSettings.toBuilder();
            this.updateChannelOperationSettings = settings.updateChannelOperationSettings.toBuilder();
            this.deleteChannelSettings = settings.deleteChannelSettings.toBuilder();
            this.deleteChannelOperationSettings = settings.deleteChannelOperationSettings.toBuilder();
            this.getProviderSettings = settings.getProviderSettings.toBuilder();
            this.listProvidersSettings = settings.listProvidersSettings.toBuilder();
            this.getChannelConnectionSettings = settings.getChannelConnectionSettings.toBuilder();
            this.listChannelConnectionsSettings = settings.listChannelConnectionsSettings.toBuilder();
            this.createChannelConnectionSettings = settings.createChannelConnectionSettings.toBuilder();
            this.createChannelConnectionOperationSettings = settings.createChannelConnectionOperationSettings.toBuilder();
            this.deleteChannelConnectionSettings = settings.deleteChannelConnectionSettings.toBuilder();
            this.deleteChannelConnectionOperationSettings = settings.deleteChannelConnectionOperationSettings.toBuilder();
            this.getGoogleChannelConfigSettings = settings.getGoogleChannelConfigSettings.toBuilder();
            this.updateGoogleChannelConfigSettings = settings.updateGoogleChannelConfigSettings.toBuilder();
            this.getMessageBusSettings = settings.getMessageBusSettings.toBuilder();
            this.listMessageBusesSettings = settings.listMessageBusesSettings.toBuilder();
            this.listMessageBusEnrollmentsSettings = settings.listMessageBusEnrollmentsSettings.toBuilder();
            this.createMessageBusSettings = settings.createMessageBusSettings.toBuilder();
            this.createMessageBusOperationSettings = settings.createMessageBusOperationSettings.toBuilder();
            this.updateMessageBusSettings = settings.updateMessageBusSettings.toBuilder();
            this.updateMessageBusOperationSettings = settings.updateMessageBusOperationSettings.toBuilder();
            this.deleteMessageBusSettings = settings.deleteMessageBusSettings.toBuilder();
            this.deleteMessageBusOperationSettings = settings.deleteMessageBusOperationSettings.toBuilder();
            this.getEnrollmentSettings = settings.getEnrollmentSettings.toBuilder();
            this.listEnrollmentsSettings = settings.listEnrollmentsSettings.toBuilder();
            this.createEnrollmentSettings = settings.createEnrollmentSettings.toBuilder();
            this.createEnrollmentOperationSettings = settings.createEnrollmentOperationSettings.toBuilder();
            this.updateEnrollmentSettings = settings.updateEnrollmentSettings.toBuilder();
            this.updateEnrollmentOperationSettings = settings.updateEnrollmentOperationSettings.toBuilder();
            this.deleteEnrollmentSettings = settings.deleteEnrollmentSettings.toBuilder();
            this.deleteEnrollmentOperationSettings = settings.deleteEnrollmentOperationSettings.toBuilder();
            this.getPipelineSettings = settings.getPipelineSettings.toBuilder();
            this.listPipelinesSettings = settings.listPipelinesSettings.toBuilder();
            this.createPipelineSettings = settings.createPipelineSettings.toBuilder();
            this.createPipelineOperationSettings = settings.createPipelineOperationSettings.toBuilder();
            this.updatePipelineSettings = settings.updatePipelineSettings.toBuilder();
            this.updatePipelineOperationSettings = settings.updatePipelineOperationSettings.toBuilder();
            this.deletePipelineSettings = settings.deletePipelineSettings.toBuilder();
            this.deletePipelineOperationSettings = settings.deletePipelineOperationSettings.toBuilder();
            this.getGoogleApiSourceSettings = settings.getGoogleApiSourceSettings.toBuilder();
            this.listGoogleApiSourcesSettings = settings.listGoogleApiSourcesSettings.toBuilder();
            this.createGoogleApiSourceSettings = settings.createGoogleApiSourceSettings.toBuilder();
            this.createGoogleApiSourceOperationSettings = settings.createGoogleApiSourceOperationSettings.toBuilder();
            this.updateGoogleApiSourceSettings = settings.updateGoogleApiSourceSettings.toBuilder();
            this.updateGoogleApiSourceOperationSettings = settings.updateGoogleApiSourceOperationSettings.toBuilder();
            this.deleteGoogleApiSourceSettings = settings.deleteGoogleApiSourceSettings.toBuilder();
            this.deleteGoogleApiSourceOperationSettings = settings.deleteGoogleApiSourceOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getTriggerSettings, this.listTriggersSettings, this.createTriggerSettings, this.updateTriggerSettings, this.deleteTriggerSettings, this.getChannelSettings, this.listChannelsSettings, this.createChannelSettings, this.updateChannelSettings, this.deleteChannelSettings, this.getProviderSettings, this.listProvidersSettings, (Object[])new UnaryCallSettings.Builder[]{this.getChannelConnectionSettings, this.listChannelConnectionsSettings, this.createChannelConnectionSettings, this.deleteChannelConnectionSettings, this.getGoogleChannelConfigSettings, this.updateGoogleChannelConfigSettings, this.getMessageBusSettings, this.listMessageBusesSettings, this.listMessageBusEnrollmentsSettings, this.createMessageBusSettings, this.updateMessageBusSettings, this.deleteMessageBusSettings, this.getEnrollmentSettings, this.listEnrollmentsSettings, this.createEnrollmentSettings, this.updateEnrollmentSettings, this.deleteEnrollmentSettings, this.getPipelineSettings, this.listPipelinesSettings, this.createPipelineSettings, this.updatePipelineSettings, this.deletePipelineSettings, this.getGoogleApiSourceSettings, this.listGoogleApiSourcesSettings, this.createGoogleApiSourceSettings, this.updateGoogleApiSourceSettings, this.deleteGoogleApiSourceSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(EventarcStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)EventarcStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EventarcStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EventarcStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)EventarcStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)EventarcStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EventarcStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EventarcStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listTriggersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getChannelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listChannelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createChannelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateChannelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteChannelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getProviderSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listProvidersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getChannelConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listChannelConnectionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createChannelConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteChannelConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getGoogleChannelConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateGoogleChannelConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getMessageBusSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listMessageBusesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listMessageBusEnrollmentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createMessageBusSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateMessageBusSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteMessageBusSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getEnrollmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listEnrollmentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createEnrollmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateEnrollmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteEnrollmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getPipelineSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listPipelinesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createPipelineSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updatePipelineSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deletePipelineSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getGoogleApiSourceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listGoogleApiSourcesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createGoogleApiSourceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateGoogleApiSourceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteGoogleApiSourceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createTriggerOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Trigger.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateTriggerOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Trigger.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteTriggerOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Trigger.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createChannelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Channel.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateChannelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Channel.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteChannelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Channel.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createChannelConnectionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ChannelConnection.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteChannelConnectionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ChannelConnection.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createMessageBusOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(MessageBus.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateMessageBusOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(MessageBus.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteMessageBusOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(MessageBus.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createEnrollmentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Enrollment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateEnrollmentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Enrollment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteEnrollmentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Enrollment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createPipelineOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Pipeline.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updatePipelineOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Pipeline.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deletePipelineOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Pipeline.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createGoogleApiSourceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(GoogleApiSource.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateGoogleApiSourceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(GoogleApiSource.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteGoogleApiSourceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(GoogleApiSource.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetTriggerRequest, Trigger> getTriggerSettings() {
            return this.getTriggerSettings;
        }

        public PagedCallSettings.Builder<ListTriggersRequest, ListTriggersResponse, EventarcClient.ListTriggersPagedResponse> listTriggersSettings() {
            return this.listTriggersSettings;
        }

        public UnaryCallSettings.Builder<CreateTriggerRequest, Operation> createTriggerSettings() {
            return this.createTriggerSettings;
        }

        public OperationCallSettings.Builder<CreateTriggerRequest, Trigger, OperationMetadata> createTriggerOperationSettings() {
            return this.createTriggerOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateTriggerRequest, Operation> updateTriggerSettings() {
            return this.updateTriggerSettings;
        }

        public OperationCallSettings.Builder<UpdateTriggerRequest, Trigger, OperationMetadata> updateTriggerOperationSettings() {
            return this.updateTriggerOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteTriggerRequest, Operation> deleteTriggerSettings() {
            return this.deleteTriggerSettings;
        }

        public OperationCallSettings.Builder<DeleteTriggerRequest, Trigger, OperationMetadata> deleteTriggerOperationSettings() {
            return this.deleteTriggerOperationSettings;
        }

        public UnaryCallSettings.Builder<GetChannelRequest, Channel> getChannelSettings() {
            return this.getChannelSettings;
        }

        public PagedCallSettings.Builder<ListChannelsRequest, ListChannelsResponse, EventarcClient.ListChannelsPagedResponse> listChannelsSettings() {
            return this.listChannelsSettings;
        }

        public UnaryCallSettings.Builder<CreateChannelRequest, Operation> createChannelSettings() {
            return this.createChannelSettings;
        }

        public OperationCallSettings.Builder<CreateChannelRequest, Channel, OperationMetadata> createChannelOperationSettings() {
            return this.createChannelOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateChannelRequest, Operation> updateChannelSettings() {
            return this.updateChannelSettings;
        }

        public OperationCallSettings.Builder<UpdateChannelRequest, Channel, OperationMetadata> updateChannelOperationSettings() {
            return this.updateChannelOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteChannelRequest, Operation> deleteChannelSettings() {
            return this.deleteChannelSettings;
        }

        public OperationCallSettings.Builder<DeleteChannelRequest, Channel, OperationMetadata> deleteChannelOperationSettings() {
            return this.deleteChannelOperationSettings;
        }

        public UnaryCallSettings.Builder<GetProviderRequest, Provider> getProviderSettings() {
            return this.getProviderSettings;
        }

        public PagedCallSettings.Builder<ListProvidersRequest, ListProvidersResponse, EventarcClient.ListProvidersPagedResponse> listProvidersSettings() {
            return this.listProvidersSettings;
        }

        public UnaryCallSettings.Builder<GetChannelConnectionRequest, ChannelConnection> getChannelConnectionSettings() {
            return this.getChannelConnectionSettings;
        }

        public PagedCallSettings.Builder<ListChannelConnectionsRequest, ListChannelConnectionsResponse, EventarcClient.ListChannelConnectionsPagedResponse> listChannelConnectionsSettings() {
            return this.listChannelConnectionsSettings;
        }

        public UnaryCallSettings.Builder<CreateChannelConnectionRequest, Operation> createChannelConnectionSettings() {
            return this.createChannelConnectionSettings;
        }

        public OperationCallSettings.Builder<CreateChannelConnectionRequest, ChannelConnection, OperationMetadata> createChannelConnectionOperationSettings() {
            return this.createChannelConnectionOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteChannelConnectionRequest, Operation> deleteChannelConnectionSettings() {
            return this.deleteChannelConnectionSettings;
        }

        public OperationCallSettings.Builder<DeleteChannelConnectionRequest, ChannelConnection, OperationMetadata> deleteChannelConnectionOperationSettings() {
            return this.deleteChannelConnectionOperationSettings;
        }

        public UnaryCallSettings.Builder<GetGoogleChannelConfigRequest, GoogleChannelConfig> getGoogleChannelConfigSettings() {
            return this.getGoogleChannelConfigSettings;
        }

        public UnaryCallSettings.Builder<UpdateGoogleChannelConfigRequest, GoogleChannelConfig> updateGoogleChannelConfigSettings() {
            return this.updateGoogleChannelConfigSettings;
        }

        public UnaryCallSettings.Builder<GetMessageBusRequest, MessageBus> getMessageBusSettings() {
            return this.getMessageBusSettings;
        }

        public PagedCallSettings.Builder<ListMessageBusesRequest, ListMessageBusesResponse, EventarcClient.ListMessageBusesPagedResponse> listMessageBusesSettings() {
            return this.listMessageBusesSettings;
        }

        public PagedCallSettings.Builder<ListMessageBusEnrollmentsRequest, ListMessageBusEnrollmentsResponse, EventarcClient.ListMessageBusEnrollmentsPagedResponse> listMessageBusEnrollmentsSettings() {
            return this.listMessageBusEnrollmentsSettings;
        }

        public UnaryCallSettings.Builder<CreateMessageBusRequest, Operation> createMessageBusSettings() {
            return this.createMessageBusSettings;
        }

        public OperationCallSettings.Builder<CreateMessageBusRequest, MessageBus, OperationMetadata> createMessageBusOperationSettings() {
            return this.createMessageBusOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateMessageBusRequest, Operation> updateMessageBusSettings() {
            return this.updateMessageBusSettings;
        }

        public OperationCallSettings.Builder<UpdateMessageBusRequest, MessageBus, OperationMetadata> updateMessageBusOperationSettings() {
            return this.updateMessageBusOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteMessageBusRequest, Operation> deleteMessageBusSettings() {
            return this.deleteMessageBusSettings;
        }

        public OperationCallSettings.Builder<DeleteMessageBusRequest, MessageBus, OperationMetadata> deleteMessageBusOperationSettings() {
            return this.deleteMessageBusOperationSettings;
        }

        public UnaryCallSettings.Builder<GetEnrollmentRequest, Enrollment> getEnrollmentSettings() {
            return this.getEnrollmentSettings;
        }

        public PagedCallSettings.Builder<ListEnrollmentsRequest, ListEnrollmentsResponse, EventarcClient.ListEnrollmentsPagedResponse> listEnrollmentsSettings() {
            return this.listEnrollmentsSettings;
        }

        public UnaryCallSettings.Builder<CreateEnrollmentRequest, Operation> createEnrollmentSettings() {
            return this.createEnrollmentSettings;
        }

        public OperationCallSettings.Builder<CreateEnrollmentRequest, Enrollment, OperationMetadata> createEnrollmentOperationSettings() {
            return this.createEnrollmentOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateEnrollmentRequest, Operation> updateEnrollmentSettings() {
            return this.updateEnrollmentSettings;
        }

        public OperationCallSettings.Builder<UpdateEnrollmentRequest, Enrollment, OperationMetadata> updateEnrollmentOperationSettings() {
            return this.updateEnrollmentOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteEnrollmentRequest, Operation> deleteEnrollmentSettings() {
            return this.deleteEnrollmentSettings;
        }

        public OperationCallSettings.Builder<DeleteEnrollmentRequest, Enrollment, OperationMetadata> deleteEnrollmentOperationSettings() {
            return this.deleteEnrollmentOperationSettings;
        }

        public UnaryCallSettings.Builder<GetPipelineRequest, Pipeline> getPipelineSettings() {
            return this.getPipelineSettings;
        }

        public PagedCallSettings.Builder<ListPipelinesRequest, ListPipelinesResponse, EventarcClient.ListPipelinesPagedResponse> listPipelinesSettings() {
            return this.listPipelinesSettings;
        }

        public UnaryCallSettings.Builder<CreatePipelineRequest, Operation> createPipelineSettings() {
            return this.createPipelineSettings;
        }

        public OperationCallSettings.Builder<CreatePipelineRequest, Pipeline, OperationMetadata> createPipelineOperationSettings() {
            return this.createPipelineOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdatePipelineRequest, Operation> updatePipelineSettings() {
            return this.updatePipelineSettings;
        }

        public OperationCallSettings.Builder<UpdatePipelineRequest, Pipeline, OperationMetadata> updatePipelineOperationSettings() {
            return this.updatePipelineOperationSettings;
        }

        public UnaryCallSettings.Builder<DeletePipelineRequest, Operation> deletePipelineSettings() {
            return this.deletePipelineSettings;
        }

        public OperationCallSettings.Builder<DeletePipelineRequest, Pipeline, OperationMetadata> deletePipelineOperationSettings() {
            return this.deletePipelineOperationSettings;
        }

        public UnaryCallSettings.Builder<GetGoogleApiSourceRequest, GoogleApiSource> getGoogleApiSourceSettings() {
            return this.getGoogleApiSourceSettings;
        }

        public PagedCallSettings.Builder<ListGoogleApiSourcesRequest, ListGoogleApiSourcesResponse, EventarcClient.ListGoogleApiSourcesPagedResponse> listGoogleApiSourcesSettings() {
            return this.listGoogleApiSourcesSettings;
        }

        public UnaryCallSettings.Builder<CreateGoogleApiSourceRequest, Operation> createGoogleApiSourceSettings() {
            return this.createGoogleApiSourceSettings;
        }

        public OperationCallSettings.Builder<CreateGoogleApiSourceRequest, GoogleApiSource, OperationMetadata> createGoogleApiSourceOperationSettings() {
            return this.createGoogleApiSourceOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateGoogleApiSourceRequest, Operation> updateGoogleApiSourceSettings() {
            return this.updateGoogleApiSourceSettings;
        }

        public OperationCallSettings.Builder<UpdateGoogleApiSourceRequest, GoogleApiSource, OperationMetadata> updateGoogleApiSourceOperationSettings() {
            return this.updateGoogleApiSourceOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteGoogleApiSourceRequest, Operation> deleteGoogleApiSourceSettings() {
            return this.deleteGoogleApiSourceSettings;
        }

        public OperationCallSettings.Builder<DeleteGoogleApiSourceRequest, GoogleApiSource, OperationMetadata> deleteGoogleApiSourceOperationSettings() {
            return this.deleteGoogleApiSourceOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, EventarcClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public EventarcStubSettings build() throws IOException {
            return new EventarcStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.UNKNOWN})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

