/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.eventarc.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.eventarc.v1.CreateTriggerRequest;
import com.google.cloud.eventarc.v1.DeleteTriggerRequest;
import com.google.cloud.eventarc.v1.EventarcClient;
import com.google.cloud.eventarc.v1.GetTriggerRequest;
import com.google.cloud.eventarc.v1.ListTriggersRequest;
import com.google.cloud.eventarc.v1.ListTriggersResponse;
import com.google.cloud.eventarc.v1.OperationMetadata;
import com.google.cloud.eventarc.v1.Trigger;
import com.google.cloud.eventarc.v1.UpdateTriggerRequest;
import com.google.cloud.eventarc.v1.stub.EventarcStub;
import com.google.cloud.eventarc.v1.stub.GrpcEventarcStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class EventarcStubSettings
extends StubSettings<EventarcStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetTriggerRequest, Trigger> getTriggerSettings;
    private final PagedCallSettings<ListTriggersRequest, ListTriggersResponse, EventarcClient.ListTriggersPagedResponse> listTriggersSettings;
    private final UnaryCallSettings<CreateTriggerRequest, Operation> createTriggerSettings;
    private final OperationCallSettings<CreateTriggerRequest, Trigger, OperationMetadata> createTriggerOperationSettings;
    private final UnaryCallSettings<UpdateTriggerRequest, Operation> updateTriggerSettings;
    private final OperationCallSettings<UpdateTriggerRequest, Trigger, OperationMetadata> updateTriggerOperationSettings;
    private final UnaryCallSettings<DeleteTriggerRequest, Operation> deleteTriggerSettings;
    private final OperationCallSettings<DeleteTriggerRequest, Trigger, OperationMetadata> deleteTriggerOperationSettings;
    private static final PagedListDescriptor<ListTriggersRequest, ListTriggersResponse, Trigger> LIST_TRIGGERS_PAGE_STR_DESC = new PagedListDescriptor<ListTriggersRequest, ListTriggersResponse, Trigger>(){

        public String emptyToken() {
            return "";
        }

        public ListTriggersRequest injectToken(ListTriggersRequest payload, String token) {
            return ListTriggersRequest.newBuilder((ListTriggersRequest)payload).setPageToken(token).build();
        }

        public ListTriggersRequest injectPageSize(ListTriggersRequest payload, int pageSize) {
            return ListTriggersRequest.newBuilder((ListTriggersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTriggersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTriggersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Trigger> extractResources(ListTriggersResponse payload) {
            return payload.getTriggersList() == null ? ImmutableList.of() : payload.getTriggersList();
        }
    };
    private static final PagedListResponseFactory<ListTriggersRequest, ListTriggersResponse, EventarcClient.ListTriggersPagedResponse> LIST_TRIGGERS_PAGE_STR_FACT = new PagedListResponseFactory<ListTriggersRequest, ListTriggersResponse, EventarcClient.ListTriggersPagedResponse>(){

        public ApiFuture<EventarcClient.ListTriggersPagedResponse> getFuturePagedResponse(UnaryCallable<ListTriggersRequest, ListTriggersResponse> callable, ListTriggersRequest request, ApiCallContext context, ApiFuture<ListTriggersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TRIGGERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EventarcClient.ListTriggersPagedResponse.createAsync((PageContext<ListTriggersRequest, ListTriggersResponse, Trigger>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetTriggerRequest, Trigger> getTriggerSettings() {
        return this.getTriggerSettings;
    }

    public PagedCallSettings<ListTriggersRequest, ListTriggersResponse, EventarcClient.ListTriggersPagedResponse> listTriggersSettings() {
        return this.listTriggersSettings;
    }

    public UnaryCallSettings<CreateTriggerRequest, Operation> createTriggerSettings() {
        return this.createTriggerSettings;
    }

    public OperationCallSettings<CreateTriggerRequest, Trigger, OperationMetadata> createTriggerOperationSettings() {
        return this.createTriggerOperationSettings;
    }

    public UnaryCallSettings<UpdateTriggerRequest, Operation> updateTriggerSettings() {
        return this.updateTriggerSettings;
    }

    public OperationCallSettings<UpdateTriggerRequest, Trigger, OperationMetadata> updateTriggerOperationSettings() {
        return this.updateTriggerOperationSettings;
    }

    public UnaryCallSettings<DeleteTriggerRequest, Operation> deleteTriggerSettings() {
        return this.deleteTriggerSettings;
    }

    public OperationCallSettings<DeleteTriggerRequest, Trigger, OperationMetadata> deleteTriggerOperationSettings() {
        return this.deleteTriggerOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public EventarcStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcEventarcStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "eventarc.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "eventarc.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return EventarcStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EventarcStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected EventarcStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getTriggerSettings = settingsBuilder.getTriggerSettings().build();
        this.listTriggersSettings = settingsBuilder.listTriggersSettings().build();
        this.createTriggerSettings = settingsBuilder.createTriggerSettings().build();
        this.createTriggerOperationSettings = settingsBuilder.createTriggerOperationSettings().build();
        this.updateTriggerSettings = settingsBuilder.updateTriggerSettings().build();
        this.updateTriggerOperationSettings = settingsBuilder.updateTriggerOperationSettings().build();
        this.deleteTriggerSettings = settingsBuilder.deleteTriggerSettings().build();
        this.deleteTriggerOperationSettings = settingsBuilder.deleteTriggerOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<EventarcStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetTriggerRequest, Trigger> getTriggerSettings;
        private final PagedCallSettings.Builder<ListTriggersRequest, ListTriggersResponse, EventarcClient.ListTriggersPagedResponse> listTriggersSettings;
        private final UnaryCallSettings.Builder<CreateTriggerRequest, Operation> createTriggerSettings;
        private final OperationCallSettings.Builder<CreateTriggerRequest, Trigger, OperationMetadata> createTriggerOperationSettings;
        private final UnaryCallSettings.Builder<UpdateTriggerRequest, Operation> updateTriggerSettings;
        private final OperationCallSettings.Builder<UpdateTriggerRequest, Trigger, OperationMetadata> updateTriggerOperationSettings;
        private final UnaryCallSettings.Builder<DeleteTriggerRequest, Operation> deleteTriggerSettings;
        private final OperationCallSettings.Builder<DeleteTriggerRequest, Trigger, OperationMetadata> deleteTriggerOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTriggersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TRIGGERS_PAGE_STR_FACT);
            this.createTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTriggerOperationSettings = OperationCallSettings.newBuilder();
            this.updateTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTriggerOperationSettings = OperationCallSettings.newBuilder();
            this.deleteTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTriggerOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getTriggerSettings, this.listTriggersSettings, this.createTriggerSettings, this.updateTriggerSettings, this.deleteTriggerSettings);
            Builder.initDefaults(this);
        }

        protected Builder(EventarcStubSettings settings) {
            super((StubSettings)settings);
            this.getTriggerSettings = settings.getTriggerSettings.toBuilder();
            this.listTriggersSettings = settings.listTriggersSettings.toBuilder();
            this.createTriggerSettings = settings.createTriggerSettings.toBuilder();
            this.createTriggerOperationSettings = settings.createTriggerOperationSettings.toBuilder();
            this.updateTriggerSettings = settings.updateTriggerSettings.toBuilder();
            this.updateTriggerOperationSettings = settings.updateTriggerOperationSettings.toBuilder();
            this.deleteTriggerSettings = settings.deleteTriggerSettings.toBuilder();
            this.deleteTriggerOperationSettings = settings.deleteTriggerOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getTriggerSettings, this.listTriggersSettings, this.createTriggerSettings, this.updateTriggerSettings, this.deleteTriggerSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(EventarcStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)EventarcStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EventarcStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(EventarcStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(EventarcStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listTriggersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createTriggerOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Trigger.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateTriggerOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Trigger.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteTriggerOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Trigger.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetTriggerRequest, Trigger> getTriggerSettings() {
            return this.getTriggerSettings;
        }

        public PagedCallSettings.Builder<ListTriggersRequest, ListTriggersResponse, EventarcClient.ListTriggersPagedResponse> listTriggersSettings() {
            return this.listTriggersSettings;
        }

        public UnaryCallSettings.Builder<CreateTriggerRequest, Operation> createTriggerSettings() {
            return this.createTriggerSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateTriggerRequest, Trigger, OperationMetadata> createTriggerOperationSettings() {
            return this.createTriggerOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateTriggerRequest, Operation> updateTriggerSettings() {
            return this.updateTriggerSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateTriggerRequest, Trigger, OperationMetadata> updateTriggerOperationSettings() {
            return this.updateTriggerOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteTriggerRequest, Operation> deleteTriggerSettings() {
            return this.deleteTriggerSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteTriggerRequest, Trigger, OperationMetadata> deleteTriggerOperationSettings() {
            return this.deleteTriggerOperationSettings;
        }

        public EventarcStubSettings build() throws IOException {
            return new EventarcStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

