/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.eventarc.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.eventarc.v1.CreateTriggerRequest;
import com.google.cloud.eventarc.v1.DeleteTriggerRequest;
import com.google.cloud.eventarc.v1.EventarcClient;
import com.google.cloud.eventarc.v1.GetTriggerRequest;
import com.google.cloud.eventarc.v1.ListTriggersRequest;
import com.google.cloud.eventarc.v1.ListTriggersResponse;
import com.google.cloud.eventarc.v1.OperationMetadata;
import com.google.cloud.eventarc.v1.Trigger;
import com.google.cloud.eventarc.v1.UpdateTriggerRequest;
import com.google.cloud.eventarc.v1.stub.EventarcStub;
import com.google.cloud.eventarc.v1.stub.EventarcStubSettings;
import com.google.cloud.eventarc.v1.stub.GrpcEventarcCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcEventarcStub
extends EventarcStub {
    private static final MethodDescriptor<GetTriggerRequest, Trigger> getTriggerMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.v1.Eventarc/GetTrigger").setRequestMarshaller(ProtoUtils.marshaller((Message)GetTriggerRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Trigger.getDefaultInstance())).build();
    private static final MethodDescriptor<ListTriggersRequest, ListTriggersResponse> listTriggersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.v1.Eventarc/ListTriggers").setRequestMarshaller(ProtoUtils.marshaller((Message)ListTriggersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListTriggersResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateTriggerRequest, Operation> createTriggerMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.v1.Eventarc/CreateTrigger").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateTriggerRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateTriggerRequest, Operation> updateTriggerMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.v1.Eventarc/UpdateTrigger").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateTriggerRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteTriggerRequest, Operation> deleteTriggerMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.v1.Eventarc/DeleteTrigger").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteTriggerRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<GetTriggerRequest, Trigger> getTriggerCallable;
    private final UnaryCallable<ListTriggersRequest, ListTriggersResponse> listTriggersCallable;
    private final UnaryCallable<ListTriggersRequest, EventarcClient.ListTriggersPagedResponse> listTriggersPagedCallable;
    private final UnaryCallable<CreateTriggerRequest, Operation> createTriggerCallable;
    private final OperationCallable<CreateTriggerRequest, Trigger, OperationMetadata> createTriggerOperationCallable;
    private final UnaryCallable<UpdateTriggerRequest, Operation> updateTriggerCallable;
    private final OperationCallable<UpdateTriggerRequest, Trigger, OperationMetadata> updateTriggerOperationCallable;
    private final UnaryCallable<DeleteTriggerRequest, Operation> deleteTriggerCallable;
    private final OperationCallable<DeleteTriggerRequest, Trigger, OperationMetadata> deleteTriggerOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcEventarcStub create(EventarcStubSettings settings) throws IOException {
        return new GrpcEventarcStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcEventarcStub create(ClientContext clientContext) throws IOException {
        return new GrpcEventarcStub(EventarcStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcEventarcStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcEventarcStub(EventarcStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcEventarcStub(EventarcStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcEventarcCallableFactory());
    }

    protected GrpcEventarcStub(EventarcStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getTriggerTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getTriggerMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetTriggerRequest>(){

            public Map<String, String> extract(GetTriggerRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listTriggersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTriggersMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListTriggersRequest>(){

            public Map<String, String> extract(ListTriggersRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings createTriggerTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createTriggerMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateTriggerRequest>(){

            public Map<String, String> extract(CreateTriggerRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings updateTriggerTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateTriggerMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateTriggerRequest>(){

            public Map<String, String> extract(UpdateTriggerRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"trigger.name", (Object)String.valueOf(request.getTrigger().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteTriggerTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteTriggerMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteTriggerRequest>(){

            public Map<String, String> extract(DeleteTriggerRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        this.getTriggerCallable = callableFactory.createUnaryCallable(getTriggerTransportSettings, settings.getTriggerSettings(), clientContext);
        this.listTriggersCallable = callableFactory.createUnaryCallable(listTriggersTransportSettings, settings.listTriggersSettings(), clientContext);
        this.listTriggersPagedCallable = callableFactory.createPagedCallable(listTriggersTransportSettings, settings.listTriggersSettings(), clientContext);
        this.createTriggerCallable = callableFactory.createUnaryCallable(createTriggerTransportSettings, settings.createTriggerSettings(), clientContext);
        this.createTriggerOperationCallable = callableFactory.createOperationCallable(createTriggerTransportSettings, settings.createTriggerOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateTriggerCallable = callableFactory.createUnaryCallable(updateTriggerTransportSettings, settings.updateTriggerSettings(), clientContext);
        this.updateTriggerOperationCallable = callableFactory.createOperationCallable(updateTriggerTransportSettings, settings.updateTriggerOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteTriggerCallable = callableFactory.createUnaryCallable(deleteTriggerTransportSettings, settings.deleteTriggerSettings(), clientContext);
        this.deleteTriggerOperationCallable = callableFactory.createOperationCallable(deleteTriggerTransportSettings, settings.deleteTriggerOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetTriggerRequest, Trigger> getTriggerCallable() {
        return this.getTriggerCallable;
    }

    @Override
    public UnaryCallable<ListTriggersRequest, ListTriggersResponse> listTriggersCallable() {
        return this.listTriggersCallable;
    }

    @Override
    public UnaryCallable<ListTriggersRequest, EventarcClient.ListTriggersPagedResponse> listTriggersPagedCallable() {
        return this.listTriggersPagedCallable;
    }

    @Override
    public UnaryCallable<CreateTriggerRequest, Operation> createTriggerCallable() {
        return this.createTriggerCallable;
    }

    @Override
    public OperationCallable<CreateTriggerRequest, Trigger, OperationMetadata> createTriggerOperationCallable() {
        return this.createTriggerOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateTriggerRequest, Operation> updateTriggerCallable() {
        return this.updateTriggerCallable;
    }

    @Override
    public OperationCallable<UpdateTriggerRequest, Trigger, OperationMetadata> updateTriggerOperationCallable() {
        return this.updateTriggerOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteTriggerRequest, Operation> deleteTriggerCallable() {
        return this.deleteTriggerCallable;
    }

    @Override
    public OperationCallable<DeleteTriggerRequest, Trigger, OperationMetadata> deleteTriggerOperationCallable() {
        return this.deleteTriggerOperationCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

