/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.essentialcontacts.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.essentialcontacts.v1.ComputeContactsRequest;
import com.google.cloud.essentialcontacts.v1.ComputeContactsResponse;
import com.google.cloud.essentialcontacts.v1.Contact;
import com.google.cloud.essentialcontacts.v1.ContactName;
import com.google.cloud.essentialcontacts.v1.CreateContactRequest;
import com.google.cloud.essentialcontacts.v1.DeleteContactRequest;
import com.google.cloud.essentialcontacts.v1.EssentialContactsServiceSettings;
import com.google.cloud.essentialcontacts.v1.FolderName;
import com.google.cloud.essentialcontacts.v1.GetContactRequest;
import com.google.cloud.essentialcontacts.v1.ListContactsRequest;
import com.google.cloud.essentialcontacts.v1.ListContactsResponse;
import com.google.cloud.essentialcontacts.v1.OrganizationName;
import com.google.cloud.essentialcontacts.v1.ProjectName;
import com.google.cloud.essentialcontacts.v1.SendTestMessageRequest;
import com.google.cloud.essentialcontacts.v1.UpdateContactRequest;
import com.google.cloud.essentialcontacts.v1.stub.EssentialContactsServiceStub;
import com.google.cloud.essentialcontacts.v1.stub.EssentialContactsServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class EssentialContactsServiceClient
implements BackgroundResource {
    private final EssentialContactsServiceSettings settings;
    private final EssentialContactsServiceStub stub;

    public static final EssentialContactsServiceClient create() throws IOException {
        return EssentialContactsServiceClient.create(EssentialContactsServiceSettings.newBuilder().build());
    }

    public static final EssentialContactsServiceClient create(EssentialContactsServiceSettings settings) throws IOException {
        return new EssentialContactsServiceClient(settings);
    }

    public static final EssentialContactsServiceClient create(EssentialContactsServiceStub stub) {
        return new EssentialContactsServiceClient(stub);
    }

    protected EssentialContactsServiceClient(EssentialContactsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((EssentialContactsServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected EssentialContactsServiceClient(EssentialContactsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final EssentialContactsServiceSettings getSettings() {
        return this.settings;
    }

    public EssentialContactsServiceStub getStub() {
        return this.stub;
    }

    public final Contact createContact(FolderName parent, Contact contact) {
        CreateContactRequest request = CreateContactRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setContact(contact).build();
        return this.createContact(request);
    }

    public final Contact createContact(OrganizationName parent, Contact contact) {
        CreateContactRequest request = CreateContactRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setContact(contact).build();
        return this.createContact(request);
    }

    public final Contact createContact(ProjectName parent, Contact contact) {
        CreateContactRequest request = CreateContactRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setContact(contact).build();
        return this.createContact(request);
    }

    public final Contact createContact(String parent, Contact contact) {
        CreateContactRequest request = CreateContactRequest.newBuilder().setParent(parent).setContact(contact).build();
        return this.createContact(request);
    }

    public final Contact createContact(CreateContactRequest request) {
        return (Contact)this.createContactCallable().call((Object)request);
    }

    public final UnaryCallable<CreateContactRequest, Contact> createContactCallable() {
        return this.stub.createContactCallable();
    }

    public final Contact updateContact(Contact contact, FieldMask updateMask) {
        UpdateContactRequest request = UpdateContactRequest.newBuilder().setContact(contact).setUpdateMask(updateMask).build();
        return this.updateContact(request);
    }

    public final Contact updateContact(UpdateContactRequest request) {
        return (Contact)this.updateContactCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateContactRequest, Contact> updateContactCallable() {
        return this.stub.updateContactCallable();
    }

    public final ListContactsPagedResponse listContacts(FolderName parent) {
        ListContactsRequest request = ListContactsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listContacts(request);
    }

    public final ListContactsPagedResponse listContacts(OrganizationName parent) {
        ListContactsRequest request = ListContactsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listContacts(request);
    }

    public final ListContactsPagedResponse listContacts(ProjectName parent) {
        ListContactsRequest request = ListContactsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listContacts(request);
    }

    public final ListContactsPagedResponse listContacts(String parent) {
        ListContactsRequest request = ListContactsRequest.newBuilder().setParent(parent).build();
        return this.listContacts(request);
    }

    public final ListContactsPagedResponse listContacts(ListContactsRequest request) {
        return (ListContactsPagedResponse)((Object)this.listContactsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListContactsRequest, ListContactsPagedResponse> listContactsPagedCallable() {
        return this.stub.listContactsPagedCallable();
    }

    public final UnaryCallable<ListContactsRequest, ListContactsResponse> listContactsCallable() {
        return this.stub.listContactsCallable();
    }

    public final Contact getContact(ContactName name) {
        GetContactRequest request = GetContactRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getContact(request);
    }

    public final Contact getContact(String name) {
        GetContactRequest request = GetContactRequest.newBuilder().setName(name).build();
        return this.getContact(request);
    }

    public final Contact getContact(GetContactRequest request) {
        return (Contact)this.getContactCallable().call((Object)request);
    }

    public final UnaryCallable<GetContactRequest, Contact> getContactCallable() {
        return this.stub.getContactCallable();
    }

    public final void deleteContact(ContactName name) {
        DeleteContactRequest request = DeleteContactRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteContact(request);
    }

    public final void deleteContact(String name) {
        DeleteContactRequest request = DeleteContactRequest.newBuilder().setName(name).build();
        this.deleteContact(request);
    }

    public final void deleteContact(DeleteContactRequest request) {
        this.deleteContactCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteContactRequest, Empty> deleteContactCallable() {
        return this.stub.deleteContactCallable();
    }

    public final ComputeContactsPagedResponse computeContacts(ComputeContactsRequest request) {
        return (ComputeContactsPagedResponse)((Object)this.computeContactsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ComputeContactsRequest, ComputeContactsPagedResponse> computeContactsPagedCallable() {
        return this.stub.computeContactsPagedCallable();
    }

    public final UnaryCallable<ComputeContactsRequest, ComputeContactsResponse> computeContactsCallable() {
        return this.stub.computeContactsCallable();
    }

    public final void sendTestMessage(SendTestMessageRequest request) {
        this.sendTestMessageCallable().call((Object)request);
    }

    public final UnaryCallable<SendTestMessageRequest, Empty> sendTestMessageCallable() {
        return this.stub.sendTestMessageCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ComputeContactsFixedSizeCollection
    extends AbstractFixedSizeCollection<ComputeContactsRequest, ComputeContactsResponse, Contact, ComputeContactsPage, ComputeContactsFixedSizeCollection> {
        private ComputeContactsFixedSizeCollection(List<ComputeContactsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ComputeContactsFixedSizeCollection createEmptyCollection() {
            return new ComputeContactsFixedSizeCollection(null, 0);
        }

        protected ComputeContactsFixedSizeCollection createCollection(List<ComputeContactsPage> pages, int collectionSize) {
            return new ComputeContactsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ComputeContactsPage
    extends AbstractPage<ComputeContactsRequest, ComputeContactsResponse, Contact, ComputeContactsPage> {
        private ComputeContactsPage(PageContext<ComputeContactsRequest, ComputeContactsResponse, Contact> context, ComputeContactsResponse response) {
            super(context, (Object)response);
        }

        private static ComputeContactsPage createEmptyPage() {
            return new ComputeContactsPage(null, null);
        }

        protected ComputeContactsPage createPage(PageContext<ComputeContactsRequest, ComputeContactsResponse, Contact> context, ComputeContactsResponse response) {
            return new ComputeContactsPage(context, response);
        }

        public ApiFuture<ComputeContactsPage> createPageAsync(PageContext<ComputeContactsRequest, ComputeContactsResponse, Contact> context, ApiFuture<ComputeContactsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ComputeContactsPagedResponse
    extends AbstractPagedListResponse<ComputeContactsRequest, ComputeContactsResponse, Contact, ComputeContactsPage, ComputeContactsFixedSizeCollection> {
        public static ApiFuture<ComputeContactsPagedResponse> createAsync(PageContext<ComputeContactsRequest, ComputeContactsResponse, Contact> context, ApiFuture<ComputeContactsResponse> futureResponse) {
            ApiFuture<ComputeContactsPage> futurePage = ComputeContactsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ComputeContactsPagedResponse((ComputeContactsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ComputeContactsPagedResponse(ComputeContactsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ComputeContactsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListContactsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListContactsRequest, ListContactsResponse, Contact, ListContactsPage, ListContactsFixedSizeCollection> {
        private ListContactsFixedSizeCollection(List<ListContactsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListContactsFixedSizeCollection createEmptyCollection() {
            return new ListContactsFixedSizeCollection(null, 0);
        }

        protected ListContactsFixedSizeCollection createCollection(List<ListContactsPage> pages, int collectionSize) {
            return new ListContactsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListContactsPage
    extends AbstractPage<ListContactsRequest, ListContactsResponse, Contact, ListContactsPage> {
        private ListContactsPage(PageContext<ListContactsRequest, ListContactsResponse, Contact> context, ListContactsResponse response) {
            super(context, (Object)response);
        }

        private static ListContactsPage createEmptyPage() {
            return new ListContactsPage(null, null);
        }

        protected ListContactsPage createPage(PageContext<ListContactsRequest, ListContactsResponse, Contact> context, ListContactsResponse response) {
            return new ListContactsPage(context, response);
        }

        public ApiFuture<ListContactsPage> createPageAsync(PageContext<ListContactsRequest, ListContactsResponse, Contact> context, ApiFuture<ListContactsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListContactsPagedResponse
    extends AbstractPagedListResponse<ListContactsRequest, ListContactsResponse, Contact, ListContactsPage, ListContactsFixedSizeCollection> {
        public static ApiFuture<ListContactsPagedResponse> createAsync(PageContext<ListContactsRequest, ListContactsResponse, Contact> context, ApiFuture<ListContactsResponse> futureResponse) {
            ApiFuture<ListContactsPage> futurePage = ListContactsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListContactsPagedResponse((ListContactsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListContactsPagedResponse(ListContactsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListContactsFixedSizeCollection.createEmptyCollection());
        }
    }
}

