/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.edgenetwork.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.edgenetwork.v1.CreateInterconnectAttachmentRequest;
import com.google.cloud.edgenetwork.v1.CreateNetworkRequest;
import com.google.cloud.edgenetwork.v1.CreateRouterRequest;
import com.google.cloud.edgenetwork.v1.CreateSubnetRequest;
import com.google.cloud.edgenetwork.v1.DeleteInterconnectAttachmentRequest;
import com.google.cloud.edgenetwork.v1.DeleteNetworkRequest;
import com.google.cloud.edgenetwork.v1.DeleteRouterRequest;
import com.google.cloud.edgenetwork.v1.DeleteSubnetRequest;
import com.google.cloud.edgenetwork.v1.DiagnoseInterconnectRequest;
import com.google.cloud.edgenetwork.v1.DiagnoseInterconnectResponse;
import com.google.cloud.edgenetwork.v1.DiagnoseNetworkRequest;
import com.google.cloud.edgenetwork.v1.DiagnoseNetworkResponse;
import com.google.cloud.edgenetwork.v1.DiagnoseRouterRequest;
import com.google.cloud.edgenetwork.v1.DiagnoseRouterResponse;
import com.google.cloud.edgenetwork.v1.EdgeNetworkSettings;
import com.google.cloud.edgenetwork.v1.GetInterconnectAttachmentRequest;
import com.google.cloud.edgenetwork.v1.GetInterconnectRequest;
import com.google.cloud.edgenetwork.v1.GetNetworkRequest;
import com.google.cloud.edgenetwork.v1.GetRouterRequest;
import com.google.cloud.edgenetwork.v1.GetSubnetRequest;
import com.google.cloud.edgenetwork.v1.GetZoneRequest;
import com.google.cloud.edgenetwork.v1.InitializeZoneRequest;
import com.google.cloud.edgenetwork.v1.InitializeZoneResponse;
import com.google.cloud.edgenetwork.v1.Interconnect;
import com.google.cloud.edgenetwork.v1.InterconnectAttachment;
import com.google.cloud.edgenetwork.v1.InterconnectAttachmentName;
import com.google.cloud.edgenetwork.v1.InterconnectName;
import com.google.cloud.edgenetwork.v1.ListInterconnectAttachmentsRequest;
import com.google.cloud.edgenetwork.v1.ListInterconnectAttachmentsResponse;
import com.google.cloud.edgenetwork.v1.ListInterconnectsRequest;
import com.google.cloud.edgenetwork.v1.ListInterconnectsResponse;
import com.google.cloud.edgenetwork.v1.ListNetworksRequest;
import com.google.cloud.edgenetwork.v1.ListNetworksResponse;
import com.google.cloud.edgenetwork.v1.ListRoutersRequest;
import com.google.cloud.edgenetwork.v1.ListRoutersResponse;
import com.google.cloud.edgenetwork.v1.ListSubnetsRequest;
import com.google.cloud.edgenetwork.v1.ListSubnetsResponse;
import com.google.cloud.edgenetwork.v1.ListZonesRequest;
import com.google.cloud.edgenetwork.v1.ListZonesResponse;
import com.google.cloud.edgenetwork.v1.LocationName;
import com.google.cloud.edgenetwork.v1.Network;
import com.google.cloud.edgenetwork.v1.NetworkName;
import com.google.cloud.edgenetwork.v1.OperationMetadata;
import com.google.cloud.edgenetwork.v1.Router;
import com.google.cloud.edgenetwork.v1.RouterName;
import com.google.cloud.edgenetwork.v1.Subnet;
import com.google.cloud.edgenetwork.v1.SubnetName;
import com.google.cloud.edgenetwork.v1.UpdateRouterRequest;
import com.google.cloud.edgenetwork.v1.UpdateSubnetRequest;
import com.google.cloud.edgenetwork.v1.Zone;
import com.google.cloud.edgenetwork.v1.ZoneName;
import com.google.cloud.edgenetwork.v1.stub.EdgeNetworkStub;
import com.google.cloud.edgenetwork.v1.stub.EdgeNetworkStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class EdgeNetworkClient
implements BackgroundResource {
    private final EdgeNetworkSettings settings;
    private final EdgeNetworkStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final EdgeNetworkClient create() throws IOException {
        return EdgeNetworkClient.create(EdgeNetworkSettings.newBuilder().build());
    }

    public static final EdgeNetworkClient create(EdgeNetworkSettings settings) throws IOException {
        return new EdgeNetworkClient(settings);
    }

    public static final EdgeNetworkClient create(EdgeNetworkStub stub) {
        return new EdgeNetworkClient(stub);
    }

    protected EdgeNetworkClient(EdgeNetworkSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((EdgeNetworkStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected EdgeNetworkClient(EdgeNetworkStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final EdgeNetworkSettings getSettings() {
        return this.settings;
    }

    public EdgeNetworkStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final InitializeZoneResponse initializeZone(ZoneName name) {
        InitializeZoneRequest request = InitializeZoneRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.initializeZone(request);
    }

    public final InitializeZoneResponse initializeZone(String name) {
        InitializeZoneRequest request = InitializeZoneRequest.newBuilder().setName(name).build();
        return this.initializeZone(request);
    }

    public final InitializeZoneResponse initializeZone(InitializeZoneRequest request) {
        return (InitializeZoneResponse)this.initializeZoneCallable().call((Object)request);
    }

    public final UnaryCallable<InitializeZoneRequest, InitializeZoneResponse> initializeZoneCallable() {
        return this.stub.initializeZoneCallable();
    }

    public final ListZonesPagedResponse listZones(LocationName parent) {
        ListZonesRequest request = ListZonesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listZones(request);
    }

    public final ListZonesPagedResponse listZones(String parent) {
        ListZonesRequest request = ListZonesRequest.newBuilder().setParent(parent).build();
        return this.listZones(request);
    }

    public final ListZonesPagedResponse listZones(ListZonesRequest request) {
        return (ListZonesPagedResponse)((Object)this.listZonesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListZonesRequest, ListZonesPagedResponse> listZonesPagedCallable() {
        return this.stub.listZonesPagedCallable();
    }

    public final UnaryCallable<ListZonesRequest, ListZonesResponse> listZonesCallable() {
        return this.stub.listZonesCallable();
    }

    public final Zone getZone(ZoneName name) {
        GetZoneRequest request = GetZoneRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getZone(request);
    }

    public final Zone getZone(String name) {
        GetZoneRequest request = GetZoneRequest.newBuilder().setName(name).build();
        return this.getZone(request);
    }

    public final Zone getZone(GetZoneRequest request) {
        return (Zone)this.getZoneCallable().call((Object)request);
    }

    public final UnaryCallable<GetZoneRequest, Zone> getZoneCallable() {
        return this.stub.getZoneCallable();
    }

    public final ListNetworksPagedResponse listNetworks(ZoneName parent) {
        ListNetworksRequest request = ListNetworksRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNetworks(request);
    }

    public final ListNetworksPagedResponse listNetworks(String parent) {
        ListNetworksRequest request = ListNetworksRequest.newBuilder().setParent(parent).build();
        return this.listNetworks(request);
    }

    public final ListNetworksPagedResponse listNetworks(ListNetworksRequest request) {
        return (ListNetworksPagedResponse)((Object)this.listNetworksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNetworksRequest, ListNetworksPagedResponse> listNetworksPagedCallable() {
        return this.stub.listNetworksPagedCallable();
    }

    public final UnaryCallable<ListNetworksRequest, ListNetworksResponse> listNetworksCallable() {
        return this.stub.listNetworksCallable();
    }

    public final Network getNetwork(NetworkName name) {
        GetNetworkRequest request = GetNetworkRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNetwork(request);
    }

    public final Network getNetwork(String name) {
        GetNetworkRequest request = GetNetworkRequest.newBuilder().setName(name).build();
        return this.getNetwork(request);
    }

    public final Network getNetwork(GetNetworkRequest request) {
        return (Network)this.getNetworkCallable().call((Object)request);
    }

    public final UnaryCallable<GetNetworkRequest, Network> getNetworkCallable() {
        return this.stub.getNetworkCallable();
    }

    public final DiagnoseNetworkResponse diagnoseNetwork(NetworkName name) {
        DiagnoseNetworkRequest request = DiagnoseNetworkRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.diagnoseNetwork(request);
    }

    public final DiagnoseNetworkResponse diagnoseNetwork(String name) {
        DiagnoseNetworkRequest request = DiagnoseNetworkRequest.newBuilder().setName(name).build();
        return this.diagnoseNetwork(request);
    }

    public final DiagnoseNetworkResponse diagnoseNetwork(DiagnoseNetworkRequest request) {
        return (DiagnoseNetworkResponse)this.diagnoseNetworkCallable().call((Object)request);
    }

    public final UnaryCallable<DiagnoseNetworkRequest, DiagnoseNetworkResponse> diagnoseNetworkCallable() {
        return this.stub.diagnoseNetworkCallable();
    }

    public final OperationFuture<Network, OperationMetadata> createNetworkAsync(ZoneName parent, Network network, String networkId) {
        CreateNetworkRequest request = CreateNetworkRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setNetwork(network).setNetworkId(networkId).build();
        return this.createNetworkAsync(request);
    }

    public final OperationFuture<Network, OperationMetadata> createNetworkAsync(String parent, Network network, String networkId) {
        CreateNetworkRequest request = CreateNetworkRequest.newBuilder().setParent(parent).setNetwork(network).setNetworkId(networkId).build();
        return this.createNetworkAsync(request);
    }

    public final OperationFuture<Network, OperationMetadata> createNetworkAsync(CreateNetworkRequest request) {
        return this.createNetworkOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateNetworkRequest, Network, OperationMetadata> createNetworkOperationCallable() {
        return this.stub.createNetworkOperationCallable();
    }

    public final UnaryCallable<CreateNetworkRequest, Operation> createNetworkCallable() {
        return this.stub.createNetworkCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteNetworkAsync(NetworkName name) {
        DeleteNetworkRequest request = DeleteNetworkRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteNetworkAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteNetworkAsync(String name) {
        DeleteNetworkRequest request = DeleteNetworkRequest.newBuilder().setName(name).build();
        return this.deleteNetworkAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteNetworkAsync(DeleteNetworkRequest request) {
        return this.deleteNetworkOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteNetworkRequest, Empty, OperationMetadata> deleteNetworkOperationCallable() {
        return this.stub.deleteNetworkOperationCallable();
    }

    public final UnaryCallable<DeleteNetworkRequest, Operation> deleteNetworkCallable() {
        return this.stub.deleteNetworkCallable();
    }

    public final ListSubnetsPagedResponse listSubnets(ZoneName parent) {
        ListSubnetsRequest request = ListSubnetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSubnets(request);
    }

    public final ListSubnetsPagedResponse listSubnets(String parent) {
        ListSubnetsRequest request = ListSubnetsRequest.newBuilder().setParent(parent).build();
        return this.listSubnets(request);
    }

    public final ListSubnetsPagedResponse listSubnets(ListSubnetsRequest request) {
        return (ListSubnetsPagedResponse)((Object)this.listSubnetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSubnetsRequest, ListSubnetsPagedResponse> listSubnetsPagedCallable() {
        return this.stub.listSubnetsPagedCallable();
    }

    public final UnaryCallable<ListSubnetsRequest, ListSubnetsResponse> listSubnetsCallable() {
        return this.stub.listSubnetsCallable();
    }

    public final Subnet getSubnet(SubnetName name) {
        GetSubnetRequest request = GetSubnetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSubnet(request);
    }

    public final Subnet getSubnet(String name) {
        GetSubnetRequest request = GetSubnetRequest.newBuilder().setName(name).build();
        return this.getSubnet(request);
    }

    public final Subnet getSubnet(GetSubnetRequest request) {
        return (Subnet)this.getSubnetCallable().call((Object)request);
    }

    public final UnaryCallable<GetSubnetRequest, Subnet> getSubnetCallable() {
        return this.stub.getSubnetCallable();
    }

    public final OperationFuture<Subnet, OperationMetadata> createSubnetAsync(ZoneName parent, Subnet subnet, String subnetId) {
        CreateSubnetRequest request = CreateSubnetRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSubnet(subnet).setSubnetId(subnetId).build();
        return this.createSubnetAsync(request);
    }

    public final OperationFuture<Subnet, OperationMetadata> createSubnetAsync(String parent, Subnet subnet, String subnetId) {
        CreateSubnetRequest request = CreateSubnetRequest.newBuilder().setParent(parent).setSubnet(subnet).setSubnetId(subnetId).build();
        return this.createSubnetAsync(request);
    }

    public final OperationFuture<Subnet, OperationMetadata> createSubnetAsync(CreateSubnetRequest request) {
        return this.createSubnetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateSubnetRequest, Subnet, OperationMetadata> createSubnetOperationCallable() {
        return this.stub.createSubnetOperationCallable();
    }

    public final UnaryCallable<CreateSubnetRequest, Operation> createSubnetCallable() {
        return this.stub.createSubnetCallable();
    }

    public final OperationFuture<Subnet, OperationMetadata> updateSubnetAsync(Subnet subnet, FieldMask updateMask) {
        UpdateSubnetRequest request = UpdateSubnetRequest.newBuilder().setSubnet(subnet).setUpdateMask(updateMask).build();
        return this.updateSubnetAsync(request);
    }

    public final OperationFuture<Subnet, OperationMetadata> updateSubnetAsync(UpdateSubnetRequest request) {
        return this.updateSubnetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateSubnetRequest, Subnet, OperationMetadata> updateSubnetOperationCallable() {
        return this.stub.updateSubnetOperationCallable();
    }

    public final UnaryCallable<UpdateSubnetRequest, Operation> updateSubnetCallable() {
        return this.stub.updateSubnetCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSubnetAsync(SubnetName name) {
        DeleteSubnetRequest request = DeleteSubnetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteSubnetAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSubnetAsync(String name) {
        DeleteSubnetRequest request = DeleteSubnetRequest.newBuilder().setName(name).build();
        return this.deleteSubnetAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSubnetAsync(DeleteSubnetRequest request) {
        return this.deleteSubnetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteSubnetRequest, Empty, OperationMetadata> deleteSubnetOperationCallable() {
        return this.stub.deleteSubnetOperationCallable();
    }

    public final UnaryCallable<DeleteSubnetRequest, Operation> deleteSubnetCallable() {
        return this.stub.deleteSubnetCallable();
    }

    public final ListInterconnectsPagedResponse listInterconnects(ZoneName parent) {
        ListInterconnectsRequest request = ListInterconnectsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInterconnects(request);
    }

    public final ListInterconnectsPagedResponse listInterconnects(String parent) {
        ListInterconnectsRequest request = ListInterconnectsRequest.newBuilder().setParent(parent).build();
        return this.listInterconnects(request);
    }

    public final ListInterconnectsPagedResponse listInterconnects(ListInterconnectsRequest request) {
        return (ListInterconnectsPagedResponse)((Object)this.listInterconnectsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInterconnectsRequest, ListInterconnectsPagedResponse> listInterconnectsPagedCallable() {
        return this.stub.listInterconnectsPagedCallable();
    }

    public final UnaryCallable<ListInterconnectsRequest, ListInterconnectsResponse> listInterconnectsCallable() {
        return this.stub.listInterconnectsCallable();
    }

    public final Interconnect getInterconnect(InterconnectName name) {
        GetInterconnectRequest request = GetInterconnectRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInterconnect(request);
    }

    public final Interconnect getInterconnect(String name) {
        GetInterconnectRequest request = GetInterconnectRequest.newBuilder().setName(name).build();
        return this.getInterconnect(request);
    }

    public final Interconnect getInterconnect(GetInterconnectRequest request) {
        return (Interconnect)this.getInterconnectCallable().call((Object)request);
    }

    public final UnaryCallable<GetInterconnectRequest, Interconnect> getInterconnectCallable() {
        return this.stub.getInterconnectCallable();
    }

    public final DiagnoseInterconnectResponse diagnoseInterconnect(InterconnectName name) {
        DiagnoseInterconnectRequest request = DiagnoseInterconnectRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.diagnoseInterconnect(request);
    }

    public final DiagnoseInterconnectResponse diagnoseInterconnect(String name) {
        DiagnoseInterconnectRequest request = DiagnoseInterconnectRequest.newBuilder().setName(name).build();
        return this.diagnoseInterconnect(request);
    }

    public final DiagnoseInterconnectResponse diagnoseInterconnect(DiagnoseInterconnectRequest request) {
        return (DiagnoseInterconnectResponse)this.diagnoseInterconnectCallable().call((Object)request);
    }

    public final UnaryCallable<DiagnoseInterconnectRequest, DiagnoseInterconnectResponse> diagnoseInterconnectCallable() {
        return this.stub.diagnoseInterconnectCallable();
    }

    public final ListInterconnectAttachmentsPagedResponse listInterconnectAttachments(ZoneName parent) {
        ListInterconnectAttachmentsRequest request = ListInterconnectAttachmentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInterconnectAttachments(request);
    }

    public final ListInterconnectAttachmentsPagedResponse listInterconnectAttachments(String parent) {
        ListInterconnectAttachmentsRequest request = ListInterconnectAttachmentsRequest.newBuilder().setParent(parent).build();
        return this.listInterconnectAttachments(request);
    }

    public final ListInterconnectAttachmentsPagedResponse listInterconnectAttachments(ListInterconnectAttachmentsRequest request) {
        return (ListInterconnectAttachmentsPagedResponse)((Object)this.listInterconnectAttachmentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInterconnectAttachmentsRequest, ListInterconnectAttachmentsPagedResponse> listInterconnectAttachmentsPagedCallable() {
        return this.stub.listInterconnectAttachmentsPagedCallable();
    }

    public final UnaryCallable<ListInterconnectAttachmentsRequest, ListInterconnectAttachmentsResponse> listInterconnectAttachmentsCallable() {
        return this.stub.listInterconnectAttachmentsCallable();
    }

    public final InterconnectAttachment getInterconnectAttachment(InterconnectAttachmentName name) {
        GetInterconnectAttachmentRequest request = GetInterconnectAttachmentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInterconnectAttachment(request);
    }

    public final InterconnectAttachment getInterconnectAttachment(String name) {
        GetInterconnectAttachmentRequest request = GetInterconnectAttachmentRequest.newBuilder().setName(name).build();
        return this.getInterconnectAttachment(request);
    }

    public final InterconnectAttachment getInterconnectAttachment(GetInterconnectAttachmentRequest request) {
        return (InterconnectAttachment)this.getInterconnectAttachmentCallable().call((Object)request);
    }

    public final UnaryCallable<GetInterconnectAttachmentRequest, InterconnectAttachment> getInterconnectAttachmentCallable() {
        return this.stub.getInterconnectAttachmentCallable();
    }

    public final OperationFuture<InterconnectAttachment, OperationMetadata> createInterconnectAttachmentAsync(ZoneName parent, InterconnectAttachment interconnectAttachment, String interconnectAttachmentId) {
        CreateInterconnectAttachmentRequest request = CreateInterconnectAttachmentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setInterconnectAttachment(interconnectAttachment).setInterconnectAttachmentId(interconnectAttachmentId).build();
        return this.createInterconnectAttachmentAsync(request);
    }

    public final OperationFuture<InterconnectAttachment, OperationMetadata> createInterconnectAttachmentAsync(String parent, InterconnectAttachment interconnectAttachment, String interconnectAttachmentId) {
        CreateInterconnectAttachmentRequest request = CreateInterconnectAttachmentRequest.newBuilder().setParent(parent).setInterconnectAttachment(interconnectAttachment).setInterconnectAttachmentId(interconnectAttachmentId).build();
        return this.createInterconnectAttachmentAsync(request);
    }

    public final OperationFuture<InterconnectAttachment, OperationMetadata> createInterconnectAttachmentAsync(CreateInterconnectAttachmentRequest request) {
        return this.createInterconnectAttachmentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateInterconnectAttachmentRequest, InterconnectAttachment, OperationMetadata> createInterconnectAttachmentOperationCallable() {
        return this.stub.createInterconnectAttachmentOperationCallable();
    }

    public final UnaryCallable<CreateInterconnectAttachmentRequest, Operation> createInterconnectAttachmentCallable() {
        return this.stub.createInterconnectAttachmentCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInterconnectAttachmentAsync(InterconnectAttachmentName name) {
        DeleteInterconnectAttachmentRequest request = DeleteInterconnectAttachmentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteInterconnectAttachmentAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInterconnectAttachmentAsync(String name) {
        DeleteInterconnectAttachmentRequest request = DeleteInterconnectAttachmentRequest.newBuilder().setName(name).build();
        return this.deleteInterconnectAttachmentAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInterconnectAttachmentAsync(DeleteInterconnectAttachmentRequest request) {
        return this.deleteInterconnectAttachmentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteInterconnectAttachmentRequest, Empty, OperationMetadata> deleteInterconnectAttachmentOperationCallable() {
        return this.stub.deleteInterconnectAttachmentOperationCallable();
    }

    public final UnaryCallable<DeleteInterconnectAttachmentRequest, Operation> deleteInterconnectAttachmentCallable() {
        return this.stub.deleteInterconnectAttachmentCallable();
    }

    public final ListRoutersPagedResponse listRouters(ZoneName parent) {
        ListRoutersRequest request = ListRoutersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRouters(request);
    }

    public final ListRoutersPagedResponse listRouters(String parent) {
        ListRoutersRequest request = ListRoutersRequest.newBuilder().setParent(parent).build();
        return this.listRouters(request);
    }

    public final ListRoutersPagedResponse listRouters(ListRoutersRequest request) {
        return (ListRoutersPagedResponse)((Object)this.listRoutersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRoutersRequest, ListRoutersPagedResponse> listRoutersPagedCallable() {
        return this.stub.listRoutersPagedCallable();
    }

    public final UnaryCallable<ListRoutersRequest, ListRoutersResponse> listRoutersCallable() {
        return this.stub.listRoutersCallable();
    }

    public final Router getRouter(RouterName name) {
        GetRouterRequest request = GetRouterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRouter(request);
    }

    public final Router getRouter(String name) {
        GetRouterRequest request = GetRouterRequest.newBuilder().setName(name).build();
        return this.getRouter(request);
    }

    public final Router getRouter(GetRouterRequest request) {
        return (Router)this.getRouterCallable().call((Object)request);
    }

    public final UnaryCallable<GetRouterRequest, Router> getRouterCallable() {
        return this.stub.getRouterCallable();
    }

    public final DiagnoseRouterResponse diagnoseRouter(RouterName name) {
        DiagnoseRouterRequest request = DiagnoseRouterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.diagnoseRouter(request);
    }

    public final DiagnoseRouterResponse diagnoseRouter(String name) {
        DiagnoseRouterRequest request = DiagnoseRouterRequest.newBuilder().setName(name).build();
        return this.diagnoseRouter(request);
    }

    public final DiagnoseRouterResponse diagnoseRouter(DiagnoseRouterRequest request) {
        return (DiagnoseRouterResponse)this.diagnoseRouterCallable().call((Object)request);
    }

    public final UnaryCallable<DiagnoseRouterRequest, DiagnoseRouterResponse> diagnoseRouterCallable() {
        return this.stub.diagnoseRouterCallable();
    }

    public final OperationFuture<Router, OperationMetadata> createRouterAsync(ZoneName parent, Router router, String routerId) {
        CreateRouterRequest request = CreateRouterRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRouter(router).setRouterId(routerId).build();
        return this.createRouterAsync(request);
    }

    public final OperationFuture<Router, OperationMetadata> createRouterAsync(String parent, Router router, String routerId) {
        CreateRouterRequest request = CreateRouterRequest.newBuilder().setParent(parent).setRouter(router).setRouterId(routerId).build();
        return this.createRouterAsync(request);
    }

    public final OperationFuture<Router, OperationMetadata> createRouterAsync(CreateRouterRequest request) {
        return this.createRouterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateRouterRequest, Router, OperationMetadata> createRouterOperationCallable() {
        return this.stub.createRouterOperationCallable();
    }

    public final UnaryCallable<CreateRouterRequest, Operation> createRouterCallable() {
        return this.stub.createRouterCallable();
    }

    public final OperationFuture<Router, OperationMetadata> updateRouterAsync(Router router, FieldMask updateMask) {
        UpdateRouterRequest request = UpdateRouterRequest.newBuilder().setRouter(router).setUpdateMask(updateMask).build();
        return this.updateRouterAsync(request);
    }

    public final OperationFuture<Router, OperationMetadata> updateRouterAsync(UpdateRouterRequest request) {
        return this.updateRouterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateRouterRequest, Router, OperationMetadata> updateRouterOperationCallable() {
        return this.stub.updateRouterOperationCallable();
    }

    public final UnaryCallable<UpdateRouterRequest, Operation> updateRouterCallable() {
        return this.stub.updateRouterCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRouterAsync(RouterName name) {
        DeleteRouterRequest request = DeleteRouterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteRouterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRouterAsync(String name) {
        DeleteRouterRequest request = DeleteRouterRequest.newBuilder().setName(name).build();
        return this.deleteRouterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRouterAsync(DeleteRouterRequest request) {
        return this.deleteRouterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRouterRequest, Empty, OperationMetadata> deleteRouterOperationCallable() {
        return this.stub.deleteRouterOperationCallable();
    }

    public final UnaryCallable<DeleteRouterRequest, Operation> deleteRouterCallable() {
        return this.stub.deleteRouterCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRoutersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRoutersRequest, ListRoutersResponse, Router, ListRoutersPage, ListRoutersFixedSizeCollection> {
        private ListRoutersFixedSizeCollection(List<ListRoutersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRoutersFixedSizeCollection createEmptyCollection() {
            return new ListRoutersFixedSizeCollection(null, 0);
        }

        protected ListRoutersFixedSizeCollection createCollection(List<ListRoutersPage> pages, int collectionSize) {
            return new ListRoutersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRoutersPage
    extends AbstractPage<ListRoutersRequest, ListRoutersResponse, Router, ListRoutersPage> {
        private ListRoutersPage(PageContext<ListRoutersRequest, ListRoutersResponse, Router> context, ListRoutersResponse response) {
            super(context, (Object)response);
        }

        private static ListRoutersPage createEmptyPage() {
            return new ListRoutersPage(null, null);
        }

        protected ListRoutersPage createPage(PageContext<ListRoutersRequest, ListRoutersResponse, Router> context, ListRoutersResponse response) {
            return new ListRoutersPage(context, response);
        }

        public ApiFuture<ListRoutersPage> createPageAsync(PageContext<ListRoutersRequest, ListRoutersResponse, Router> context, ApiFuture<ListRoutersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRoutersPagedResponse
    extends AbstractPagedListResponse<ListRoutersRequest, ListRoutersResponse, Router, ListRoutersPage, ListRoutersFixedSizeCollection> {
        public static ApiFuture<ListRoutersPagedResponse> createAsync(PageContext<ListRoutersRequest, ListRoutersResponse, Router> context, ApiFuture<ListRoutersResponse> futureResponse) {
            ApiFuture<ListRoutersPage> futurePage = ListRoutersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRoutersPagedResponse((ListRoutersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRoutersPagedResponse(ListRoutersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRoutersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInterconnectAttachmentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInterconnectAttachmentsRequest, ListInterconnectAttachmentsResponse, InterconnectAttachment, ListInterconnectAttachmentsPage, ListInterconnectAttachmentsFixedSizeCollection> {
        private ListInterconnectAttachmentsFixedSizeCollection(List<ListInterconnectAttachmentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInterconnectAttachmentsFixedSizeCollection createEmptyCollection() {
            return new ListInterconnectAttachmentsFixedSizeCollection(null, 0);
        }

        protected ListInterconnectAttachmentsFixedSizeCollection createCollection(List<ListInterconnectAttachmentsPage> pages, int collectionSize) {
            return new ListInterconnectAttachmentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInterconnectAttachmentsPage
    extends AbstractPage<ListInterconnectAttachmentsRequest, ListInterconnectAttachmentsResponse, InterconnectAttachment, ListInterconnectAttachmentsPage> {
        private ListInterconnectAttachmentsPage(PageContext<ListInterconnectAttachmentsRequest, ListInterconnectAttachmentsResponse, InterconnectAttachment> context, ListInterconnectAttachmentsResponse response) {
            super(context, (Object)response);
        }

        private static ListInterconnectAttachmentsPage createEmptyPage() {
            return new ListInterconnectAttachmentsPage(null, null);
        }

        protected ListInterconnectAttachmentsPage createPage(PageContext<ListInterconnectAttachmentsRequest, ListInterconnectAttachmentsResponse, InterconnectAttachment> context, ListInterconnectAttachmentsResponse response) {
            return new ListInterconnectAttachmentsPage(context, response);
        }

        public ApiFuture<ListInterconnectAttachmentsPage> createPageAsync(PageContext<ListInterconnectAttachmentsRequest, ListInterconnectAttachmentsResponse, InterconnectAttachment> context, ApiFuture<ListInterconnectAttachmentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInterconnectAttachmentsPagedResponse
    extends AbstractPagedListResponse<ListInterconnectAttachmentsRequest, ListInterconnectAttachmentsResponse, InterconnectAttachment, ListInterconnectAttachmentsPage, ListInterconnectAttachmentsFixedSizeCollection> {
        public static ApiFuture<ListInterconnectAttachmentsPagedResponse> createAsync(PageContext<ListInterconnectAttachmentsRequest, ListInterconnectAttachmentsResponse, InterconnectAttachment> context, ApiFuture<ListInterconnectAttachmentsResponse> futureResponse) {
            ApiFuture<ListInterconnectAttachmentsPage> futurePage = ListInterconnectAttachmentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInterconnectAttachmentsPagedResponse((ListInterconnectAttachmentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInterconnectAttachmentsPagedResponse(ListInterconnectAttachmentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInterconnectAttachmentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInterconnectsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInterconnectsRequest, ListInterconnectsResponse, Interconnect, ListInterconnectsPage, ListInterconnectsFixedSizeCollection> {
        private ListInterconnectsFixedSizeCollection(List<ListInterconnectsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInterconnectsFixedSizeCollection createEmptyCollection() {
            return new ListInterconnectsFixedSizeCollection(null, 0);
        }

        protected ListInterconnectsFixedSizeCollection createCollection(List<ListInterconnectsPage> pages, int collectionSize) {
            return new ListInterconnectsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInterconnectsPage
    extends AbstractPage<ListInterconnectsRequest, ListInterconnectsResponse, Interconnect, ListInterconnectsPage> {
        private ListInterconnectsPage(PageContext<ListInterconnectsRequest, ListInterconnectsResponse, Interconnect> context, ListInterconnectsResponse response) {
            super(context, (Object)response);
        }

        private static ListInterconnectsPage createEmptyPage() {
            return new ListInterconnectsPage(null, null);
        }

        protected ListInterconnectsPage createPage(PageContext<ListInterconnectsRequest, ListInterconnectsResponse, Interconnect> context, ListInterconnectsResponse response) {
            return new ListInterconnectsPage(context, response);
        }

        public ApiFuture<ListInterconnectsPage> createPageAsync(PageContext<ListInterconnectsRequest, ListInterconnectsResponse, Interconnect> context, ApiFuture<ListInterconnectsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInterconnectsPagedResponse
    extends AbstractPagedListResponse<ListInterconnectsRequest, ListInterconnectsResponse, Interconnect, ListInterconnectsPage, ListInterconnectsFixedSizeCollection> {
        public static ApiFuture<ListInterconnectsPagedResponse> createAsync(PageContext<ListInterconnectsRequest, ListInterconnectsResponse, Interconnect> context, ApiFuture<ListInterconnectsResponse> futureResponse) {
            ApiFuture<ListInterconnectsPage> futurePage = ListInterconnectsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInterconnectsPagedResponse((ListInterconnectsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInterconnectsPagedResponse(ListInterconnectsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInterconnectsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSubnetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSubnetsRequest, ListSubnetsResponse, Subnet, ListSubnetsPage, ListSubnetsFixedSizeCollection> {
        private ListSubnetsFixedSizeCollection(List<ListSubnetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSubnetsFixedSizeCollection createEmptyCollection() {
            return new ListSubnetsFixedSizeCollection(null, 0);
        }

        protected ListSubnetsFixedSizeCollection createCollection(List<ListSubnetsPage> pages, int collectionSize) {
            return new ListSubnetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSubnetsPage
    extends AbstractPage<ListSubnetsRequest, ListSubnetsResponse, Subnet, ListSubnetsPage> {
        private ListSubnetsPage(PageContext<ListSubnetsRequest, ListSubnetsResponse, Subnet> context, ListSubnetsResponse response) {
            super(context, (Object)response);
        }

        private static ListSubnetsPage createEmptyPage() {
            return new ListSubnetsPage(null, null);
        }

        protected ListSubnetsPage createPage(PageContext<ListSubnetsRequest, ListSubnetsResponse, Subnet> context, ListSubnetsResponse response) {
            return new ListSubnetsPage(context, response);
        }

        public ApiFuture<ListSubnetsPage> createPageAsync(PageContext<ListSubnetsRequest, ListSubnetsResponse, Subnet> context, ApiFuture<ListSubnetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSubnetsPagedResponse
    extends AbstractPagedListResponse<ListSubnetsRequest, ListSubnetsResponse, Subnet, ListSubnetsPage, ListSubnetsFixedSizeCollection> {
        public static ApiFuture<ListSubnetsPagedResponse> createAsync(PageContext<ListSubnetsRequest, ListSubnetsResponse, Subnet> context, ApiFuture<ListSubnetsResponse> futureResponse) {
            ApiFuture<ListSubnetsPage> futurePage = ListSubnetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSubnetsPagedResponse((ListSubnetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSubnetsPagedResponse(ListSubnetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSubnetsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNetworksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNetworksRequest, ListNetworksResponse, Network, ListNetworksPage, ListNetworksFixedSizeCollection> {
        private ListNetworksFixedSizeCollection(List<ListNetworksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNetworksFixedSizeCollection createEmptyCollection() {
            return new ListNetworksFixedSizeCollection(null, 0);
        }

        protected ListNetworksFixedSizeCollection createCollection(List<ListNetworksPage> pages, int collectionSize) {
            return new ListNetworksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNetworksPage
    extends AbstractPage<ListNetworksRequest, ListNetworksResponse, Network, ListNetworksPage> {
        private ListNetworksPage(PageContext<ListNetworksRequest, ListNetworksResponse, Network> context, ListNetworksResponse response) {
            super(context, (Object)response);
        }

        private static ListNetworksPage createEmptyPage() {
            return new ListNetworksPage(null, null);
        }

        protected ListNetworksPage createPage(PageContext<ListNetworksRequest, ListNetworksResponse, Network> context, ListNetworksResponse response) {
            return new ListNetworksPage(context, response);
        }

        public ApiFuture<ListNetworksPage> createPageAsync(PageContext<ListNetworksRequest, ListNetworksResponse, Network> context, ApiFuture<ListNetworksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNetworksPagedResponse
    extends AbstractPagedListResponse<ListNetworksRequest, ListNetworksResponse, Network, ListNetworksPage, ListNetworksFixedSizeCollection> {
        public static ApiFuture<ListNetworksPagedResponse> createAsync(PageContext<ListNetworksRequest, ListNetworksResponse, Network> context, ApiFuture<ListNetworksResponse> futureResponse) {
            ApiFuture<ListNetworksPage> futurePage = ListNetworksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNetworksPagedResponse((ListNetworksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListNetworksPagedResponse(ListNetworksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNetworksFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListZonesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListZonesRequest, ListZonesResponse, Zone, ListZonesPage, ListZonesFixedSizeCollection> {
        private ListZonesFixedSizeCollection(List<ListZonesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListZonesFixedSizeCollection createEmptyCollection() {
            return new ListZonesFixedSizeCollection(null, 0);
        }

        protected ListZonesFixedSizeCollection createCollection(List<ListZonesPage> pages, int collectionSize) {
            return new ListZonesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListZonesPage
    extends AbstractPage<ListZonesRequest, ListZonesResponse, Zone, ListZonesPage> {
        private ListZonesPage(PageContext<ListZonesRequest, ListZonesResponse, Zone> context, ListZonesResponse response) {
            super(context, (Object)response);
        }

        private static ListZonesPage createEmptyPage() {
            return new ListZonesPage(null, null);
        }

        protected ListZonesPage createPage(PageContext<ListZonesRequest, ListZonesResponse, Zone> context, ListZonesResponse response) {
            return new ListZonesPage(context, response);
        }

        public ApiFuture<ListZonesPage> createPageAsync(PageContext<ListZonesRequest, ListZonesResponse, Zone> context, ApiFuture<ListZonesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListZonesPagedResponse
    extends AbstractPagedListResponse<ListZonesRequest, ListZonesResponse, Zone, ListZonesPage, ListZonesFixedSizeCollection> {
        public static ApiFuture<ListZonesPagedResponse> createAsync(PageContext<ListZonesRequest, ListZonesResponse, Zone> context, ApiFuture<ListZonesResponse> futureResponse) {
            ApiFuture<ListZonesPage> futurePage = ListZonesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListZonesPagedResponse((ListZonesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListZonesPagedResponse(ListZonesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListZonesFixedSizeCollection.createEmptyCollection());
        }
    }
}

