/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.domains.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.domains.v1.AuthorizationCode;
import com.google.cloud.domains.v1.ConfigureContactSettingsRequest;
import com.google.cloud.domains.v1.ConfigureDnsSettingsRequest;
import com.google.cloud.domains.v1.ConfigureManagementSettingsRequest;
import com.google.cloud.domains.v1.DeleteRegistrationRequest;
import com.google.cloud.domains.v1.DomainsClient;
import com.google.cloud.domains.v1.ExportRegistrationRequest;
import com.google.cloud.domains.v1.GetRegistrationRequest;
import com.google.cloud.domains.v1.ListRegistrationsRequest;
import com.google.cloud.domains.v1.ListRegistrationsResponse;
import com.google.cloud.domains.v1.OperationMetadata;
import com.google.cloud.domains.v1.RegisterDomainRequest;
import com.google.cloud.domains.v1.Registration;
import com.google.cloud.domains.v1.ResetAuthorizationCodeRequest;
import com.google.cloud.domains.v1.RetrieveAuthorizationCodeRequest;
import com.google.cloud.domains.v1.RetrieveRegisterParametersRequest;
import com.google.cloud.domains.v1.RetrieveRegisterParametersResponse;
import com.google.cloud.domains.v1.RetrieveTransferParametersRequest;
import com.google.cloud.domains.v1.RetrieveTransferParametersResponse;
import com.google.cloud.domains.v1.SearchDomainsRequest;
import com.google.cloud.domains.v1.SearchDomainsResponse;
import com.google.cloud.domains.v1.TransferDomainRequest;
import com.google.cloud.domains.v1.UpdateRegistrationRequest;
import com.google.cloud.domains.v1.stub.DomainsStub;
import com.google.cloud.domains.v1.stub.DomainsStubSettings;
import com.google.cloud.domains.v1.stub.HttpJsonDomainsCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpJsonDomainsStub
extends DomainsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(OperationMetadata.getDescriptor()).add(Empty.getDescriptor()).add(Registration.getDescriptor()).build();
    private static final ApiMethodDescriptor<SearchDomainsRequest, SearchDomainsResponse> searchDomainsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.domains.v1.Domains/SearchDomains").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{location=projects/*/locations/*}/registrations:searchDomains", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "location", (Object)request.getLocation());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "query", (Object)request.getQuery());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SearchDomainsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<RetrieveRegisterParametersRequest, RetrieveRegisterParametersResponse> retrieveRegisterParametersMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.domains.v1.Domains/RetrieveRegisterParameters").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{location=projects/*/locations/*}/registrations:retrieveRegisterParameters", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "location", (Object)request.getLocation());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "domainName", (Object)request.getDomainName());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)RetrieveRegisterParametersResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<RegisterDomainRequest, Operation> registerDomainMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.domains.v1.Domains/RegisterDomain").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/registrations:register", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<RetrieveTransferParametersRequest, RetrieveTransferParametersResponse> retrieveTransferParametersMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.domains.v1.Domains/RetrieveTransferParameters").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{location=projects/*/locations/*}/registrations:retrieveTransferParameters", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "location", (Object)request.getLocation());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "domainName", (Object)request.getDomainName());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)RetrieveTransferParametersResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<TransferDomainRequest, Operation> transferDomainMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.domains.v1.Domains/TransferDomain").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/registrations:transfer", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListRegistrationsRequest, ListRegistrationsResponse> listRegistrationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.domains.v1.Domains/ListRegistrations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/registrations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListRegistrationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetRegistrationRequest, Registration> getRegistrationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.domains.v1.Domains/GetRegistration").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/registrations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Registration.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateRegistrationRequest, Operation> updateRegistrationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.domains.v1.Domains/UpdateRegistration").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{registration.name=projects/*/locations/*/registrations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "registration.name", (Object)request.getRegistration().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("registration", (Message)request.getRegistration(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ConfigureManagementSettingsRequest, Operation> configureManagementSettingsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.domains.v1.Domains/ConfigureManagementSettings").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{registration=projects/*/locations/*/registrations/*}:configureManagementSettings", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "registration", (Object)request.getRegistration());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearRegistration().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ConfigureDnsSettingsRequest, Operation> configureDnsSettingsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.domains.v1.Domains/ConfigureDnsSettings").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{registration=projects/*/locations/*/registrations/*}:configureDnsSettings", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "registration", (Object)request.getRegistration());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearRegistration().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ConfigureContactSettingsRequest, Operation> configureContactSettingsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.domains.v1.Domains/ConfigureContactSettings").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{registration=projects/*/locations/*/registrations/*}:configureContactSettings", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "registration", (Object)request.getRegistration());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearRegistration().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ExportRegistrationRequest, Operation> exportRegistrationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.domains.v1.Domains/ExportRegistration").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/registrations/*}:export", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteRegistrationRequest, Operation> deleteRegistrationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.domains.v1.Domains/DeleteRegistration").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/registrations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<RetrieveAuthorizationCodeRequest, AuthorizationCode> retrieveAuthorizationCodeMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.domains.v1.Domains/RetrieveAuthorizationCode").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{registration=projects/*/locations/*/registrations/*}:retrieveAuthorizationCode", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "registration", (Object)request.getRegistration());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)AuthorizationCode.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ResetAuthorizationCodeRequest, AuthorizationCode> resetAuthorizationCodeMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.domains.v1.Domains/ResetAuthorizationCode").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{registration=projects/*/locations/*/registrations/*}:resetAuthorizationCode", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "registration", (Object)request.getRegistration());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearRegistration().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)AuthorizationCode.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<SearchDomainsRequest, SearchDomainsResponse> searchDomainsCallable;
    private final UnaryCallable<RetrieveRegisterParametersRequest, RetrieveRegisterParametersResponse> retrieveRegisterParametersCallable;
    private final UnaryCallable<RegisterDomainRequest, Operation> registerDomainCallable;
    private final OperationCallable<RegisterDomainRequest, Registration, OperationMetadata> registerDomainOperationCallable;
    private final UnaryCallable<RetrieveTransferParametersRequest, RetrieveTransferParametersResponse> retrieveTransferParametersCallable;
    private final UnaryCallable<TransferDomainRequest, Operation> transferDomainCallable;
    private final OperationCallable<TransferDomainRequest, Registration, OperationMetadata> transferDomainOperationCallable;
    private final UnaryCallable<ListRegistrationsRequest, ListRegistrationsResponse> listRegistrationsCallable;
    private final UnaryCallable<ListRegistrationsRequest, DomainsClient.ListRegistrationsPagedResponse> listRegistrationsPagedCallable;
    private final UnaryCallable<GetRegistrationRequest, Registration> getRegistrationCallable;
    private final UnaryCallable<UpdateRegistrationRequest, Operation> updateRegistrationCallable;
    private final OperationCallable<UpdateRegistrationRequest, Registration, OperationMetadata> updateRegistrationOperationCallable;
    private final UnaryCallable<ConfigureManagementSettingsRequest, Operation> configureManagementSettingsCallable;
    private final OperationCallable<ConfigureManagementSettingsRequest, Registration, OperationMetadata> configureManagementSettingsOperationCallable;
    private final UnaryCallable<ConfigureDnsSettingsRequest, Operation> configureDnsSettingsCallable;
    private final OperationCallable<ConfigureDnsSettingsRequest, Registration, OperationMetadata> configureDnsSettingsOperationCallable;
    private final UnaryCallable<ConfigureContactSettingsRequest, Operation> configureContactSettingsCallable;
    private final OperationCallable<ConfigureContactSettingsRequest, Registration, OperationMetadata> configureContactSettingsOperationCallable;
    private final UnaryCallable<ExportRegistrationRequest, Operation> exportRegistrationCallable;
    private final OperationCallable<ExportRegistrationRequest, Registration, OperationMetadata> exportRegistrationOperationCallable;
    private final UnaryCallable<DeleteRegistrationRequest, Operation> deleteRegistrationCallable;
    private final OperationCallable<DeleteRegistrationRequest, Empty, OperationMetadata> deleteRegistrationOperationCallable;
    private final UnaryCallable<RetrieveAuthorizationCodeRequest, AuthorizationCode> retrieveAuthorizationCodeCallable;
    private final UnaryCallable<ResetAuthorizationCodeRequest, AuthorizationCode> resetAuthorizationCodeCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonDomainsStub create(DomainsStubSettings settings) throws IOException {
        return new HttpJsonDomainsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonDomainsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonDomainsStub(DomainsStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonDomainsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonDomainsStub(DomainsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonDomainsStub(DomainsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonDomainsCallableFactory());
    }

    protected HttpJsonDomainsStub(DomainsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*}/operations").build()).build());
        HttpJsonCallSettings searchDomainsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(searchDomainsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("location", String.valueOf(request.getLocation()));
            return builder.build();
        }).build();
        HttpJsonCallSettings retrieveRegisterParametersTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(retrieveRegisterParametersMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("location", String.valueOf(request.getLocation()));
            return builder.build();
        }).build();
        HttpJsonCallSettings registerDomainTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(registerDomainMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings retrieveTransferParametersTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(retrieveTransferParametersMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("location", String.valueOf(request.getLocation()));
            return builder.build();
        }).build();
        HttpJsonCallSettings transferDomainTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(transferDomainMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listRegistrationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listRegistrationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getRegistrationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getRegistrationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateRegistrationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateRegistrationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("registration.name", String.valueOf(request.getRegistration().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings configureManagementSettingsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(configureManagementSettingsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("registration", String.valueOf(request.getRegistration()));
            return builder.build();
        }).build();
        HttpJsonCallSettings configureDnsSettingsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(configureDnsSettingsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("registration", String.valueOf(request.getRegistration()));
            return builder.build();
        }).build();
        HttpJsonCallSettings configureContactSettingsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(configureContactSettingsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("registration", String.valueOf(request.getRegistration()));
            return builder.build();
        }).build();
        HttpJsonCallSettings exportRegistrationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(exportRegistrationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteRegistrationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteRegistrationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings retrieveAuthorizationCodeTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(retrieveAuthorizationCodeMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("registration", String.valueOf(request.getRegistration()));
            return builder.build();
        }).build();
        HttpJsonCallSettings resetAuthorizationCodeTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(resetAuthorizationCodeMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("registration", String.valueOf(request.getRegistration()));
            return builder.build();
        }).build();
        this.searchDomainsCallable = callableFactory.createUnaryCallable(searchDomainsTransportSettings, settings.searchDomainsSettings(), clientContext);
        this.retrieveRegisterParametersCallable = callableFactory.createUnaryCallable(retrieveRegisterParametersTransportSettings, settings.retrieveRegisterParametersSettings(), clientContext);
        this.registerDomainCallable = callableFactory.createUnaryCallable(registerDomainTransportSettings, settings.registerDomainSettings(), clientContext);
        this.registerDomainOperationCallable = callableFactory.createOperationCallable(registerDomainTransportSettings, settings.registerDomainOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.retrieveTransferParametersCallable = callableFactory.createUnaryCallable(retrieveTransferParametersTransportSettings, settings.retrieveTransferParametersSettings(), clientContext);
        this.transferDomainCallable = callableFactory.createUnaryCallable(transferDomainTransportSettings, settings.transferDomainSettings(), clientContext);
        this.transferDomainOperationCallable = callableFactory.createOperationCallable(transferDomainTransportSettings, settings.transferDomainOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listRegistrationsCallable = callableFactory.createUnaryCallable(listRegistrationsTransportSettings, settings.listRegistrationsSettings(), clientContext);
        this.listRegistrationsPagedCallable = callableFactory.createPagedCallable(listRegistrationsTransportSettings, settings.listRegistrationsSettings(), clientContext);
        this.getRegistrationCallable = callableFactory.createUnaryCallable(getRegistrationTransportSettings, settings.getRegistrationSettings(), clientContext);
        this.updateRegistrationCallable = callableFactory.createUnaryCallable(updateRegistrationTransportSettings, settings.updateRegistrationSettings(), clientContext);
        this.updateRegistrationOperationCallable = callableFactory.createOperationCallable(updateRegistrationTransportSettings, settings.updateRegistrationOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.configureManagementSettingsCallable = callableFactory.createUnaryCallable(configureManagementSettingsTransportSettings, settings.configureManagementSettingsSettings(), clientContext);
        this.configureManagementSettingsOperationCallable = callableFactory.createOperationCallable(configureManagementSettingsTransportSettings, settings.configureManagementSettingsOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.configureDnsSettingsCallable = callableFactory.createUnaryCallable(configureDnsSettingsTransportSettings, settings.configureDnsSettingsSettings(), clientContext);
        this.configureDnsSettingsOperationCallable = callableFactory.createOperationCallable(configureDnsSettingsTransportSettings, settings.configureDnsSettingsOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.configureContactSettingsCallable = callableFactory.createUnaryCallable(configureContactSettingsTransportSettings, settings.configureContactSettingsSettings(), clientContext);
        this.configureContactSettingsOperationCallable = callableFactory.createOperationCallable(configureContactSettingsTransportSettings, settings.configureContactSettingsOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.exportRegistrationCallable = callableFactory.createUnaryCallable(exportRegistrationTransportSettings, settings.exportRegistrationSettings(), clientContext);
        this.exportRegistrationOperationCallable = callableFactory.createOperationCallable(exportRegistrationTransportSettings, settings.exportRegistrationOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteRegistrationCallable = callableFactory.createUnaryCallable(deleteRegistrationTransportSettings, settings.deleteRegistrationSettings(), clientContext);
        this.deleteRegistrationOperationCallable = callableFactory.createOperationCallable(deleteRegistrationTransportSettings, settings.deleteRegistrationOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.retrieveAuthorizationCodeCallable = callableFactory.createUnaryCallable(retrieveAuthorizationCodeTransportSettings, settings.retrieveAuthorizationCodeSettings(), clientContext);
        this.resetAuthorizationCodeCallable = callableFactory.createUnaryCallable(resetAuthorizationCodeTransportSettings, settings.resetAuthorizationCodeSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(searchDomainsMethodDescriptor);
        methodDescriptors.add(retrieveRegisterParametersMethodDescriptor);
        methodDescriptors.add(registerDomainMethodDescriptor);
        methodDescriptors.add(retrieveTransferParametersMethodDescriptor);
        methodDescriptors.add(transferDomainMethodDescriptor);
        methodDescriptors.add(listRegistrationsMethodDescriptor);
        methodDescriptors.add(getRegistrationMethodDescriptor);
        methodDescriptors.add(updateRegistrationMethodDescriptor);
        methodDescriptors.add(configureManagementSettingsMethodDescriptor);
        methodDescriptors.add(configureDnsSettingsMethodDescriptor);
        methodDescriptors.add(configureContactSettingsMethodDescriptor);
        methodDescriptors.add(exportRegistrationMethodDescriptor);
        methodDescriptors.add(deleteRegistrationMethodDescriptor);
        methodDescriptors.add(retrieveAuthorizationCodeMethodDescriptor);
        methodDescriptors.add(resetAuthorizationCodeMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<SearchDomainsRequest, SearchDomainsResponse> searchDomainsCallable() {
        return this.searchDomainsCallable;
    }

    @Override
    public UnaryCallable<RetrieveRegisterParametersRequest, RetrieveRegisterParametersResponse> retrieveRegisterParametersCallable() {
        return this.retrieveRegisterParametersCallable;
    }

    @Override
    public UnaryCallable<RegisterDomainRequest, Operation> registerDomainCallable() {
        return this.registerDomainCallable;
    }

    @Override
    public OperationCallable<RegisterDomainRequest, Registration, OperationMetadata> registerDomainOperationCallable() {
        return this.registerDomainOperationCallable;
    }

    @Override
    public UnaryCallable<RetrieveTransferParametersRequest, RetrieveTransferParametersResponse> retrieveTransferParametersCallable() {
        return this.retrieveTransferParametersCallable;
    }

    @Override
    public UnaryCallable<TransferDomainRequest, Operation> transferDomainCallable() {
        return this.transferDomainCallable;
    }

    @Override
    public OperationCallable<TransferDomainRequest, Registration, OperationMetadata> transferDomainOperationCallable() {
        return this.transferDomainOperationCallable;
    }

    @Override
    public UnaryCallable<ListRegistrationsRequest, ListRegistrationsResponse> listRegistrationsCallable() {
        return this.listRegistrationsCallable;
    }

    @Override
    public UnaryCallable<ListRegistrationsRequest, DomainsClient.ListRegistrationsPagedResponse> listRegistrationsPagedCallable() {
        return this.listRegistrationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetRegistrationRequest, Registration> getRegistrationCallable() {
        return this.getRegistrationCallable;
    }

    @Override
    public UnaryCallable<UpdateRegistrationRequest, Operation> updateRegistrationCallable() {
        return this.updateRegistrationCallable;
    }

    @Override
    public OperationCallable<UpdateRegistrationRequest, Registration, OperationMetadata> updateRegistrationOperationCallable() {
        return this.updateRegistrationOperationCallable;
    }

    @Override
    public UnaryCallable<ConfigureManagementSettingsRequest, Operation> configureManagementSettingsCallable() {
        return this.configureManagementSettingsCallable;
    }

    @Override
    public OperationCallable<ConfigureManagementSettingsRequest, Registration, OperationMetadata> configureManagementSettingsOperationCallable() {
        return this.configureManagementSettingsOperationCallable;
    }

    @Override
    public UnaryCallable<ConfigureDnsSettingsRequest, Operation> configureDnsSettingsCallable() {
        return this.configureDnsSettingsCallable;
    }

    @Override
    public OperationCallable<ConfigureDnsSettingsRequest, Registration, OperationMetadata> configureDnsSettingsOperationCallable() {
        return this.configureDnsSettingsOperationCallable;
    }

    @Override
    public UnaryCallable<ConfigureContactSettingsRequest, Operation> configureContactSettingsCallable() {
        return this.configureContactSettingsCallable;
    }

    @Override
    public OperationCallable<ConfigureContactSettingsRequest, Registration, OperationMetadata> configureContactSettingsOperationCallable() {
        return this.configureContactSettingsOperationCallable;
    }

    @Override
    public UnaryCallable<ExportRegistrationRequest, Operation> exportRegistrationCallable() {
        return this.exportRegistrationCallable;
    }

    @Override
    public OperationCallable<ExportRegistrationRequest, Registration, OperationMetadata> exportRegistrationOperationCallable() {
        return this.exportRegistrationOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteRegistrationRequest, Operation> deleteRegistrationCallable() {
        return this.deleteRegistrationCallable;
    }

    @Override
    public OperationCallable<DeleteRegistrationRequest, Empty, OperationMetadata> deleteRegistrationOperationCallable() {
        return this.deleteRegistrationOperationCallable;
    }

    @Override
    public UnaryCallable<RetrieveAuthorizationCodeRequest, AuthorizationCode> retrieveAuthorizationCodeCallable() {
        return this.retrieveAuthorizationCodeCallable;
    }

    @Override
    public UnaryCallable<ResetAuthorizationCodeRequest, AuthorizationCode> resetAuthorizationCodeCallable() {
        return this.resetAuthorizationCodeCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

