/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.documentai.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.documentai.v1.BatchProcessMetadata;
import com.google.cloud.documentai.v1.BatchProcessRequest;
import com.google.cloud.documentai.v1.BatchProcessResponse;
import com.google.cloud.documentai.v1.CreateProcessorRequest;
import com.google.cloud.documentai.v1.DeleteProcessorMetadata;
import com.google.cloud.documentai.v1.DeleteProcessorRequest;
import com.google.cloud.documentai.v1.DeleteProcessorVersionMetadata;
import com.google.cloud.documentai.v1.DeleteProcessorVersionRequest;
import com.google.cloud.documentai.v1.DeployProcessorVersionMetadata;
import com.google.cloud.documentai.v1.DeployProcessorVersionRequest;
import com.google.cloud.documentai.v1.DeployProcessorVersionResponse;
import com.google.cloud.documentai.v1.DisableProcessorMetadata;
import com.google.cloud.documentai.v1.DisableProcessorRequest;
import com.google.cloud.documentai.v1.DisableProcessorResponse;
import com.google.cloud.documentai.v1.DocumentProcessorServiceSettings;
import com.google.cloud.documentai.v1.EnableProcessorMetadata;
import com.google.cloud.documentai.v1.EnableProcessorRequest;
import com.google.cloud.documentai.v1.EnableProcessorResponse;
import com.google.cloud.documentai.v1.FetchProcessorTypesRequest;
import com.google.cloud.documentai.v1.FetchProcessorTypesResponse;
import com.google.cloud.documentai.v1.GetProcessorRequest;
import com.google.cloud.documentai.v1.GetProcessorVersionRequest;
import com.google.cloud.documentai.v1.HumanReviewConfigName;
import com.google.cloud.documentai.v1.ListProcessorTypesRequest;
import com.google.cloud.documentai.v1.ListProcessorTypesResponse;
import com.google.cloud.documentai.v1.ListProcessorVersionsRequest;
import com.google.cloud.documentai.v1.ListProcessorVersionsResponse;
import com.google.cloud.documentai.v1.ListProcessorsRequest;
import com.google.cloud.documentai.v1.ListProcessorsResponse;
import com.google.cloud.documentai.v1.LocationName;
import com.google.cloud.documentai.v1.ProcessRequest;
import com.google.cloud.documentai.v1.ProcessResponse;
import com.google.cloud.documentai.v1.Processor;
import com.google.cloud.documentai.v1.ProcessorName;
import com.google.cloud.documentai.v1.ProcessorType;
import com.google.cloud.documentai.v1.ProcessorVersion;
import com.google.cloud.documentai.v1.ProcessorVersionName;
import com.google.cloud.documentai.v1.ReviewDocumentOperationMetadata;
import com.google.cloud.documentai.v1.ReviewDocumentRequest;
import com.google.cloud.documentai.v1.ReviewDocumentResponse;
import com.google.cloud.documentai.v1.SetDefaultProcessorVersionMetadata;
import com.google.cloud.documentai.v1.SetDefaultProcessorVersionRequest;
import com.google.cloud.documentai.v1.SetDefaultProcessorVersionResponse;
import com.google.cloud.documentai.v1.UndeployProcessorVersionMetadata;
import com.google.cloud.documentai.v1.UndeployProcessorVersionRequest;
import com.google.cloud.documentai.v1.UndeployProcessorVersionResponse;
import com.google.cloud.documentai.v1.stub.DocumentProcessorServiceStub;
import com.google.cloud.documentai.v1.stub.DocumentProcessorServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DocumentProcessorServiceClient
implements BackgroundResource {
    private final DocumentProcessorServiceSettings settings;
    private final DocumentProcessorServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final DocumentProcessorServiceClient create() throws IOException {
        return DocumentProcessorServiceClient.create(DocumentProcessorServiceSettings.newBuilder().build());
    }

    public static final DocumentProcessorServiceClient create(DocumentProcessorServiceSettings settings) throws IOException {
        return new DocumentProcessorServiceClient(settings);
    }

    public static final DocumentProcessorServiceClient create(DocumentProcessorServiceStub stub) {
        return new DocumentProcessorServiceClient(stub);
    }

    protected DocumentProcessorServiceClient(DocumentProcessorServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DocumentProcessorServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected DocumentProcessorServiceClient(DocumentProcessorServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final DocumentProcessorServiceSettings getSettings() {
        return this.settings;
    }

    public DocumentProcessorServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ProcessResponse processDocument(ResourceName name) {
        ProcessRequest request = ProcessRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.processDocument(request);
    }

    public final ProcessResponse processDocument(String name) {
        ProcessRequest request = ProcessRequest.newBuilder().setName(name).build();
        return this.processDocument(request);
    }

    public final ProcessResponse processDocument(ProcessRequest request) {
        return (ProcessResponse)this.processDocumentCallable().call((Object)request);
    }

    public final UnaryCallable<ProcessRequest, ProcessResponse> processDocumentCallable() {
        return this.stub.processDocumentCallable();
    }

    public final OperationFuture<BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsAsync(ResourceName name) {
        BatchProcessRequest request = BatchProcessRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.batchProcessDocumentsAsync(request);
    }

    public final OperationFuture<BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsAsync(String name) {
        BatchProcessRequest request = BatchProcessRequest.newBuilder().setName(name).build();
        return this.batchProcessDocumentsAsync(request);
    }

    public final OperationFuture<BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsAsync(BatchProcessRequest request) {
        return this.batchProcessDocumentsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchProcessRequest, BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsOperationCallable() {
        return this.stub.batchProcessDocumentsOperationCallable();
    }

    public final UnaryCallable<BatchProcessRequest, Operation> batchProcessDocumentsCallable() {
        return this.stub.batchProcessDocumentsCallable();
    }

    public final FetchProcessorTypesResponse fetchProcessorTypes(LocationName parent) {
        FetchProcessorTypesRequest request = FetchProcessorTypesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.fetchProcessorTypes(request);
    }

    public final FetchProcessorTypesResponse fetchProcessorTypes(String parent) {
        FetchProcessorTypesRequest request = FetchProcessorTypesRequest.newBuilder().setParent(parent).build();
        return this.fetchProcessorTypes(request);
    }

    public final FetchProcessorTypesResponse fetchProcessorTypes(FetchProcessorTypesRequest request) {
        return (FetchProcessorTypesResponse)this.fetchProcessorTypesCallable().call((Object)request);
    }

    public final UnaryCallable<FetchProcessorTypesRequest, FetchProcessorTypesResponse> fetchProcessorTypesCallable() {
        return this.stub.fetchProcessorTypesCallable();
    }

    public final ListProcessorTypesPagedResponse listProcessorTypes(LocationName parent) {
        ListProcessorTypesRequest request = ListProcessorTypesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listProcessorTypes(request);
    }

    public final ListProcessorTypesPagedResponse listProcessorTypes(String parent) {
        ListProcessorTypesRequest request = ListProcessorTypesRequest.newBuilder().setParent(parent).build();
        return this.listProcessorTypes(request);
    }

    public final ListProcessorTypesPagedResponse listProcessorTypes(ListProcessorTypesRequest request) {
        return (ListProcessorTypesPagedResponse)((Object)this.listProcessorTypesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListProcessorTypesRequest, ListProcessorTypesPagedResponse> listProcessorTypesPagedCallable() {
        return this.stub.listProcessorTypesPagedCallable();
    }

    public final UnaryCallable<ListProcessorTypesRequest, ListProcessorTypesResponse> listProcessorTypesCallable() {
        return this.stub.listProcessorTypesCallable();
    }

    public final ListProcessorsPagedResponse listProcessors(LocationName parent) {
        ListProcessorsRequest request = ListProcessorsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listProcessors(request);
    }

    public final ListProcessorsPagedResponse listProcessors(String parent) {
        ListProcessorsRequest request = ListProcessorsRequest.newBuilder().setParent(parent).build();
        return this.listProcessors(request);
    }

    public final ListProcessorsPagedResponse listProcessors(ListProcessorsRequest request) {
        return (ListProcessorsPagedResponse)((Object)this.listProcessorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListProcessorsRequest, ListProcessorsPagedResponse> listProcessorsPagedCallable() {
        return this.stub.listProcessorsPagedCallable();
    }

    public final UnaryCallable<ListProcessorsRequest, ListProcessorsResponse> listProcessorsCallable() {
        return this.stub.listProcessorsCallable();
    }

    public final Processor getProcessor(ProcessorName name) {
        GetProcessorRequest request = GetProcessorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getProcessor(request);
    }

    public final Processor getProcessor(String name) {
        GetProcessorRequest request = GetProcessorRequest.newBuilder().setName(name).build();
        return this.getProcessor(request);
    }

    public final Processor getProcessor(GetProcessorRequest request) {
        return (Processor)this.getProcessorCallable().call((Object)request);
    }

    public final UnaryCallable<GetProcessorRequest, Processor> getProcessorCallable() {
        return this.stub.getProcessorCallable();
    }

    public final ProcessorVersion getProcessorVersion(ProcessorVersionName name) {
        GetProcessorVersionRequest request = GetProcessorVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getProcessorVersion(request);
    }

    public final ProcessorVersion getProcessorVersion(String name) {
        GetProcessorVersionRequest request = GetProcessorVersionRequest.newBuilder().setName(name).build();
        return this.getProcessorVersion(request);
    }

    public final ProcessorVersion getProcessorVersion(GetProcessorVersionRequest request) {
        return (ProcessorVersion)this.getProcessorVersionCallable().call((Object)request);
    }

    public final UnaryCallable<GetProcessorVersionRequest, ProcessorVersion> getProcessorVersionCallable() {
        return this.stub.getProcessorVersionCallable();
    }

    public final ListProcessorVersionsPagedResponse listProcessorVersions(ProcessorName parent) {
        ListProcessorVersionsRequest request = ListProcessorVersionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listProcessorVersions(request);
    }

    public final ListProcessorVersionsPagedResponse listProcessorVersions(String parent) {
        ListProcessorVersionsRequest request = ListProcessorVersionsRequest.newBuilder().setParent(parent).build();
        return this.listProcessorVersions(request);
    }

    public final ListProcessorVersionsPagedResponse listProcessorVersions(ListProcessorVersionsRequest request) {
        return (ListProcessorVersionsPagedResponse)((Object)this.listProcessorVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListProcessorVersionsRequest, ListProcessorVersionsPagedResponse> listProcessorVersionsPagedCallable() {
        return this.stub.listProcessorVersionsPagedCallable();
    }

    public final UnaryCallable<ListProcessorVersionsRequest, ListProcessorVersionsResponse> listProcessorVersionsCallable() {
        return this.stub.listProcessorVersionsCallable();
    }

    public final OperationFuture<Empty, DeleteProcessorVersionMetadata> deleteProcessorVersionAsync(ProcessorVersionName name) {
        DeleteProcessorVersionRequest request = DeleteProcessorVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteProcessorVersionAsync(request);
    }

    public final OperationFuture<Empty, DeleteProcessorVersionMetadata> deleteProcessorVersionAsync(String name) {
        DeleteProcessorVersionRequest request = DeleteProcessorVersionRequest.newBuilder().setName(name).build();
        return this.deleteProcessorVersionAsync(request);
    }

    public final OperationFuture<Empty, DeleteProcessorVersionMetadata> deleteProcessorVersionAsync(DeleteProcessorVersionRequest request) {
        return this.deleteProcessorVersionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteProcessorVersionRequest, Empty, DeleteProcessorVersionMetadata> deleteProcessorVersionOperationCallable() {
        return this.stub.deleteProcessorVersionOperationCallable();
    }

    public final UnaryCallable<DeleteProcessorVersionRequest, Operation> deleteProcessorVersionCallable() {
        return this.stub.deleteProcessorVersionCallable();
    }

    public final OperationFuture<DeployProcessorVersionResponse, DeployProcessorVersionMetadata> deployProcessorVersionAsync(ProcessorVersionName name) {
        DeployProcessorVersionRequest request = DeployProcessorVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deployProcessorVersionAsync(request);
    }

    public final OperationFuture<DeployProcessorVersionResponse, DeployProcessorVersionMetadata> deployProcessorVersionAsync(String name) {
        DeployProcessorVersionRequest request = DeployProcessorVersionRequest.newBuilder().setName(name).build();
        return this.deployProcessorVersionAsync(request);
    }

    public final OperationFuture<DeployProcessorVersionResponse, DeployProcessorVersionMetadata> deployProcessorVersionAsync(DeployProcessorVersionRequest request) {
        return this.deployProcessorVersionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeployProcessorVersionRequest, DeployProcessorVersionResponse, DeployProcessorVersionMetadata> deployProcessorVersionOperationCallable() {
        return this.stub.deployProcessorVersionOperationCallable();
    }

    public final UnaryCallable<DeployProcessorVersionRequest, Operation> deployProcessorVersionCallable() {
        return this.stub.deployProcessorVersionCallable();
    }

    public final OperationFuture<UndeployProcessorVersionResponse, UndeployProcessorVersionMetadata> undeployProcessorVersionAsync(ProcessorVersionName name) {
        UndeployProcessorVersionRequest request = UndeployProcessorVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.undeployProcessorVersionAsync(request);
    }

    public final OperationFuture<UndeployProcessorVersionResponse, UndeployProcessorVersionMetadata> undeployProcessorVersionAsync(String name) {
        UndeployProcessorVersionRequest request = UndeployProcessorVersionRequest.newBuilder().setName(name).build();
        return this.undeployProcessorVersionAsync(request);
    }

    public final OperationFuture<UndeployProcessorVersionResponse, UndeployProcessorVersionMetadata> undeployProcessorVersionAsync(UndeployProcessorVersionRequest request) {
        return this.undeployProcessorVersionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UndeployProcessorVersionRequest, UndeployProcessorVersionResponse, UndeployProcessorVersionMetadata> undeployProcessorVersionOperationCallable() {
        return this.stub.undeployProcessorVersionOperationCallable();
    }

    public final UnaryCallable<UndeployProcessorVersionRequest, Operation> undeployProcessorVersionCallable() {
        return this.stub.undeployProcessorVersionCallable();
    }

    public final Processor createProcessor(LocationName parent, Processor processor) {
        CreateProcessorRequest request = CreateProcessorRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setProcessor(processor).build();
        return this.createProcessor(request);
    }

    public final Processor createProcessor(String parent, Processor processor) {
        CreateProcessorRequest request = CreateProcessorRequest.newBuilder().setParent(parent).setProcessor(processor).build();
        return this.createProcessor(request);
    }

    public final Processor createProcessor(CreateProcessorRequest request) {
        return (Processor)this.createProcessorCallable().call((Object)request);
    }

    public final UnaryCallable<CreateProcessorRequest, Processor> createProcessorCallable() {
        return this.stub.createProcessorCallable();
    }

    public final OperationFuture<Empty, DeleteProcessorMetadata> deleteProcessorAsync(ProcessorName name) {
        DeleteProcessorRequest request = DeleteProcessorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteProcessorAsync(request);
    }

    public final OperationFuture<Empty, DeleteProcessorMetadata> deleteProcessorAsync(String name) {
        DeleteProcessorRequest request = DeleteProcessorRequest.newBuilder().setName(name).build();
        return this.deleteProcessorAsync(request);
    }

    public final OperationFuture<Empty, DeleteProcessorMetadata> deleteProcessorAsync(DeleteProcessorRequest request) {
        return this.deleteProcessorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteProcessorRequest, Empty, DeleteProcessorMetadata> deleteProcessorOperationCallable() {
        return this.stub.deleteProcessorOperationCallable();
    }

    public final UnaryCallable<DeleteProcessorRequest, Operation> deleteProcessorCallable() {
        return this.stub.deleteProcessorCallable();
    }

    public final OperationFuture<EnableProcessorResponse, EnableProcessorMetadata> enableProcessorAsync(EnableProcessorRequest request) {
        return this.enableProcessorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<EnableProcessorRequest, EnableProcessorResponse, EnableProcessorMetadata> enableProcessorOperationCallable() {
        return this.stub.enableProcessorOperationCallable();
    }

    public final UnaryCallable<EnableProcessorRequest, Operation> enableProcessorCallable() {
        return this.stub.enableProcessorCallable();
    }

    public final OperationFuture<DisableProcessorResponse, DisableProcessorMetadata> disableProcessorAsync(DisableProcessorRequest request) {
        return this.disableProcessorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DisableProcessorRequest, DisableProcessorResponse, DisableProcessorMetadata> disableProcessorOperationCallable() {
        return this.stub.disableProcessorOperationCallable();
    }

    public final UnaryCallable<DisableProcessorRequest, Operation> disableProcessorCallable() {
        return this.stub.disableProcessorCallable();
    }

    public final OperationFuture<SetDefaultProcessorVersionResponse, SetDefaultProcessorVersionMetadata> setDefaultProcessorVersionAsync(SetDefaultProcessorVersionRequest request) {
        return this.setDefaultProcessorVersionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetDefaultProcessorVersionRequest, SetDefaultProcessorVersionResponse, SetDefaultProcessorVersionMetadata> setDefaultProcessorVersionOperationCallable() {
        return this.stub.setDefaultProcessorVersionOperationCallable();
    }

    public final UnaryCallable<SetDefaultProcessorVersionRequest, Operation> setDefaultProcessorVersionCallable() {
        return this.stub.setDefaultProcessorVersionCallable();
    }

    public final OperationFuture<ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentAsync(HumanReviewConfigName humanReviewConfig) {
        ReviewDocumentRequest request = ReviewDocumentRequest.newBuilder().setHumanReviewConfig(humanReviewConfig == null ? null : humanReviewConfig.toString()).build();
        return this.reviewDocumentAsync(request);
    }

    public final OperationFuture<ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentAsync(String humanReviewConfig) {
        ReviewDocumentRequest request = ReviewDocumentRequest.newBuilder().setHumanReviewConfig(humanReviewConfig).build();
        return this.reviewDocumentAsync(request);
    }

    public final OperationFuture<ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentAsync(ReviewDocumentRequest request) {
        return this.reviewDocumentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ReviewDocumentRequest, ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentOperationCallable() {
        return this.stub.reviewDocumentOperationCallable();
    }

    public final UnaryCallable<ReviewDocumentRequest, Operation> reviewDocumentCallable() {
        return this.stub.reviewDocumentCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListProcessorVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListProcessorVersionsRequest, ListProcessorVersionsResponse, ProcessorVersion, ListProcessorVersionsPage, ListProcessorVersionsFixedSizeCollection> {
        private ListProcessorVersionsFixedSizeCollection(List<ListProcessorVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListProcessorVersionsFixedSizeCollection createEmptyCollection() {
            return new ListProcessorVersionsFixedSizeCollection(null, 0);
        }

        protected ListProcessorVersionsFixedSizeCollection createCollection(List<ListProcessorVersionsPage> pages, int collectionSize) {
            return new ListProcessorVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListProcessorVersionsPage
    extends AbstractPage<ListProcessorVersionsRequest, ListProcessorVersionsResponse, ProcessorVersion, ListProcessorVersionsPage> {
        private ListProcessorVersionsPage(PageContext<ListProcessorVersionsRequest, ListProcessorVersionsResponse, ProcessorVersion> context, ListProcessorVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListProcessorVersionsPage createEmptyPage() {
            return new ListProcessorVersionsPage(null, null);
        }

        protected ListProcessorVersionsPage createPage(PageContext<ListProcessorVersionsRequest, ListProcessorVersionsResponse, ProcessorVersion> context, ListProcessorVersionsResponse response) {
            return new ListProcessorVersionsPage(context, response);
        }

        public ApiFuture<ListProcessorVersionsPage> createPageAsync(PageContext<ListProcessorVersionsRequest, ListProcessorVersionsResponse, ProcessorVersion> context, ApiFuture<ListProcessorVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListProcessorVersionsPagedResponse
    extends AbstractPagedListResponse<ListProcessorVersionsRequest, ListProcessorVersionsResponse, ProcessorVersion, ListProcessorVersionsPage, ListProcessorVersionsFixedSizeCollection> {
        public static ApiFuture<ListProcessorVersionsPagedResponse> createAsync(PageContext<ListProcessorVersionsRequest, ListProcessorVersionsResponse, ProcessorVersion> context, ApiFuture<ListProcessorVersionsResponse> futureResponse) {
            ApiFuture<ListProcessorVersionsPage> futurePage = ListProcessorVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListProcessorVersionsPagedResponse((ListProcessorVersionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListProcessorVersionsPagedResponse(ListProcessorVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListProcessorVersionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListProcessorsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListProcessorsRequest, ListProcessorsResponse, Processor, ListProcessorsPage, ListProcessorsFixedSizeCollection> {
        private ListProcessorsFixedSizeCollection(List<ListProcessorsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListProcessorsFixedSizeCollection createEmptyCollection() {
            return new ListProcessorsFixedSizeCollection(null, 0);
        }

        protected ListProcessorsFixedSizeCollection createCollection(List<ListProcessorsPage> pages, int collectionSize) {
            return new ListProcessorsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListProcessorsPage
    extends AbstractPage<ListProcessorsRequest, ListProcessorsResponse, Processor, ListProcessorsPage> {
        private ListProcessorsPage(PageContext<ListProcessorsRequest, ListProcessorsResponse, Processor> context, ListProcessorsResponse response) {
            super(context, (Object)response);
        }

        private static ListProcessorsPage createEmptyPage() {
            return new ListProcessorsPage(null, null);
        }

        protected ListProcessorsPage createPage(PageContext<ListProcessorsRequest, ListProcessorsResponse, Processor> context, ListProcessorsResponse response) {
            return new ListProcessorsPage(context, response);
        }

        public ApiFuture<ListProcessorsPage> createPageAsync(PageContext<ListProcessorsRequest, ListProcessorsResponse, Processor> context, ApiFuture<ListProcessorsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListProcessorsPagedResponse
    extends AbstractPagedListResponse<ListProcessorsRequest, ListProcessorsResponse, Processor, ListProcessorsPage, ListProcessorsFixedSizeCollection> {
        public static ApiFuture<ListProcessorsPagedResponse> createAsync(PageContext<ListProcessorsRequest, ListProcessorsResponse, Processor> context, ApiFuture<ListProcessorsResponse> futureResponse) {
            ApiFuture<ListProcessorsPage> futurePage = ListProcessorsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListProcessorsPagedResponse((ListProcessorsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListProcessorsPagedResponse(ListProcessorsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListProcessorsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListProcessorTypesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListProcessorTypesRequest, ListProcessorTypesResponse, ProcessorType, ListProcessorTypesPage, ListProcessorTypesFixedSizeCollection> {
        private ListProcessorTypesFixedSizeCollection(List<ListProcessorTypesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListProcessorTypesFixedSizeCollection createEmptyCollection() {
            return new ListProcessorTypesFixedSizeCollection(null, 0);
        }

        protected ListProcessorTypesFixedSizeCollection createCollection(List<ListProcessorTypesPage> pages, int collectionSize) {
            return new ListProcessorTypesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListProcessorTypesPage
    extends AbstractPage<ListProcessorTypesRequest, ListProcessorTypesResponse, ProcessorType, ListProcessorTypesPage> {
        private ListProcessorTypesPage(PageContext<ListProcessorTypesRequest, ListProcessorTypesResponse, ProcessorType> context, ListProcessorTypesResponse response) {
            super(context, (Object)response);
        }

        private static ListProcessorTypesPage createEmptyPage() {
            return new ListProcessorTypesPage(null, null);
        }

        protected ListProcessorTypesPage createPage(PageContext<ListProcessorTypesRequest, ListProcessorTypesResponse, ProcessorType> context, ListProcessorTypesResponse response) {
            return new ListProcessorTypesPage(context, response);
        }

        public ApiFuture<ListProcessorTypesPage> createPageAsync(PageContext<ListProcessorTypesRequest, ListProcessorTypesResponse, ProcessorType> context, ApiFuture<ListProcessorTypesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListProcessorTypesPagedResponse
    extends AbstractPagedListResponse<ListProcessorTypesRequest, ListProcessorTypesResponse, ProcessorType, ListProcessorTypesPage, ListProcessorTypesFixedSizeCollection> {
        public static ApiFuture<ListProcessorTypesPagedResponse> createAsync(PageContext<ListProcessorTypesRequest, ListProcessorTypesResponse, ProcessorType> context, ApiFuture<ListProcessorTypesResponse> futureResponse) {
            ApiFuture<ListProcessorTypesPage> futurePage = ListProcessorTypesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListProcessorTypesPagedResponse((ListProcessorTypesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListProcessorTypesPagedResponse(ListProcessorTypesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListProcessorTypesFixedSizeCollection.createEmptyCollection());
        }
    }
}

