/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.documentai.v1beta3;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.documentai.v1beta3.BatchDeleteDocumentsMetadata;
import com.google.cloud.documentai.v1beta3.BatchDeleteDocumentsRequest;
import com.google.cloud.documentai.v1beta3.BatchDeleteDocumentsResponse;
import com.google.cloud.documentai.v1beta3.Dataset;
import com.google.cloud.documentai.v1beta3.DatasetName;
import com.google.cloud.documentai.v1beta3.DatasetSchema;
import com.google.cloud.documentai.v1beta3.DatasetSchemaName;
import com.google.cloud.documentai.v1beta3.DocumentMetadata;
import com.google.cloud.documentai.v1beta3.DocumentServiceSettings;
import com.google.cloud.documentai.v1beta3.GetDatasetSchemaRequest;
import com.google.cloud.documentai.v1beta3.GetDocumentRequest;
import com.google.cloud.documentai.v1beta3.GetDocumentResponse;
import com.google.cloud.documentai.v1beta3.ImportDocumentsMetadata;
import com.google.cloud.documentai.v1beta3.ImportDocumentsRequest;
import com.google.cloud.documentai.v1beta3.ImportDocumentsResponse;
import com.google.cloud.documentai.v1beta3.ListDocumentsRequest;
import com.google.cloud.documentai.v1beta3.ListDocumentsResponse;
import com.google.cloud.documentai.v1beta3.UpdateDatasetOperationMetadata;
import com.google.cloud.documentai.v1beta3.UpdateDatasetRequest;
import com.google.cloud.documentai.v1beta3.UpdateDatasetSchemaRequest;
import com.google.cloud.documentai.v1beta3.stub.DocumentServiceStub;
import com.google.cloud.documentai.v1beta3.stub.DocumentServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DocumentServiceClient
implements BackgroundResource {
    private final DocumentServiceSettings settings;
    private final DocumentServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final DocumentServiceClient create() throws IOException {
        return DocumentServiceClient.create(DocumentServiceSettings.newBuilder().build());
    }

    public static final DocumentServiceClient create(DocumentServiceSettings settings) throws IOException {
        return new DocumentServiceClient(settings);
    }

    public static final DocumentServiceClient create(DocumentServiceStub stub) {
        return new DocumentServiceClient(stub);
    }

    protected DocumentServiceClient(DocumentServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DocumentServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected DocumentServiceClient(DocumentServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final DocumentServiceSettings getSettings() {
        return this.settings;
    }

    public DocumentServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<Dataset, UpdateDatasetOperationMetadata> updateDatasetAsync(Dataset dataset, FieldMask updateMask) {
        UpdateDatasetRequest request = UpdateDatasetRequest.newBuilder().setDataset(dataset).setUpdateMask(updateMask).build();
        return this.updateDatasetAsync(request);
    }

    public final OperationFuture<Dataset, UpdateDatasetOperationMetadata> updateDatasetAsync(UpdateDatasetRequest request) {
        return this.updateDatasetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateDatasetRequest, Dataset, UpdateDatasetOperationMetadata> updateDatasetOperationCallable() {
        return this.stub.updateDatasetOperationCallable();
    }

    public final UnaryCallable<UpdateDatasetRequest, Operation> updateDatasetCallable() {
        return this.stub.updateDatasetCallable();
    }

    public final OperationFuture<ImportDocumentsResponse, ImportDocumentsMetadata> importDocumentsAsync(DatasetName dataset) {
        ImportDocumentsRequest request = ImportDocumentsRequest.newBuilder().setDataset(dataset == null ? null : dataset.toString()).build();
        return this.importDocumentsAsync(request);
    }

    public final OperationFuture<ImportDocumentsResponse, ImportDocumentsMetadata> importDocumentsAsync(String dataset) {
        ImportDocumentsRequest request = ImportDocumentsRequest.newBuilder().setDataset(dataset).build();
        return this.importDocumentsAsync(request);
    }

    public final OperationFuture<ImportDocumentsResponse, ImportDocumentsMetadata> importDocumentsAsync(ImportDocumentsRequest request) {
        return this.importDocumentsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportDocumentsRequest, ImportDocumentsResponse, ImportDocumentsMetadata> importDocumentsOperationCallable() {
        return this.stub.importDocumentsOperationCallable();
    }

    public final UnaryCallable<ImportDocumentsRequest, Operation> importDocumentsCallable() {
        return this.stub.importDocumentsCallable();
    }

    public final GetDocumentResponse getDocument(DatasetName dataset) {
        GetDocumentRequest request = GetDocumentRequest.newBuilder().setDataset(dataset == null ? null : dataset.toString()).build();
        return this.getDocument(request);
    }

    public final GetDocumentResponse getDocument(String dataset) {
        GetDocumentRequest request = GetDocumentRequest.newBuilder().setDataset(dataset).build();
        return this.getDocument(request);
    }

    public final GetDocumentResponse getDocument(GetDocumentRequest request) {
        return (GetDocumentResponse)this.getDocumentCallable().call((Object)request);
    }

    public final UnaryCallable<GetDocumentRequest, GetDocumentResponse> getDocumentCallable() {
        return this.stub.getDocumentCallable();
    }

    public final ListDocumentsPagedResponse listDocuments(DatasetName dataset) {
        ListDocumentsRequest request = ListDocumentsRequest.newBuilder().setDataset(dataset == null ? null : dataset.toString()).build();
        return this.listDocuments(request);
    }

    public final ListDocumentsPagedResponse listDocuments(String dataset) {
        ListDocumentsRequest request = ListDocumentsRequest.newBuilder().setDataset(dataset).build();
        return this.listDocuments(request);
    }

    public final ListDocumentsPagedResponse listDocuments(ListDocumentsRequest request) {
        return (ListDocumentsPagedResponse)((Object)this.listDocumentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDocumentsRequest, ListDocumentsPagedResponse> listDocumentsPagedCallable() {
        return this.stub.listDocumentsPagedCallable();
    }

    public final UnaryCallable<ListDocumentsRequest, ListDocumentsResponse> listDocumentsCallable() {
        return this.stub.listDocumentsCallable();
    }

    public final OperationFuture<BatchDeleteDocumentsResponse, BatchDeleteDocumentsMetadata> batchDeleteDocumentsAsync(String dataset) {
        BatchDeleteDocumentsRequest request = BatchDeleteDocumentsRequest.newBuilder().setDataset(dataset).build();
        return this.batchDeleteDocumentsAsync(request);
    }

    public final OperationFuture<BatchDeleteDocumentsResponse, BatchDeleteDocumentsMetadata> batchDeleteDocumentsAsync(BatchDeleteDocumentsRequest request) {
        return this.batchDeleteDocumentsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchDeleteDocumentsRequest, BatchDeleteDocumentsResponse, BatchDeleteDocumentsMetadata> batchDeleteDocumentsOperationCallable() {
        return this.stub.batchDeleteDocumentsOperationCallable();
    }

    public final UnaryCallable<BatchDeleteDocumentsRequest, Operation> batchDeleteDocumentsCallable() {
        return this.stub.batchDeleteDocumentsCallable();
    }

    public final DatasetSchema getDatasetSchema(DatasetSchemaName name) {
        GetDatasetSchemaRequest request = GetDatasetSchemaRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDatasetSchema(request);
    }

    public final DatasetSchema getDatasetSchema(String name) {
        GetDatasetSchemaRequest request = GetDatasetSchemaRequest.newBuilder().setName(name).build();
        return this.getDatasetSchema(request);
    }

    public final DatasetSchema getDatasetSchema(GetDatasetSchemaRequest request) {
        return (DatasetSchema)this.getDatasetSchemaCallable().call((Object)request);
    }

    public final UnaryCallable<GetDatasetSchemaRequest, DatasetSchema> getDatasetSchemaCallable() {
        return this.stub.getDatasetSchemaCallable();
    }

    public final DatasetSchema updateDatasetSchema(DatasetSchema datasetSchema, FieldMask updateMask) {
        UpdateDatasetSchemaRequest request = UpdateDatasetSchemaRequest.newBuilder().setDatasetSchema(datasetSchema).setUpdateMask(updateMask).build();
        return this.updateDatasetSchema(request);
    }

    public final DatasetSchema updateDatasetSchema(UpdateDatasetSchemaRequest request) {
        return (DatasetSchema)this.updateDatasetSchemaCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDatasetSchemaRequest, DatasetSchema> updateDatasetSchemaCallable() {
        return this.stub.updateDatasetSchemaCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDocumentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDocumentsRequest, ListDocumentsResponse, DocumentMetadata, ListDocumentsPage, ListDocumentsFixedSizeCollection> {
        private ListDocumentsFixedSizeCollection(List<ListDocumentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDocumentsFixedSizeCollection createEmptyCollection() {
            return new ListDocumentsFixedSizeCollection(null, 0);
        }

        protected ListDocumentsFixedSizeCollection createCollection(List<ListDocumentsPage> pages, int collectionSize) {
            return new ListDocumentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDocumentsPage
    extends AbstractPage<ListDocumentsRequest, ListDocumentsResponse, DocumentMetadata, ListDocumentsPage> {
        private ListDocumentsPage(PageContext<ListDocumentsRequest, ListDocumentsResponse, DocumentMetadata> context, ListDocumentsResponse response) {
            super(context, (Object)response);
        }

        private static ListDocumentsPage createEmptyPage() {
            return new ListDocumentsPage(null, null);
        }

        protected ListDocumentsPage createPage(PageContext<ListDocumentsRequest, ListDocumentsResponse, DocumentMetadata> context, ListDocumentsResponse response) {
            return new ListDocumentsPage(context, response);
        }

        public ApiFuture<ListDocumentsPage> createPageAsync(PageContext<ListDocumentsRequest, ListDocumentsResponse, DocumentMetadata> context, ApiFuture<ListDocumentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDocumentsPagedResponse
    extends AbstractPagedListResponse<ListDocumentsRequest, ListDocumentsResponse, DocumentMetadata, ListDocumentsPage, ListDocumentsFixedSizeCollection> {
        public static ApiFuture<ListDocumentsPagedResponse> createAsync(PageContext<ListDocumentsRequest, ListDocumentsResponse, DocumentMetadata> context, ApiFuture<ListDocumentsResponse> futureResponse) {
            ApiFuture<ListDocumentsPage> futurePage = ListDocumentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDocumentsPagedResponse((ListDocumentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDocumentsPagedResponse(ListDocumentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDocumentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

