/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.documentai.v1beta3.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.documentai.v1beta3.BatchProcessMetadata;
import com.google.cloud.documentai.v1beta3.BatchProcessRequest;
import com.google.cloud.documentai.v1beta3.BatchProcessResponse;
import com.google.cloud.documentai.v1beta3.CreateProcessorRequest;
import com.google.cloud.documentai.v1beta3.DeleteProcessorMetadata;
import com.google.cloud.documentai.v1beta3.DeleteProcessorRequest;
import com.google.cloud.documentai.v1beta3.DisableProcessorMetadata;
import com.google.cloud.documentai.v1beta3.DisableProcessorRequest;
import com.google.cloud.documentai.v1beta3.DisableProcessorResponse;
import com.google.cloud.documentai.v1beta3.DocumentProcessorServiceClient;
import com.google.cloud.documentai.v1beta3.EnableProcessorMetadata;
import com.google.cloud.documentai.v1beta3.EnableProcessorRequest;
import com.google.cloud.documentai.v1beta3.EnableProcessorResponse;
import com.google.cloud.documentai.v1beta3.FetchProcessorTypesRequest;
import com.google.cloud.documentai.v1beta3.FetchProcessorTypesResponse;
import com.google.cloud.documentai.v1beta3.ListProcessorsRequest;
import com.google.cloud.documentai.v1beta3.ListProcessorsResponse;
import com.google.cloud.documentai.v1beta3.ProcessRequest;
import com.google.cloud.documentai.v1beta3.ProcessResponse;
import com.google.cloud.documentai.v1beta3.Processor;
import com.google.cloud.documentai.v1beta3.ReviewDocumentOperationMetadata;
import com.google.cloud.documentai.v1beta3.ReviewDocumentRequest;
import com.google.cloud.documentai.v1beta3.ReviewDocumentResponse;
import com.google.cloud.documentai.v1beta3.stub.DocumentProcessorServiceStub;
import com.google.cloud.documentai.v1beta3.stub.DocumentProcessorServiceStubSettings;
import com.google.cloud.documentai.v1beta3.stub.GrpcDocumentProcessorServiceCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcDocumentProcessorServiceStub
extends DocumentProcessorServiceStub {
    private static final MethodDescriptor<ProcessRequest, ProcessResponse> processDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.documentai.v1beta3.DocumentProcessorService/ProcessDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)ProcessRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ProcessResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchProcessRequest, Operation> batchProcessDocumentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.documentai.v1beta3.DocumentProcessorService/BatchProcessDocuments").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchProcessRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<FetchProcessorTypesRequest, FetchProcessorTypesResponse> fetchProcessorTypesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.documentai.v1beta3.DocumentProcessorService/FetchProcessorTypes").setRequestMarshaller(ProtoUtils.marshaller((Message)FetchProcessorTypesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)FetchProcessorTypesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListProcessorsRequest, ListProcessorsResponse> listProcessorsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.documentai.v1beta3.DocumentProcessorService/ListProcessors").setRequestMarshaller(ProtoUtils.marshaller((Message)ListProcessorsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListProcessorsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateProcessorRequest, Processor> createProcessorMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.documentai.v1beta3.DocumentProcessorService/CreateProcessor").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateProcessorRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Processor.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteProcessorRequest, Operation> deleteProcessorMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.documentai.v1beta3.DocumentProcessorService/DeleteProcessor").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteProcessorRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<EnableProcessorRequest, Operation> enableProcessorMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.documentai.v1beta3.DocumentProcessorService/EnableProcessor").setRequestMarshaller(ProtoUtils.marshaller((Message)EnableProcessorRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DisableProcessorRequest, Operation> disableProcessorMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.documentai.v1beta3.DocumentProcessorService/DisableProcessor").setRequestMarshaller(ProtoUtils.marshaller((Message)DisableProcessorRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ReviewDocumentRequest, Operation> reviewDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.documentai.v1beta3.DocumentProcessorService/ReviewDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)ReviewDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<ProcessRequest, ProcessResponse> processDocumentCallable;
    private final UnaryCallable<BatchProcessRequest, Operation> batchProcessDocumentsCallable;
    private final OperationCallable<BatchProcessRequest, BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsOperationCallable;
    private final UnaryCallable<FetchProcessorTypesRequest, FetchProcessorTypesResponse> fetchProcessorTypesCallable;
    private final UnaryCallable<ListProcessorsRequest, ListProcessorsResponse> listProcessorsCallable;
    private final UnaryCallable<ListProcessorsRequest, DocumentProcessorServiceClient.ListProcessorsPagedResponse> listProcessorsPagedCallable;
    private final UnaryCallable<CreateProcessorRequest, Processor> createProcessorCallable;
    private final UnaryCallable<DeleteProcessorRequest, Operation> deleteProcessorCallable;
    private final OperationCallable<DeleteProcessorRequest, Empty, DeleteProcessorMetadata> deleteProcessorOperationCallable;
    private final UnaryCallable<EnableProcessorRequest, Operation> enableProcessorCallable;
    private final OperationCallable<EnableProcessorRequest, EnableProcessorResponse, EnableProcessorMetadata> enableProcessorOperationCallable;
    private final UnaryCallable<DisableProcessorRequest, Operation> disableProcessorCallable;
    private final OperationCallable<DisableProcessorRequest, DisableProcessorResponse, DisableProcessorMetadata> disableProcessorOperationCallable;
    private final UnaryCallable<ReviewDocumentRequest, Operation> reviewDocumentCallable;
    private final OperationCallable<ReviewDocumentRequest, ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDocumentProcessorServiceStub create(DocumentProcessorServiceStubSettings settings) throws IOException {
        return new GrpcDocumentProcessorServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDocumentProcessorServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcDocumentProcessorServiceStub(DocumentProcessorServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDocumentProcessorServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDocumentProcessorServiceStub(DocumentProcessorServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDocumentProcessorServiceStub(DocumentProcessorServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDocumentProcessorServiceCallableFactory());
    }

    protected GrpcDocumentProcessorServiceStub(DocumentProcessorServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings processDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(processDocumentMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ProcessRequest>(){

            public Map<String, String> extract(ProcessRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings batchProcessDocumentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchProcessDocumentsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<BatchProcessRequest>(){

            public Map<String, String> extract(BatchProcessRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings fetchProcessorTypesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(fetchProcessorTypesMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<FetchProcessorTypesRequest>(){

            public Map<String, String> extract(FetchProcessorTypesRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listProcessorsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listProcessorsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListProcessorsRequest>(){

            public Map<String, String> extract(ListProcessorsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings createProcessorTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createProcessorMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateProcessorRequest>(){

            public Map<String, String> extract(CreateProcessorRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteProcessorTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteProcessorMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteProcessorRequest>(){

            public Map<String, String> extract(DeleteProcessorRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings enableProcessorTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(enableProcessorMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<EnableProcessorRequest>(){

            public Map<String, String> extract(EnableProcessorRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings disableProcessorTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(disableProcessorMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DisableProcessorRequest>(){

            public Map<String, String> extract(DisableProcessorRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings reviewDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(reviewDocumentMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ReviewDocumentRequest>(){

            public Map<String, String> extract(ReviewDocumentRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"human_review_config", (Object)String.valueOf(request.getHumanReviewConfig()));
                return params.build();
            }
        }).build();
        this.processDocumentCallable = callableFactory.createUnaryCallable(processDocumentTransportSettings, settings.processDocumentSettings(), clientContext);
        this.batchProcessDocumentsCallable = callableFactory.createUnaryCallable(batchProcessDocumentsTransportSettings, settings.batchProcessDocumentsSettings(), clientContext);
        this.batchProcessDocumentsOperationCallable = callableFactory.createOperationCallable(batchProcessDocumentsTransportSettings, settings.batchProcessDocumentsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.fetchProcessorTypesCallable = callableFactory.createUnaryCallable(fetchProcessorTypesTransportSettings, settings.fetchProcessorTypesSettings(), clientContext);
        this.listProcessorsCallable = callableFactory.createUnaryCallable(listProcessorsTransportSettings, settings.listProcessorsSettings(), clientContext);
        this.listProcessorsPagedCallable = callableFactory.createPagedCallable(listProcessorsTransportSettings, settings.listProcessorsSettings(), clientContext);
        this.createProcessorCallable = callableFactory.createUnaryCallable(createProcessorTransportSettings, settings.createProcessorSettings(), clientContext);
        this.deleteProcessorCallable = callableFactory.createUnaryCallable(deleteProcessorTransportSettings, settings.deleteProcessorSettings(), clientContext);
        this.deleteProcessorOperationCallable = callableFactory.createOperationCallable(deleteProcessorTransportSettings, settings.deleteProcessorOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.enableProcessorCallable = callableFactory.createUnaryCallable(enableProcessorTransportSettings, settings.enableProcessorSettings(), clientContext);
        this.enableProcessorOperationCallable = callableFactory.createOperationCallable(enableProcessorTransportSettings, settings.enableProcessorOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.disableProcessorCallable = callableFactory.createUnaryCallable(disableProcessorTransportSettings, settings.disableProcessorSettings(), clientContext);
        this.disableProcessorOperationCallable = callableFactory.createOperationCallable(disableProcessorTransportSettings, settings.disableProcessorOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.reviewDocumentCallable = callableFactory.createUnaryCallable(reviewDocumentTransportSettings, settings.reviewDocumentSettings(), clientContext);
        this.reviewDocumentOperationCallable = callableFactory.createOperationCallable(reviewDocumentTransportSettings, settings.reviewDocumentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ProcessRequest, ProcessResponse> processDocumentCallable() {
        return this.processDocumentCallable;
    }

    @Override
    public UnaryCallable<BatchProcessRequest, Operation> batchProcessDocumentsCallable() {
        return this.batchProcessDocumentsCallable;
    }

    @Override
    public OperationCallable<BatchProcessRequest, BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsOperationCallable() {
        return this.batchProcessDocumentsOperationCallable;
    }

    @Override
    public UnaryCallable<FetchProcessorTypesRequest, FetchProcessorTypesResponse> fetchProcessorTypesCallable() {
        return this.fetchProcessorTypesCallable;
    }

    @Override
    public UnaryCallable<ListProcessorsRequest, ListProcessorsResponse> listProcessorsCallable() {
        return this.listProcessorsCallable;
    }

    @Override
    public UnaryCallable<ListProcessorsRequest, DocumentProcessorServiceClient.ListProcessorsPagedResponse> listProcessorsPagedCallable() {
        return this.listProcessorsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateProcessorRequest, Processor> createProcessorCallable() {
        return this.createProcessorCallable;
    }

    @Override
    public UnaryCallable<DeleteProcessorRequest, Operation> deleteProcessorCallable() {
        return this.deleteProcessorCallable;
    }

    @Override
    public OperationCallable<DeleteProcessorRequest, Empty, DeleteProcessorMetadata> deleteProcessorOperationCallable() {
        return this.deleteProcessorOperationCallable;
    }

    @Override
    public UnaryCallable<EnableProcessorRequest, Operation> enableProcessorCallable() {
        return this.enableProcessorCallable;
    }

    @Override
    public OperationCallable<EnableProcessorRequest, EnableProcessorResponse, EnableProcessorMetadata> enableProcessorOperationCallable() {
        return this.enableProcessorOperationCallable;
    }

    @Override
    public UnaryCallable<DisableProcessorRequest, Operation> disableProcessorCallable() {
        return this.disableProcessorCallable;
    }

    @Override
    public OperationCallable<DisableProcessorRequest, DisableProcessorResponse, DisableProcessorMetadata> disableProcessorOperationCallable() {
        return this.disableProcessorOperationCallable;
    }

    @Override
    public UnaryCallable<ReviewDocumentRequest, Operation> reviewDocumentCallable() {
        return this.reviewDocumentCallable;
    }

    @Override
    public OperationCallable<ReviewDocumentRequest, ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentOperationCallable() {
        return this.reviewDocumentOperationCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

