/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.documentai.v1beta1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.documentai.v1beta1.BatchProcessDocumentsRequest;
import com.google.cloud.documentai.v1beta1.BatchProcessDocumentsResponse;
import com.google.cloud.documentai.v1beta1.OperationMetadata;
import com.google.cloud.documentai.v1beta1.stub.DocumentUnderstandingServiceStub;
import com.google.cloud.documentai.v1beta1.stub.DocumentUnderstandingServiceStubSettings;
import com.google.cloud.documentai.v1beta1.stub.GrpcDocumentUnderstandingServiceCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcDocumentUnderstandingServiceStub
extends DocumentUnderstandingServiceStub {
    private static final MethodDescriptor<BatchProcessDocumentsRequest, Operation> batchProcessDocumentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.documentai.v1beta1.DocumentUnderstandingService/BatchProcessDocuments").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchProcessDocumentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<BatchProcessDocumentsRequest, Operation> batchProcessDocumentsCallable;
    private final OperationCallable<BatchProcessDocumentsRequest, BatchProcessDocumentsResponse, OperationMetadata> batchProcessDocumentsOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDocumentUnderstandingServiceStub create(DocumentUnderstandingServiceStubSettings settings) throws IOException {
        return new GrpcDocumentUnderstandingServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDocumentUnderstandingServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcDocumentUnderstandingServiceStub(DocumentUnderstandingServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDocumentUnderstandingServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDocumentUnderstandingServiceStub(DocumentUnderstandingServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDocumentUnderstandingServiceStub(DocumentUnderstandingServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDocumentUnderstandingServiceCallableFactory());
    }

    protected GrpcDocumentUnderstandingServiceStub(DocumentUnderstandingServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings batchProcessDocumentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchProcessDocumentsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<BatchProcessDocumentsRequest>(){

            public Map<String, String> extract(BatchProcessDocumentsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        this.batchProcessDocumentsCallable = callableFactory.createUnaryCallable(batchProcessDocumentsTransportSettings, settings.batchProcessDocumentsSettings(), clientContext);
        this.batchProcessDocumentsOperationCallable = callableFactory.createOperationCallable(batchProcessDocumentsTransportSettings, settings.batchProcessDocumentsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<BatchProcessDocumentsRequest, Operation> batchProcessDocumentsCallable() {
        return this.batchProcessDocumentsCallable;
    }

    @Override
    public OperationCallable<BatchProcessDocumentsRequest, BatchProcessDocumentsResponse, OperationMetadata> batchProcessDocumentsOperationCallable() {
        return this.batchProcessDocumentsOperationCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

