/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dns.spi.v1;

import com.google.api.services.dns.model.Change;
import com.google.api.services.dns.model.ManagedZone;
import com.google.api.services.dns.model.Project;
import com.google.api.services.dns.model.ResourceRecordSet;
import com.google.cloud.ServiceRpc;
import com.google.cloud.dns.DnsException;
import com.google.cloud.dns.spi.v1.RpcBatch;
import com.google.common.collect.ImmutableList;
import java.util.Map;

public interface DnsRpc
extends ServiceRpc {
    public ManagedZone create(ManagedZone var1, Map<Option, ?> var2) throws DnsException;

    public ManagedZone getZone(String var1, Map<Option, ?> var2) throws DnsException;

    public ListResult<ManagedZone> listZones(Map<Option, ?> var1) throws DnsException;

    public boolean deleteZone(String var1) throws DnsException;

    public ListResult<ResourceRecordSet> listRecordSets(String var1, Map<Option, ?> var2) throws DnsException;

    public Project getProject(Map<Option, ?> var1) throws DnsException;

    public Change applyChangeRequest(String var1, Change var2, Map<Option, ?> var3) throws DnsException;

    public Change getChangeRequest(String var1, String var2, Map<Option, ?> var3) throws DnsException;

    public ListResult<Change> listChangeRequests(String var1, Map<Option, ?> var2) throws DnsException;

    public RpcBatch createBatch();

    public static class ListResult<T> {
        private final Iterable<T> results;
        private final String pageToken;

        public ListResult(String pageToken, Iterable<T> results) {
            this.results = ImmutableList.copyOf(results);
            this.pageToken = pageToken;
        }

        public static <T> ListResult<T> of(String pageToken, Iterable<T> list) {
            return new ListResult<T>(pageToken, list);
        }

        public Iterable<T> results() {
            return this.results;
        }

        public String pageToken() {
            return this.pageToken;
        }
    }

    public static enum Option {
        FIELDS("fields"),
        PAGE_SIZE("maxResults"),
        PAGE_TOKEN("pageToken"),
        DNS_NAME("dnsName"),
        NAME("name"),
        DNS_TYPE("type"),
        SORTING_ORDER("sortOrder");

        private final String value;

        private Option(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        <T> T get(Map<Option, ?> options) {
            return (T)options.get((Object)this);
        }

        String getString(Map<Option, ?> options) {
            return (String)this.get(options);
        }

        Integer getInt(Map<Option, ?> options) {
            return (Integer)this.get(options);
        }
    }
}

