/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dns;

import com.google.cloud.HttpServiceOptions;
import com.google.cloud.dns.Dns;
import com.google.cloud.dns.DnsFactory;
import com.google.cloud.dns.DnsImpl;
import com.google.cloud.dns.spi.DefaultDnsRpc;
import com.google.cloud.dns.spi.DnsRpc;
import com.google.cloud.dns.spi.DnsRpcFactory;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class DnsOptions
extends HttpServiceOptions<Dns, DnsRpc, DnsOptions> {
    private static final long serialVersionUID = -2501790264435912627L;
    private static final String GC_DNS_RW = "https://www.googleapis.com/auth/ndev.clouddns.readwrite";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/ndev.clouddns.readwrite");

    private DnsOptions(Builder builder) {
        super(DnsFactory.class, DnsRpcFactory.class, (HttpServiceOptions.Builder)builder);
    }

    protected DnsFactory getDefaultServiceFactory() {
        return DefaultDnsFactory.INSTANCE;
    }

    protected DnsRpcFactory getDefaultRpcFactory() {
        return DefaultDnsRpcFactory.INSTANCE;
    }

    protected Set<String> getScopes() {
        return SCOPES;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Deprecated
    public static Builder builder() {
        return DnsOptions.newBuilder();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Deprecated
    public static DnsOptions defaultInstance() {
        return DnsOptions.getDefaultInstance();
    }

    public static DnsOptions getDefaultInstance() {
        return DnsOptions.newBuilder().build();
    }

    public boolean equals(Object obj) {
        return obj instanceof DnsOptions && this.baseEquals((DnsOptions)((Object)obj));
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    public static class Builder
    extends HttpServiceOptions.Builder<Dns, DnsRpc, DnsOptions, Builder> {
        private Builder() {
        }

        private Builder(DnsOptions options) {
            super((HttpServiceOptions)options);
        }

        public DnsOptions build() {
            return new DnsOptions(this);
        }
    }

    public static class DefaultDnsRpcFactory
    implements DnsRpcFactory {
        private static final DnsRpcFactory INSTANCE = new DefaultDnsRpcFactory();

        public DnsRpc create(DnsOptions options) {
            return new DefaultDnsRpc(options);
        }
    }

    public static class DefaultDnsFactory
    implements DnsFactory {
        private static final DnsFactory INSTANCE = new DefaultDnsFactory();

        public Dns create(DnsOptions options) {
            return new DnsImpl(options);
        }
    }
}

