/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.clouddms.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.clouddms.v1.ConnectionProfile;
import com.google.cloud.clouddms.v1.ConnectionProfileName;
import com.google.cloud.clouddms.v1.CreateConnectionProfileRequest;
import com.google.cloud.clouddms.v1.CreateMigrationJobRequest;
import com.google.cloud.clouddms.v1.DataMigrationServiceSettings;
import com.google.cloud.clouddms.v1.DeleteConnectionProfileRequest;
import com.google.cloud.clouddms.v1.DeleteMigrationJobRequest;
import com.google.cloud.clouddms.v1.GenerateSshScriptRequest;
import com.google.cloud.clouddms.v1.GetConnectionProfileRequest;
import com.google.cloud.clouddms.v1.GetMigrationJobRequest;
import com.google.cloud.clouddms.v1.ListConnectionProfilesRequest;
import com.google.cloud.clouddms.v1.ListConnectionProfilesResponse;
import com.google.cloud.clouddms.v1.ListMigrationJobsRequest;
import com.google.cloud.clouddms.v1.ListMigrationJobsResponse;
import com.google.cloud.clouddms.v1.LocationName;
import com.google.cloud.clouddms.v1.MigrationJob;
import com.google.cloud.clouddms.v1.MigrationJobName;
import com.google.cloud.clouddms.v1.OperationMetadata;
import com.google.cloud.clouddms.v1.PromoteMigrationJobRequest;
import com.google.cloud.clouddms.v1.RestartMigrationJobRequest;
import com.google.cloud.clouddms.v1.ResumeMigrationJobRequest;
import com.google.cloud.clouddms.v1.SshScript;
import com.google.cloud.clouddms.v1.StartMigrationJobRequest;
import com.google.cloud.clouddms.v1.StopMigrationJobRequest;
import com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest;
import com.google.cloud.clouddms.v1.UpdateMigrationJobRequest;
import com.google.cloud.clouddms.v1.VerifyMigrationJobRequest;
import com.google.cloud.clouddms.v1.stub.DataMigrationServiceStub;
import com.google.cloud.clouddms.v1.stub.DataMigrationServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DataMigrationServiceClient
implements BackgroundResource {
    private final DataMigrationServiceSettings settings;
    private final DataMigrationServiceStub stub;
    private final OperationsClient operationsClient;

    public static final DataMigrationServiceClient create() throws IOException {
        return DataMigrationServiceClient.create(DataMigrationServiceSettings.newBuilder().build());
    }

    public static final DataMigrationServiceClient create(DataMigrationServiceSettings settings) throws IOException {
        return new DataMigrationServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final DataMigrationServiceClient create(DataMigrationServiceStub stub) {
        return new DataMigrationServiceClient(stub);
    }

    protected DataMigrationServiceClient(DataMigrationServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DataMigrationServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected DataMigrationServiceClient(DataMigrationServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final DataMigrationServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DataMigrationServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListMigrationJobsPagedResponse listMigrationJobs(LocationName parent) {
        ListMigrationJobsRequest request = ListMigrationJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMigrationJobs(request);
    }

    public final ListMigrationJobsPagedResponse listMigrationJobs(String parent) {
        ListMigrationJobsRequest request = ListMigrationJobsRequest.newBuilder().setParent(parent).build();
        return this.listMigrationJobs(request);
    }

    public final ListMigrationJobsPagedResponse listMigrationJobs(ListMigrationJobsRequest request) {
        return (ListMigrationJobsPagedResponse)((Object)this.listMigrationJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMigrationJobsRequest, ListMigrationJobsPagedResponse> listMigrationJobsPagedCallable() {
        return this.stub.listMigrationJobsPagedCallable();
    }

    public final UnaryCallable<ListMigrationJobsRequest, ListMigrationJobsResponse> listMigrationJobsCallable() {
        return this.stub.listMigrationJobsCallable();
    }

    public final MigrationJob getMigrationJob(MigrationJobName name) {
        GetMigrationJobRequest request = GetMigrationJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMigrationJob(request);
    }

    public final MigrationJob getMigrationJob(String name) {
        GetMigrationJobRequest request = GetMigrationJobRequest.newBuilder().setName(name).build();
        return this.getMigrationJob(request);
    }

    public final MigrationJob getMigrationJob(GetMigrationJobRequest request) {
        return (MigrationJob)this.getMigrationJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetMigrationJobRequest, MigrationJob> getMigrationJobCallable() {
        return this.stub.getMigrationJobCallable();
    }

    public final OperationFuture<MigrationJob, OperationMetadata> createMigrationJobAsync(LocationName parent, MigrationJob migrationJob, String migrationJobId) {
        CreateMigrationJobRequest request = CreateMigrationJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setMigrationJob(migrationJob).setMigrationJobId(migrationJobId).build();
        return this.createMigrationJobAsync(request);
    }

    public final OperationFuture<MigrationJob, OperationMetadata> createMigrationJobAsync(String parent, MigrationJob migrationJob, String migrationJobId) {
        CreateMigrationJobRequest request = CreateMigrationJobRequest.newBuilder().setParent(parent).setMigrationJob(migrationJob).setMigrationJobId(migrationJobId).build();
        return this.createMigrationJobAsync(request);
    }

    public final OperationFuture<MigrationJob, OperationMetadata> createMigrationJobAsync(CreateMigrationJobRequest request) {
        return this.createMigrationJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateMigrationJobRequest, MigrationJob, OperationMetadata> createMigrationJobOperationCallable() {
        return this.stub.createMigrationJobOperationCallable();
    }

    public final UnaryCallable<CreateMigrationJobRequest, Operation> createMigrationJobCallable() {
        return this.stub.createMigrationJobCallable();
    }

    public final OperationFuture<MigrationJob, OperationMetadata> updateMigrationJobAsync(MigrationJob migrationJob, FieldMask updateMask) {
        UpdateMigrationJobRequest request = UpdateMigrationJobRequest.newBuilder().setMigrationJob(migrationJob).setUpdateMask(updateMask).build();
        return this.updateMigrationJobAsync(request);
    }

    public final OperationFuture<MigrationJob, OperationMetadata> updateMigrationJobAsync(UpdateMigrationJobRequest request) {
        return this.updateMigrationJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateMigrationJobRequest, MigrationJob, OperationMetadata> updateMigrationJobOperationCallable() {
        return this.stub.updateMigrationJobOperationCallable();
    }

    public final UnaryCallable<UpdateMigrationJobRequest, Operation> updateMigrationJobCallable() {
        return this.stub.updateMigrationJobCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMigrationJobAsync(MigrationJobName name) {
        DeleteMigrationJobRequest request = DeleteMigrationJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteMigrationJobAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMigrationJobAsync(String name) {
        DeleteMigrationJobRequest request = DeleteMigrationJobRequest.newBuilder().setName(name).build();
        return this.deleteMigrationJobAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMigrationJobAsync(DeleteMigrationJobRequest request) {
        return this.deleteMigrationJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteMigrationJobRequest, Empty, OperationMetadata> deleteMigrationJobOperationCallable() {
        return this.stub.deleteMigrationJobOperationCallable();
    }

    public final UnaryCallable<DeleteMigrationJobRequest, Operation> deleteMigrationJobCallable() {
        return this.stub.deleteMigrationJobCallable();
    }

    public final OperationFuture<MigrationJob, OperationMetadata> startMigrationJobAsync(StartMigrationJobRequest request) {
        return this.startMigrationJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StartMigrationJobRequest, MigrationJob, OperationMetadata> startMigrationJobOperationCallable() {
        return this.stub.startMigrationJobOperationCallable();
    }

    public final UnaryCallable<StartMigrationJobRequest, Operation> startMigrationJobCallable() {
        return this.stub.startMigrationJobCallable();
    }

    public final OperationFuture<MigrationJob, OperationMetadata> stopMigrationJobAsync(StopMigrationJobRequest request) {
        return this.stopMigrationJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StopMigrationJobRequest, MigrationJob, OperationMetadata> stopMigrationJobOperationCallable() {
        return this.stub.stopMigrationJobOperationCallable();
    }

    public final UnaryCallable<StopMigrationJobRequest, Operation> stopMigrationJobCallable() {
        return this.stub.stopMigrationJobCallable();
    }

    public final OperationFuture<MigrationJob, OperationMetadata> resumeMigrationJobAsync(ResumeMigrationJobRequest request) {
        return this.resumeMigrationJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ResumeMigrationJobRequest, MigrationJob, OperationMetadata> resumeMigrationJobOperationCallable() {
        return this.stub.resumeMigrationJobOperationCallable();
    }

    public final UnaryCallable<ResumeMigrationJobRequest, Operation> resumeMigrationJobCallable() {
        return this.stub.resumeMigrationJobCallable();
    }

    public final OperationFuture<MigrationJob, OperationMetadata> promoteMigrationJobAsync(PromoteMigrationJobRequest request) {
        return this.promoteMigrationJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PromoteMigrationJobRequest, MigrationJob, OperationMetadata> promoteMigrationJobOperationCallable() {
        return this.stub.promoteMigrationJobOperationCallable();
    }

    public final UnaryCallable<PromoteMigrationJobRequest, Operation> promoteMigrationJobCallable() {
        return this.stub.promoteMigrationJobCallable();
    }

    public final OperationFuture<MigrationJob, OperationMetadata> verifyMigrationJobAsync(VerifyMigrationJobRequest request) {
        return this.verifyMigrationJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<VerifyMigrationJobRequest, MigrationJob, OperationMetadata> verifyMigrationJobOperationCallable() {
        return this.stub.verifyMigrationJobOperationCallable();
    }

    public final UnaryCallable<VerifyMigrationJobRequest, Operation> verifyMigrationJobCallable() {
        return this.stub.verifyMigrationJobCallable();
    }

    public final OperationFuture<MigrationJob, OperationMetadata> restartMigrationJobAsync(RestartMigrationJobRequest request) {
        return this.restartMigrationJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RestartMigrationJobRequest, MigrationJob, OperationMetadata> restartMigrationJobOperationCallable() {
        return this.stub.restartMigrationJobOperationCallable();
    }

    public final UnaryCallable<RestartMigrationJobRequest, Operation> restartMigrationJobCallable() {
        return this.stub.restartMigrationJobCallable();
    }

    public final SshScript generateSshScript(GenerateSshScriptRequest request) {
        return (SshScript)this.generateSshScriptCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateSshScriptRequest, SshScript> generateSshScriptCallable() {
        return this.stub.generateSshScriptCallable();
    }

    public final ListConnectionProfilesPagedResponse listConnectionProfiles(LocationName parent) {
        ListConnectionProfilesRequest request = ListConnectionProfilesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConnectionProfiles(request);
    }

    public final ListConnectionProfilesPagedResponse listConnectionProfiles(String parent) {
        ListConnectionProfilesRequest request = ListConnectionProfilesRequest.newBuilder().setParent(parent).build();
        return this.listConnectionProfiles(request);
    }

    public final ListConnectionProfilesPagedResponse listConnectionProfiles(ListConnectionProfilesRequest request) {
        return (ListConnectionProfilesPagedResponse)((Object)this.listConnectionProfilesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConnectionProfilesRequest, ListConnectionProfilesPagedResponse> listConnectionProfilesPagedCallable() {
        return this.stub.listConnectionProfilesPagedCallable();
    }

    public final UnaryCallable<ListConnectionProfilesRequest, ListConnectionProfilesResponse> listConnectionProfilesCallable() {
        return this.stub.listConnectionProfilesCallable();
    }

    public final ConnectionProfile getConnectionProfile(ConnectionProfileName name) {
        GetConnectionProfileRequest request = GetConnectionProfileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConnectionProfile(request);
    }

    public final ConnectionProfile getConnectionProfile(String name) {
        GetConnectionProfileRequest request = GetConnectionProfileRequest.newBuilder().setName(name).build();
        return this.getConnectionProfile(request);
    }

    public final ConnectionProfile getConnectionProfile(GetConnectionProfileRequest request) {
        return (ConnectionProfile)this.getConnectionProfileCallable().call((Object)request);
    }

    public final UnaryCallable<GetConnectionProfileRequest, ConnectionProfile> getConnectionProfileCallable() {
        return this.stub.getConnectionProfileCallable();
    }

    public final OperationFuture<ConnectionProfile, OperationMetadata> createConnectionProfileAsync(ConnectionProfileName parent, ConnectionProfile connectionProfile, String connectionProfileId) {
        CreateConnectionProfileRequest request = CreateConnectionProfileRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConnectionProfile(connectionProfile).setConnectionProfileId(connectionProfileId).build();
        return this.createConnectionProfileAsync(request);
    }

    public final OperationFuture<ConnectionProfile, OperationMetadata> createConnectionProfileAsync(String parent, ConnectionProfile connectionProfile, String connectionProfileId) {
        CreateConnectionProfileRequest request = CreateConnectionProfileRequest.newBuilder().setParent(parent).setConnectionProfile(connectionProfile).setConnectionProfileId(connectionProfileId).build();
        return this.createConnectionProfileAsync(request);
    }

    public final OperationFuture<ConnectionProfile, OperationMetadata> createConnectionProfileAsync(CreateConnectionProfileRequest request) {
        return this.createConnectionProfileOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateConnectionProfileRequest, ConnectionProfile, OperationMetadata> createConnectionProfileOperationCallable() {
        return this.stub.createConnectionProfileOperationCallable();
    }

    public final UnaryCallable<CreateConnectionProfileRequest, Operation> createConnectionProfileCallable() {
        return this.stub.createConnectionProfileCallable();
    }

    public final OperationFuture<ConnectionProfile, OperationMetadata> updateConnectionProfileAsync(ConnectionProfile connectionProfile, FieldMask updateMask) {
        UpdateConnectionProfileRequest request = UpdateConnectionProfileRequest.newBuilder().setConnectionProfile(connectionProfile).setUpdateMask(updateMask).build();
        return this.updateConnectionProfileAsync(request);
    }

    public final OperationFuture<ConnectionProfile, OperationMetadata> updateConnectionProfileAsync(UpdateConnectionProfileRequest request) {
        return this.updateConnectionProfileOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateConnectionProfileRequest, ConnectionProfile, OperationMetadata> updateConnectionProfileOperationCallable() {
        return this.stub.updateConnectionProfileOperationCallable();
    }

    public final UnaryCallable<UpdateConnectionProfileRequest, Operation> updateConnectionProfileCallable() {
        return this.stub.updateConnectionProfileCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConnectionProfileAsync(ConnectionProfileName name) {
        DeleteConnectionProfileRequest request = DeleteConnectionProfileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteConnectionProfileAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConnectionProfileAsync(String name) {
        DeleteConnectionProfileRequest request = DeleteConnectionProfileRequest.newBuilder().setName(name).build();
        return this.deleteConnectionProfileAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConnectionProfileAsync(DeleteConnectionProfileRequest request) {
        return this.deleteConnectionProfileOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteConnectionProfileRequest, Empty, OperationMetadata> deleteConnectionProfileOperationCallable() {
        return this.stub.deleteConnectionProfileOperationCallable();
    }

    public final UnaryCallable<DeleteConnectionProfileRequest, Operation> deleteConnectionProfileCallable() {
        return this.stub.deleteConnectionProfileCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListConnectionProfilesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile, ListConnectionProfilesPage, ListConnectionProfilesFixedSizeCollection> {
        private ListConnectionProfilesFixedSizeCollection(List<ListConnectionProfilesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConnectionProfilesFixedSizeCollection createEmptyCollection() {
            return new ListConnectionProfilesFixedSizeCollection(null, 0);
        }

        protected ListConnectionProfilesFixedSizeCollection createCollection(List<ListConnectionProfilesPage> pages, int collectionSize) {
            return new ListConnectionProfilesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConnectionProfilesPage
    extends AbstractPage<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile, ListConnectionProfilesPage> {
        private ListConnectionProfilesPage(PageContext<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile> context, ListConnectionProfilesResponse response) {
            super(context, (Object)response);
        }

        private static ListConnectionProfilesPage createEmptyPage() {
            return new ListConnectionProfilesPage(null, null);
        }

        protected ListConnectionProfilesPage createPage(PageContext<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile> context, ListConnectionProfilesResponse response) {
            return new ListConnectionProfilesPage(context, response);
        }

        public ApiFuture<ListConnectionProfilesPage> createPageAsync(PageContext<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile> context, ApiFuture<ListConnectionProfilesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConnectionProfilesPagedResponse
    extends AbstractPagedListResponse<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile, ListConnectionProfilesPage, ListConnectionProfilesFixedSizeCollection> {
        public static ApiFuture<ListConnectionProfilesPagedResponse> createAsync(PageContext<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile> context, ApiFuture<ListConnectionProfilesResponse> futureResponse) {
            ApiFuture<ListConnectionProfilesPage> futurePage = ListConnectionProfilesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListConnectionProfilesPage, ListConnectionProfilesPagedResponse>(){

                public ListConnectionProfilesPagedResponse apply(ListConnectionProfilesPage input) {
                    return new ListConnectionProfilesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListConnectionProfilesPagedResponse(ListConnectionProfilesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConnectionProfilesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMigrationJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMigrationJobsRequest, ListMigrationJobsResponse, MigrationJob, ListMigrationJobsPage, ListMigrationJobsFixedSizeCollection> {
        private ListMigrationJobsFixedSizeCollection(List<ListMigrationJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMigrationJobsFixedSizeCollection createEmptyCollection() {
            return new ListMigrationJobsFixedSizeCollection(null, 0);
        }

        protected ListMigrationJobsFixedSizeCollection createCollection(List<ListMigrationJobsPage> pages, int collectionSize) {
            return new ListMigrationJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMigrationJobsPage
    extends AbstractPage<ListMigrationJobsRequest, ListMigrationJobsResponse, MigrationJob, ListMigrationJobsPage> {
        private ListMigrationJobsPage(PageContext<ListMigrationJobsRequest, ListMigrationJobsResponse, MigrationJob> context, ListMigrationJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListMigrationJobsPage createEmptyPage() {
            return new ListMigrationJobsPage(null, null);
        }

        protected ListMigrationJobsPage createPage(PageContext<ListMigrationJobsRequest, ListMigrationJobsResponse, MigrationJob> context, ListMigrationJobsResponse response) {
            return new ListMigrationJobsPage(context, response);
        }

        public ApiFuture<ListMigrationJobsPage> createPageAsync(PageContext<ListMigrationJobsRequest, ListMigrationJobsResponse, MigrationJob> context, ApiFuture<ListMigrationJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMigrationJobsPagedResponse
    extends AbstractPagedListResponse<ListMigrationJobsRequest, ListMigrationJobsResponse, MigrationJob, ListMigrationJobsPage, ListMigrationJobsFixedSizeCollection> {
        public static ApiFuture<ListMigrationJobsPagedResponse> createAsync(PageContext<ListMigrationJobsRequest, ListMigrationJobsResponse, MigrationJob> context, ApiFuture<ListMigrationJobsResponse> futureResponse) {
            ApiFuture<ListMigrationJobsPage> futurePage = ListMigrationJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListMigrationJobsPage, ListMigrationJobsPagedResponse>(){

                public ListMigrationJobsPagedResponse apply(ListMigrationJobsPage input) {
                    return new ListMigrationJobsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListMigrationJobsPagedResponse(ListMigrationJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMigrationJobsFixedSizeCollection.createEmptyCollection());
        }
    }
}

