/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dlp.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dlp.v2.DlpServiceClient;
import com.google.cloud.dlp.v2.stub.DlpServiceStub;
import com.google.cloud.dlp.v2.stub.GrpcDlpServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.privacy.dlp.v2.CancelDlpJobRequest;
import com.google.privacy.dlp.v2.CreateDeidentifyTemplateRequest;
import com.google.privacy.dlp.v2.CreateDlpJobRequest;
import com.google.privacy.dlp.v2.CreateInspectTemplateRequest;
import com.google.privacy.dlp.v2.CreateJobTriggerRequest;
import com.google.privacy.dlp.v2.CreateStoredInfoTypeRequest;
import com.google.privacy.dlp.v2.DeidentifyContentRequest;
import com.google.privacy.dlp.v2.DeidentifyContentResponse;
import com.google.privacy.dlp.v2.DeidentifyTemplate;
import com.google.privacy.dlp.v2.DeleteDeidentifyTemplateRequest;
import com.google.privacy.dlp.v2.DeleteDlpJobRequest;
import com.google.privacy.dlp.v2.DeleteInspectTemplateRequest;
import com.google.privacy.dlp.v2.DeleteJobTriggerRequest;
import com.google.privacy.dlp.v2.DeleteStoredInfoTypeRequest;
import com.google.privacy.dlp.v2.DlpJob;
import com.google.privacy.dlp.v2.FinishDlpJobRequest;
import com.google.privacy.dlp.v2.GetDeidentifyTemplateRequest;
import com.google.privacy.dlp.v2.GetDlpJobRequest;
import com.google.privacy.dlp.v2.GetInspectTemplateRequest;
import com.google.privacy.dlp.v2.GetJobTriggerRequest;
import com.google.privacy.dlp.v2.GetStoredInfoTypeRequest;
import com.google.privacy.dlp.v2.HybridInspectDlpJobRequest;
import com.google.privacy.dlp.v2.HybridInspectJobTriggerRequest;
import com.google.privacy.dlp.v2.HybridInspectResponse;
import com.google.privacy.dlp.v2.InspectContentRequest;
import com.google.privacy.dlp.v2.InspectContentResponse;
import com.google.privacy.dlp.v2.InspectTemplate;
import com.google.privacy.dlp.v2.JobTrigger;
import com.google.privacy.dlp.v2.ListDeidentifyTemplatesRequest;
import com.google.privacy.dlp.v2.ListDeidentifyTemplatesResponse;
import com.google.privacy.dlp.v2.ListDlpJobsRequest;
import com.google.privacy.dlp.v2.ListDlpJobsResponse;
import com.google.privacy.dlp.v2.ListInfoTypesRequest;
import com.google.privacy.dlp.v2.ListInfoTypesResponse;
import com.google.privacy.dlp.v2.ListInspectTemplatesRequest;
import com.google.privacy.dlp.v2.ListInspectTemplatesResponse;
import com.google.privacy.dlp.v2.ListJobTriggersRequest;
import com.google.privacy.dlp.v2.ListJobTriggersResponse;
import com.google.privacy.dlp.v2.ListStoredInfoTypesRequest;
import com.google.privacy.dlp.v2.ListStoredInfoTypesResponse;
import com.google.privacy.dlp.v2.RedactImageRequest;
import com.google.privacy.dlp.v2.RedactImageResponse;
import com.google.privacy.dlp.v2.ReidentifyContentRequest;
import com.google.privacy.dlp.v2.ReidentifyContentResponse;
import com.google.privacy.dlp.v2.StoredInfoType;
import com.google.privacy.dlp.v2.UpdateDeidentifyTemplateRequest;
import com.google.privacy.dlp.v2.UpdateInspectTemplateRequest;
import com.google.privacy.dlp.v2.UpdateJobTriggerRequest;
import com.google.privacy.dlp.v2.UpdateStoredInfoTypeRequest;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class DlpServiceStubSettings
extends StubSettings<DlpServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<InspectContentRequest, InspectContentResponse> inspectContentSettings;
    private final UnaryCallSettings<RedactImageRequest, RedactImageResponse> redactImageSettings;
    private final UnaryCallSettings<DeidentifyContentRequest, DeidentifyContentResponse> deidentifyContentSettings;
    private final UnaryCallSettings<ReidentifyContentRequest, ReidentifyContentResponse> reidentifyContentSettings;
    private final UnaryCallSettings<ListInfoTypesRequest, ListInfoTypesResponse> listInfoTypesSettings;
    private final UnaryCallSettings<CreateInspectTemplateRequest, InspectTemplate> createInspectTemplateSettings;
    private final UnaryCallSettings<UpdateInspectTemplateRequest, InspectTemplate> updateInspectTemplateSettings;
    private final UnaryCallSettings<GetInspectTemplateRequest, InspectTemplate> getInspectTemplateSettings;
    private final PagedCallSettings<ListInspectTemplatesRequest, ListInspectTemplatesResponse, DlpServiceClient.ListInspectTemplatesPagedResponse> listInspectTemplatesSettings;
    private final UnaryCallSettings<DeleteInspectTemplateRequest, Empty> deleteInspectTemplateSettings;
    private final UnaryCallSettings<CreateDeidentifyTemplateRequest, DeidentifyTemplate> createDeidentifyTemplateSettings;
    private final UnaryCallSettings<UpdateDeidentifyTemplateRequest, DeidentifyTemplate> updateDeidentifyTemplateSettings;
    private final UnaryCallSettings<GetDeidentifyTemplateRequest, DeidentifyTemplate> getDeidentifyTemplateSettings;
    private final PagedCallSettings<ListDeidentifyTemplatesRequest, ListDeidentifyTemplatesResponse, DlpServiceClient.ListDeidentifyTemplatesPagedResponse> listDeidentifyTemplatesSettings;
    private final UnaryCallSettings<DeleteDeidentifyTemplateRequest, Empty> deleteDeidentifyTemplateSettings;
    private final UnaryCallSettings<CreateJobTriggerRequest, JobTrigger> createJobTriggerSettings;
    private final UnaryCallSettings<UpdateJobTriggerRequest, JobTrigger> updateJobTriggerSettings;
    private final UnaryCallSettings<HybridInspectJobTriggerRequest, HybridInspectResponse> hybridInspectJobTriggerSettings;
    private final UnaryCallSettings<GetJobTriggerRequest, JobTrigger> getJobTriggerSettings;
    private final PagedCallSettings<ListJobTriggersRequest, ListJobTriggersResponse, DlpServiceClient.ListJobTriggersPagedResponse> listJobTriggersSettings;
    private final UnaryCallSettings<DeleteJobTriggerRequest, Empty> deleteJobTriggerSettings;
    private final UnaryCallSettings<CreateDlpJobRequest, DlpJob> createDlpJobSettings;
    private final PagedCallSettings<ListDlpJobsRequest, ListDlpJobsResponse, DlpServiceClient.ListDlpJobsPagedResponse> listDlpJobsSettings;
    private final UnaryCallSettings<GetDlpJobRequest, DlpJob> getDlpJobSettings;
    private final UnaryCallSettings<DeleteDlpJobRequest, Empty> deleteDlpJobSettings;
    private final UnaryCallSettings<CancelDlpJobRequest, Empty> cancelDlpJobSettings;
    private final UnaryCallSettings<CreateStoredInfoTypeRequest, StoredInfoType> createStoredInfoTypeSettings;
    private final UnaryCallSettings<UpdateStoredInfoTypeRequest, StoredInfoType> updateStoredInfoTypeSettings;
    private final UnaryCallSettings<GetStoredInfoTypeRequest, StoredInfoType> getStoredInfoTypeSettings;
    private final PagedCallSettings<ListStoredInfoTypesRequest, ListStoredInfoTypesResponse, DlpServiceClient.ListStoredInfoTypesPagedResponse> listStoredInfoTypesSettings;
    private final UnaryCallSettings<DeleteStoredInfoTypeRequest, Empty> deleteStoredInfoTypeSettings;
    private final UnaryCallSettings<HybridInspectDlpJobRequest, HybridInspectResponse> hybridInspectDlpJobSettings;
    private final UnaryCallSettings<FinishDlpJobRequest, Empty> finishDlpJobSettings;
    private static final PagedListDescriptor<ListInspectTemplatesRequest, ListInspectTemplatesResponse, InspectTemplate> LIST_INSPECT_TEMPLATES_PAGE_STR_DESC = new PagedListDescriptor<ListInspectTemplatesRequest, ListInspectTemplatesResponse, InspectTemplate>(){

        public String emptyToken() {
            return "";
        }

        public ListInspectTemplatesRequest injectToken(ListInspectTemplatesRequest payload, String token) {
            return ListInspectTemplatesRequest.newBuilder((ListInspectTemplatesRequest)payload).setPageToken(token).build();
        }

        public ListInspectTemplatesRequest injectPageSize(ListInspectTemplatesRequest payload, int pageSize) {
            return ListInspectTemplatesRequest.newBuilder((ListInspectTemplatesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListInspectTemplatesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListInspectTemplatesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InspectTemplate> extractResources(ListInspectTemplatesResponse payload) {
            return payload.getInspectTemplatesList() != null ? payload.getInspectTemplatesList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListDeidentifyTemplatesRequest, ListDeidentifyTemplatesResponse, DeidentifyTemplate> LIST_DEIDENTIFY_TEMPLATES_PAGE_STR_DESC = new PagedListDescriptor<ListDeidentifyTemplatesRequest, ListDeidentifyTemplatesResponse, DeidentifyTemplate>(){

        public String emptyToken() {
            return "";
        }

        public ListDeidentifyTemplatesRequest injectToken(ListDeidentifyTemplatesRequest payload, String token) {
            return ListDeidentifyTemplatesRequest.newBuilder((ListDeidentifyTemplatesRequest)payload).setPageToken(token).build();
        }

        public ListDeidentifyTemplatesRequest injectPageSize(ListDeidentifyTemplatesRequest payload, int pageSize) {
            return ListDeidentifyTemplatesRequest.newBuilder((ListDeidentifyTemplatesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDeidentifyTemplatesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDeidentifyTemplatesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DeidentifyTemplate> extractResources(ListDeidentifyTemplatesResponse payload) {
            return payload.getDeidentifyTemplatesList() != null ? payload.getDeidentifyTemplatesList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListJobTriggersRequest, ListJobTriggersResponse, JobTrigger> LIST_JOB_TRIGGERS_PAGE_STR_DESC = new PagedListDescriptor<ListJobTriggersRequest, ListJobTriggersResponse, JobTrigger>(){

        public String emptyToken() {
            return "";
        }

        public ListJobTriggersRequest injectToken(ListJobTriggersRequest payload, String token) {
            return ListJobTriggersRequest.newBuilder((ListJobTriggersRequest)payload).setPageToken(token).build();
        }

        public ListJobTriggersRequest injectPageSize(ListJobTriggersRequest payload, int pageSize) {
            return ListJobTriggersRequest.newBuilder((ListJobTriggersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListJobTriggersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListJobTriggersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<JobTrigger> extractResources(ListJobTriggersResponse payload) {
            return payload.getJobTriggersList() != null ? payload.getJobTriggersList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListDlpJobsRequest, ListDlpJobsResponse, DlpJob> LIST_DLP_JOBS_PAGE_STR_DESC = new PagedListDescriptor<ListDlpJobsRequest, ListDlpJobsResponse, DlpJob>(){

        public String emptyToken() {
            return "";
        }

        public ListDlpJobsRequest injectToken(ListDlpJobsRequest payload, String token) {
            return ListDlpJobsRequest.newBuilder((ListDlpJobsRequest)payload).setPageToken(token).build();
        }

        public ListDlpJobsRequest injectPageSize(ListDlpJobsRequest payload, int pageSize) {
            return ListDlpJobsRequest.newBuilder((ListDlpJobsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDlpJobsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDlpJobsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DlpJob> extractResources(ListDlpJobsResponse payload) {
            return payload.getJobsList() != null ? payload.getJobsList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListStoredInfoTypesRequest, ListStoredInfoTypesResponse, StoredInfoType> LIST_STORED_INFO_TYPES_PAGE_STR_DESC = new PagedListDescriptor<ListStoredInfoTypesRequest, ListStoredInfoTypesResponse, StoredInfoType>(){

        public String emptyToken() {
            return "";
        }

        public ListStoredInfoTypesRequest injectToken(ListStoredInfoTypesRequest payload, String token) {
            return ListStoredInfoTypesRequest.newBuilder((ListStoredInfoTypesRequest)payload).setPageToken(token).build();
        }

        public ListStoredInfoTypesRequest injectPageSize(ListStoredInfoTypesRequest payload, int pageSize) {
            return ListStoredInfoTypesRequest.newBuilder((ListStoredInfoTypesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListStoredInfoTypesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListStoredInfoTypesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<StoredInfoType> extractResources(ListStoredInfoTypesResponse payload) {
            return payload.getStoredInfoTypesList() != null ? payload.getStoredInfoTypesList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListInspectTemplatesRequest, ListInspectTemplatesResponse, DlpServiceClient.ListInspectTemplatesPagedResponse> LIST_INSPECT_TEMPLATES_PAGE_STR_FACT = new PagedListResponseFactory<ListInspectTemplatesRequest, ListInspectTemplatesResponse, DlpServiceClient.ListInspectTemplatesPagedResponse>(){

        public ApiFuture<DlpServiceClient.ListInspectTemplatesPagedResponse> getFuturePagedResponse(UnaryCallable<ListInspectTemplatesRequest, ListInspectTemplatesResponse> callable, ListInspectTemplatesRequest request, ApiCallContext context, ApiFuture<ListInspectTemplatesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INSPECT_TEMPLATES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DlpServiceClient.ListInspectTemplatesPagedResponse.createAsync((PageContext<ListInspectTemplatesRequest, ListInspectTemplatesResponse, InspectTemplate>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDeidentifyTemplatesRequest, ListDeidentifyTemplatesResponse, DlpServiceClient.ListDeidentifyTemplatesPagedResponse> LIST_DEIDENTIFY_TEMPLATES_PAGE_STR_FACT = new PagedListResponseFactory<ListDeidentifyTemplatesRequest, ListDeidentifyTemplatesResponse, DlpServiceClient.ListDeidentifyTemplatesPagedResponse>(){

        public ApiFuture<DlpServiceClient.ListDeidentifyTemplatesPagedResponse> getFuturePagedResponse(UnaryCallable<ListDeidentifyTemplatesRequest, ListDeidentifyTemplatesResponse> callable, ListDeidentifyTemplatesRequest request, ApiCallContext context, ApiFuture<ListDeidentifyTemplatesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DEIDENTIFY_TEMPLATES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DlpServiceClient.ListDeidentifyTemplatesPagedResponse.createAsync((PageContext<ListDeidentifyTemplatesRequest, ListDeidentifyTemplatesResponse, DeidentifyTemplate>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListJobTriggersRequest, ListJobTriggersResponse, DlpServiceClient.ListJobTriggersPagedResponse> LIST_JOB_TRIGGERS_PAGE_STR_FACT = new PagedListResponseFactory<ListJobTriggersRequest, ListJobTriggersResponse, DlpServiceClient.ListJobTriggersPagedResponse>(){

        public ApiFuture<DlpServiceClient.ListJobTriggersPagedResponse> getFuturePagedResponse(UnaryCallable<ListJobTriggersRequest, ListJobTriggersResponse> callable, ListJobTriggersRequest request, ApiCallContext context, ApiFuture<ListJobTriggersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_JOB_TRIGGERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DlpServiceClient.ListJobTriggersPagedResponse.createAsync((PageContext<ListJobTriggersRequest, ListJobTriggersResponse, JobTrigger>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDlpJobsRequest, ListDlpJobsResponse, DlpServiceClient.ListDlpJobsPagedResponse> LIST_DLP_JOBS_PAGE_STR_FACT = new PagedListResponseFactory<ListDlpJobsRequest, ListDlpJobsResponse, DlpServiceClient.ListDlpJobsPagedResponse>(){

        public ApiFuture<DlpServiceClient.ListDlpJobsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDlpJobsRequest, ListDlpJobsResponse> callable, ListDlpJobsRequest request, ApiCallContext context, ApiFuture<ListDlpJobsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DLP_JOBS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DlpServiceClient.ListDlpJobsPagedResponse.createAsync((PageContext<ListDlpJobsRequest, ListDlpJobsResponse, DlpJob>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListStoredInfoTypesRequest, ListStoredInfoTypesResponse, DlpServiceClient.ListStoredInfoTypesPagedResponse> LIST_STORED_INFO_TYPES_PAGE_STR_FACT = new PagedListResponseFactory<ListStoredInfoTypesRequest, ListStoredInfoTypesResponse, DlpServiceClient.ListStoredInfoTypesPagedResponse>(){

        public ApiFuture<DlpServiceClient.ListStoredInfoTypesPagedResponse> getFuturePagedResponse(UnaryCallable<ListStoredInfoTypesRequest, ListStoredInfoTypesResponse> callable, ListStoredInfoTypesRequest request, ApiCallContext context, ApiFuture<ListStoredInfoTypesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_STORED_INFO_TYPES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DlpServiceClient.ListStoredInfoTypesPagedResponse.createAsync((PageContext<ListStoredInfoTypesRequest, ListStoredInfoTypesResponse, StoredInfoType>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<InspectContentRequest, InspectContentResponse> inspectContentSettings() {
        return this.inspectContentSettings;
    }

    public UnaryCallSettings<RedactImageRequest, RedactImageResponse> redactImageSettings() {
        return this.redactImageSettings;
    }

    public UnaryCallSettings<DeidentifyContentRequest, DeidentifyContentResponse> deidentifyContentSettings() {
        return this.deidentifyContentSettings;
    }

    public UnaryCallSettings<ReidentifyContentRequest, ReidentifyContentResponse> reidentifyContentSettings() {
        return this.reidentifyContentSettings;
    }

    public UnaryCallSettings<ListInfoTypesRequest, ListInfoTypesResponse> listInfoTypesSettings() {
        return this.listInfoTypesSettings;
    }

    public UnaryCallSettings<CreateInspectTemplateRequest, InspectTemplate> createInspectTemplateSettings() {
        return this.createInspectTemplateSettings;
    }

    public UnaryCallSettings<UpdateInspectTemplateRequest, InspectTemplate> updateInspectTemplateSettings() {
        return this.updateInspectTemplateSettings;
    }

    public UnaryCallSettings<GetInspectTemplateRequest, InspectTemplate> getInspectTemplateSettings() {
        return this.getInspectTemplateSettings;
    }

    public PagedCallSettings<ListInspectTemplatesRequest, ListInspectTemplatesResponse, DlpServiceClient.ListInspectTemplatesPagedResponse> listInspectTemplatesSettings() {
        return this.listInspectTemplatesSettings;
    }

    public UnaryCallSettings<DeleteInspectTemplateRequest, Empty> deleteInspectTemplateSettings() {
        return this.deleteInspectTemplateSettings;
    }

    public UnaryCallSettings<CreateDeidentifyTemplateRequest, DeidentifyTemplate> createDeidentifyTemplateSettings() {
        return this.createDeidentifyTemplateSettings;
    }

    public UnaryCallSettings<UpdateDeidentifyTemplateRequest, DeidentifyTemplate> updateDeidentifyTemplateSettings() {
        return this.updateDeidentifyTemplateSettings;
    }

    public UnaryCallSettings<GetDeidentifyTemplateRequest, DeidentifyTemplate> getDeidentifyTemplateSettings() {
        return this.getDeidentifyTemplateSettings;
    }

    public PagedCallSettings<ListDeidentifyTemplatesRequest, ListDeidentifyTemplatesResponse, DlpServiceClient.ListDeidentifyTemplatesPagedResponse> listDeidentifyTemplatesSettings() {
        return this.listDeidentifyTemplatesSettings;
    }

    public UnaryCallSettings<DeleteDeidentifyTemplateRequest, Empty> deleteDeidentifyTemplateSettings() {
        return this.deleteDeidentifyTemplateSettings;
    }

    public UnaryCallSettings<CreateJobTriggerRequest, JobTrigger> createJobTriggerSettings() {
        return this.createJobTriggerSettings;
    }

    public UnaryCallSettings<UpdateJobTriggerRequest, JobTrigger> updateJobTriggerSettings() {
        return this.updateJobTriggerSettings;
    }

    public UnaryCallSettings<HybridInspectJobTriggerRequest, HybridInspectResponse> hybridInspectJobTriggerSettings() {
        return this.hybridInspectJobTriggerSettings;
    }

    public UnaryCallSettings<GetJobTriggerRequest, JobTrigger> getJobTriggerSettings() {
        return this.getJobTriggerSettings;
    }

    public PagedCallSettings<ListJobTriggersRequest, ListJobTriggersResponse, DlpServiceClient.ListJobTriggersPagedResponse> listJobTriggersSettings() {
        return this.listJobTriggersSettings;
    }

    public UnaryCallSettings<DeleteJobTriggerRequest, Empty> deleteJobTriggerSettings() {
        return this.deleteJobTriggerSettings;
    }

    public UnaryCallSettings<CreateDlpJobRequest, DlpJob> createDlpJobSettings() {
        return this.createDlpJobSettings;
    }

    public PagedCallSettings<ListDlpJobsRequest, ListDlpJobsResponse, DlpServiceClient.ListDlpJobsPagedResponse> listDlpJobsSettings() {
        return this.listDlpJobsSettings;
    }

    public UnaryCallSettings<GetDlpJobRequest, DlpJob> getDlpJobSettings() {
        return this.getDlpJobSettings;
    }

    public UnaryCallSettings<DeleteDlpJobRequest, Empty> deleteDlpJobSettings() {
        return this.deleteDlpJobSettings;
    }

    public UnaryCallSettings<CancelDlpJobRequest, Empty> cancelDlpJobSettings() {
        return this.cancelDlpJobSettings;
    }

    public UnaryCallSettings<CreateStoredInfoTypeRequest, StoredInfoType> createStoredInfoTypeSettings() {
        return this.createStoredInfoTypeSettings;
    }

    public UnaryCallSettings<UpdateStoredInfoTypeRequest, StoredInfoType> updateStoredInfoTypeSettings() {
        return this.updateStoredInfoTypeSettings;
    }

    public UnaryCallSettings<GetStoredInfoTypeRequest, StoredInfoType> getStoredInfoTypeSettings() {
        return this.getStoredInfoTypeSettings;
    }

    public PagedCallSettings<ListStoredInfoTypesRequest, ListStoredInfoTypesResponse, DlpServiceClient.ListStoredInfoTypesPagedResponse> listStoredInfoTypesSettings() {
        return this.listStoredInfoTypesSettings;
    }

    public UnaryCallSettings<DeleteStoredInfoTypeRequest, Empty> deleteStoredInfoTypeSettings() {
        return this.deleteStoredInfoTypeSettings;
    }

    public UnaryCallSettings<HybridInspectDlpJobRequest, HybridInspectResponse> hybridInspectDlpJobSettings() {
        return this.hybridInspectDlpJobSettings;
    }

    public UnaryCallSettings<FinishDlpJobRequest, Empty> finishDlpJobSettings() {
        return this.finishDlpJobSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DlpServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDlpServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dlp.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DlpServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DlpServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DlpServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.inspectContentSettings = settingsBuilder.inspectContentSettings().build();
        this.redactImageSettings = settingsBuilder.redactImageSettings().build();
        this.deidentifyContentSettings = settingsBuilder.deidentifyContentSettings().build();
        this.reidentifyContentSettings = settingsBuilder.reidentifyContentSettings().build();
        this.listInfoTypesSettings = settingsBuilder.listInfoTypesSettings().build();
        this.createInspectTemplateSettings = settingsBuilder.createInspectTemplateSettings().build();
        this.updateInspectTemplateSettings = settingsBuilder.updateInspectTemplateSettings().build();
        this.getInspectTemplateSettings = settingsBuilder.getInspectTemplateSettings().build();
        this.listInspectTemplatesSettings = settingsBuilder.listInspectTemplatesSettings().build();
        this.deleteInspectTemplateSettings = settingsBuilder.deleteInspectTemplateSettings().build();
        this.createDeidentifyTemplateSettings = settingsBuilder.createDeidentifyTemplateSettings().build();
        this.updateDeidentifyTemplateSettings = settingsBuilder.updateDeidentifyTemplateSettings().build();
        this.getDeidentifyTemplateSettings = settingsBuilder.getDeidentifyTemplateSettings().build();
        this.listDeidentifyTemplatesSettings = settingsBuilder.listDeidentifyTemplatesSettings().build();
        this.deleteDeidentifyTemplateSettings = settingsBuilder.deleteDeidentifyTemplateSettings().build();
        this.createJobTriggerSettings = settingsBuilder.createJobTriggerSettings().build();
        this.updateJobTriggerSettings = settingsBuilder.updateJobTriggerSettings().build();
        this.hybridInspectJobTriggerSettings = settingsBuilder.hybridInspectJobTriggerSettings().build();
        this.getJobTriggerSettings = settingsBuilder.getJobTriggerSettings().build();
        this.listJobTriggersSettings = settingsBuilder.listJobTriggersSettings().build();
        this.deleteJobTriggerSettings = settingsBuilder.deleteJobTriggerSettings().build();
        this.createDlpJobSettings = settingsBuilder.createDlpJobSettings().build();
        this.listDlpJobsSettings = settingsBuilder.listDlpJobsSettings().build();
        this.getDlpJobSettings = settingsBuilder.getDlpJobSettings().build();
        this.deleteDlpJobSettings = settingsBuilder.deleteDlpJobSettings().build();
        this.cancelDlpJobSettings = settingsBuilder.cancelDlpJobSettings().build();
        this.createStoredInfoTypeSettings = settingsBuilder.createStoredInfoTypeSettings().build();
        this.updateStoredInfoTypeSettings = settingsBuilder.updateStoredInfoTypeSettings().build();
        this.getStoredInfoTypeSettings = settingsBuilder.getStoredInfoTypeSettings().build();
        this.listStoredInfoTypesSettings = settingsBuilder.listStoredInfoTypesSettings().build();
        this.deleteStoredInfoTypeSettings = settingsBuilder.deleteStoredInfoTypeSettings().build();
        this.hybridInspectDlpJobSettings = settingsBuilder.hybridInspectDlpJobSettings().build();
        this.finishDlpJobSettings = settingsBuilder.finishDlpJobSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DlpServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<InspectContentRequest, InspectContentResponse> inspectContentSettings;
        private final UnaryCallSettings.Builder<RedactImageRequest, RedactImageResponse> redactImageSettings;
        private final UnaryCallSettings.Builder<DeidentifyContentRequest, DeidentifyContentResponse> deidentifyContentSettings;
        private final UnaryCallSettings.Builder<ReidentifyContentRequest, ReidentifyContentResponse> reidentifyContentSettings;
        private final UnaryCallSettings.Builder<ListInfoTypesRequest, ListInfoTypesResponse> listInfoTypesSettings;
        private final UnaryCallSettings.Builder<CreateInspectTemplateRequest, InspectTemplate> createInspectTemplateSettings;
        private final UnaryCallSettings.Builder<UpdateInspectTemplateRequest, InspectTemplate> updateInspectTemplateSettings;
        private final UnaryCallSettings.Builder<GetInspectTemplateRequest, InspectTemplate> getInspectTemplateSettings;
        private final PagedCallSettings.Builder<ListInspectTemplatesRequest, ListInspectTemplatesResponse, DlpServiceClient.ListInspectTemplatesPagedResponse> listInspectTemplatesSettings;
        private final UnaryCallSettings.Builder<DeleteInspectTemplateRequest, Empty> deleteInspectTemplateSettings;
        private final UnaryCallSettings.Builder<CreateDeidentifyTemplateRequest, DeidentifyTemplate> createDeidentifyTemplateSettings;
        private final UnaryCallSettings.Builder<UpdateDeidentifyTemplateRequest, DeidentifyTemplate> updateDeidentifyTemplateSettings;
        private final UnaryCallSettings.Builder<GetDeidentifyTemplateRequest, DeidentifyTemplate> getDeidentifyTemplateSettings;
        private final PagedCallSettings.Builder<ListDeidentifyTemplatesRequest, ListDeidentifyTemplatesResponse, DlpServiceClient.ListDeidentifyTemplatesPagedResponse> listDeidentifyTemplatesSettings;
        private final UnaryCallSettings.Builder<DeleteDeidentifyTemplateRequest, Empty> deleteDeidentifyTemplateSettings;
        private final UnaryCallSettings.Builder<CreateJobTriggerRequest, JobTrigger> createJobTriggerSettings;
        private final UnaryCallSettings.Builder<UpdateJobTriggerRequest, JobTrigger> updateJobTriggerSettings;
        private final UnaryCallSettings.Builder<HybridInspectJobTriggerRequest, HybridInspectResponse> hybridInspectJobTriggerSettings;
        private final UnaryCallSettings.Builder<GetJobTriggerRequest, JobTrigger> getJobTriggerSettings;
        private final PagedCallSettings.Builder<ListJobTriggersRequest, ListJobTriggersResponse, DlpServiceClient.ListJobTriggersPagedResponse> listJobTriggersSettings;
        private final UnaryCallSettings.Builder<DeleteJobTriggerRequest, Empty> deleteJobTriggerSettings;
        private final UnaryCallSettings.Builder<CreateDlpJobRequest, DlpJob> createDlpJobSettings;
        private final PagedCallSettings.Builder<ListDlpJobsRequest, ListDlpJobsResponse, DlpServiceClient.ListDlpJobsPagedResponse> listDlpJobsSettings;
        private final UnaryCallSettings.Builder<GetDlpJobRequest, DlpJob> getDlpJobSettings;
        private final UnaryCallSettings.Builder<DeleteDlpJobRequest, Empty> deleteDlpJobSettings;
        private final UnaryCallSettings.Builder<CancelDlpJobRequest, Empty> cancelDlpJobSettings;
        private final UnaryCallSettings.Builder<CreateStoredInfoTypeRequest, StoredInfoType> createStoredInfoTypeSettings;
        private final UnaryCallSettings.Builder<UpdateStoredInfoTypeRequest, StoredInfoType> updateStoredInfoTypeSettings;
        private final UnaryCallSettings.Builder<GetStoredInfoTypeRequest, StoredInfoType> getStoredInfoTypeSettings;
        private final PagedCallSettings.Builder<ListStoredInfoTypesRequest, ListStoredInfoTypesResponse, DlpServiceClient.ListStoredInfoTypesPagedResponse> listStoredInfoTypesSettings;
        private final UnaryCallSettings.Builder<DeleteStoredInfoTypeRequest, Empty> deleteStoredInfoTypeSettings;
        private final UnaryCallSettings.Builder<HybridInspectDlpJobRequest, HybridInspectResponse> hybridInspectDlpJobSettings;
        private final UnaryCallSettings.Builder<FinishDlpJobRequest, Empty> finishDlpJobSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.inspectContentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.redactImageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deidentifyContentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.reidentifyContentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listInfoTypesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInspectTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateInspectTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getInspectTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listInspectTemplatesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INSPECT_TEMPLATES_PAGE_STR_FACT);
            this.deleteInspectTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDeidentifyTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDeidentifyTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getDeidentifyTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDeidentifyTemplatesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DEIDENTIFY_TEMPLATES_PAGE_STR_FACT);
            this.deleteDeidentifyTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createJobTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateJobTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.hybridInspectJobTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getJobTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listJobTriggersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_JOB_TRIGGERS_PAGE_STR_FACT);
            this.deleteJobTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDlpJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDlpJobsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DLP_JOBS_PAGE_STR_FACT);
            this.getDlpJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDlpJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.cancelDlpJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createStoredInfoTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateStoredInfoTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getStoredInfoTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listStoredInfoTypesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_STORED_INFO_TYPES_PAGE_STR_FACT);
            this.deleteStoredInfoTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.hybridInspectDlpJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.finishDlpJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.inspectContentSettings, this.redactImageSettings, this.deidentifyContentSettings, this.reidentifyContentSettings, this.listInfoTypesSettings, this.createInspectTemplateSettings, this.updateInspectTemplateSettings, this.getInspectTemplateSettings, this.listInspectTemplatesSettings, this.deleteInspectTemplateSettings, this.createDeidentifyTemplateSettings, this.updateDeidentifyTemplateSettings, (Object[])new UnaryCallSettings.Builder[]{this.getDeidentifyTemplateSettings, this.listDeidentifyTemplatesSettings, this.deleteDeidentifyTemplateSettings, this.createJobTriggerSettings, this.updateJobTriggerSettings, this.hybridInspectJobTriggerSettings, this.getJobTriggerSettings, this.listJobTriggersSettings, this.deleteJobTriggerSettings, this.createDlpJobSettings, this.listDlpJobsSettings, this.getDlpJobSettings, this.deleteDlpJobSettings, this.cancelDlpJobSettings, this.createStoredInfoTypeSettings, this.updateStoredInfoTypeSettings, this.getStoredInfoTypeSettings, this.listStoredInfoTypesSettings, this.deleteStoredInfoTypeSettings, this.hybridInspectDlpJobSettings, this.finishDlpJobSettings});
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DlpServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DlpServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DlpServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DlpServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.inspectContentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.redactImageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deidentifyContentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.reidentifyContentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listInfoTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createInspectTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateInspectTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getInspectTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listInspectTemplatesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deleteInspectTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createDeidentifyTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateDeidentifyTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getDeidentifyTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listDeidentifyTemplatesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deleteDeidentifyTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createJobTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateJobTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.hybridInspectJobTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getJobTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listJobTriggersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deleteJobTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createDlpJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listDlpJobsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getDlpJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deleteDlpJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.cancelDlpJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createStoredInfoTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateStoredInfoTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getStoredInfoTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listStoredInfoTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deleteStoredInfoTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.hybridInspectDlpJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.finishDlpJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            return builder;
        }

        protected Builder(DlpServiceStubSettings settings) {
            super((StubSettings)settings);
            this.inspectContentSettings = settings.inspectContentSettings.toBuilder();
            this.redactImageSettings = settings.redactImageSettings.toBuilder();
            this.deidentifyContentSettings = settings.deidentifyContentSettings.toBuilder();
            this.reidentifyContentSettings = settings.reidentifyContentSettings.toBuilder();
            this.listInfoTypesSettings = settings.listInfoTypesSettings.toBuilder();
            this.createInspectTemplateSettings = settings.createInspectTemplateSettings.toBuilder();
            this.updateInspectTemplateSettings = settings.updateInspectTemplateSettings.toBuilder();
            this.getInspectTemplateSettings = settings.getInspectTemplateSettings.toBuilder();
            this.listInspectTemplatesSettings = settings.listInspectTemplatesSettings.toBuilder();
            this.deleteInspectTemplateSettings = settings.deleteInspectTemplateSettings.toBuilder();
            this.createDeidentifyTemplateSettings = settings.createDeidentifyTemplateSettings.toBuilder();
            this.updateDeidentifyTemplateSettings = settings.updateDeidentifyTemplateSettings.toBuilder();
            this.getDeidentifyTemplateSettings = settings.getDeidentifyTemplateSettings.toBuilder();
            this.listDeidentifyTemplatesSettings = settings.listDeidentifyTemplatesSettings.toBuilder();
            this.deleteDeidentifyTemplateSettings = settings.deleteDeidentifyTemplateSettings.toBuilder();
            this.createJobTriggerSettings = settings.createJobTriggerSettings.toBuilder();
            this.updateJobTriggerSettings = settings.updateJobTriggerSettings.toBuilder();
            this.hybridInspectJobTriggerSettings = settings.hybridInspectJobTriggerSettings.toBuilder();
            this.getJobTriggerSettings = settings.getJobTriggerSettings.toBuilder();
            this.listJobTriggersSettings = settings.listJobTriggersSettings.toBuilder();
            this.deleteJobTriggerSettings = settings.deleteJobTriggerSettings.toBuilder();
            this.createDlpJobSettings = settings.createDlpJobSettings.toBuilder();
            this.listDlpJobsSettings = settings.listDlpJobsSettings.toBuilder();
            this.getDlpJobSettings = settings.getDlpJobSettings.toBuilder();
            this.deleteDlpJobSettings = settings.deleteDlpJobSettings.toBuilder();
            this.cancelDlpJobSettings = settings.cancelDlpJobSettings.toBuilder();
            this.createStoredInfoTypeSettings = settings.createStoredInfoTypeSettings.toBuilder();
            this.updateStoredInfoTypeSettings = settings.updateStoredInfoTypeSettings.toBuilder();
            this.getStoredInfoTypeSettings = settings.getStoredInfoTypeSettings.toBuilder();
            this.listStoredInfoTypesSettings = settings.listStoredInfoTypesSettings.toBuilder();
            this.deleteStoredInfoTypeSettings = settings.deleteStoredInfoTypeSettings.toBuilder();
            this.hybridInspectDlpJobSettings = settings.hybridInspectDlpJobSettings.toBuilder();
            this.finishDlpJobSettings = settings.finishDlpJobSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.inspectContentSettings, this.redactImageSettings, this.deidentifyContentSettings, this.reidentifyContentSettings, this.listInfoTypesSettings, this.createInspectTemplateSettings, this.updateInspectTemplateSettings, this.getInspectTemplateSettings, this.listInspectTemplatesSettings, this.deleteInspectTemplateSettings, this.createDeidentifyTemplateSettings, this.updateDeidentifyTemplateSettings, (Object[])new UnaryCallSettings.Builder[]{this.getDeidentifyTemplateSettings, this.listDeidentifyTemplatesSettings, this.deleteDeidentifyTemplateSettings, this.createJobTriggerSettings, this.updateJobTriggerSettings, this.hybridInspectJobTriggerSettings, this.getJobTriggerSettings, this.listJobTriggersSettings, this.deleteJobTriggerSettings, this.createDlpJobSettings, this.listDlpJobsSettings, this.getDlpJobSettings, this.deleteDlpJobSettings, this.cancelDlpJobSettings, this.createStoredInfoTypeSettings, this.updateStoredInfoTypeSettings, this.getStoredInfoTypeSettings, this.listStoredInfoTypesSettings, this.deleteStoredInfoTypeSettings, this.hybridInspectDlpJobSettings, this.finishDlpJobSettings});
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<InspectContentRequest, InspectContentResponse> inspectContentSettings() {
            return this.inspectContentSettings;
        }

        public UnaryCallSettings.Builder<RedactImageRequest, RedactImageResponse> redactImageSettings() {
            return this.redactImageSettings;
        }

        public UnaryCallSettings.Builder<DeidentifyContentRequest, DeidentifyContentResponse> deidentifyContentSettings() {
            return this.deidentifyContentSettings;
        }

        public UnaryCallSettings.Builder<ReidentifyContentRequest, ReidentifyContentResponse> reidentifyContentSettings() {
            return this.reidentifyContentSettings;
        }

        public UnaryCallSettings.Builder<ListInfoTypesRequest, ListInfoTypesResponse> listInfoTypesSettings() {
            return this.listInfoTypesSettings;
        }

        public UnaryCallSettings.Builder<CreateInspectTemplateRequest, InspectTemplate> createInspectTemplateSettings() {
            return this.createInspectTemplateSettings;
        }

        public UnaryCallSettings.Builder<UpdateInspectTemplateRequest, InspectTemplate> updateInspectTemplateSettings() {
            return this.updateInspectTemplateSettings;
        }

        public UnaryCallSettings.Builder<GetInspectTemplateRequest, InspectTemplate> getInspectTemplateSettings() {
            return this.getInspectTemplateSettings;
        }

        public PagedCallSettings.Builder<ListInspectTemplatesRequest, ListInspectTemplatesResponse, DlpServiceClient.ListInspectTemplatesPagedResponse> listInspectTemplatesSettings() {
            return this.listInspectTemplatesSettings;
        }

        public UnaryCallSettings.Builder<DeleteInspectTemplateRequest, Empty> deleteInspectTemplateSettings() {
            return this.deleteInspectTemplateSettings;
        }

        public UnaryCallSettings.Builder<CreateDeidentifyTemplateRequest, DeidentifyTemplate> createDeidentifyTemplateSettings() {
            return this.createDeidentifyTemplateSettings;
        }

        public UnaryCallSettings.Builder<UpdateDeidentifyTemplateRequest, DeidentifyTemplate> updateDeidentifyTemplateSettings() {
            return this.updateDeidentifyTemplateSettings;
        }

        public UnaryCallSettings.Builder<GetDeidentifyTemplateRequest, DeidentifyTemplate> getDeidentifyTemplateSettings() {
            return this.getDeidentifyTemplateSettings;
        }

        public PagedCallSettings.Builder<ListDeidentifyTemplatesRequest, ListDeidentifyTemplatesResponse, DlpServiceClient.ListDeidentifyTemplatesPagedResponse> listDeidentifyTemplatesSettings() {
            return this.listDeidentifyTemplatesSettings;
        }

        public UnaryCallSettings.Builder<DeleteDeidentifyTemplateRequest, Empty> deleteDeidentifyTemplateSettings() {
            return this.deleteDeidentifyTemplateSettings;
        }

        public UnaryCallSettings.Builder<CreateJobTriggerRequest, JobTrigger> createJobTriggerSettings() {
            return this.createJobTriggerSettings;
        }

        public UnaryCallSettings.Builder<UpdateJobTriggerRequest, JobTrigger> updateJobTriggerSettings() {
            return this.updateJobTriggerSettings;
        }

        public UnaryCallSettings.Builder<HybridInspectJobTriggerRequest, HybridInspectResponse> hybridInspectJobTriggerSettings() {
            return this.hybridInspectJobTriggerSettings;
        }

        public UnaryCallSettings.Builder<GetJobTriggerRequest, JobTrigger> getJobTriggerSettings() {
            return this.getJobTriggerSettings;
        }

        public PagedCallSettings.Builder<ListJobTriggersRequest, ListJobTriggersResponse, DlpServiceClient.ListJobTriggersPagedResponse> listJobTriggersSettings() {
            return this.listJobTriggersSettings;
        }

        public UnaryCallSettings.Builder<DeleteJobTriggerRequest, Empty> deleteJobTriggerSettings() {
            return this.deleteJobTriggerSettings;
        }

        public UnaryCallSettings.Builder<CreateDlpJobRequest, DlpJob> createDlpJobSettings() {
            return this.createDlpJobSettings;
        }

        public PagedCallSettings.Builder<ListDlpJobsRequest, ListDlpJobsResponse, DlpServiceClient.ListDlpJobsPagedResponse> listDlpJobsSettings() {
            return this.listDlpJobsSettings;
        }

        public UnaryCallSettings.Builder<GetDlpJobRequest, DlpJob> getDlpJobSettings() {
            return this.getDlpJobSettings;
        }

        public UnaryCallSettings.Builder<DeleteDlpJobRequest, Empty> deleteDlpJobSettings() {
            return this.deleteDlpJobSettings;
        }

        public UnaryCallSettings.Builder<CancelDlpJobRequest, Empty> cancelDlpJobSettings() {
            return this.cancelDlpJobSettings;
        }

        public UnaryCallSettings.Builder<CreateStoredInfoTypeRequest, StoredInfoType> createStoredInfoTypeSettings() {
            return this.createStoredInfoTypeSettings;
        }

        public UnaryCallSettings.Builder<UpdateStoredInfoTypeRequest, StoredInfoType> updateStoredInfoTypeSettings() {
            return this.updateStoredInfoTypeSettings;
        }

        public UnaryCallSettings.Builder<GetStoredInfoTypeRequest, StoredInfoType> getStoredInfoTypeSettings() {
            return this.getStoredInfoTypeSettings;
        }

        public PagedCallSettings.Builder<ListStoredInfoTypesRequest, ListStoredInfoTypesResponse, DlpServiceClient.ListStoredInfoTypesPagedResponse> listStoredInfoTypesSettings() {
            return this.listStoredInfoTypesSettings;
        }

        public UnaryCallSettings.Builder<DeleteStoredInfoTypeRequest, Empty> deleteStoredInfoTypeSettings() {
            return this.deleteStoredInfoTypeSettings;
        }

        public UnaryCallSettings.Builder<HybridInspectDlpJobRequest, HybridInspectResponse> hybridInspectDlpJobSettings() {
            return this.hybridInspectDlpJobSettings;
        }

        public UnaryCallSettings.Builder<FinishDlpJobRequest, Empty> finishDlpJobSettings() {
            return this.finishDlpJobSettings;
        }

        public DlpServiceStubSettings build() throws IOException {
            return new DlpServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)300000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)300000L)).setTotalTimeout(Duration.ofMillis((long)300000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)300000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)300000L)).setTotalTimeout(Duration.ofMillis((long)300000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

