/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dlp.v2beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.core.PropertiesProvider;
import com.google.api.gax.grpc.GrpcExtraHeaderData;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.dlp.v2beta1.stub.DlpServiceStub;
import com.google.cloud.dlp.v2beta1.stub.GrpcDlpServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.privacy.dlp.v2beta1.AnalyzeDataSourceRiskRequest;
import com.google.privacy.dlp.v2beta1.CreateInspectOperationRequest;
import com.google.privacy.dlp.v2beta1.DeidentifyContentRequest;
import com.google.privacy.dlp.v2beta1.DeidentifyContentResponse;
import com.google.privacy.dlp.v2beta1.InspectContentRequest;
import com.google.privacy.dlp.v2beta1.InspectContentResponse;
import com.google.privacy.dlp.v2beta1.InspectOperationMetadata;
import com.google.privacy.dlp.v2beta1.InspectOperationResult;
import com.google.privacy.dlp.v2beta1.ListInfoTypesRequest;
import com.google.privacy.dlp.v2beta1.ListInfoTypesResponse;
import com.google.privacy.dlp.v2beta1.ListInspectFindingsRequest;
import com.google.privacy.dlp.v2beta1.ListInspectFindingsResponse;
import com.google.privacy.dlp.v2beta1.ListRootCategoriesRequest;
import com.google.privacy.dlp.v2beta1.ListRootCategoriesResponse;
import com.google.privacy.dlp.v2beta1.RedactContentRequest;
import com.google.privacy.dlp.v2beta1.RedactContentResponse;
import com.google.privacy.dlp.v2beta1.RiskAnalysisOperationMetadata;
import com.google.privacy.dlp.v2beta1.RiskAnalysisOperationResult;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class DlpServiceSettings
extends ClientSettings<DlpServiceSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private static final String PROPERTIES_FILE = "/com/google/cloud/dlp/project.properties";
    private static final String META_VERSION_KEY = "artifact.version";
    private static String gapicVersion;
    private final UnaryCallSettings<InspectContentRequest, InspectContentResponse> inspectContentSettings;
    private final UnaryCallSettings<RedactContentRequest, RedactContentResponse> redactContentSettings;
    private final UnaryCallSettings<DeidentifyContentRequest, DeidentifyContentResponse> deidentifyContentSettings;
    private final UnaryCallSettings<AnalyzeDataSourceRiskRequest, Operation> analyzeDataSourceRiskSettings;
    private final OperationCallSettings<AnalyzeDataSourceRiskRequest, RiskAnalysisOperationResult, RiskAnalysisOperationMetadata> analyzeDataSourceRiskOperationSettings;
    private final UnaryCallSettings<CreateInspectOperationRequest, Operation> createInspectOperationSettings;
    private final OperationCallSettings<CreateInspectOperationRequest, InspectOperationResult, InspectOperationMetadata> createInspectOperationOperationSettings;
    private final UnaryCallSettings<ListInspectFindingsRequest, ListInspectFindingsResponse> listInspectFindingsSettings;
    private final UnaryCallSettings<ListInfoTypesRequest, ListInfoTypesResponse> listInfoTypesSettings;
    private final UnaryCallSettings<ListRootCategoriesRequest, ListRootCategoriesResponse> listRootCategoriesSettings;

    public UnaryCallSettings<InspectContentRequest, InspectContentResponse> inspectContentSettings() {
        return this.inspectContentSettings;
    }

    public UnaryCallSettings<RedactContentRequest, RedactContentResponse> redactContentSettings() {
        return this.redactContentSettings;
    }

    public UnaryCallSettings<DeidentifyContentRequest, DeidentifyContentResponse> deidentifyContentSettings() {
        return this.deidentifyContentSettings;
    }

    public UnaryCallSettings<AnalyzeDataSourceRiskRequest, Operation> analyzeDataSourceRiskSettings() {
        return this.analyzeDataSourceRiskSettings;
    }

    public OperationCallSettings<AnalyzeDataSourceRiskRequest, RiskAnalysisOperationResult, RiskAnalysisOperationMetadata> analyzeDataSourceRiskOperationSettings() {
        return this.analyzeDataSourceRiskOperationSettings;
    }

    public UnaryCallSettings<CreateInspectOperationRequest, Operation> createInspectOperationSettings() {
        return this.createInspectOperationSettings;
    }

    public OperationCallSettings<CreateInspectOperationRequest, InspectOperationResult, InspectOperationMetadata> createInspectOperationOperationSettings() {
        return this.createInspectOperationOperationSettings;
    }

    public UnaryCallSettings<ListInspectFindingsRequest, ListInspectFindingsResponse> listInspectFindingsSettings() {
        return this.listInspectFindingsSettings;
    }

    public UnaryCallSettings<ListInfoTypesRequest, ListInfoTypesResponse> listInfoTypesSettings() {
        return this.listInfoTypesSettings;
    }

    public UnaryCallSettings<ListRootCategoriesRequest, ListRootCategoriesResponse> listRootCategoriesSettings() {
        return this.listRootCategoriesSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DlpServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDlpServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dlp.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DlpServiceSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratorHeader(DEFAULT_GAPIC_NAME, DlpServiceSettings.getGapicVersion()).setApiClientHeaderLineKey("x-goog-api-client").addApiClientHeaderLineData(GrpcExtraHeaderData.getXGoogApiClientData());
    }

    private static String getGapicVersion() {
        if (gapicVersion == null) {
            gapicVersion = PropertiesProvider.loadProperty(DlpServiceSettings.class, (String)PROPERTIES_FILE, (String)META_VERSION_KEY);
            gapicVersion = gapicVersion == null ? DEFAULT_GAPIC_VERSION : gapicVersion;
        }
        return gapicVersion;
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private DlpServiceSettings(Builder settingsBuilder) throws IOException {
        super((ClientSettings.Builder)settingsBuilder);
        this.inspectContentSettings = settingsBuilder.inspectContentSettings().build();
        this.redactContentSettings = settingsBuilder.redactContentSettings().build();
        this.deidentifyContentSettings = settingsBuilder.deidentifyContentSettings().build();
        this.analyzeDataSourceRiskSettings = settingsBuilder.analyzeDataSourceRiskSettings().build();
        this.analyzeDataSourceRiskOperationSettings = settingsBuilder.analyzeDataSourceRiskOperationSettings().build();
        this.createInspectOperationSettings = settingsBuilder.createInspectOperationSettings().build();
        this.createInspectOperationOperationSettings = settingsBuilder.createInspectOperationOperationSettings().build();
        this.listInspectFindingsSettings = settingsBuilder.listInspectFindingsSettings().build();
        this.listInfoTypesSettings = settingsBuilder.listInfoTypesSettings().build();
        this.listRootCategoriesSettings = settingsBuilder.listRootCategoriesSettings().build();
    }

    public static class Builder
    extends ClientSettings.Builder<DlpServiceSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<InspectContentRequest, InspectContentResponse> inspectContentSettings;
        private final UnaryCallSettings.Builder<RedactContentRequest, RedactContentResponse> redactContentSettings;
        private final UnaryCallSettings.Builder<DeidentifyContentRequest, DeidentifyContentResponse> deidentifyContentSettings;
        private final UnaryCallSettings.Builder<AnalyzeDataSourceRiskRequest, Operation> analyzeDataSourceRiskSettings;
        private final OperationCallSettings.Builder<AnalyzeDataSourceRiskRequest, RiskAnalysisOperationResult, RiskAnalysisOperationMetadata> analyzeDataSourceRiskOperationSettings;
        private final UnaryCallSettings.Builder<CreateInspectOperationRequest, Operation> createInspectOperationSettings;
        private final OperationCallSettings.Builder<CreateInspectOperationRequest, InspectOperationResult, InspectOperationMetadata> createInspectOperationOperationSettings;
        private final UnaryCallSettings.Builder<ListInspectFindingsRequest, ListInspectFindingsResponse> listInspectFindingsSettings;
        private final UnaryCallSettings.Builder<ListInfoTypesRequest, ListInfoTypesResponse> listInfoTypesSettings;
        private final UnaryCallSettings.Builder<ListRootCategoriesRequest, ListRootCategoriesResponse> listRootCategoriesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            this((ClientContext)null);
        }

        private Builder(ClientContext clientContext) {
            super(clientContext);
            this.inspectContentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.redactContentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deidentifyContentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.analyzeDataSourceRiskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.analyzeDataSourceRiskOperationSettings = OperationCallSettings.newBuilder();
            this.createInspectOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInspectOperationOperationSettings = OperationCallSettings.newBuilder();
            this.listInspectFindingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listInfoTypesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRootCategoriesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.inspectContentSettings, this.redactContentSettings, this.deidentifyContentSettings, this.analyzeDataSourceRiskSettings, this.createInspectOperationSettings, this.listInspectFindingsSettings, this.listInfoTypesSettings, this.listRootCategoriesSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DlpServiceSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DlpServiceSettings.defaultCredentialsProviderBuilder().build());
            builder.setHeaderProvider((HeaderProvider)DlpServiceSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DlpServiceSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.inspectContentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.redactContentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deidentifyContentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.analyzeDataSourceRiskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createInspectOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listInspectFindingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listInfoTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listRootCategoriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.analyzeDataSourceRiskOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(RiskAnalysisOperationResult.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(RiskAnalysisOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)20000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)86400000L)).build()));
            builder.createInspectOperationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(InspectOperationResult.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(InspectOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)20000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)86400000L)).build()));
            return builder;
        }

        private Builder(DlpServiceSettings settings) {
            super((ClientSettings)settings);
            this.inspectContentSettings = settings.inspectContentSettings.toBuilder();
            this.redactContentSettings = settings.redactContentSettings.toBuilder();
            this.deidentifyContentSettings = settings.deidentifyContentSettings.toBuilder();
            this.analyzeDataSourceRiskSettings = settings.analyzeDataSourceRiskSettings.toBuilder();
            this.analyzeDataSourceRiskOperationSettings = settings.analyzeDataSourceRiskOperationSettings.toBuilder();
            this.createInspectOperationSettings = settings.createInspectOperationSettings.toBuilder();
            this.createInspectOperationOperationSettings = settings.createInspectOperationOperationSettings.toBuilder();
            this.listInspectFindingsSettings = settings.listInspectFindingsSettings.toBuilder();
            this.listInfoTypesSettings = settings.listInfoTypesSettings.toBuilder();
            this.listRootCategoriesSettings = settings.listRootCategoriesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.inspectContentSettings, this.redactContentSettings, this.deidentifyContentSettings, this.analyzeDataSourceRiskSettings, this.createInspectOperationSettings, this.listInspectFindingsSettings, this.listInfoTypesSettings, this.listRootCategoriesSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            ClientSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public UnaryCallSettings.Builder<InspectContentRequest, InspectContentResponse> inspectContentSettings() {
            return this.inspectContentSettings;
        }

        public UnaryCallSettings.Builder<RedactContentRequest, RedactContentResponse> redactContentSettings() {
            return this.redactContentSettings;
        }

        public UnaryCallSettings.Builder<DeidentifyContentRequest, DeidentifyContentResponse> deidentifyContentSettings() {
            return this.deidentifyContentSettings;
        }

        public UnaryCallSettings.Builder<AnalyzeDataSourceRiskRequest, Operation> analyzeDataSourceRiskSettings() {
            return this.analyzeDataSourceRiskSettings;
        }

        public OperationCallSettings.Builder<AnalyzeDataSourceRiskRequest, RiskAnalysisOperationResult, RiskAnalysisOperationMetadata> analyzeDataSourceRiskOperationSettings() {
            return this.analyzeDataSourceRiskOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateInspectOperationRequest, Operation> createInspectOperationSettings() {
            return this.createInspectOperationSettings;
        }

        public OperationCallSettings.Builder<CreateInspectOperationRequest, InspectOperationResult, InspectOperationMetadata> createInspectOperationOperationSettings() {
            return this.createInspectOperationOperationSettings;
        }

        public UnaryCallSettings.Builder<ListInspectFindingsRequest, ListInspectFindingsResponse> listInspectFindingsSettings() {
            return this.listInspectFindingsSettings;
        }

        public UnaryCallSettings.Builder<ListInfoTypesRequest, ListInfoTypesResponse> listInfoTypesSettings() {
            return this.listInfoTypesSettings;
        }

        public UnaryCallSettings.Builder<ListRootCategoriesRequest, ListRootCategoriesResponse> listRootCategoriesSettings() {
            return this.listRootCategoriesSettings;
        }

        public DlpServiceSettings build() throws IOException {
            return new DlpServiceSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

