/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1beta.ListCustomModelsRequest;
import com.google.cloud.discoveryengine.v1beta.ListCustomModelsResponse;
import com.google.cloud.discoveryengine.v1beta.TrainCustomModelMetadata;
import com.google.cloud.discoveryengine.v1beta.TrainCustomModelRequest;
import com.google.cloud.discoveryengine.v1beta.TrainCustomModelResponse;
import com.google.cloud.discoveryengine.v1beta.stub.GrpcSearchTuningServiceCallableFactory;
import com.google.cloud.discoveryengine.v1beta.stub.SearchTuningServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.SearchTuningServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcSearchTuningServiceStub
extends SearchTuningServiceStub {
    private static final MethodDescriptor<TrainCustomModelRequest, Operation> trainCustomModelMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1beta.SearchTuningService/TrainCustomModel").setRequestMarshaller(ProtoUtils.marshaller((Message)TrainCustomModelRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListCustomModelsRequest, ListCustomModelsResponse> listCustomModelsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1beta.SearchTuningService/ListCustomModels").setRequestMarshaller(ProtoUtils.marshaller((Message)ListCustomModelsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListCustomModelsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<TrainCustomModelRequest, Operation> trainCustomModelCallable;
    private final OperationCallable<TrainCustomModelRequest, TrainCustomModelResponse, TrainCustomModelMetadata> trainCustomModelOperationCallable;
    private final UnaryCallable<ListCustomModelsRequest, ListCustomModelsResponse> listCustomModelsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSearchTuningServiceStub create(SearchTuningServiceStubSettings settings) throws IOException {
        return new GrpcSearchTuningServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcSearchTuningServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcSearchTuningServiceStub(SearchTuningServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSearchTuningServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSearchTuningServiceStub(SearchTuningServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSearchTuningServiceStub(SearchTuningServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSearchTuningServiceCallableFactory());
    }

    protected GrpcSearchTuningServiceStub(SearchTuningServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings trainCustomModelTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(trainCustomModelMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("data_store", String.valueOf(request.getDataStore()));
            return builder.build();
        }).build();
        GrpcCallSettings listCustomModelsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listCustomModelsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("data_store", String.valueOf(request.getDataStore()));
            return builder.build();
        }).build();
        this.trainCustomModelCallable = callableFactory.createUnaryCallable(trainCustomModelTransportSettings, settings.trainCustomModelSettings(), clientContext);
        this.trainCustomModelOperationCallable = callableFactory.createOperationCallable(trainCustomModelTransportSettings, settings.trainCustomModelOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listCustomModelsCallable = callableFactory.createUnaryCallable(listCustomModelsTransportSettings, settings.listCustomModelsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<TrainCustomModelRequest, Operation> trainCustomModelCallable() {
        return this.trainCustomModelCallable;
    }

    @Override
    public OperationCallable<TrainCustomModelRequest, TrainCustomModelResponse, TrainCustomModelMetadata> trainCustomModelOperationCallable() {
        return this.trainCustomModelOperationCallable;
    }

    @Override
    public UnaryCallable<ListCustomModelsRequest, ListCustomModelsResponse> listCustomModelsCallable() {
        return this.listCustomModelsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

