/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1beta.Control;
import com.google.cloud.discoveryengine.v1beta.ControlServiceClient;
import com.google.cloud.discoveryengine.v1beta.CreateControlRequest;
import com.google.cloud.discoveryengine.v1beta.DeleteControlRequest;
import com.google.cloud.discoveryengine.v1beta.GetControlRequest;
import com.google.cloud.discoveryengine.v1beta.ListControlsRequest;
import com.google.cloud.discoveryengine.v1beta.ListControlsResponse;
import com.google.cloud.discoveryengine.v1beta.UpdateControlRequest;
import com.google.cloud.discoveryengine.v1beta.stub.ControlServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.ControlServiceStubSettings;
import com.google.cloud.discoveryengine.v1beta.stub.HttpJsonControlServiceCallableFactory;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonControlServiceStub
extends ControlServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateControlRequest, Control> createControlMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1beta.ControlService/CreateControl").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{parent=projects/*/locations/*/dataStores/*}/controls", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1beta/{parent=projects/*/locations/*/collections/*/dataStores/*}/controls", "/v1beta/{parent=projects/*/locations/*/collections/*/engines/*}/controls"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "controlId", (Object)request.getControlId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("control", (Message)request.getControl(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Control.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteControlRequest, Empty> deleteControlMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1beta.ControlService/DeleteControl").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/dataStores/*/controls/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1beta/{name=projects/*/locations/*/collections/*/dataStores/*/controls/*}", "/v1beta/{name=projects/*/locations/*/collections/*/engines/*/controls/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateControlRequest, Control> updateControlMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1beta.ControlService/UpdateControl").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{control.name=projects/*/locations/*/dataStores/*/controls/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "control.name", (Object)request.getControl().getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1beta/{control.name=projects/*/locations/*/collections/*/dataStores/*/controls/*}", "/v1beta/{control.name=projects/*/locations/*/collections/*/engines/*/controls/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("control", (Message)request.getControl(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Control.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetControlRequest, Control> getControlMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1beta.ControlService/GetControl").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{name=projects/*/locations/*/dataStores/*/controls/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1beta/{name=projects/*/locations/*/collections/*/dataStores/*/controls/*}", "/v1beta/{name=projects/*/locations/*/collections/*/engines/*/controls/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Control.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListControlsRequest, ListControlsResponse> listControlsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.discoveryengine.v1beta.ControlService/ListControls").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta/{parent=projects/*/locations/*/dataStores/*}/controls", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1beta/{parent=projects/*/locations/*/collections/*/dataStores/*}/controls", "/v1beta/{parent=projects/*/locations/*/collections/*/engines/*}/controls"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListControlsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateControlRequest, Control> createControlCallable;
    private final UnaryCallable<DeleteControlRequest, Empty> deleteControlCallable;
    private final UnaryCallable<UpdateControlRequest, Control> updateControlCallable;
    private final UnaryCallable<GetControlRequest, Control> getControlCallable;
    private final UnaryCallable<ListControlsRequest, ListControlsResponse> listControlsCallable;
    private final UnaryCallable<ListControlsRequest, ControlServiceClient.ListControlsPagedResponse> listControlsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonControlServiceStub create(ControlServiceStubSettings settings) throws IOException {
        return new HttpJsonControlServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonControlServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonControlServiceStub(ControlServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonControlServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonControlServiceStub(ControlServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonControlServiceStub(ControlServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonControlServiceCallableFactory());
    }

    protected HttpJsonControlServiceStub(ControlServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createControlTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createControlMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteControlTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteControlMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateControlTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateControlMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("control.name", String.valueOf(request.getControl().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getControlTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getControlMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listControlsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listControlsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.createControlCallable = callableFactory.createUnaryCallable(createControlTransportSettings, settings.createControlSettings(), clientContext);
        this.deleteControlCallable = callableFactory.createUnaryCallable(deleteControlTransportSettings, settings.deleteControlSettings(), clientContext);
        this.updateControlCallable = callableFactory.createUnaryCallable(updateControlTransportSettings, settings.updateControlSettings(), clientContext);
        this.getControlCallable = callableFactory.createUnaryCallable(getControlTransportSettings, settings.getControlSettings(), clientContext);
        this.listControlsCallable = callableFactory.createUnaryCallable(listControlsTransportSettings, settings.listControlsSettings(), clientContext);
        this.listControlsPagedCallable = callableFactory.createPagedCallable(listControlsTransportSettings, settings.listControlsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createControlMethodDescriptor);
        methodDescriptors.add(deleteControlMethodDescriptor);
        methodDescriptors.add(updateControlMethodDescriptor);
        methodDescriptors.add(getControlMethodDescriptor);
        methodDescriptors.add(listControlsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateControlRequest, Control> createControlCallable() {
        return this.createControlCallable;
    }

    @Override
    public UnaryCallable<DeleteControlRequest, Empty> deleteControlCallable() {
        return this.deleteControlCallable;
    }

    @Override
    public UnaryCallable<UpdateControlRequest, Control> updateControlCallable() {
        return this.updateControlCallable;
    }

    @Override
    public UnaryCallable<GetControlRequest, Control> getControlCallable() {
        return this.getControlCallable;
    }

    @Override
    public UnaryCallable<ListControlsRequest, ListControlsResponse> listControlsCallable() {
        return this.listControlsCallable;
    }

    @Override
    public UnaryCallable<ListControlsRequest, ControlServiceClient.ListControlsPagedResponse> listControlsPagedCallable() {
        return this.listControlsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

