/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.CreateSessionRequest;
import com.google.cloud.discoveryengine.v1alpha.DeleteSessionRequest;
import com.google.cloud.discoveryengine.v1alpha.FileMetadata;
import com.google.cloud.discoveryengine.v1alpha.GetSessionRequest;
import com.google.cloud.discoveryengine.v1alpha.ListFilesRequest;
import com.google.cloud.discoveryengine.v1alpha.ListFilesResponse;
import com.google.cloud.discoveryengine.v1alpha.ListSessionsRequest;
import com.google.cloud.discoveryengine.v1alpha.ListSessionsResponse;
import com.google.cloud.discoveryengine.v1alpha.Session;
import com.google.cloud.discoveryengine.v1alpha.SessionServiceClient;
import com.google.cloud.discoveryengine.v1alpha.UpdateSessionRequest;
import com.google.cloud.discoveryengine.v1alpha.stub.GrpcSessionServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.HttpJsonSessionServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.SessionServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class SessionServiceStubSettings
extends StubSettings<SessionServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateSessionRequest, Session> createSessionSettings;
    private final UnaryCallSettings<DeleteSessionRequest, Empty> deleteSessionSettings;
    private final UnaryCallSettings<UpdateSessionRequest, Session> updateSessionSettings;
    private final UnaryCallSettings<GetSessionRequest, Session> getSessionSettings;
    private final PagedCallSettings<ListSessionsRequest, ListSessionsResponse, SessionServiceClient.ListSessionsPagedResponse> listSessionsSettings;
    private final PagedCallSettings<ListFilesRequest, ListFilesResponse, SessionServiceClient.ListFilesPagedResponse> listFilesSettings;
    private static final PagedListDescriptor<ListSessionsRequest, ListSessionsResponse, Session> LIST_SESSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListSessionsRequest, ListSessionsResponse, Session>(){

        public String emptyToken() {
            return "";
        }

        public ListSessionsRequest injectToken(ListSessionsRequest payload, String token) {
            return ListSessionsRequest.newBuilder((ListSessionsRequest)payload).setPageToken(token).build();
        }

        public ListSessionsRequest injectPageSize(ListSessionsRequest payload, int pageSize) {
            return ListSessionsRequest.newBuilder((ListSessionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSessionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSessionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Session> extractResources(ListSessionsResponse payload) {
            return payload.getSessionsList();
        }
    };
    private static final PagedListDescriptor<ListFilesRequest, ListFilesResponse, FileMetadata> LIST_FILES_PAGE_STR_DESC = new PagedListDescriptor<ListFilesRequest, ListFilesResponse, FileMetadata>(){

        public String emptyToken() {
            return "";
        }

        public ListFilesRequest injectToken(ListFilesRequest payload, String token) {
            return ListFilesRequest.newBuilder((ListFilesRequest)payload).setPageToken(token).build();
        }

        public ListFilesRequest injectPageSize(ListFilesRequest payload, int pageSize) {
            return ListFilesRequest.newBuilder((ListFilesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListFilesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListFilesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<FileMetadata> extractResources(ListFilesResponse payload) {
            return payload.getFilesList();
        }
    };
    private static final PagedListResponseFactory<ListSessionsRequest, ListSessionsResponse, SessionServiceClient.ListSessionsPagedResponse> LIST_SESSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListSessionsRequest, ListSessionsResponse, SessionServiceClient.ListSessionsPagedResponse>(){

        public ApiFuture<SessionServiceClient.ListSessionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSessionsRequest, ListSessionsResponse> callable, ListSessionsRequest request, ApiCallContext context, ApiFuture<ListSessionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SESSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SessionServiceClient.ListSessionsPagedResponse.createAsync((PageContext<ListSessionsRequest, ListSessionsResponse, Session>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListFilesRequest, ListFilesResponse, SessionServiceClient.ListFilesPagedResponse> LIST_FILES_PAGE_STR_FACT = new PagedListResponseFactory<ListFilesRequest, ListFilesResponse, SessionServiceClient.ListFilesPagedResponse>(){

        public ApiFuture<SessionServiceClient.ListFilesPagedResponse> getFuturePagedResponse(UnaryCallable<ListFilesRequest, ListFilesResponse> callable, ListFilesRequest request, ApiCallContext context, ApiFuture<ListFilesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_FILES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SessionServiceClient.ListFilesPagedResponse.createAsync((PageContext<ListFilesRequest, ListFilesResponse, FileMetadata>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateSessionRequest, Session> createSessionSettings() {
        return this.createSessionSettings;
    }

    public UnaryCallSettings<DeleteSessionRequest, Empty> deleteSessionSettings() {
        return this.deleteSessionSettings;
    }

    public UnaryCallSettings<UpdateSessionRequest, Session> updateSessionSettings() {
        return this.updateSessionSettings;
    }

    public UnaryCallSettings<GetSessionRequest, Session> getSessionSettings() {
        return this.getSessionSettings;
    }

    public PagedCallSettings<ListSessionsRequest, ListSessionsResponse, SessionServiceClient.ListSessionsPagedResponse> listSessionsSettings() {
        return this.listSessionsSettings;
    }

    public PagedCallSettings<ListFilesRequest, ListFilesResponse, SessionServiceClient.ListFilesPagedResponse> listFilesSettings() {
        return this.listFilesSettings;
    }

    public SessionServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSessionServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSessionServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "discoveryengine";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "discoveryengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "discoveryengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SessionServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SessionServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SessionServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return SessionServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SessionServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createSessionSettings = settingsBuilder.createSessionSettings().build();
        this.deleteSessionSettings = settingsBuilder.deleteSessionSettings().build();
        this.updateSessionSettings = settingsBuilder.updateSessionSettings().build();
        this.getSessionSettings = settingsBuilder.getSessionSettings().build();
        this.listSessionsSettings = settingsBuilder.listSessionsSettings().build();
        this.listFilesSettings = settingsBuilder.listFilesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SessionServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateSessionRequest, Session> createSessionSettings;
        private final UnaryCallSettings.Builder<DeleteSessionRequest, Empty> deleteSessionSettings;
        private final UnaryCallSettings.Builder<UpdateSessionRequest, Session> updateSessionSettings;
        private final UnaryCallSettings.Builder<GetSessionRequest, Session> getSessionSettings;
        private final PagedCallSettings.Builder<ListSessionsRequest, ListSessionsResponse, SessionServiceClient.ListSessionsPagedResponse> listSessionsSettings;
        private final PagedCallSettings.Builder<ListFilesRequest, ListFilesResponse, SessionServiceClient.ListFilesPagedResponse> listFilesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSessionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SESSIONS_PAGE_STR_FACT);
            this.listFilesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_FILES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSessionSettings, this.deleteSessionSettings, this.updateSessionSettings, this.getSessionSettings, this.listSessionsSettings, this.listFilesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(SessionServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createSessionSettings = settings.createSessionSettings.toBuilder();
            this.deleteSessionSettings = settings.deleteSessionSettings.toBuilder();
            this.updateSessionSettings = settings.updateSessionSettings.toBuilder();
            this.getSessionSettings = settings.getSessionSettings.toBuilder();
            this.listSessionsSettings = settings.listSessionsSettings.toBuilder();
            this.listFilesSettings = settings.listFilesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSessionSettings, this.deleteSessionSettings, this.updateSessionSettings, this.getSessionSettings, this.listSessionsSettings, this.listFilesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SessionServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SessionServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SessionServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SessionServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)SessionServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)SessionServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SessionServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SessionServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deleteSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.updateSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listSessionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listFilesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateSessionRequest, Session> createSessionSettings() {
            return this.createSessionSettings;
        }

        public UnaryCallSettings.Builder<DeleteSessionRequest, Empty> deleteSessionSettings() {
            return this.deleteSessionSettings;
        }

        public UnaryCallSettings.Builder<UpdateSessionRequest, Session> updateSessionSettings() {
            return this.updateSessionSettings;
        }

        public UnaryCallSettings.Builder<GetSessionRequest, Session> getSessionSettings() {
            return this.getSessionSettings;
        }

        public PagedCallSettings.Builder<ListSessionsRequest, ListSessionsResponse, SessionServiceClient.ListSessionsPagedResponse> listSessionsSettings() {
            return this.listSessionsSettings;
        }

        public PagedCallSettings.Builder<ListFilesRequest, ListFilesResponse, SessionServiceClient.ListFilesPagedResponse> listFilesSettings() {
            return this.listFilesSettings;
        }

        public SessionServiceStubSettings build() throws IOException {
            return new SessionServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(30000L)).setTotalTimeoutDuration(Duration.ofMillis(30000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

