/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.AclConfig;
import com.google.cloud.discoveryengine.v1alpha.AclConfigName;
import com.google.cloud.discoveryengine.v1alpha.AclConfigServiceSettings;
import com.google.cloud.discoveryengine.v1alpha.GetAclConfigRequest;
import com.google.cloud.discoveryengine.v1alpha.UpdateAclConfigRequest;
import com.google.cloud.discoveryengine.v1alpha.stub.AclConfigServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.AclConfigServiceStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class AclConfigServiceClient
implements BackgroundResource {
    private final AclConfigServiceSettings settings;
    private final AclConfigServiceStub stub;

    public static final AclConfigServiceClient create() throws IOException {
        return AclConfigServiceClient.create(AclConfigServiceSettings.newBuilder().build());
    }

    public static final AclConfigServiceClient create(AclConfigServiceSettings settings) throws IOException {
        return new AclConfigServiceClient(settings);
    }

    public static final AclConfigServiceClient create(AclConfigServiceStub stub) {
        return new AclConfigServiceClient(stub);
    }

    protected AclConfigServiceClient(AclConfigServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AclConfigServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AclConfigServiceClient(AclConfigServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AclConfigServiceSettings getSettings() {
        return this.settings;
    }

    public AclConfigServiceStub getStub() {
        return this.stub;
    }

    public final AclConfig updateAclConfig(UpdateAclConfigRequest request) {
        return (AclConfig)this.updateAclConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateAclConfigRequest, AclConfig> updateAclConfigCallable() {
        return this.stub.updateAclConfigCallable();
    }

    public final AclConfig getAclConfig(AclConfigName name) {
        GetAclConfigRequest request = GetAclConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAclConfig(request);
    }

    public final AclConfig getAclConfig(String name) {
        GetAclConfigRequest request = GetAclConfigRequest.newBuilder().setName(name).build();
        return this.getAclConfig(request);
    }

    public final AclConfig getAclConfig(GetAclConfigRequest request) {
        return (AclConfig)this.getAclConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetAclConfigRequest, AclConfig> getAclConfigCallable() {
        return this.stub.getAclConfigCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

