/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1beta.CreateSampleQuerySetRequest;
import com.google.cloud.discoveryengine.v1beta.DeleteSampleQuerySetRequest;
import com.google.cloud.discoveryengine.v1beta.GetSampleQuerySetRequest;
import com.google.cloud.discoveryengine.v1beta.ListSampleQuerySetsRequest;
import com.google.cloud.discoveryengine.v1beta.ListSampleQuerySetsResponse;
import com.google.cloud.discoveryengine.v1beta.SampleQuerySet;
import com.google.cloud.discoveryengine.v1beta.SampleQuerySetServiceClient;
import com.google.cloud.discoveryengine.v1beta.UpdateSampleQuerySetRequest;
import com.google.cloud.discoveryengine.v1beta.stub.GrpcSampleQuerySetServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.HttpJsonSampleQuerySetServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.SampleQuerySetServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class SampleQuerySetServiceStubSettings
extends StubSettings<SampleQuerySetServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetSampleQuerySetRequest, SampleQuerySet> getSampleQuerySetSettings;
    private final PagedCallSettings<ListSampleQuerySetsRequest, ListSampleQuerySetsResponse, SampleQuerySetServiceClient.ListSampleQuerySetsPagedResponse> listSampleQuerySetsSettings;
    private final UnaryCallSettings<CreateSampleQuerySetRequest, SampleQuerySet> createSampleQuerySetSettings;
    private final UnaryCallSettings<UpdateSampleQuerySetRequest, SampleQuerySet> updateSampleQuerySetSettings;
    private final UnaryCallSettings<DeleteSampleQuerySetRequest, Empty> deleteSampleQuerySetSettings;
    private static final PagedListDescriptor<ListSampleQuerySetsRequest, ListSampleQuerySetsResponse, SampleQuerySet> LIST_SAMPLE_QUERY_SETS_PAGE_STR_DESC = new PagedListDescriptor<ListSampleQuerySetsRequest, ListSampleQuerySetsResponse, SampleQuerySet>(){

        public String emptyToken() {
            return "";
        }

        public ListSampleQuerySetsRequest injectToken(ListSampleQuerySetsRequest payload, String token) {
            return ListSampleQuerySetsRequest.newBuilder((ListSampleQuerySetsRequest)payload).setPageToken(token).build();
        }

        public ListSampleQuerySetsRequest injectPageSize(ListSampleQuerySetsRequest payload, int pageSize) {
            return ListSampleQuerySetsRequest.newBuilder((ListSampleQuerySetsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSampleQuerySetsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSampleQuerySetsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SampleQuerySet> extractResources(ListSampleQuerySetsResponse payload) {
            return payload.getSampleQuerySetsList() == null ? ImmutableList.of() : payload.getSampleQuerySetsList();
        }
    };
    private static final PagedListResponseFactory<ListSampleQuerySetsRequest, ListSampleQuerySetsResponse, SampleQuerySetServiceClient.ListSampleQuerySetsPagedResponse> LIST_SAMPLE_QUERY_SETS_PAGE_STR_FACT = new PagedListResponseFactory<ListSampleQuerySetsRequest, ListSampleQuerySetsResponse, SampleQuerySetServiceClient.ListSampleQuerySetsPagedResponse>(){

        public ApiFuture<SampleQuerySetServiceClient.ListSampleQuerySetsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSampleQuerySetsRequest, ListSampleQuerySetsResponse> callable, ListSampleQuerySetsRequest request, ApiCallContext context, ApiFuture<ListSampleQuerySetsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SAMPLE_QUERY_SETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SampleQuerySetServiceClient.ListSampleQuerySetsPagedResponse.createAsync((PageContext<ListSampleQuerySetsRequest, ListSampleQuerySetsResponse, SampleQuerySet>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetSampleQuerySetRequest, SampleQuerySet> getSampleQuerySetSettings() {
        return this.getSampleQuerySetSettings;
    }

    public PagedCallSettings<ListSampleQuerySetsRequest, ListSampleQuerySetsResponse, SampleQuerySetServiceClient.ListSampleQuerySetsPagedResponse> listSampleQuerySetsSettings() {
        return this.listSampleQuerySetsSettings;
    }

    public UnaryCallSettings<CreateSampleQuerySetRequest, SampleQuerySet> createSampleQuerySetSettings() {
        return this.createSampleQuerySetSettings;
    }

    public UnaryCallSettings<UpdateSampleQuerySetRequest, SampleQuerySet> updateSampleQuerySetSettings() {
        return this.updateSampleQuerySetSettings;
    }

    public UnaryCallSettings<DeleteSampleQuerySetRequest, Empty> deleteSampleQuerySetSettings() {
        return this.deleteSampleQuerySetSettings;
    }

    public SampleQuerySetServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSampleQuerySetServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSampleQuerySetServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "discoveryengine";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "discoveryengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "discoveryengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SampleQuerySetServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SampleQuerySetServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SampleQuerySetServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return SampleQuerySetServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SampleQuerySetServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getSampleQuerySetSettings = settingsBuilder.getSampleQuerySetSettings().build();
        this.listSampleQuerySetsSettings = settingsBuilder.listSampleQuerySetsSettings().build();
        this.createSampleQuerySetSettings = settingsBuilder.createSampleQuerySetSettings().build();
        this.updateSampleQuerySetSettings = settingsBuilder.updateSampleQuerySetSettings().build();
        this.deleteSampleQuerySetSettings = settingsBuilder.deleteSampleQuerySetSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SampleQuerySetServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetSampleQuerySetRequest, SampleQuerySet> getSampleQuerySetSettings;
        private final PagedCallSettings.Builder<ListSampleQuerySetsRequest, ListSampleQuerySetsResponse, SampleQuerySetServiceClient.ListSampleQuerySetsPagedResponse> listSampleQuerySetsSettings;
        private final UnaryCallSettings.Builder<CreateSampleQuerySetRequest, SampleQuerySet> createSampleQuerySetSettings;
        private final UnaryCallSettings.Builder<UpdateSampleQuerySetRequest, SampleQuerySet> updateSampleQuerySetSettings;
        private final UnaryCallSettings.Builder<DeleteSampleQuerySetRequest, Empty> deleteSampleQuerySetSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getSampleQuerySetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSampleQuerySetsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SAMPLE_QUERY_SETS_PAGE_STR_FACT);
            this.createSampleQuerySetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSampleQuerySetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSampleQuerySetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getSampleQuerySetSettings, this.listSampleQuerySetsSettings, this.createSampleQuerySetSettings, this.updateSampleQuerySetSettings, this.deleteSampleQuerySetSettings);
            Builder.initDefaults(this);
        }

        protected Builder(SampleQuerySetServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getSampleQuerySetSettings = settings.getSampleQuerySetSettings.toBuilder();
            this.listSampleQuerySetsSettings = settings.listSampleQuerySetsSettings.toBuilder();
            this.createSampleQuerySetSettings = settings.createSampleQuerySetSettings.toBuilder();
            this.updateSampleQuerySetSettings = settings.updateSampleQuerySetSettings.toBuilder();
            this.deleteSampleQuerySetSettings = settings.deleteSampleQuerySetSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getSampleQuerySetSettings, this.listSampleQuerySetsSettings, this.createSampleQuerySetSettings, this.updateSampleQuerySetSettings, this.deleteSampleQuerySetSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SampleQuerySetServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SampleQuerySetServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SampleQuerySetServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SampleQuerySetServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)SampleQuerySetServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)SampleQuerySetServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SampleQuerySetServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SampleQuerySetServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getSampleQuerySetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listSampleQuerySetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createSampleQuerySetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.updateSampleQuerySetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deleteSampleQuerySetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetSampleQuerySetRequest, SampleQuerySet> getSampleQuerySetSettings() {
            return this.getSampleQuerySetSettings;
        }

        public PagedCallSettings.Builder<ListSampleQuerySetsRequest, ListSampleQuerySetsResponse, SampleQuerySetServiceClient.ListSampleQuerySetsPagedResponse> listSampleQuerySetsSettings() {
            return this.listSampleQuerySetsSettings;
        }

        public UnaryCallSettings.Builder<CreateSampleQuerySetRequest, SampleQuerySet> createSampleQuerySetSettings() {
            return this.createSampleQuerySetSettings;
        }

        public UnaryCallSettings.Builder<UpdateSampleQuerySetRequest, SampleQuerySet> updateSampleQuerySetSettings() {
            return this.updateSampleQuerySetSettings;
        }

        public UnaryCallSettings.Builder<DeleteSampleQuerySetRequest, Empty> deleteSampleQuerySetSettings() {
            return this.deleteSampleQuerySetSettings;
        }

        public SampleQuerySetServiceStubSettings build() throws IOException {
            return new SampleQuerySetServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

