/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.Chunk;
import com.google.cloud.discoveryengine.v1alpha.ChunkName;
import com.google.cloud.discoveryengine.v1alpha.ChunkServiceSettings;
import com.google.cloud.discoveryengine.v1alpha.DocumentName;
import com.google.cloud.discoveryengine.v1alpha.GetChunkRequest;
import com.google.cloud.discoveryengine.v1alpha.ListChunksRequest;
import com.google.cloud.discoveryengine.v1alpha.ListChunksResponse;
import com.google.cloud.discoveryengine.v1alpha.stub.ChunkServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.ChunkServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ChunkServiceClient
implements BackgroundResource {
    private final ChunkServiceSettings settings;
    private final ChunkServiceStub stub;

    public static final ChunkServiceClient create() throws IOException {
        return ChunkServiceClient.create(ChunkServiceSettings.newBuilder().build());
    }

    public static final ChunkServiceClient create(ChunkServiceSettings settings) throws IOException {
        return new ChunkServiceClient(settings);
    }

    public static final ChunkServiceClient create(ChunkServiceStub stub) {
        return new ChunkServiceClient(stub);
    }

    protected ChunkServiceClient(ChunkServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ChunkServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ChunkServiceClient(ChunkServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ChunkServiceSettings getSettings() {
        return this.settings;
    }

    public ChunkServiceStub getStub() {
        return this.stub;
    }

    public final Chunk getChunk(ChunkName name) {
        GetChunkRequest request = GetChunkRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getChunk(request);
    }

    public final Chunk getChunk(String name) {
        GetChunkRequest request = GetChunkRequest.newBuilder().setName(name).build();
        return this.getChunk(request);
    }

    public final Chunk getChunk(GetChunkRequest request) {
        return (Chunk)this.getChunkCallable().call((Object)request);
    }

    public final UnaryCallable<GetChunkRequest, Chunk> getChunkCallable() {
        return this.stub.getChunkCallable();
    }

    public final ListChunksPagedResponse listChunks(DocumentName parent) {
        ListChunksRequest request = ListChunksRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listChunks(request);
    }

    public final ListChunksPagedResponse listChunks(String parent) {
        ListChunksRequest request = ListChunksRequest.newBuilder().setParent(parent).build();
        return this.listChunks(request);
    }

    public final ListChunksPagedResponse listChunks(ListChunksRequest request) {
        return (ListChunksPagedResponse)((Object)this.listChunksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListChunksRequest, ListChunksPagedResponse> listChunksPagedCallable() {
        return this.stub.listChunksPagedCallable();
    }

    public final UnaryCallable<ListChunksRequest, ListChunksResponse> listChunksCallable() {
        return this.stub.listChunksCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListChunksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListChunksRequest, ListChunksResponse, Chunk, ListChunksPage, ListChunksFixedSizeCollection> {
        private ListChunksFixedSizeCollection(List<ListChunksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListChunksFixedSizeCollection createEmptyCollection() {
            return new ListChunksFixedSizeCollection(null, 0);
        }

        protected ListChunksFixedSizeCollection createCollection(List<ListChunksPage> pages, int collectionSize) {
            return new ListChunksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListChunksPage
    extends AbstractPage<ListChunksRequest, ListChunksResponse, Chunk, ListChunksPage> {
        private ListChunksPage(PageContext<ListChunksRequest, ListChunksResponse, Chunk> context, ListChunksResponse response) {
            super(context, (Object)response);
        }

        private static ListChunksPage createEmptyPage() {
            return new ListChunksPage(null, null);
        }

        protected ListChunksPage createPage(PageContext<ListChunksRequest, ListChunksResponse, Chunk> context, ListChunksResponse response) {
            return new ListChunksPage(context, response);
        }

        public ApiFuture<ListChunksPage> createPageAsync(PageContext<ListChunksRequest, ListChunksResponse, Chunk> context, ApiFuture<ListChunksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListChunksPagedResponse
    extends AbstractPagedListResponse<ListChunksRequest, ListChunksResponse, Chunk, ListChunksPage, ListChunksFixedSizeCollection> {
        public static ApiFuture<ListChunksPagedResponse> createAsync(PageContext<ListChunksRequest, ListChunksResponse, Chunk> context, ApiFuture<ListChunksResponse> futureResponse) {
            ApiFuture<ListChunksPage> futurePage = ListChunksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListChunksPagedResponse((ListChunksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListChunksPagedResponse(ListChunksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListChunksFixedSizeCollection.createEmptyCollection());
        }
    }
}

