/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1;

import com.google.api.HttpBody;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1.CollectUserEventRequest;
import com.google.cloud.discoveryengine.v1.ImportUserEventsMetadata;
import com.google.cloud.discoveryengine.v1.ImportUserEventsRequest;
import com.google.cloud.discoveryengine.v1.ImportUserEventsResponse;
import com.google.cloud.discoveryengine.v1.UserEvent;
import com.google.cloud.discoveryengine.v1.UserEventServiceSettings;
import com.google.cloud.discoveryengine.v1.WriteUserEventRequest;
import com.google.cloud.discoveryengine.v1.stub.UserEventServiceStub;
import com.google.cloud.discoveryengine.v1.stub.UserEventServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class UserEventServiceClient
implements BackgroundResource {
    private final UserEventServiceSettings settings;
    private final UserEventServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final UserEventServiceClient create() throws IOException {
        return UserEventServiceClient.create(UserEventServiceSettings.newBuilder().build());
    }

    public static final UserEventServiceClient create(UserEventServiceSettings settings) throws IOException {
        return new UserEventServiceClient(settings);
    }

    public static final UserEventServiceClient create(UserEventServiceStub stub) {
        return new UserEventServiceClient(stub);
    }

    protected UserEventServiceClient(UserEventServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((UserEventServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected UserEventServiceClient(UserEventServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final UserEventServiceSettings getSettings() {
        return this.settings;
    }

    public UserEventServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final UserEvent writeUserEvent(WriteUserEventRequest request) {
        return (UserEvent)this.writeUserEventCallable().call((Object)request);
    }

    public final UnaryCallable<WriteUserEventRequest, UserEvent> writeUserEventCallable() {
        return this.stub.writeUserEventCallable();
    }

    public final HttpBody collectUserEvent(CollectUserEventRequest request) {
        return (HttpBody)this.collectUserEventCallable().call((Object)request);
    }

    public final UnaryCallable<CollectUserEventRequest, HttpBody> collectUserEventCallable() {
        return this.stub.collectUserEventCallable();
    }

    public final OperationFuture<ImportUserEventsResponse, ImportUserEventsMetadata> importUserEventsAsync(ImportUserEventsRequest request) {
        return this.importUserEventsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportUserEventsRequest, ImportUserEventsResponse, ImportUserEventsMetadata> importUserEventsOperationCallable() {
        return this.stub.importUserEventsOperationCallable();
    }

    public final UnaryCallable<ImportUserEventsRequest, Operation> importUserEventsCallable() {
        return this.stub.importUserEventsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

