/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1.Conversation;
import com.google.cloud.discoveryengine.v1.ConversationalSearchServiceClient;
import com.google.cloud.discoveryengine.v1.ConverseConversationRequest;
import com.google.cloud.discoveryengine.v1.ConverseConversationResponse;
import com.google.cloud.discoveryengine.v1.CreateConversationRequest;
import com.google.cloud.discoveryengine.v1.DeleteConversationRequest;
import com.google.cloud.discoveryengine.v1.GetConversationRequest;
import com.google.cloud.discoveryengine.v1.ListConversationsRequest;
import com.google.cloud.discoveryengine.v1.ListConversationsResponse;
import com.google.cloud.discoveryengine.v1.UpdateConversationRequest;
import com.google.cloud.discoveryengine.v1.stub.ConversationalSearchServiceStub;
import com.google.cloud.discoveryengine.v1.stub.GrpcConversationalSearchServiceStub;
import com.google.cloud.discoveryengine.v1.stub.HttpJsonConversationalSearchServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ConversationalSearchServiceStubSettings
extends StubSettings<ConversationalSearchServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<ConverseConversationRequest, ConverseConversationResponse> converseConversationSettings;
    private final UnaryCallSettings<CreateConversationRequest, Conversation> createConversationSettings;
    private final UnaryCallSettings<DeleteConversationRequest, Empty> deleteConversationSettings;
    private final UnaryCallSettings<UpdateConversationRequest, Conversation> updateConversationSettings;
    private final UnaryCallSettings<GetConversationRequest, Conversation> getConversationSettings;
    private final PagedCallSettings<ListConversationsRequest, ListConversationsResponse, ConversationalSearchServiceClient.ListConversationsPagedResponse> listConversationsSettings;
    private static final PagedListDescriptor<ListConversationsRequest, ListConversationsResponse, Conversation> LIST_CONVERSATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListConversationsRequest, ListConversationsResponse, Conversation>(){

        public String emptyToken() {
            return "";
        }

        public ListConversationsRequest injectToken(ListConversationsRequest payload, String token) {
            return ListConversationsRequest.newBuilder((ListConversationsRequest)payload).setPageToken(token).build();
        }

        public ListConversationsRequest injectPageSize(ListConversationsRequest payload, int pageSize) {
            return ListConversationsRequest.newBuilder((ListConversationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListConversationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListConversationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Conversation> extractResources(ListConversationsResponse payload) {
            return payload.getConversationsList() == null ? ImmutableList.of() : payload.getConversationsList();
        }
    };
    private static final PagedListResponseFactory<ListConversationsRequest, ListConversationsResponse, ConversationalSearchServiceClient.ListConversationsPagedResponse> LIST_CONVERSATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListConversationsRequest, ListConversationsResponse, ConversationalSearchServiceClient.ListConversationsPagedResponse>(){

        public ApiFuture<ConversationalSearchServiceClient.ListConversationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListConversationsRequest, ListConversationsResponse> callable, ListConversationsRequest request, ApiCallContext context, ApiFuture<ListConversationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONVERSATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConversationalSearchServiceClient.ListConversationsPagedResponse.createAsync((PageContext<ListConversationsRequest, ListConversationsResponse, Conversation>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<ConverseConversationRequest, ConverseConversationResponse> converseConversationSettings() {
        return this.converseConversationSettings;
    }

    public UnaryCallSettings<CreateConversationRequest, Conversation> createConversationSettings() {
        return this.createConversationSettings;
    }

    public UnaryCallSettings<DeleteConversationRequest, Empty> deleteConversationSettings() {
        return this.deleteConversationSettings;
    }

    public UnaryCallSettings<UpdateConversationRequest, Conversation> updateConversationSettings() {
        return this.updateConversationSettings;
    }

    public UnaryCallSettings<GetConversationRequest, Conversation> getConversationSettings() {
        return this.getConversationSettings;
    }

    public PagedCallSettings<ListConversationsRequest, ListConversationsResponse, ConversationalSearchServiceClient.ListConversationsPagedResponse> listConversationsSettings() {
        return this.listConversationsSettings;
    }

    public ConversationalSearchServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcConversationalSearchServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonConversationalSearchServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "discoveryengine";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "discoveryengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "discoveryengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ConversationalSearchServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ConversationalSearchServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ConversationalSearchServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ConversationalSearchServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ConversationalSearchServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.converseConversationSettings = settingsBuilder.converseConversationSettings().build();
        this.createConversationSettings = settingsBuilder.createConversationSettings().build();
        this.deleteConversationSettings = settingsBuilder.deleteConversationSettings().build();
        this.updateConversationSettings = settingsBuilder.updateConversationSettings().build();
        this.getConversationSettings = settingsBuilder.getConversationSettings().build();
        this.listConversationsSettings = settingsBuilder.listConversationsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ConversationalSearchServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<ConverseConversationRequest, ConverseConversationResponse> converseConversationSettings;
        private final UnaryCallSettings.Builder<CreateConversationRequest, Conversation> createConversationSettings;
        private final UnaryCallSettings.Builder<DeleteConversationRequest, Empty> deleteConversationSettings;
        private final UnaryCallSettings.Builder<UpdateConversationRequest, Conversation> updateConversationSettings;
        private final UnaryCallSettings.Builder<GetConversationRequest, Conversation> getConversationSettings;
        private final PagedCallSettings.Builder<ListConversationsRequest, ListConversationsResponse, ConversationalSearchServiceClient.ListConversationsPagedResponse> listConversationsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.converseConversationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createConversationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteConversationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateConversationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getConversationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listConversationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONVERSATIONS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.converseConversationSettings, this.createConversationSettings, this.deleteConversationSettings, this.updateConversationSettings, this.getConversationSettings, this.listConversationsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ConversationalSearchServiceStubSettings settings) {
            super((StubSettings)settings);
            this.converseConversationSettings = settings.converseConversationSettings.toBuilder();
            this.createConversationSettings = settings.createConversationSettings.toBuilder();
            this.deleteConversationSettings = settings.deleteConversationSettings.toBuilder();
            this.updateConversationSettings = settings.updateConversationSettings.toBuilder();
            this.getConversationSettings = settings.getConversationSettings.toBuilder();
            this.listConversationsSettings = settings.listConversationsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.converseConversationSettings, this.createConversationSettings, this.deleteConversationSettings, this.updateConversationSettings, this.getConversationSettings, this.listConversationsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ConversationalSearchServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ConversationalSearchServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ConversationalSearchServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ConversationalSearchServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ConversationalSearchServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ConversationalSearchServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ConversationalSearchServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ConversationalSearchServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ConversationalSearchServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ConversationalSearchServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.converseConversationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createConversationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deleteConversationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.updateConversationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getConversationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listConversationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<ConverseConversationRequest, ConverseConversationResponse> converseConversationSettings() {
            return this.converseConversationSettings;
        }

        public UnaryCallSettings.Builder<CreateConversationRequest, Conversation> createConversationSettings() {
            return this.createConversationSettings;
        }

        public UnaryCallSettings.Builder<DeleteConversationRequest, Empty> deleteConversationSettings() {
            return this.deleteConversationSettings;
        }

        public UnaryCallSettings.Builder<UpdateConversationRequest, Conversation> updateConversationSettings() {
            return this.updateConversationSettings;
        }

        public UnaryCallSettings.Builder<GetConversationRequest, Conversation> getConversationSettings() {
            return this.getConversationSettings;
        }

        public PagedCallSettings.Builder<ListConversationsRequest, ListConversationsResponse, ConversationalSearchServiceClient.ListConversationsPagedResponse> listConversationsSettings() {
            return this.listConversationsSettings;
        }

        public ConversationalSearchServiceStubSettings build() throws IOException {
            return new ConversationalSearchServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

