/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.OperationsClient;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.RecrawlUrisMetadata;
import com.google.cloud.discoveryengine.v1alpha.RecrawlUrisRequest;
import com.google.cloud.discoveryengine.v1alpha.RecrawlUrisResponse;
import com.google.cloud.discoveryengine.v1alpha.SiteSearchEngineServiceSettings;
import com.google.cloud.discoveryengine.v1alpha.stub.SiteSearchEngineServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.SiteSearchEngineServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.OperationsStub;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SiteSearchEngineServiceClient
implements BackgroundResource {
    private final SiteSearchEngineServiceSettings settings;
    private final SiteSearchEngineServiceStub stub;
    private final OperationsClient httpJsonOperationsClient;
    private final com.google.longrunning.OperationsClient operationsClient;

    public static final SiteSearchEngineServiceClient create() throws IOException {
        return SiteSearchEngineServiceClient.create(SiteSearchEngineServiceSettings.newBuilder().build());
    }

    public static final SiteSearchEngineServiceClient create(SiteSearchEngineServiceSettings settings) throws IOException {
        return new SiteSearchEngineServiceClient(settings);
    }

    public static final SiteSearchEngineServiceClient create(SiteSearchEngineServiceStub stub) {
        return new SiteSearchEngineServiceClient(stub);
    }

    protected SiteSearchEngineServiceClient(SiteSearchEngineServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SiteSearchEngineServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = com.google.longrunning.OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = OperationsClient.create((com.google.api.gax.httpjson.longrunning.stub.OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected SiteSearchEngineServiceClient(SiteSearchEngineServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = com.google.longrunning.OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = OperationsClient.create((com.google.api.gax.httpjson.longrunning.stub.OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final SiteSearchEngineServiceSettings getSettings() {
        return this.settings;
    }

    public SiteSearchEngineServiceStub getStub() {
        return this.stub;
    }

    public final com.google.longrunning.OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<RecrawlUrisResponse, RecrawlUrisMetadata> recrawlUrisAsync(RecrawlUrisRequest request) {
        return this.recrawlUrisOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RecrawlUrisRequest, RecrawlUrisResponse, RecrawlUrisMetadata> recrawlUrisOperationCallable() {
        return this.stub.recrawlUrisOperationCallable();
    }

    public final UnaryCallable<RecrawlUrisRequest, Operation> recrawlUrisCallable() {
        return this.stub.recrawlUrisCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

