/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.DeletePhoneNumberRequest;
import com.google.cloud.dialogflow.v2beta1.ListPhoneNumbersRequest;
import com.google.cloud.dialogflow.v2beta1.ListPhoneNumbersResponse;
import com.google.cloud.dialogflow.v2beta1.LocationName;
import com.google.cloud.dialogflow.v2beta1.PhoneNumber;
import com.google.cloud.dialogflow.v2beta1.PhoneNumberName;
import com.google.cloud.dialogflow.v2beta1.PhoneNumbersSettings;
import com.google.cloud.dialogflow.v2beta1.ProjectName;
import com.google.cloud.dialogflow.v2beta1.UndeletePhoneNumberRequest;
import com.google.cloud.dialogflow.v2beta1.UpdatePhoneNumberRequest;
import com.google.cloud.dialogflow.v2beta1.stub.PhoneNumbersStub;
import com.google.cloud.dialogflow.v2beta1.stub.PhoneNumbersStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class PhoneNumbersClient
implements BackgroundResource {
    private final PhoneNumbersSettings settings;
    private final PhoneNumbersStub stub;

    public static final PhoneNumbersClient create() throws IOException {
        return PhoneNumbersClient.create(PhoneNumbersSettings.newBuilder().build());
    }

    public static final PhoneNumbersClient create(PhoneNumbersSettings settings) throws IOException {
        return new PhoneNumbersClient(settings);
    }

    public static final PhoneNumbersClient create(PhoneNumbersStub stub) {
        return new PhoneNumbersClient(stub);
    }

    protected PhoneNumbersClient(PhoneNumbersSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PhoneNumbersStubSettings)settings.getStubSettings()).createStub();
    }

    protected PhoneNumbersClient(PhoneNumbersStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final PhoneNumbersSettings getSettings() {
        return this.settings;
    }

    public PhoneNumbersStub getStub() {
        return this.stub;
    }

    public final ListPhoneNumbersPagedResponse listPhoneNumbers(LocationName parent) {
        ListPhoneNumbersRequest request = ListPhoneNumbersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPhoneNumbers(request);
    }

    public final ListPhoneNumbersPagedResponse listPhoneNumbers(ProjectName parent) {
        ListPhoneNumbersRequest request = ListPhoneNumbersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPhoneNumbers(request);
    }

    public final ListPhoneNumbersPagedResponse listPhoneNumbers(String parent) {
        ListPhoneNumbersRequest request = ListPhoneNumbersRequest.newBuilder().setParent(parent).build();
        return this.listPhoneNumbers(request);
    }

    public final ListPhoneNumbersPagedResponse listPhoneNumbers(ListPhoneNumbersRequest request) {
        return (ListPhoneNumbersPagedResponse)((Object)this.listPhoneNumbersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPhoneNumbersRequest, ListPhoneNumbersPagedResponse> listPhoneNumbersPagedCallable() {
        return this.stub.listPhoneNumbersPagedCallable();
    }

    public final UnaryCallable<ListPhoneNumbersRequest, ListPhoneNumbersResponse> listPhoneNumbersCallable() {
        return this.stub.listPhoneNumbersCallable();
    }

    public final PhoneNumber updatePhoneNumber(PhoneNumber phoneNumber, FieldMask updateMask) {
        UpdatePhoneNumberRequest request = UpdatePhoneNumberRequest.newBuilder().setPhoneNumber(phoneNumber).setUpdateMask(updateMask).build();
        return this.updatePhoneNumber(request);
    }

    public final PhoneNumber updatePhoneNumber(UpdatePhoneNumberRequest request) {
        return (PhoneNumber)this.updatePhoneNumberCallable().call((Object)request);
    }

    public final UnaryCallable<UpdatePhoneNumberRequest, PhoneNumber> updatePhoneNumberCallable() {
        return this.stub.updatePhoneNumberCallable();
    }

    public final PhoneNumber deletePhoneNumber(PhoneNumberName name) {
        DeletePhoneNumberRequest request = DeletePhoneNumberRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deletePhoneNumber(request);
    }

    public final PhoneNumber deletePhoneNumber(String name) {
        DeletePhoneNumberRequest request = DeletePhoneNumberRequest.newBuilder().setName(name).build();
        return this.deletePhoneNumber(request);
    }

    public final PhoneNumber deletePhoneNumber(DeletePhoneNumberRequest request) {
        return (PhoneNumber)this.deletePhoneNumberCallable().call((Object)request);
    }

    public final UnaryCallable<DeletePhoneNumberRequest, PhoneNumber> deletePhoneNumberCallable() {
        return this.stub.deletePhoneNumberCallable();
    }

    public final PhoneNumber undeletePhoneNumber(PhoneNumberName name) {
        UndeletePhoneNumberRequest request = UndeletePhoneNumberRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.undeletePhoneNumber(request);
    }

    public final PhoneNumber undeletePhoneNumber(String name) {
        UndeletePhoneNumberRequest request = UndeletePhoneNumberRequest.newBuilder().setName(name).build();
        return this.undeletePhoneNumber(request);
    }

    public final PhoneNumber undeletePhoneNumber(UndeletePhoneNumberRequest request) {
        return (PhoneNumber)this.undeletePhoneNumberCallable().call((Object)request);
    }

    public final UnaryCallable<UndeletePhoneNumberRequest, PhoneNumber> undeletePhoneNumberCallable() {
        return this.stub.undeletePhoneNumberCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPhoneNumbersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPhoneNumbersRequest, ListPhoneNumbersResponse, PhoneNumber, ListPhoneNumbersPage, ListPhoneNumbersFixedSizeCollection> {
        private ListPhoneNumbersFixedSizeCollection(List<ListPhoneNumbersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPhoneNumbersFixedSizeCollection createEmptyCollection() {
            return new ListPhoneNumbersFixedSizeCollection(null, 0);
        }

        protected ListPhoneNumbersFixedSizeCollection createCollection(List<ListPhoneNumbersPage> pages, int collectionSize) {
            return new ListPhoneNumbersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPhoneNumbersPage
    extends AbstractPage<ListPhoneNumbersRequest, ListPhoneNumbersResponse, PhoneNumber, ListPhoneNumbersPage> {
        private ListPhoneNumbersPage(PageContext<ListPhoneNumbersRequest, ListPhoneNumbersResponse, PhoneNumber> context, ListPhoneNumbersResponse response) {
            super(context, (Object)response);
        }

        private static ListPhoneNumbersPage createEmptyPage() {
            return new ListPhoneNumbersPage(null, null);
        }

        protected ListPhoneNumbersPage createPage(PageContext<ListPhoneNumbersRequest, ListPhoneNumbersResponse, PhoneNumber> context, ListPhoneNumbersResponse response) {
            return new ListPhoneNumbersPage(context, response);
        }

        public ApiFuture<ListPhoneNumbersPage> createPageAsync(PageContext<ListPhoneNumbersRequest, ListPhoneNumbersResponse, PhoneNumber> context, ApiFuture<ListPhoneNumbersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPhoneNumbersPagedResponse
    extends AbstractPagedListResponse<ListPhoneNumbersRequest, ListPhoneNumbersResponse, PhoneNumber, ListPhoneNumbersPage, ListPhoneNumbersFixedSizeCollection> {
        public static ApiFuture<ListPhoneNumbersPagedResponse> createAsync(PageContext<ListPhoneNumbersRequest, ListPhoneNumbersResponse, PhoneNumber> context, ApiFuture<ListPhoneNumbersResponse> futureResponse) {
            ApiFuture<ListPhoneNumbersPage> futurePage = ListPhoneNumbersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPhoneNumbersPagedResponse((ListPhoneNumbersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPhoneNumbersPagedResponse(ListPhoneNumbersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPhoneNumbersFixedSizeCollection.createEmptyCollection());
        }
    }
}

