/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.CreateGeneratorEvaluationRequest;
import com.google.cloud.dialogflow.v2beta1.DeleteGeneratorEvaluationRequest;
import com.google.cloud.dialogflow.v2beta1.GeneratorEvaluation;
import com.google.cloud.dialogflow.v2beta1.GeneratorEvaluationName;
import com.google.cloud.dialogflow.v2beta1.GeneratorEvaluationOperationMetadata;
import com.google.cloud.dialogflow.v2beta1.GeneratorEvaluationsSettings;
import com.google.cloud.dialogflow.v2beta1.GeneratorName;
import com.google.cloud.dialogflow.v2beta1.GetGeneratorEvaluationRequest;
import com.google.cloud.dialogflow.v2beta1.ListGeneratorEvaluationsRequest;
import com.google.cloud.dialogflow.v2beta1.ListGeneratorEvaluationsResponse;
import com.google.cloud.dialogflow.v2beta1.stub.GeneratorEvaluationsStub;
import com.google.cloud.dialogflow.v2beta1.stub.GeneratorEvaluationsStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GeneratorEvaluationsClient
implements BackgroundResource {
    private final GeneratorEvaluationsSettings settings;
    private final GeneratorEvaluationsStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final GeneratorEvaluationsClient create() throws IOException {
        return GeneratorEvaluationsClient.create(GeneratorEvaluationsSettings.newBuilder().build());
    }

    public static final GeneratorEvaluationsClient create(GeneratorEvaluationsSettings settings) throws IOException {
        return new GeneratorEvaluationsClient(settings);
    }

    public static final GeneratorEvaluationsClient create(GeneratorEvaluationsStub stub) {
        return new GeneratorEvaluationsClient(stub);
    }

    protected GeneratorEvaluationsClient(GeneratorEvaluationsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GeneratorEvaluationsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected GeneratorEvaluationsClient(GeneratorEvaluationsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final GeneratorEvaluationsSettings getSettings() {
        return this.settings;
    }

    public GeneratorEvaluationsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<GeneratorEvaluation, GeneratorEvaluationOperationMetadata> createGeneratorEvaluationAsync(GeneratorName parent, GeneratorEvaluation generatorEvaluation) {
        CreateGeneratorEvaluationRequest request = CreateGeneratorEvaluationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setGeneratorEvaluation(generatorEvaluation).build();
        return this.createGeneratorEvaluationAsync(request);
    }

    public final OperationFuture<GeneratorEvaluation, GeneratorEvaluationOperationMetadata> createGeneratorEvaluationAsync(String parent, GeneratorEvaluation generatorEvaluation) {
        CreateGeneratorEvaluationRequest request = CreateGeneratorEvaluationRequest.newBuilder().setParent(parent).setGeneratorEvaluation(generatorEvaluation).build();
        return this.createGeneratorEvaluationAsync(request);
    }

    public final OperationFuture<GeneratorEvaluation, GeneratorEvaluationOperationMetadata> createGeneratorEvaluationAsync(CreateGeneratorEvaluationRequest request) {
        return this.createGeneratorEvaluationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateGeneratorEvaluationRequest, GeneratorEvaluation, GeneratorEvaluationOperationMetadata> createGeneratorEvaluationOperationCallable() {
        return this.stub.createGeneratorEvaluationOperationCallable();
    }

    public final UnaryCallable<CreateGeneratorEvaluationRequest, Operation> createGeneratorEvaluationCallable() {
        return this.stub.createGeneratorEvaluationCallable();
    }

    public final GeneratorEvaluation getGeneratorEvaluation(GeneratorEvaluationName name) {
        GetGeneratorEvaluationRequest request = GetGeneratorEvaluationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGeneratorEvaluation(request);
    }

    public final GeneratorEvaluation getGeneratorEvaluation(String name) {
        GetGeneratorEvaluationRequest request = GetGeneratorEvaluationRequest.newBuilder().setName(name).build();
        return this.getGeneratorEvaluation(request);
    }

    public final GeneratorEvaluation getGeneratorEvaluation(GetGeneratorEvaluationRequest request) {
        return (GeneratorEvaluation)this.getGeneratorEvaluationCallable().call((Object)request);
    }

    public final UnaryCallable<GetGeneratorEvaluationRequest, GeneratorEvaluation> getGeneratorEvaluationCallable() {
        return this.stub.getGeneratorEvaluationCallable();
    }

    public final ListGeneratorEvaluationsPagedResponse listGeneratorEvaluations(GeneratorName parent) {
        ListGeneratorEvaluationsRequest request = ListGeneratorEvaluationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGeneratorEvaluations(request);
    }

    public final ListGeneratorEvaluationsPagedResponse listGeneratorEvaluations(String parent) {
        ListGeneratorEvaluationsRequest request = ListGeneratorEvaluationsRequest.newBuilder().setParent(parent).build();
        return this.listGeneratorEvaluations(request);
    }

    public final ListGeneratorEvaluationsPagedResponse listGeneratorEvaluations(ListGeneratorEvaluationsRequest request) {
        return (ListGeneratorEvaluationsPagedResponse)((Object)this.listGeneratorEvaluationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGeneratorEvaluationsRequest, ListGeneratorEvaluationsPagedResponse> listGeneratorEvaluationsPagedCallable() {
        return this.stub.listGeneratorEvaluationsPagedCallable();
    }

    public final UnaryCallable<ListGeneratorEvaluationsRequest, ListGeneratorEvaluationsResponse> listGeneratorEvaluationsCallable() {
        return this.stub.listGeneratorEvaluationsCallable();
    }

    public final void deleteGeneratorEvaluation(GeneratorEvaluationName name) {
        DeleteGeneratorEvaluationRequest request = DeleteGeneratorEvaluationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteGeneratorEvaluation(request);
    }

    public final void deleteGeneratorEvaluation(String name) {
        DeleteGeneratorEvaluationRequest request = DeleteGeneratorEvaluationRequest.newBuilder().setName(name).build();
        this.deleteGeneratorEvaluation(request);
    }

    public final void deleteGeneratorEvaluation(DeleteGeneratorEvaluationRequest request) {
        this.deleteGeneratorEvaluationCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteGeneratorEvaluationRequest, Empty> deleteGeneratorEvaluationCallable() {
        return this.stub.deleteGeneratorEvaluationCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListGeneratorEvaluationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGeneratorEvaluationsRequest, ListGeneratorEvaluationsResponse, GeneratorEvaluation, ListGeneratorEvaluationsPage, ListGeneratorEvaluationsFixedSizeCollection> {
        private ListGeneratorEvaluationsFixedSizeCollection(List<ListGeneratorEvaluationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGeneratorEvaluationsFixedSizeCollection createEmptyCollection() {
            return new ListGeneratorEvaluationsFixedSizeCollection(null, 0);
        }

        protected ListGeneratorEvaluationsFixedSizeCollection createCollection(List<ListGeneratorEvaluationsPage> pages, int collectionSize) {
            return new ListGeneratorEvaluationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGeneratorEvaluationsPage
    extends AbstractPage<ListGeneratorEvaluationsRequest, ListGeneratorEvaluationsResponse, GeneratorEvaluation, ListGeneratorEvaluationsPage> {
        private ListGeneratorEvaluationsPage(PageContext<ListGeneratorEvaluationsRequest, ListGeneratorEvaluationsResponse, GeneratorEvaluation> context, ListGeneratorEvaluationsResponse response) {
            super(context, (Object)response);
        }

        private static ListGeneratorEvaluationsPage createEmptyPage() {
            return new ListGeneratorEvaluationsPage(null, null);
        }

        protected ListGeneratorEvaluationsPage createPage(PageContext<ListGeneratorEvaluationsRequest, ListGeneratorEvaluationsResponse, GeneratorEvaluation> context, ListGeneratorEvaluationsResponse response) {
            return new ListGeneratorEvaluationsPage(context, response);
        }

        public ApiFuture<ListGeneratorEvaluationsPage> createPageAsync(PageContext<ListGeneratorEvaluationsRequest, ListGeneratorEvaluationsResponse, GeneratorEvaluation> context, ApiFuture<ListGeneratorEvaluationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGeneratorEvaluationsPagedResponse
    extends AbstractPagedListResponse<ListGeneratorEvaluationsRequest, ListGeneratorEvaluationsResponse, GeneratorEvaluation, ListGeneratorEvaluationsPage, ListGeneratorEvaluationsFixedSizeCollection> {
        public static ApiFuture<ListGeneratorEvaluationsPagedResponse> createAsync(PageContext<ListGeneratorEvaluationsRequest, ListGeneratorEvaluationsResponse, GeneratorEvaluation> context, ApiFuture<ListGeneratorEvaluationsResponse> futureResponse) {
            ApiFuture<ListGeneratorEvaluationsPage> futurePage = ListGeneratorEvaluationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListGeneratorEvaluationsPagedResponse((ListGeneratorEvaluationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListGeneratorEvaluationsPagedResponse(ListGeneratorEvaluationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGeneratorEvaluationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

