/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.AgentName;
import com.google.cloud.dialogflow.v2beta1.CreateEnvironmentRequest;
import com.google.cloud.dialogflow.v2beta1.DeleteEnvironmentRequest;
import com.google.cloud.dialogflow.v2beta1.Environment;
import com.google.cloud.dialogflow.v2beta1.EnvironmentHistory;
import com.google.cloud.dialogflow.v2beta1.EnvironmentsSettings;
import com.google.cloud.dialogflow.v2beta1.GetEnvironmentHistoryRequest;
import com.google.cloud.dialogflow.v2beta1.GetEnvironmentRequest;
import com.google.cloud.dialogflow.v2beta1.ListEnvironmentsRequest;
import com.google.cloud.dialogflow.v2beta1.ListEnvironmentsResponse;
import com.google.cloud.dialogflow.v2beta1.UpdateEnvironmentRequest;
import com.google.cloud.dialogflow.v2beta1.stub.EnvironmentsStub;
import com.google.cloud.dialogflow.v2beta1.stub.EnvironmentsStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class EnvironmentsClient
implements BackgroundResource {
    private final EnvironmentsSettings settings;
    private final EnvironmentsStub stub;

    public static final EnvironmentsClient create() throws IOException {
        return EnvironmentsClient.create(EnvironmentsSettings.newBuilder().build());
    }

    public static final EnvironmentsClient create(EnvironmentsSettings settings) throws IOException {
        return new EnvironmentsClient(settings);
    }

    public static final EnvironmentsClient create(EnvironmentsStub stub) {
        return new EnvironmentsClient(stub);
    }

    protected EnvironmentsClient(EnvironmentsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((EnvironmentsStubSettings)settings.getStubSettings()).createStub();
    }

    protected EnvironmentsClient(EnvironmentsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final EnvironmentsSettings getSettings() {
        return this.settings;
    }

    public EnvironmentsStub getStub() {
        return this.stub;
    }

    public final ListEnvironmentsPagedResponse listEnvironments(AgentName parent) {
        ListEnvironmentsRequest request = ListEnvironmentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEnvironments(request);
    }

    public final ListEnvironmentsPagedResponse listEnvironments(String parent) {
        ListEnvironmentsRequest request = ListEnvironmentsRequest.newBuilder().setParent(parent).build();
        return this.listEnvironments(request);
    }

    public final ListEnvironmentsPagedResponse listEnvironments(ListEnvironmentsRequest request) {
        return (ListEnvironmentsPagedResponse)((Object)this.listEnvironmentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEnvironmentsRequest, ListEnvironmentsPagedResponse> listEnvironmentsPagedCallable() {
        return this.stub.listEnvironmentsPagedCallable();
    }

    public final UnaryCallable<ListEnvironmentsRequest, ListEnvironmentsResponse> listEnvironmentsCallable() {
        return this.stub.listEnvironmentsCallable();
    }

    public final Environment getEnvironment(GetEnvironmentRequest request) {
        return (Environment)this.getEnvironmentCallable().call((Object)request);
    }

    public final UnaryCallable<GetEnvironmentRequest, Environment> getEnvironmentCallable() {
        return this.stub.getEnvironmentCallable();
    }

    public final Environment createEnvironment(CreateEnvironmentRequest request) {
        return (Environment)this.createEnvironmentCallable().call((Object)request);
    }

    public final UnaryCallable<CreateEnvironmentRequest, Environment> createEnvironmentCallable() {
        return this.stub.createEnvironmentCallable();
    }

    public final Environment updateEnvironment(UpdateEnvironmentRequest request) {
        return (Environment)this.updateEnvironmentCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateEnvironmentRequest, Environment> updateEnvironmentCallable() {
        return this.stub.updateEnvironmentCallable();
    }

    public final void deleteEnvironment(DeleteEnvironmentRequest request) {
        this.deleteEnvironmentCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteEnvironmentRequest, Empty> deleteEnvironmentCallable() {
        return this.stub.deleteEnvironmentCallable();
    }

    public final GetEnvironmentHistoryPagedResponse getEnvironmentHistory(GetEnvironmentHistoryRequest request) {
        return (GetEnvironmentHistoryPagedResponse)((Object)this.getEnvironmentHistoryPagedCallable().call((Object)request));
    }

    public final UnaryCallable<GetEnvironmentHistoryRequest, GetEnvironmentHistoryPagedResponse> getEnvironmentHistoryPagedCallable() {
        return this.stub.getEnvironmentHistoryPagedCallable();
    }

    public final UnaryCallable<GetEnvironmentHistoryRequest, EnvironmentHistory> getEnvironmentHistoryCallable() {
        return this.stub.getEnvironmentHistoryCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class GetEnvironmentHistoryFixedSizeCollection
    extends AbstractFixedSizeCollection<GetEnvironmentHistoryRequest, EnvironmentHistory, EnvironmentHistory.Entry, GetEnvironmentHistoryPage, GetEnvironmentHistoryFixedSizeCollection> {
        private GetEnvironmentHistoryFixedSizeCollection(List<GetEnvironmentHistoryPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static GetEnvironmentHistoryFixedSizeCollection createEmptyCollection() {
            return new GetEnvironmentHistoryFixedSizeCollection(null, 0);
        }

        protected GetEnvironmentHistoryFixedSizeCollection createCollection(List<GetEnvironmentHistoryPage> pages, int collectionSize) {
            return new GetEnvironmentHistoryFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class GetEnvironmentHistoryPage
    extends AbstractPage<GetEnvironmentHistoryRequest, EnvironmentHistory, EnvironmentHistory.Entry, GetEnvironmentHistoryPage> {
        private GetEnvironmentHistoryPage(PageContext<GetEnvironmentHistoryRequest, EnvironmentHistory, EnvironmentHistory.Entry> context, EnvironmentHistory response) {
            super(context, (Object)response);
        }

        private static GetEnvironmentHistoryPage createEmptyPage() {
            return new GetEnvironmentHistoryPage(null, null);
        }

        protected GetEnvironmentHistoryPage createPage(PageContext<GetEnvironmentHistoryRequest, EnvironmentHistory, EnvironmentHistory.Entry> context, EnvironmentHistory response) {
            return new GetEnvironmentHistoryPage(context, response);
        }

        public ApiFuture<GetEnvironmentHistoryPage> createPageAsync(PageContext<GetEnvironmentHistoryRequest, EnvironmentHistory, EnvironmentHistory.Entry> context, ApiFuture<EnvironmentHistory> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class GetEnvironmentHistoryPagedResponse
    extends AbstractPagedListResponse<GetEnvironmentHistoryRequest, EnvironmentHistory, EnvironmentHistory.Entry, GetEnvironmentHistoryPage, GetEnvironmentHistoryFixedSizeCollection> {
        public static ApiFuture<GetEnvironmentHistoryPagedResponse> createAsync(PageContext<GetEnvironmentHistoryRequest, EnvironmentHistory, EnvironmentHistory.Entry> context, ApiFuture<EnvironmentHistory> futureResponse) {
            ApiFuture<GetEnvironmentHistoryPage> futurePage = GetEnvironmentHistoryPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new GetEnvironmentHistoryPagedResponse((GetEnvironmentHistoryPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private GetEnvironmentHistoryPagedResponse(GetEnvironmentHistoryPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)GetEnvironmentHistoryFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEnvironmentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment, ListEnvironmentsPage, ListEnvironmentsFixedSizeCollection> {
        private ListEnvironmentsFixedSizeCollection(List<ListEnvironmentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEnvironmentsFixedSizeCollection createEmptyCollection() {
            return new ListEnvironmentsFixedSizeCollection(null, 0);
        }

        protected ListEnvironmentsFixedSizeCollection createCollection(List<ListEnvironmentsPage> pages, int collectionSize) {
            return new ListEnvironmentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEnvironmentsPage
    extends AbstractPage<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment, ListEnvironmentsPage> {
        private ListEnvironmentsPage(PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> context, ListEnvironmentsResponse response) {
            super(context, (Object)response);
        }

        private static ListEnvironmentsPage createEmptyPage() {
            return new ListEnvironmentsPage(null, null);
        }

        protected ListEnvironmentsPage createPage(PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> context, ListEnvironmentsResponse response) {
            return new ListEnvironmentsPage(context, response);
        }

        public ApiFuture<ListEnvironmentsPage> createPageAsync(PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> context, ApiFuture<ListEnvironmentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEnvironmentsPagedResponse
    extends AbstractPagedListResponse<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment, ListEnvironmentsPage, ListEnvironmentsFixedSizeCollection> {
        public static ApiFuture<ListEnvironmentsPagedResponse> createAsync(PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> context, ApiFuture<ListEnvironmentsResponse> futureResponse) {
            ApiFuture<ListEnvironmentsPage> futurePage = ListEnvironmentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEnvironmentsPagedResponse((ListEnvironmentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEnvironmentsPagedResponse(ListEnvironmentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEnvironmentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

