/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.CreateSipTrunkRequest;
import com.google.cloud.dialogflow.v2.DeleteSipTrunkRequest;
import com.google.cloud.dialogflow.v2.GetSipTrunkRequest;
import com.google.cloud.dialogflow.v2.ListSipTrunksRequest;
import com.google.cloud.dialogflow.v2.ListSipTrunksResponse;
import com.google.cloud.dialogflow.v2.LocationName;
import com.google.cloud.dialogflow.v2.SipTrunk;
import com.google.cloud.dialogflow.v2.SipTrunkName;
import com.google.cloud.dialogflow.v2.SipTrunksSettings;
import com.google.cloud.dialogflow.v2.UpdateSipTrunkRequest;
import com.google.cloud.dialogflow.v2.stub.SipTrunksStub;
import com.google.cloud.dialogflow.v2.stub.SipTrunksStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class SipTrunksClient
implements BackgroundResource {
    private final SipTrunksSettings settings;
    private final SipTrunksStub stub;

    public static final SipTrunksClient create() throws IOException {
        return SipTrunksClient.create(SipTrunksSettings.newBuilder().build());
    }

    public static final SipTrunksClient create(SipTrunksSettings settings) throws IOException {
        return new SipTrunksClient(settings);
    }

    public static final SipTrunksClient create(SipTrunksStub stub) {
        return new SipTrunksClient(stub);
    }

    protected SipTrunksClient(SipTrunksSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SipTrunksStubSettings)settings.getStubSettings()).createStub();
    }

    protected SipTrunksClient(SipTrunksStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SipTrunksSettings getSettings() {
        return this.settings;
    }

    public SipTrunksStub getStub() {
        return this.stub;
    }

    public final SipTrunk createSipTrunk(LocationName parent, SipTrunk sipTrunk) {
        CreateSipTrunkRequest request = CreateSipTrunkRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSipTrunk(sipTrunk).build();
        return this.createSipTrunk(request);
    }

    public final SipTrunk createSipTrunk(String parent, SipTrunk sipTrunk) {
        CreateSipTrunkRequest request = CreateSipTrunkRequest.newBuilder().setParent(parent).setSipTrunk(sipTrunk).build();
        return this.createSipTrunk(request);
    }

    public final SipTrunk createSipTrunk(CreateSipTrunkRequest request) {
        return (SipTrunk)this.createSipTrunkCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSipTrunkRequest, SipTrunk> createSipTrunkCallable() {
        return this.stub.createSipTrunkCallable();
    }

    public final void deleteSipTrunk(SipTrunkName name) {
        DeleteSipTrunkRequest request = DeleteSipTrunkRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteSipTrunk(request);
    }

    public final void deleteSipTrunk(String name) {
        DeleteSipTrunkRequest request = DeleteSipTrunkRequest.newBuilder().setName(name).build();
        this.deleteSipTrunk(request);
    }

    public final void deleteSipTrunk(DeleteSipTrunkRequest request) {
        this.deleteSipTrunkCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSipTrunkRequest, Empty> deleteSipTrunkCallable() {
        return this.stub.deleteSipTrunkCallable();
    }

    public final ListSipTrunksPagedResponse listSipTrunks(LocationName parent) {
        ListSipTrunksRequest request = ListSipTrunksRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSipTrunks(request);
    }

    public final ListSipTrunksPagedResponse listSipTrunks(String parent) {
        ListSipTrunksRequest request = ListSipTrunksRequest.newBuilder().setParent(parent).build();
        return this.listSipTrunks(request);
    }

    public final ListSipTrunksPagedResponse listSipTrunks(ListSipTrunksRequest request) {
        return (ListSipTrunksPagedResponse)((Object)this.listSipTrunksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSipTrunksRequest, ListSipTrunksPagedResponse> listSipTrunksPagedCallable() {
        return this.stub.listSipTrunksPagedCallable();
    }

    public final UnaryCallable<ListSipTrunksRequest, ListSipTrunksResponse> listSipTrunksCallable() {
        return this.stub.listSipTrunksCallable();
    }

    public final SipTrunk getSipTrunk(SipTrunkName name) {
        GetSipTrunkRequest request = GetSipTrunkRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSipTrunk(request);
    }

    public final SipTrunk getSipTrunk(String name) {
        GetSipTrunkRequest request = GetSipTrunkRequest.newBuilder().setName(name).build();
        return this.getSipTrunk(request);
    }

    public final SipTrunk getSipTrunk(GetSipTrunkRequest request) {
        return (SipTrunk)this.getSipTrunkCallable().call((Object)request);
    }

    public final UnaryCallable<GetSipTrunkRequest, SipTrunk> getSipTrunkCallable() {
        return this.stub.getSipTrunkCallable();
    }

    public final SipTrunk updateSipTrunk(SipTrunk sipTrunk, FieldMask updateMask) {
        UpdateSipTrunkRequest request = UpdateSipTrunkRequest.newBuilder().setSipTrunk(sipTrunk).setUpdateMask(updateMask).build();
        return this.updateSipTrunk(request);
    }

    public final SipTrunk updateSipTrunk(UpdateSipTrunkRequest request) {
        return (SipTrunk)this.updateSipTrunkCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSipTrunkRequest, SipTrunk> updateSipTrunkCallable() {
        return this.stub.updateSipTrunkCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSipTrunksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSipTrunksRequest, ListSipTrunksResponse, SipTrunk, ListSipTrunksPage, ListSipTrunksFixedSizeCollection> {
        private ListSipTrunksFixedSizeCollection(List<ListSipTrunksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSipTrunksFixedSizeCollection createEmptyCollection() {
            return new ListSipTrunksFixedSizeCollection(null, 0);
        }

        protected ListSipTrunksFixedSizeCollection createCollection(List<ListSipTrunksPage> pages, int collectionSize) {
            return new ListSipTrunksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSipTrunksPage
    extends AbstractPage<ListSipTrunksRequest, ListSipTrunksResponse, SipTrunk, ListSipTrunksPage> {
        private ListSipTrunksPage(PageContext<ListSipTrunksRequest, ListSipTrunksResponse, SipTrunk> context, ListSipTrunksResponse response) {
            super(context, (Object)response);
        }

        private static ListSipTrunksPage createEmptyPage() {
            return new ListSipTrunksPage(null, null);
        }

        protected ListSipTrunksPage createPage(PageContext<ListSipTrunksRequest, ListSipTrunksResponse, SipTrunk> context, ListSipTrunksResponse response) {
            return new ListSipTrunksPage(context, response);
        }

        public ApiFuture<ListSipTrunksPage> createPageAsync(PageContext<ListSipTrunksRequest, ListSipTrunksResponse, SipTrunk> context, ApiFuture<ListSipTrunksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSipTrunksPagedResponse
    extends AbstractPagedListResponse<ListSipTrunksRequest, ListSipTrunksResponse, SipTrunk, ListSipTrunksPage, ListSipTrunksFixedSizeCollection> {
        public static ApiFuture<ListSipTrunksPagedResponse> createAsync(PageContext<ListSipTrunksRequest, ListSipTrunksResponse, SipTrunk> context, ApiFuture<ListSipTrunksResponse> futureResponse) {
            ApiFuture<ListSipTrunksPage> futurePage = ListSipTrunksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSipTrunksPagedResponse((ListSipTrunksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSipTrunksPagedResponse(ListSipTrunksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSipTrunksFixedSizeCollection.createEmptyCollection());
        }
    }
}

