/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.CreateSipTrunkRequest;
import com.google.cloud.dialogflow.v2beta1.DeleteSipTrunkRequest;
import com.google.cloud.dialogflow.v2beta1.GetSipTrunkRequest;
import com.google.cloud.dialogflow.v2beta1.ListSipTrunksRequest;
import com.google.cloud.dialogflow.v2beta1.ListSipTrunksResponse;
import com.google.cloud.dialogflow.v2beta1.SipTrunk;
import com.google.cloud.dialogflow.v2beta1.SipTrunksClient;
import com.google.cloud.dialogflow.v2beta1.UpdateSipTrunkRequest;
import com.google.cloud.dialogflow.v2beta1.stub.GrpcSipTrunksStub;
import com.google.cloud.dialogflow.v2beta1.stub.HttpJsonSipTrunksStub;
import com.google.cloud.dialogflow.v2beta1.stub.SipTrunksStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class SipTrunksStubSettings
extends StubSettings<SipTrunksStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final UnaryCallSettings<CreateSipTrunkRequest, SipTrunk> createSipTrunkSettings;
    private final UnaryCallSettings<DeleteSipTrunkRequest, Empty> deleteSipTrunkSettings;
    private final PagedCallSettings<ListSipTrunksRequest, ListSipTrunksResponse, SipTrunksClient.ListSipTrunksPagedResponse> listSipTrunksSettings;
    private final UnaryCallSettings<GetSipTrunkRequest, SipTrunk> getSipTrunkSettings;
    private final UnaryCallSettings<UpdateSipTrunkRequest, SipTrunk> updateSipTrunkSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, SipTrunksClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListSipTrunksRequest, ListSipTrunksResponse, SipTrunk> LIST_SIP_TRUNKS_PAGE_STR_DESC = new PagedListDescriptor<ListSipTrunksRequest, ListSipTrunksResponse, SipTrunk>(){

        public String emptyToken() {
            return "";
        }

        public ListSipTrunksRequest injectToken(ListSipTrunksRequest payload, String token) {
            return ListSipTrunksRequest.newBuilder((ListSipTrunksRequest)payload).setPageToken(token).build();
        }

        public ListSipTrunksRequest injectPageSize(ListSipTrunksRequest payload, int pageSize) {
            return ListSipTrunksRequest.newBuilder((ListSipTrunksRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSipTrunksRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSipTrunksResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SipTrunk> extractResources(ListSipTrunksResponse payload) {
            return payload.getSipTrunksList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListSipTrunksRequest, ListSipTrunksResponse, SipTrunksClient.ListSipTrunksPagedResponse> LIST_SIP_TRUNKS_PAGE_STR_FACT = new PagedListResponseFactory<ListSipTrunksRequest, ListSipTrunksResponse, SipTrunksClient.ListSipTrunksPagedResponse>(){

        public ApiFuture<SipTrunksClient.ListSipTrunksPagedResponse> getFuturePagedResponse(UnaryCallable<ListSipTrunksRequest, ListSipTrunksResponse> callable, ListSipTrunksRequest request, ApiCallContext context, ApiFuture<ListSipTrunksResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SIP_TRUNKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SipTrunksClient.ListSipTrunksPagedResponse.createAsync((PageContext<ListSipTrunksRequest, ListSipTrunksResponse, SipTrunk>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, SipTrunksClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, SipTrunksClient.ListLocationsPagedResponse>(){

        public ApiFuture<SipTrunksClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SipTrunksClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateSipTrunkRequest, SipTrunk> createSipTrunkSettings() {
        return this.createSipTrunkSettings;
    }

    public UnaryCallSettings<DeleteSipTrunkRequest, Empty> deleteSipTrunkSettings() {
        return this.deleteSipTrunkSettings;
    }

    public PagedCallSettings<ListSipTrunksRequest, ListSipTrunksResponse, SipTrunksClient.ListSipTrunksPagedResponse> listSipTrunksSettings() {
        return this.listSipTrunksSettings;
    }

    public UnaryCallSettings<GetSipTrunkRequest, SipTrunk> getSipTrunkSettings() {
        return this.getSipTrunkSettings;
    }

    public UnaryCallSettings<UpdateSipTrunkRequest, SipTrunk> updateSipTrunkSettings() {
        return this.updateSipTrunkSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, SipTrunksClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public SipTrunksStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSipTrunksStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSipTrunksStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "dialogflow";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dialogflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SipTrunksStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SipTrunksStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SipTrunksStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return SipTrunksStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SipTrunksStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createSipTrunkSettings = settingsBuilder.createSipTrunkSettings().build();
        this.deleteSipTrunkSettings = settingsBuilder.deleteSipTrunkSettings().build();
        this.listSipTrunksSettings = settingsBuilder.listSipTrunksSettings().build();
        this.getSipTrunkSettings = settingsBuilder.getSipTrunkSettings().build();
        this.updateSipTrunkSettings = settingsBuilder.updateSipTrunkSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SipTrunksStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateSipTrunkRequest, SipTrunk> createSipTrunkSettings;
        private final UnaryCallSettings.Builder<DeleteSipTrunkRequest, Empty> deleteSipTrunkSettings;
        private final PagedCallSettings.Builder<ListSipTrunksRequest, ListSipTrunksResponse, SipTrunksClient.ListSipTrunksPagedResponse> listSipTrunksSettings;
        private final UnaryCallSettings.Builder<GetSipTrunkRequest, SipTrunk> getSipTrunkSettings;
        private final UnaryCallSettings.Builder<UpdateSipTrunkRequest, SipTrunk> updateSipTrunkSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, SipTrunksClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createSipTrunkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSipTrunkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSipTrunksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SIP_TRUNKS_PAGE_STR_FACT);
            this.getSipTrunkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSipTrunkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSipTrunkSettings, this.deleteSipTrunkSettings, this.listSipTrunksSettings, this.getSipTrunkSettings, this.updateSipTrunkSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(SipTrunksStubSettings settings) {
            super((StubSettings)settings);
            this.createSipTrunkSettings = settings.createSipTrunkSettings.toBuilder();
            this.deleteSipTrunkSettings = settings.deleteSipTrunkSettings.toBuilder();
            this.listSipTrunksSettings = settings.listSipTrunksSettings.toBuilder();
            this.getSipTrunkSettings = settings.getSipTrunkSettings.toBuilder();
            this.updateSipTrunkSettings = settings.updateSipTrunkSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSipTrunkSettings, this.deleteSipTrunkSettings, this.listSipTrunksSettings, this.getSipTrunkSettings, this.updateSipTrunkSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SipTrunksStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SipTrunksStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SipTrunksStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SipTrunksStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)SipTrunksStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)SipTrunksStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SipTrunksStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SipTrunksStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createSipTrunkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSipTrunkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listSipTrunksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getSipTrunkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateSipTrunkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateSipTrunkRequest, SipTrunk> createSipTrunkSettings() {
            return this.createSipTrunkSettings;
        }

        public UnaryCallSettings.Builder<DeleteSipTrunkRequest, Empty> deleteSipTrunkSettings() {
            return this.deleteSipTrunkSettings;
        }

        public PagedCallSettings.Builder<ListSipTrunksRequest, ListSipTrunksResponse, SipTrunksClient.ListSipTrunksPagedResponse> listSipTrunksSettings() {
            return this.listSipTrunksSettings;
        }

        public UnaryCallSettings.Builder<GetSipTrunkRequest, SipTrunk> getSipTrunkSettings() {
            return this.getSipTrunkSettings;
        }

        public UnaryCallSettings.Builder<UpdateSipTrunkRequest, SipTrunk> updateSipTrunkSettings() {
            return this.updateSipTrunkSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, SipTrunksClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public SipTrunksStubSettings build() throws IOException {
            return new SipTrunksStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

