/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.ConversationModel;
import com.google.cloud.dialogflow.v2.ConversationModelEvaluation;
import com.google.cloud.dialogflow.v2.ConversationModelName;
import com.google.cloud.dialogflow.v2.ConversationModelsSettings;
import com.google.cloud.dialogflow.v2.CreateConversationModelEvaluationOperationMetadata;
import com.google.cloud.dialogflow.v2.CreateConversationModelEvaluationRequest;
import com.google.cloud.dialogflow.v2.CreateConversationModelOperationMetadata;
import com.google.cloud.dialogflow.v2.CreateConversationModelRequest;
import com.google.cloud.dialogflow.v2.DeleteConversationModelOperationMetadata;
import com.google.cloud.dialogflow.v2.DeleteConversationModelRequest;
import com.google.cloud.dialogflow.v2.DeployConversationModelOperationMetadata;
import com.google.cloud.dialogflow.v2.DeployConversationModelRequest;
import com.google.cloud.dialogflow.v2.GetConversationModelEvaluationRequest;
import com.google.cloud.dialogflow.v2.GetConversationModelRequest;
import com.google.cloud.dialogflow.v2.ListConversationModelEvaluationsRequest;
import com.google.cloud.dialogflow.v2.ListConversationModelEvaluationsResponse;
import com.google.cloud.dialogflow.v2.ListConversationModelsRequest;
import com.google.cloud.dialogflow.v2.ListConversationModelsResponse;
import com.google.cloud.dialogflow.v2.UndeployConversationModelOperationMetadata;
import com.google.cloud.dialogflow.v2.UndeployConversationModelRequest;
import com.google.cloud.dialogflow.v2.stub.ConversationModelsStub;
import com.google.cloud.dialogflow.v2.stub.ConversationModelsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ConversationModelsClient
implements BackgroundResource {
    private final ConversationModelsSettings settings;
    private final ConversationModelsStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final ConversationModelsClient create() throws IOException {
        return ConversationModelsClient.create(ConversationModelsSettings.newBuilder().build());
    }

    public static final ConversationModelsClient create(ConversationModelsSettings settings) throws IOException {
        return new ConversationModelsClient(settings);
    }

    public static final ConversationModelsClient create(ConversationModelsStub stub) {
        return new ConversationModelsClient(stub);
    }

    protected ConversationModelsClient(ConversationModelsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ConversationModelsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ConversationModelsClient(ConversationModelsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ConversationModelsSettings getSettings() {
        return this.settings;
    }

    public ConversationModelsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<ConversationModel, CreateConversationModelOperationMetadata> createConversationModelAsync(String parent, ConversationModel conversationModel) {
        CreateConversationModelRequest request = CreateConversationModelRequest.newBuilder().setParent(parent).setConversationModel(conversationModel).build();
        return this.createConversationModelAsync(request);
    }

    public final OperationFuture<ConversationModel, CreateConversationModelOperationMetadata> createConversationModelAsync(CreateConversationModelRequest request) {
        return this.createConversationModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateConversationModelRequest, ConversationModel, CreateConversationModelOperationMetadata> createConversationModelOperationCallable() {
        return this.stub.createConversationModelOperationCallable();
    }

    public final UnaryCallable<CreateConversationModelRequest, Operation> createConversationModelCallable() {
        return this.stub.createConversationModelCallable();
    }

    public final ConversationModel getConversationModel(String name) {
        GetConversationModelRequest request = GetConversationModelRequest.newBuilder().setName(name).build();
        return this.getConversationModel(request);
    }

    public final ConversationModel getConversationModel(GetConversationModelRequest request) {
        return (ConversationModel)this.getConversationModelCallable().call((Object)request);
    }

    public final UnaryCallable<GetConversationModelRequest, ConversationModel> getConversationModelCallable() {
        return this.stub.getConversationModelCallable();
    }

    public final ListConversationModelsPagedResponse listConversationModels(String parent) {
        ListConversationModelsRequest request = ListConversationModelsRequest.newBuilder().setParent(parent).build();
        return this.listConversationModels(request);
    }

    public final ListConversationModelsPagedResponse listConversationModels(ListConversationModelsRequest request) {
        return (ListConversationModelsPagedResponse)((Object)this.listConversationModelsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConversationModelsRequest, ListConversationModelsPagedResponse> listConversationModelsPagedCallable() {
        return this.stub.listConversationModelsPagedCallable();
    }

    public final UnaryCallable<ListConversationModelsRequest, ListConversationModelsResponse> listConversationModelsCallable() {
        return this.stub.listConversationModelsCallable();
    }

    public final OperationFuture<Empty, DeleteConversationModelOperationMetadata> deleteConversationModelAsync(String name) {
        DeleteConversationModelRequest request = DeleteConversationModelRequest.newBuilder().setName(name).build();
        return this.deleteConversationModelAsync(request);
    }

    public final OperationFuture<Empty, DeleteConversationModelOperationMetadata> deleteConversationModelAsync(DeleteConversationModelRequest request) {
        return this.deleteConversationModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteConversationModelRequest, Empty, DeleteConversationModelOperationMetadata> deleteConversationModelOperationCallable() {
        return this.stub.deleteConversationModelOperationCallable();
    }

    public final UnaryCallable<DeleteConversationModelRequest, Operation> deleteConversationModelCallable() {
        return this.stub.deleteConversationModelCallable();
    }

    public final OperationFuture<Empty, DeployConversationModelOperationMetadata> deployConversationModelAsync(DeployConversationModelRequest request) {
        return this.deployConversationModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeployConversationModelRequest, Empty, DeployConversationModelOperationMetadata> deployConversationModelOperationCallable() {
        return this.stub.deployConversationModelOperationCallable();
    }

    public final UnaryCallable<DeployConversationModelRequest, Operation> deployConversationModelCallable() {
        return this.stub.deployConversationModelCallable();
    }

    public final OperationFuture<Empty, UndeployConversationModelOperationMetadata> undeployConversationModelAsync(UndeployConversationModelRequest request) {
        return this.undeployConversationModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UndeployConversationModelRequest, Empty, UndeployConversationModelOperationMetadata> undeployConversationModelOperationCallable() {
        return this.stub.undeployConversationModelOperationCallable();
    }

    public final UnaryCallable<UndeployConversationModelRequest, Operation> undeployConversationModelCallable() {
        return this.stub.undeployConversationModelCallable();
    }

    public final ConversationModelEvaluation getConversationModelEvaluation(String name) {
        GetConversationModelEvaluationRequest request = GetConversationModelEvaluationRequest.newBuilder().setName(name).build();
        return this.getConversationModelEvaluation(request);
    }

    public final ConversationModelEvaluation getConversationModelEvaluation(GetConversationModelEvaluationRequest request) {
        return (ConversationModelEvaluation)this.getConversationModelEvaluationCallable().call((Object)request);
    }

    public final UnaryCallable<GetConversationModelEvaluationRequest, ConversationModelEvaluation> getConversationModelEvaluationCallable() {
        return this.stub.getConversationModelEvaluationCallable();
    }

    public final ListConversationModelEvaluationsPagedResponse listConversationModelEvaluations(String parent) {
        ListConversationModelEvaluationsRequest request = ListConversationModelEvaluationsRequest.newBuilder().setParent(parent).build();
        return this.listConversationModelEvaluations(request);
    }

    public final ListConversationModelEvaluationsPagedResponse listConversationModelEvaluations(ListConversationModelEvaluationsRequest request) {
        return (ListConversationModelEvaluationsPagedResponse)((Object)this.listConversationModelEvaluationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConversationModelEvaluationsRequest, ListConversationModelEvaluationsPagedResponse> listConversationModelEvaluationsPagedCallable() {
        return this.stub.listConversationModelEvaluationsPagedCallable();
    }

    public final UnaryCallable<ListConversationModelEvaluationsRequest, ListConversationModelEvaluationsResponse> listConversationModelEvaluationsCallable() {
        return this.stub.listConversationModelEvaluationsCallable();
    }

    public final OperationFuture<ConversationModelEvaluation, CreateConversationModelEvaluationOperationMetadata> createConversationModelEvaluationAsync(ConversationModelName parent, ConversationModelEvaluation conversationModelEvaluation) {
        CreateConversationModelEvaluationRequest request = CreateConversationModelEvaluationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConversationModelEvaluation(conversationModelEvaluation).build();
        return this.createConversationModelEvaluationAsync(request);
    }

    public final OperationFuture<ConversationModelEvaluation, CreateConversationModelEvaluationOperationMetadata> createConversationModelEvaluationAsync(String parent, ConversationModelEvaluation conversationModelEvaluation) {
        CreateConversationModelEvaluationRequest request = CreateConversationModelEvaluationRequest.newBuilder().setParent(parent).setConversationModelEvaluation(conversationModelEvaluation).build();
        return this.createConversationModelEvaluationAsync(request);
    }

    public final OperationFuture<ConversationModelEvaluation, CreateConversationModelEvaluationOperationMetadata> createConversationModelEvaluationAsync(CreateConversationModelEvaluationRequest request) {
        return this.createConversationModelEvaluationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateConversationModelEvaluationRequest, ConversationModelEvaluation, CreateConversationModelEvaluationOperationMetadata> createConversationModelEvaluationOperationCallable() {
        return this.stub.createConversationModelEvaluationOperationCallable();
    }

    public final UnaryCallable<CreateConversationModelEvaluationRequest, Operation> createConversationModelEvaluationCallable() {
        return this.stub.createConversationModelEvaluationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListConversationModelEvaluationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConversationModelEvaluationsRequest, ListConversationModelEvaluationsResponse, ConversationModelEvaluation, ListConversationModelEvaluationsPage, ListConversationModelEvaluationsFixedSizeCollection> {
        private ListConversationModelEvaluationsFixedSizeCollection(List<ListConversationModelEvaluationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConversationModelEvaluationsFixedSizeCollection createEmptyCollection() {
            return new ListConversationModelEvaluationsFixedSizeCollection(null, 0);
        }

        protected ListConversationModelEvaluationsFixedSizeCollection createCollection(List<ListConversationModelEvaluationsPage> pages, int collectionSize) {
            return new ListConversationModelEvaluationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConversationModelEvaluationsPage
    extends AbstractPage<ListConversationModelEvaluationsRequest, ListConversationModelEvaluationsResponse, ConversationModelEvaluation, ListConversationModelEvaluationsPage> {
        private ListConversationModelEvaluationsPage(PageContext<ListConversationModelEvaluationsRequest, ListConversationModelEvaluationsResponse, ConversationModelEvaluation> context, ListConversationModelEvaluationsResponse response) {
            super(context, (Object)response);
        }

        private static ListConversationModelEvaluationsPage createEmptyPage() {
            return new ListConversationModelEvaluationsPage(null, null);
        }

        protected ListConversationModelEvaluationsPage createPage(PageContext<ListConversationModelEvaluationsRequest, ListConversationModelEvaluationsResponse, ConversationModelEvaluation> context, ListConversationModelEvaluationsResponse response) {
            return new ListConversationModelEvaluationsPage(context, response);
        }

        public ApiFuture<ListConversationModelEvaluationsPage> createPageAsync(PageContext<ListConversationModelEvaluationsRequest, ListConversationModelEvaluationsResponse, ConversationModelEvaluation> context, ApiFuture<ListConversationModelEvaluationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConversationModelEvaluationsPagedResponse
    extends AbstractPagedListResponse<ListConversationModelEvaluationsRequest, ListConversationModelEvaluationsResponse, ConversationModelEvaluation, ListConversationModelEvaluationsPage, ListConversationModelEvaluationsFixedSizeCollection> {
        public static ApiFuture<ListConversationModelEvaluationsPagedResponse> createAsync(PageContext<ListConversationModelEvaluationsRequest, ListConversationModelEvaluationsResponse, ConversationModelEvaluation> context, ApiFuture<ListConversationModelEvaluationsResponse> futureResponse) {
            ApiFuture<ListConversationModelEvaluationsPage> futurePage = ListConversationModelEvaluationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListConversationModelEvaluationsPagedResponse((ListConversationModelEvaluationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListConversationModelEvaluationsPagedResponse(ListConversationModelEvaluationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConversationModelEvaluationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListConversationModelsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConversationModelsRequest, ListConversationModelsResponse, ConversationModel, ListConversationModelsPage, ListConversationModelsFixedSizeCollection> {
        private ListConversationModelsFixedSizeCollection(List<ListConversationModelsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConversationModelsFixedSizeCollection createEmptyCollection() {
            return new ListConversationModelsFixedSizeCollection(null, 0);
        }

        protected ListConversationModelsFixedSizeCollection createCollection(List<ListConversationModelsPage> pages, int collectionSize) {
            return new ListConversationModelsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConversationModelsPage
    extends AbstractPage<ListConversationModelsRequest, ListConversationModelsResponse, ConversationModel, ListConversationModelsPage> {
        private ListConversationModelsPage(PageContext<ListConversationModelsRequest, ListConversationModelsResponse, ConversationModel> context, ListConversationModelsResponse response) {
            super(context, (Object)response);
        }

        private static ListConversationModelsPage createEmptyPage() {
            return new ListConversationModelsPage(null, null);
        }

        protected ListConversationModelsPage createPage(PageContext<ListConversationModelsRequest, ListConversationModelsResponse, ConversationModel> context, ListConversationModelsResponse response) {
            return new ListConversationModelsPage(context, response);
        }

        public ApiFuture<ListConversationModelsPage> createPageAsync(PageContext<ListConversationModelsRequest, ListConversationModelsResponse, ConversationModel> context, ApiFuture<ListConversationModelsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConversationModelsPagedResponse
    extends AbstractPagedListResponse<ListConversationModelsRequest, ListConversationModelsResponse, ConversationModel, ListConversationModelsPage, ListConversationModelsFixedSizeCollection> {
        public static ApiFuture<ListConversationModelsPagedResponse> createAsync(PageContext<ListConversationModelsRequest, ListConversationModelsResponse, ConversationModel> context, ApiFuture<ListConversationModelsResponse> futureResponse) {
            ApiFuture<ListConversationModelsPage> futurePage = ListConversationModelsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListConversationModelsPagedResponse((ListConversationModelsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListConversationModelsPagedResponse(ListConversationModelsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConversationModelsFixedSizeCollection.createEmptyCollection());
        }
    }
}

