/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.AnalyzeContentRequest;
import com.google.cloud.dialogflow.v2.AnalyzeContentResponse;
import com.google.cloud.dialogflow.v2.AudioInput;
import com.google.cloud.dialogflow.v2.ConversationName;
import com.google.cloud.dialogflow.v2.CreateParticipantRequest;
import com.google.cloud.dialogflow.v2.EventInput;
import com.google.cloud.dialogflow.v2.GetParticipantRequest;
import com.google.cloud.dialogflow.v2.ListParticipantsRequest;
import com.google.cloud.dialogflow.v2.ListParticipantsResponse;
import com.google.cloud.dialogflow.v2.Participant;
import com.google.cloud.dialogflow.v2.ParticipantName;
import com.google.cloud.dialogflow.v2.ParticipantsSettings;
import com.google.cloud.dialogflow.v2.StreamingAnalyzeContentRequest;
import com.google.cloud.dialogflow.v2.StreamingAnalyzeContentResponse;
import com.google.cloud.dialogflow.v2.SuggestArticlesRequest;
import com.google.cloud.dialogflow.v2.SuggestArticlesResponse;
import com.google.cloud.dialogflow.v2.SuggestFaqAnswersRequest;
import com.google.cloud.dialogflow.v2.SuggestFaqAnswersResponse;
import com.google.cloud.dialogflow.v2.SuggestKnowledgeAssistRequest;
import com.google.cloud.dialogflow.v2.SuggestKnowledgeAssistResponse;
import com.google.cloud.dialogflow.v2.SuggestSmartRepliesRequest;
import com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse;
import com.google.cloud.dialogflow.v2.TextInput;
import com.google.cloud.dialogflow.v2.UpdateParticipantRequest;
import com.google.cloud.dialogflow.v2.stub.ParticipantsStub;
import com.google.cloud.dialogflow.v2.stub.ParticipantsStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ParticipantsClient
implements BackgroundResource {
    private final ParticipantsSettings settings;
    private final ParticipantsStub stub;

    public static final ParticipantsClient create() throws IOException {
        return ParticipantsClient.create(ParticipantsSettings.newBuilder().build());
    }

    public static final ParticipantsClient create(ParticipantsSettings settings) throws IOException {
        return new ParticipantsClient(settings);
    }

    public static final ParticipantsClient create(ParticipantsStub stub) {
        return new ParticipantsClient(stub);
    }

    protected ParticipantsClient(ParticipantsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ParticipantsStubSettings)settings.getStubSettings()).createStub();
    }

    protected ParticipantsClient(ParticipantsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ParticipantsSettings getSettings() {
        return this.settings;
    }

    public ParticipantsStub getStub() {
        return this.stub;
    }

    public final Participant createParticipant(ConversationName parent, Participant participant) {
        CreateParticipantRequest request = CreateParticipantRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setParticipant(participant).build();
        return this.createParticipant(request);
    }

    public final Participant createParticipant(String parent, Participant participant) {
        CreateParticipantRequest request = CreateParticipantRequest.newBuilder().setParent(parent).setParticipant(participant).build();
        return this.createParticipant(request);
    }

    public final Participant createParticipant(CreateParticipantRequest request) {
        return (Participant)this.createParticipantCallable().call((Object)request);
    }

    public final UnaryCallable<CreateParticipantRequest, Participant> createParticipantCallable() {
        return this.stub.createParticipantCallable();
    }

    public final Participant getParticipant(ParticipantName name) {
        GetParticipantRequest request = GetParticipantRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getParticipant(request);
    }

    public final Participant getParticipant(String name) {
        GetParticipantRequest request = GetParticipantRequest.newBuilder().setName(name).build();
        return this.getParticipant(request);
    }

    public final Participant getParticipant(GetParticipantRequest request) {
        return (Participant)this.getParticipantCallable().call((Object)request);
    }

    public final UnaryCallable<GetParticipantRequest, Participant> getParticipantCallable() {
        return this.stub.getParticipantCallable();
    }

    public final ListParticipantsPagedResponse listParticipants(ConversationName parent) {
        ListParticipantsRequest request = ListParticipantsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listParticipants(request);
    }

    public final ListParticipantsPagedResponse listParticipants(String parent) {
        ListParticipantsRequest request = ListParticipantsRequest.newBuilder().setParent(parent).build();
        return this.listParticipants(request);
    }

    public final ListParticipantsPagedResponse listParticipants(ListParticipantsRequest request) {
        return (ListParticipantsPagedResponse)((Object)this.listParticipantsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListParticipantsRequest, ListParticipantsPagedResponse> listParticipantsPagedCallable() {
        return this.stub.listParticipantsPagedCallable();
    }

    public final UnaryCallable<ListParticipantsRequest, ListParticipantsResponse> listParticipantsCallable() {
        return this.stub.listParticipantsCallable();
    }

    public final Participant updateParticipant(Participant participant, FieldMask updateMask) {
        UpdateParticipantRequest request = UpdateParticipantRequest.newBuilder().setParticipant(participant).setUpdateMask(updateMask).build();
        return this.updateParticipant(request);
    }

    public final Participant updateParticipant(UpdateParticipantRequest request) {
        return (Participant)this.updateParticipantCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateParticipantRequest, Participant> updateParticipantCallable() {
        return this.stub.updateParticipantCallable();
    }

    public final AnalyzeContentResponse analyzeContent(ParticipantName participant, AudioInput audioInput) {
        AnalyzeContentRequest request = AnalyzeContentRequest.newBuilder().setParticipant(participant == null ? null : participant.toString()).setAudioInput(audioInput).build();
        return this.analyzeContent(request);
    }

    public final AnalyzeContentResponse analyzeContent(ParticipantName participant, EventInput eventInput) {
        AnalyzeContentRequest request = AnalyzeContentRequest.newBuilder().setParticipant(participant == null ? null : participant.toString()).setEventInput(eventInput).build();
        return this.analyzeContent(request);
    }

    public final AnalyzeContentResponse analyzeContent(ParticipantName participant, TextInput textInput) {
        AnalyzeContentRequest request = AnalyzeContentRequest.newBuilder().setParticipant(participant == null ? null : participant.toString()).setTextInput(textInput).build();
        return this.analyzeContent(request);
    }

    public final AnalyzeContentResponse analyzeContent(String participant, AudioInput audioInput) {
        AnalyzeContentRequest request = AnalyzeContentRequest.newBuilder().setParticipant(participant).setAudioInput(audioInput).build();
        return this.analyzeContent(request);
    }

    public final AnalyzeContentResponse analyzeContent(String participant, EventInput eventInput) {
        AnalyzeContentRequest request = AnalyzeContentRequest.newBuilder().setParticipant(participant).setEventInput(eventInput).build();
        return this.analyzeContent(request);
    }

    public final AnalyzeContentResponse analyzeContent(String participant, TextInput textInput) {
        AnalyzeContentRequest request = AnalyzeContentRequest.newBuilder().setParticipant(participant).setTextInput(textInput).build();
        return this.analyzeContent(request);
    }

    public final AnalyzeContentResponse analyzeContent(AnalyzeContentRequest request) {
        return (AnalyzeContentResponse)this.analyzeContentCallable().call((Object)request);
    }

    public final UnaryCallable<AnalyzeContentRequest, AnalyzeContentResponse> analyzeContentCallable() {
        return this.stub.analyzeContentCallable();
    }

    public final BidiStreamingCallable<StreamingAnalyzeContentRequest, StreamingAnalyzeContentResponse> streamingAnalyzeContentCallable() {
        return this.stub.streamingAnalyzeContentCallable();
    }

    public final SuggestArticlesResponse suggestArticles(ParticipantName parent) {
        SuggestArticlesRequest request = SuggestArticlesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.suggestArticles(request);
    }

    public final SuggestArticlesResponse suggestArticles(String parent) {
        SuggestArticlesRequest request = SuggestArticlesRequest.newBuilder().setParent(parent).build();
        return this.suggestArticles(request);
    }

    public final SuggestArticlesResponse suggestArticles(SuggestArticlesRequest request) {
        return (SuggestArticlesResponse)this.suggestArticlesCallable().call((Object)request);
    }

    public final UnaryCallable<SuggestArticlesRequest, SuggestArticlesResponse> suggestArticlesCallable() {
        return this.stub.suggestArticlesCallable();
    }

    public final SuggestFaqAnswersResponse suggestFaqAnswers(ParticipantName parent) {
        SuggestFaqAnswersRequest request = SuggestFaqAnswersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.suggestFaqAnswers(request);
    }

    public final SuggestFaqAnswersResponse suggestFaqAnswers(String parent) {
        SuggestFaqAnswersRequest request = SuggestFaqAnswersRequest.newBuilder().setParent(parent).build();
        return this.suggestFaqAnswers(request);
    }

    public final SuggestFaqAnswersResponse suggestFaqAnswers(SuggestFaqAnswersRequest request) {
        return (SuggestFaqAnswersResponse)this.suggestFaqAnswersCallable().call((Object)request);
    }

    public final UnaryCallable<SuggestFaqAnswersRequest, SuggestFaqAnswersResponse> suggestFaqAnswersCallable() {
        return this.stub.suggestFaqAnswersCallable();
    }

    public final SuggestSmartRepliesResponse suggestSmartReplies(ParticipantName parent) {
        SuggestSmartRepliesRequest request = SuggestSmartRepliesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.suggestSmartReplies(request);
    }

    public final SuggestSmartRepliesResponse suggestSmartReplies(String parent) {
        SuggestSmartRepliesRequest request = SuggestSmartRepliesRequest.newBuilder().setParent(parent).build();
        return this.suggestSmartReplies(request);
    }

    public final SuggestSmartRepliesResponse suggestSmartReplies(SuggestSmartRepliesRequest request) {
        return (SuggestSmartRepliesResponse)this.suggestSmartRepliesCallable().call((Object)request);
    }

    public final UnaryCallable<SuggestSmartRepliesRequest, SuggestSmartRepliesResponse> suggestSmartRepliesCallable() {
        return this.stub.suggestSmartRepliesCallable();
    }

    public final SuggestKnowledgeAssistResponse suggestKnowledgeAssist(SuggestKnowledgeAssistRequest request) {
        return (SuggestKnowledgeAssistResponse)this.suggestKnowledgeAssistCallable().call((Object)request);
    }

    public final UnaryCallable<SuggestKnowledgeAssistRequest, SuggestKnowledgeAssistResponse> suggestKnowledgeAssistCallable() {
        return this.stub.suggestKnowledgeAssistCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListParticipantsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListParticipantsRequest, ListParticipantsResponse, Participant, ListParticipantsPage, ListParticipantsFixedSizeCollection> {
        private ListParticipantsFixedSizeCollection(List<ListParticipantsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListParticipantsFixedSizeCollection createEmptyCollection() {
            return new ListParticipantsFixedSizeCollection(null, 0);
        }

        protected ListParticipantsFixedSizeCollection createCollection(List<ListParticipantsPage> pages, int collectionSize) {
            return new ListParticipantsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListParticipantsPage
    extends AbstractPage<ListParticipantsRequest, ListParticipantsResponse, Participant, ListParticipantsPage> {
        private ListParticipantsPage(PageContext<ListParticipantsRequest, ListParticipantsResponse, Participant> context, ListParticipantsResponse response) {
            super(context, (Object)response);
        }

        private static ListParticipantsPage createEmptyPage() {
            return new ListParticipantsPage(null, null);
        }

        protected ListParticipantsPage createPage(PageContext<ListParticipantsRequest, ListParticipantsResponse, Participant> context, ListParticipantsResponse response) {
            return new ListParticipantsPage(context, response);
        }

        public ApiFuture<ListParticipantsPage> createPageAsync(PageContext<ListParticipantsRequest, ListParticipantsResponse, Participant> context, ApiFuture<ListParticipantsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListParticipantsPagedResponse
    extends AbstractPagedListResponse<ListParticipantsRequest, ListParticipantsResponse, Participant, ListParticipantsPage, ListParticipantsFixedSizeCollection> {
        public static ApiFuture<ListParticipantsPagedResponse> createAsync(PageContext<ListParticipantsRequest, ListParticipantsResponse, Participant> context, ApiFuture<ListParticipantsResponse> futureResponse) {
            ApiFuture<ListParticipantsPage> futurePage = ListParticipantsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListParticipantsPagedResponse((ListParticipantsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListParticipantsPagedResponse(ListParticipantsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListParticipantsFixedSizeCollection.createEmptyCollection());
        }
    }
}

