/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.CreateVersionRequest;
import com.google.cloud.dialogflow.v2.DeleteVersionRequest;
import com.google.cloud.dialogflow.v2.GetVersionRequest;
import com.google.cloud.dialogflow.v2.ListVersionsRequest;
import com.google.cloud.dialogflow.v2.ListVersionsResponse;
import com.google.cloud.dialogflow.v2.UpdateVersionRequest;
import com.google.cloud.dialogflow.v2.Version;
import com.google.cloud.dialogflow.v2.VersionsClient;
import com.google.cloud.dialogflow.v2.stub.GrpcVersionsCallableFactory;
import com.google.cloud.dialogflow.v2.stub.VersionsStub;
import com.google.cloud.dialogflow.v2.stub.VersionsStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcVersionsStub
extends VersionsStub {
    private static final MethodDescriptor<ListVersionsRequest, ListVersionsResponse> listVersionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Versions/ListVersions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListVersionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListVersionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetVersionRequest, Version> getVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Versions/GetVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)GetVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Version.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateVersionRequest, Version> createVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Versions/CreateVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Version.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateVersionRequest, Version> updateVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Versions/UpdateVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Version.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteVersionRequest, Empty> deleteVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Versions/DeleteVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private final UnaryCallable<ListVersionsRequest, ListVersionsResponse> listVersionsCallable;
    private final UnaryCallable<ListVersionsRequest, VersionsClient.ListVersionsPagedResponse> listVersionsPagedCallable;
    private final UnaryCallable<GetVersionRequest, Version> getVersionCallable;
    private final UnaryCallable<CreateVersionRequest, Version> createVersionCallable;
    private final UnaryCallable<UpdateVersionRequest, Version> updateVersionCallable;
    private final UnaryCallable<DeleteVersionRequest, Empty> deleteVersionCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcVersionsStub create(VersionsStubSettings settings) throws IOException {
        return new GrpcVersionsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcVersionsStub create(ClientContext clientContext) throws IOException {
        return new GrpcVersionsStub(VersionsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcVersionsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcVersionsStub(VersionsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcVersionsStub(VersionsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcVersionsCallableFactory());
    }

    protected GrpcVersionsStub(VersionsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listVersionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listVersionsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getVersionMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings createVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createVersionMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings updateVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateVersionMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"version.name", (Object)String.valueOf(request.getVersion().getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteVersionMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        this.listVersionsCallable = callableFactory.createUnaryCallable(listVersionsTransportSettings, settings.listVersionsSettings(), clientContext);
        this.listVersionsPagedCallable = callableFactory.createPagedCallable(listVersionsTransportSettings, settings.listVersionsSettings(), clientContext);
        this.getVersionCallable = callableFactory.createUnaryCallable(getVersionTransportSettings, settings.getVersionSettings(), clientContext);
        this.createVersionCallable = callableFactory.createUnaryCallable(createVersionTransportSettings, settings.createVersionSettings(), clientContext);
        this.updateVersionCallable = callableFactory.createUnaryCallable(updateVersionTransportSettings, settings.updateVersionSettings(), clientContext);
        this.deleteVersionCallable = callableFactory.createUnaryCallable(deleteVersionTransportSettings, settings.deleteVersionSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListVersionsRequest, ListVersionsResponse> listVersionsCallable() {
        return this.listVersionsCallable;
    }

    @Override
    public UnaryCallable<ListVersionsRequest, VersionsClient.ListVersionsPagedResponse> listVersionsPagedCallable() {
        return this.listVersionsPagedCallable;
    }

    @Override
    public UnaryCallable<GetVersionRequest, Version> getVersionCallable() {
        return this.getVersionCallable;
    }

    @Override
    public UnaryCallable<CreateVersionRequest, Version> createVersionCallable() {
        return this.createVersionCallable;
    }

    @Override
    public UnaryCallable<UpdateVersionRequest, Version> updateVersionCallable() {
        return this.updateVersionCallable;
    }

    @Override
    public UnaryCallable<DeleteVersionRequest, Empty> deleteVersionCallable() {
        return this.deleteVersionCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

