/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.CreateDocumentRequest;
import com.google.cloud.dialogflow.v2beta1.DeleteDocumentRequest;
import com.google.cloud.dialogflow.v2beta1.Document;
import com.google.cloud.dialogflow.v2beta1.DocumentsClient;
import com.google.cloud.dialogflow.v2beta1.GetDocumentRequest;
import com.google.cloud.dialogflow.v2beta1.ImportDocumentsRequest;
import com.google.cloud.dialogflow.v2beta1.ImportDocumentsResponse;
import com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata;
import com.google.cloud.dialogflow.v2beta1.ListDocumentsRequest;
import com.google.cloud.dialogflow.v2beta1.ListDocumentsResponse;
import com.google.cloud.dialogflow.v2beta1.ReloadDocumentRequest;
import com.google.cloud.dialogflow.v2beta1.UpdateDocumentRequest;
import com.google.cloud.dialogflow.v2beta1.stub.DocumentsStub;
import com.google.cloud.dialogflow.v2beta1.stub.GrpcDocumentsStub;
import com.google.cloud.dialogflow.v2beta1.stub.HttpJsonDocumentsStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class DocumentsStubSettings
extends StubSettings<DocumentsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final PagedCallSettings<ListDocumentsRequest, ListDocumentsResponse, DocumentsClient.ListDocumentsPagedResponse> listDocumentsSettings;
    private final UnaryCallSettings<GetDocumentRequest, Document> getDocumentSettings;
    private final UnaryCallSettings<CreateDocumentRequest, Operation> createDocumentSettings;
    private final OperationCallSettings<CreateDocumentRequest, Document, KnowledgeOperationMetadata> createDocumentOperationSettings;
    private final UnaryCallSettings<ImportDocumentsRequest, Operation> importDocumentsSettings;
    private final OperationCallSettings<ImportDocumentsRequest, ImportDocumentsResponse, KnowledgeOperationMetadata> importDocumentsOperationSettings;
    private final UnaryCallSettings<DeleteDocumentRequest, Operation> deleteDocumentSettings;
    private final OperationCallSettings<DeleteDocumentRequest, Empty, KnowledgeOperationMetadata> deleteDocumentOperationSettings;
    private final UnaryCallSettings<UpdateDocumentRequest, Operation> updateDocumentSettings;
    private final OperationCallSettings<UpdateDocumentRequest, Document, KnowledgeOperationMetadata> updateDocumentOperationSettings;
    private final UnaryCallSettings<ReloadDocumentRequest, Operation> reloadDocumentSettings;
    private final OperationCallSettings<ReloadDocumentRequest, Document, KnowledgeOperationMetadata> reloadDocumentOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DocumentsClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListDocumentsRequest, ListDocumentsResponse, Document> LIST_DOCUMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListDocumentsRequest, ListDocumentsResponse, Document>(){

        public String emptyToken() {
            return "";
        }

        public ListDocumentsRequest injectToken(ListDocumentsRequest payload, String token) {
            return ListDocumentsRequest.newBuilder((ListDocumentsRequest)payload).setPageToken(token).build();
        }

        public ListDocumentsRequest injectPageSize(ListDocumentsRequest payload, int pageSize) {
            return ListDocumentsRequest.newBuilder((ListDocumentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDocumentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDocumentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Document> extractResources(ListDocumentsResponse payload) {
            return payload.getDocumentsList() == null ? ImmutableList.of() : payload.getDocumentsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListDocumentsRequest, ListDocumentsResponse, DocumentsClient.ListDocumentsPagedResponse> LIST_DOCUMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListDocumentsRequest, ListDocumentsResponse, DocumentsClient.ListDocumentsPagedResponse>(){

        public ApiFuture<DocumentsClient.ListDocumentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDocumentsRequest, ListDocumentsResponse> callable, ListDocumentsRequest request, ApiCallContext context, ApiFuture<ListDocumentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DOCUMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DocumentsClient.ListDocumentsPagedResponse.createAsync((PageContext<ListDocumentsRequest, ListDocumentsResponse, Document>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DocumentsClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DocumentsClient.ListLocationsPagedResponse>(){

        public ApiFuture<DocumentsClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DocumentsClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListDocumentsRequest, ListDocumentsResponse, DocumentsClient.ListDocumentsPagedResponse> listDocumentsSettings() {
        return this.listDocumentsSettings;
    }

    public UnaryCallSettings<GetDocumentRequest, Document> getDocumentSettings() {
        return this.getDocumentSettings;
    }

    public UnaryCallSettings<CreateDocumentRequest, Operation> createDocumentSettings() {
        return this.createDocumentSettings;
    }

    public OperationCallSettings<CreateDocumentRequest, Document, KnowledgeOperationMetadata> createDocumentOperationSettings() {
        return this.createDocumentOperationSettings;
    }

    public UnaryCallSettings<ImportDocumentsRequest, Operation> importDocumentsSettings() {
        return this.importDocumentsSettings;
    }

    public OperationCallSettings<ImportDocumentsRequest, ImportDocumentsResponse, KnowledgeOperationMetadata> importDocumentsOperationSettings() {
        return this.importDocumentsOperationSettings;
    }

    public UnaryCallSettings<DeleteDocumentRequest, Operation> deleteDocumentSettings() {
        return this.deleteDocumentSettings;
    }

    public OperationCallSettings<DeleteDocumentRequest, Empty, KnowledgeOperationMetadata> deleteDocumentOperationSettings() {
        return this.deleteDocumentOperationSettings;
    }

    public UnaryCallSettings<UpdateDocumentRequest, Operation> updateDocumentSettings() {
        return this.updateDocumentSettings;
    }

    public OperationCallSettings<UpdateDocumentRequest, Document, KnowledgeOperationMetadata> updateDocumentOperationSettings() {
        return this.updateDocumentOperationSettings;
    }

    public UnaryCallSettings<ReloadDocumentRequest, Operation> reloadDocumentSettings() {
        return this.reloadDocumentSettings;
    }

    public OperationCallSettings<ReloadDocumentRequest, Document, KnowledgeOperationMetadata> reloadDocumentOperationSettings() {
        return this.reloadDocumentOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DocumentsClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public DocumentsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDocumentsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDocumentsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return DocumentsStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "dialogflow";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dialogflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DocumentsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DocumentsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DocumentsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DocumentsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DocumentsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listDocumentsSettings = settingsBuilder.listDocumentsSettings().build();
        this.getDocumentSettings = settingsBuilder.getDocumentSettings().build();
        this.createDocumentSettings = settingsBuilder.createDocumentSettings().build();
        this.createDocumentOperationSettings = settingsBuilder.createDocumentOperationSettings().build();
        this.importDocumentsSettings = settingsBuilder.importDocumentsSettings().build();
        this.importDocumentsOperationSettings = settingsBuilder.importDocumentsOperationSettings().build();
        this.deleteDocumentSettings = settingsBuilder.deleteDocumentSettings().build();
        this.deleteDocumentOperationSettings = settingsBuilder.deleteDocumentOperationSettings().build();
        this.updateDocumentSettings = settingsBuilder.updateDocumentSettings().build();
        this.updateDocumentOperationSettings = settingsBuilder.updateDocumentOperationSettings().build();
        this.reloadDocumentSettings = settingsBuilder.reloadDocumentSettings().build();
        this.reloadDocumentOperationSettings = settingsBuilder.reloadDocumentOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DocumentsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListDocumentsRequest, ListDocumentsResponse, DocumentsClient.ListDocumentsPagedResponse> listDocumentsSettings;
        private final UnaryCallSettings.Builder<GetDocumentRequest, Document> getDocumentSettings;
        private final UnaryCallSettings.Builder<CreateDocumentRequest, Operation> createDocumentSettings;
        private final OperationCallSettings.Builder<CreateDocumentRequest, Document, KnowledgeOperationMetadata> createDocumentOperationSettings;
        private final UnaryCallSettings.Builder<ImportDocumentsRequest, Operation> importDocumentsSettings;
        private final OperationCallSettings.Builder<ImportDocumentsRequest, ImportDocumentsResponse, KnowledgeOperationMetadata> importDocumentsOperationSettings;
        private final UnaryCallSettings.Builder<DeleteDocumentRequest, Operation> deleteDocumentSettings;
        private final OperationCallSettings.Builder<DeleteDocumentRequest, Empty, KnowledgeOperationMetadata> deleteDocumentOperationSettings;
        private final UnaryCallSettings.Builder<UpdateDocumentRequest, Operation> updateDocumentSettings;
        private final OperationCallSettings.Builder<UpdateDocumentRequest, Document, KnowledgeOperationMetadata> updateDocumentOperationSettings;
        private final UnaryCallSettings.Builder<ReloadDocumentRequest, Operation> reloadDocumentSettings;
        private final OperationCallSettings.Builder<ReloadDocumentRequest, Document, KnowledgeOperationMetadata> reloadDocumentOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DocumentsClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listDocumentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DOCUMENTS_PAGE_STR_FACT);
            this.getDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDocumentOperationSettings = OperationCallSettings.newBuilder();
            this.importDocumentsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importDocumentsOperationSettings = OperationCallSettings.newBuilder();
            this.deleteDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDocumentOperationSettings = OperationCallSettings.newBuilder();
            this.updateDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDocumentOperationSettings = OperationCallSettings.newBuilder();
            this.reloadDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.reloadDocumentOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDocumentsSettings, this.getDocumentSettings, this.createDocumentSettings, this.importDocumentsSettings, this.deleteDocumentSettings, this.updateDocumentSettings, this.reloadDocumentSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DocumentsStubSettings settings) {
            super((StubSettings)settings);
            this.listDocumentsSettings = settings.listDocumentsSettings.toBuilder();
            this.getDocumentSettings = settings.getDocumentSettings.toBuilder();
            this.createDocumentSettings = settings.createDocumentSettings.toBuilder();
            this.createDocumentOperationSettings = settings.createDocumentOperationSettings.toBuilder();
            this.importDocumentsSettings = settings.importDocumentsSettings.toBuilder();
            this.importDocumentsOperationSettings = settings.importDocumentsOperationSettings.toBuilder();
            this.deleteDocumentSettings = settings.deleteDocumentSettings.toBuilder();
            this.deleteDocumentOperationSettings = settings.deleteDocumentOperationSettings.toBuilder();
            this.updateDocumentSettings = settings.updateDocumentSettings.toBuilder();
            this.updateDocumentOperationSettings = settings.updateDocumentOperationSettings.toBuilder();
            this.reloadDocumentSettings = settings.reloadDocumentSettings.toBuilder();
            this.reloadDocumentOperationSettings = settings.reloadDocumentOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDocumentsSettings, this.getDocumentSettings, this.createDocumentSettings, this.importDocumentsSettings, this.deleteDocumentSettings, this.updateDocumentSettings, this.reloadDocumentSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DocumentsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DocumentsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DocumentsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DocumentsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DocumentsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DocumentsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DocumentsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DocumentsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listDocumentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.importDocumentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.reloadDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createDocumentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Document.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(KnowledgeOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.importDocumentsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ImportDocumentsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(KnowledgeOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteDocumentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(KnowledgeOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateDocumentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Document.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(KnowledgeOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.reloadDocumentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Document.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(KnowledgeOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListDocumentsRequest, ListDocumentsResponse, DocumentsClient.ListDocumentsPagedResponse> listDocumentsSettings() {
            return this.listDocumentsSettings;
        }

        public UnaryCallSettings.Builder<GetDocumentRequest, Document> getDocumentSettings() {
            return this.getDocumentSettings;
        }

        public UnaryCallSettings.Builder<CreateDocumentRequest, Operation> createDocumentSettings() {
            return this.createDocumentSettings;
        }

        public OperationCallSettings.Builder<CreateDocumentRequest, Document, KnowledgeOperationMetadata> createDocumentOperationSettings() {
            return this.createDocumentOperationSettings;
        }

        public UnaryCallSettings.Builder<ImportDocumentsRequest, Operation> importDocumentsSettings() {
            return this.importDocumentsSettings;
        }

        public OperationCallSettings.Builder<ImportDocumentsRequest, ImportDocumentsResponse, KnowledgeOperationMetadata> importDocumentsOperationSettings() {
            return this.importDocumentsOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteDocumentRequest, Operation> deleteDocumentSettings() {
            return this.deleteDocumentSettings;
        }

        public OperationCallSettings.Builder<DeleteDocumentRequest, Empty, KnowledgeOperationMetadata> deleteDocumentOperationSettings() {
            return this.deleteDocumentOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateDocumentRequest, Operation> updateDocumentSettings() {
            return this.updateDocumentSettings;
        }

        public OperationCallSettings.Builder<UpdateDocumentRequest, Document, KnowledgeOperationMetadata> updateDocumentOperationSettings() {
            return this.updateDocumentOperationSettings;
        }

        public UnaryCallSettings.Builder<ReloadDocumentRequest, Operation> reloadDocumentSettings() {
            return this.reloadDocumentSettings;
        }

        public OperationCallSettings.Builder<ReloadDocumentRequest, Document, KnowledgeOperationMetadata> reloadDocumentOperationSettings() {
            return this.reloadDocumentOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DocumentsClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return DocumentsStubSettings.getDefaultEndpoint();
        }

        public DocumentsStubSettings build() throws IOException {
            return new DocumentsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

