/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.CreateKnowledgeBaseRequest;
import com.google.cloud.dialogflow.v2.DeleteKnowledgeBaseRequest;
import com.google.cloud.dialogflow.v2.GetKnowledgeBaseRequest;
import com.google.cloud.dialogflow.v2.KnowledgeBase;
import com.google.cloud.dialogflow.v2.KnowledgeBaseName;
import com.google.cloud.dialogflow.v2.KnowledgeBasesSettings;
import com.google.cloud.dialogflow.v2.ListKnowledgeBasesRequest;
import com.google.cloud.dialogflow.v2.ListKnowledgeBasesResponse;
import com.google.cloud.dialogflow.v2.LocationName;
import com.google.cloud.dialogflow.v2.ProjectName;
import com.google.cloud.dialogflow.v2.UpdateKnowledgeBaseRequest;
import com.google.cloud.dialogflow.v2.stub.KnowledgeBasesStub;
import com.google.cloud.dialogflow.v2.stub.KnowledgeBasesStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class KnowledgeBasesClient
implements BackgroundResource {
    private final KnowledgeBasesSettings settings;
    private final KnowledgeBasesStub stub;

    public static final KnowledgeBasesClient create() throws IOException {
        return KnowledgeBasesClient.create(KnowledgeBasesSettings.newBuilder().build());
    }

    public static final KnowledgeBasesClient create(KnowledgeBasesSettings settings) throws IOException {
        return new KnowledgeBasesClient(settings);
    }

    public static final KnowledgeBasesClient create(KnowledgeBasesStub stub) {
        return new KnowledgeBasesClient(stub);
    }

    protected KnowledgeBasesClient(KnowledgeBasesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((KnowledgeBasesStubSettings)settings.getStubSettings()).createStub();
    }

    protected KnowledgeBasesClient(KnowledgeBasesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final KnowledgeBasesSettings getSettings() {
        return this.settings;
    }

    public KnowledgeBasesStub getStub() {
        return this.stub;
    }

    public final ListKnowledgeBasesPagedResponse listKnowledgeBases(LocationName parent) {
        ListKnowledgeBasesRequest request = ListKnowledgeBasesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listKnowledgeBases(request);
    }

    public final ListKnowledgeBasesPagedResponse listKnowledgeBases(ProjectName parent) {
        ListKnowledgeBasesRequest request = ListKnowledgeBasesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listKnowledgeBases(request);
    }

    public final ListKnowledgeBasesPagedResponse listKnowledgeBases(String parent) {
        ListKnowledgeBasesRequest request = ListKnowledgeBasesRequest.newBuilder().setParent(parent).build();
        return this.listKnowledgeBases(request);
    }

    public final ListKnowledgeBasesPagedResponse listKnowledgeBases(ListKnowledgeBasesRequest request) {
        return (ListKnowledgeBasesPagedResponse)((Object)this.listKnowledgeBasesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListKnowledgeBasesRequest, ListKnowledgeBasesPagedResponse> listKnowledgeBasesPagedCallable() {
        return this.stub.listKnowledgeBasesPagedCallable();
    }

    public final UnaryCallable<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse> listKnowledgeBasesCallable() {
        return this.stub.listKnowledgeBasesCallable();
    }

    public final KnowledgeBase getKnowledgeBase(KnowledgeBaseName name) {
        GetKnowledgeBaseRequest request = GetKnowledgeBaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getKnowledgeBase(request);
    }

    public final KnowledgeBase getKnowledgeBase(String name) {
        GetKnowledgeBaseRequest request = GetKnowledgeBaseRequest.newBuilder().setName(name).build();
        return this.getKnowledgeBase(request);
    }

    public final KnowledgeBase getKnowledgeBase(GetKnowledgeBaseRequest request) {
        return (KnowledgeBase)this.getKnowledgeBaseCallable().call((Object)request);
    }

    public final UnaryCallable<GetKnowledgeBaseRequest, KnowledgeBase> getKnowledgeBaseCallable() {
        return this.stub.getKnowledgeBaseCallable();
    }

    public final KnowledgeBase createKnowledgeBase(LocationName parent, KnowledgeBase knowledgeBase) {
        CreateKnowledgeBaseRequest request = CreateKnowledgeBaseRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setKnowledgeBase(knowledgeBase).build();
        return this.createKnowledgeBase(request);
    }

    public final KnowledgeBase createKnowledgeBase(ProjectName parent, KnowledgeBase knowledgeBase) {
        CreateKnowledgeBaseRequest request = CreateKnowledgeBaseRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setKnowledgeBase(knowledgeBase).build();
        return this.createKnowledgeBase(request);
    }

    public final KnowledgeBase createKnowledgeBase(String parent, KnowledgeBase knowledgeBase) {
        CreateKnowledgeBaseRequest request = CreateKnowledgeBaseRequest.newBuilder().setParent(parent).setKnowledgeBase(knowledgeBase).build();
        return this.createKnowledgeBase(request);
    }

    public final KnowledgeBase createKnowledgeBase(CreateKnowledgeBaseRequest request) {
        return (KnowledgeBase)this.createKnowledgeBaseCallable().call((Object)request);
    }

    public final UnaryCallable<CreateKnowledgeBaseRequest, KnowledgeBase> createKnowledgeBaseCallable() {
        return this.stub.createKnowledgeBaseCallable();
    }

    public final void deleteKnowledgeBase(KnowledgeBaseName name) {
        DeleteKnowledgeBaseRequest request = DeleteKnowledgeBaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteKnowledgeBase(request);
    }

    public final void deleteKnowledgeBase(String name) {
        DeleteKnowledgeBaseRequest request = DeleteKnowledgeBaseRequest.newBuilder().setName(name).build();
        this.deleteKnowledgeBase(request);
    }

    public final void deleteKnowledgeBase(DeleteKnowledgeBaseRequest request) {
        this.deleteKnowledgeBaseCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteKnowledgeBaseRequest, Empty> deleteKnowledgeBaseCallable() {
        return this.stub.deleteKnowledgeBaseCallable();
    }

    public final KnowledgeBase updateKnowledgeBase(KnowledgeBase knowledgeBase, FieldMask updateMask) {
        UpdateKnowledgeBaseRequest request = UpdateKnowledgeBaseRequest.newBuilder().setKnowledgeBase(knowledgeBase).setUpdateMask(updateMask).build();
        return this.updateKnowledgeBase(request);
    }

    public final KnowledgeBase updateKnowledgeBase(UpdateKnowledgeBaseRequest request) {
        return (KnowledgeBase)this.updateKnowledgeBaseCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateKnowledgeBaseRequest, KnowledgeBase> updateKnowledgeBaseCallable() {
        return this.stub.updateKnowledgeBaseCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListKnowledgeBasesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse, KnowledgeBase, ListKnowledgeBasesPage, ListKnowledgeBasesFixedSizeCollection> {
        private ListKnowledgeBasesFixedSizeCollection(List<ListKnowledgeBasesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListKnowledgeBasesFixedSizeCollection createEmptyCollection() {
            return new ListKnowledgeBasesFixedSizeCollection(null, 0);
        }

        protected ListKnowledgeBasesFixedSizeCollection createCollection(List<ListKnowledgeBasesPage> pages, int collectionSize) {
            return new ListKnowledgeBasesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListKnowledgeBasesPage
    extends AbstractPage<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse, KnowledgeBase, ListKnowledgeBasesPage> {
        private ListKnowledgeBasesPage(PageContext<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse, KnowledgeBase> context, ListKnowledgeBasesResponse response) {
            super(context, (Object)response);
        }

        private static ListKnowledgeBasesPage createEmptyPage() {
            return new ListKnowledgeBasesPage(null, null);
        }

        protected ListKnowledgeBasesPage createPage(PageContext<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse, KnowledgeBase> context, ListKnowledgeBasesResponse response) {
            return new ListKnowledgeBasesPage(context, response);
        }

        public ApiFuture<ListKnowledgeBasesPage> createPageAsync(PageContext<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse, KnowledgeBase> context, ApiFuture<ListKnowledgeBasesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListKnowledgeBasesPagedResponse
    extends AbstractPagedListResponse<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse, KnowledgeBase, ListKnowledgeBasesPage, ListKnowledgeBasesFixedSizeCollection> {
        public static ApiFuture<ListKnowledgeBasesPagedResponse> createAsync(PageContext<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse, KnowledgeBase> context, ApiFuture<ListKnowledgeBasesResponse> futureResponse) {
            ApiFuture<ListKnowledgeBasesPage> futurePage = ListKnowledgeBasesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListKnowledgeBasesPagedResponse((ListKnowledgeBasesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListKnowledgeBasesPagedResponse(ListKnowledgeBasesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListKnowledgeBasesFixedSizeCollection.createEmptyCollection());
        }
    }
}

