/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.BatchCreateMessagesRequest;
import com.google.cloud.dialogflow.v2beta1.BatchCreateMessagesResponse;
import com.google.cloud.dialogflow.v2beta1.CompleteConversationRequest;
import com.google.cloud.dialogflow.v2beta1.Conversation;
import com.google.cloud.dialogflow.v2beta1.ConversationsClient;
import com.google.cloud.dialogflow.v2beta1.CreateConversationRequest;
import com.google.cloud.dialogflow.v2beta1.GenerateStatelessSummaryRequest;
import com.google.cloud.dialogflow.v2beta1.GenerateStatelessSummaryResponse;
import com.google.cloud.dialogflow.v2beta1.GetConversationRequest;
import com.google.cloud.dialogflow.v2beta1.ListConversationsRequest;
import com.google.cloud.dialogflow.v2beta1.ListConversationsResponse;
import com.google.cloud.dialogflow.v2beta1.ListMessagesRequest;
import com.google.cloud.dialogflow.v2beta1.ListMessagesResponse;
import com.google.cloud.dialogflow.v2beta1.SuggestConversationSummaryRequest;
import com.google.cloud.dialogflow.v2beta1.SuggestConversationSummaryResponse;
import com.google.cloud.dialogflow.v2beta1.stub.ConversationsStub;
import com.google.cloud.dialogflow.v2beta1.stub.ConversationsStubSettings;
import com.google.cloud.dialogflow.v2beta1.stub.GrpcConversationsCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcConversationsStub
extends ConversationsStub {
    private static final MethodDescriptor<CreateConversationRequest, Conversation> createConversationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.Conversations/CreateConversation").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateConversationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Conversation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListConversationsRequest, ListConversationsResponse> listConversationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.Conversations/ListConversations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListConversationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListConversationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetConversationRequest, Conversation> getConversationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.Conversations/GetConversation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetConversationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Conversation.getDefaultInstance())).build();
    private static final MethodDescriptor<CompleteConversationRequest, Conversation> completeConversationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.Conversations/CompleteConversation").setRequestMarshaller(ProtoUtils.marshaller((Message)CompleteConversationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Conversation.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchCreateMessagesRequest, BatchCreateMessagesResponse> batchCreateMessagesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.Conversations/BatchCreateMessages").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchCreateMessagesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)BatchCreateMessagesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListMessagesRequest, ListMessagesResponse> listMessagesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.Conversations/ListMessages").setRequestMarshaller(ProtoUtils.marshaller((Message)ListMessagesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListMessagesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<SuggestConversationSummaryRequest, SuggestConversationSummaryResponse> suggestConversationSummaryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.Conversations/SuggestConversationSummary").setRequestMarshaller(ProtoUtils.marshaller((Message)SuggestConversationSummaryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SuggestConversationSummaryResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GenerateStatelessSummaryRequest, GenerateStatelessSummaryResponse> generateStatelessSummaryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.Conversations/GenerateStatelessSummary").setRequestMarshaller(ProtoUtils.marshaller((Message)GenerateStatelessSummaryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GenerateStatelessSummaryResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<CreateConversationRequest, Conversation> createConversationCallable;
    private final UnaryCallable<ListConversationsRequest, ListConversationsResponse> listConversationsCallable;
    private final UnaryCallable<ListConversationsRequest, ConversationsClient.ListConversationsPagedResponse> listConversationsPagedCallable;
    private final UnaryCallable<GetConversationRequest, Conversation> getConversationCallable;
    private final UnaryCallable<CompleteConversationRequest, Conversation> completeConversationCallable;
    private final UnaryCallable<BatchCreateMessagesRequest, BatchCreateMessagesResponse> batchCreateMessagesCallable;
    private final UnaryCallable<ListMessagesRequest, ListMessagesResponse> listMessagesCallable;
    private final UnaryCallable<ListMessagesRequest, ConversationsClient.ListMessagesPagedResponse> listMessagesPagedCallable;
    private final UnaryCallable<SuggestConversationSummaryRequest, SuggestConversationSummaryResponse> suggestConversationSummaryCallable;
    private final UnaryCallable<GenerateStatelessSummaryRequest, GenerateStatelessSummaryResponse> generateStatelessSummaryCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ConversationsClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcConversationsStub create(ConversationsStubSettings settings) throws IOException {
        return new GrpcConversationsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcConversationsStub create(ClientContext clientContext) throws IOException {
        return new GrpcConversationsStub(ConversationsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcConversationsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcConversationsStub(ConversationsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcConversationsStub(ConversationsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcConversationsCallableFactory());
    }

    protected GrpcConversationsStub(ConversationsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createConversationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createConversationMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings listConversationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listConversationsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getConversationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getConversationMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings completeConversationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(completeConversationMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings batchCreateMessagesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchCreateMessagesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings listMessagesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listMessagesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings suggestConversationSummaryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(suggestConversationSummaryMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"conversation", (Object)String.valueOf(request.getConversation()));
            return params.build();
        }).build();
        GrpcCallSettings generateStatelessSummaryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(generateStatelessSummaryMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"stateless_conversation.parent", (Object)String.valueOf(request.getStatelessConversation().getParent()));
            return params.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        this.createConversationCallable = callableFactory.createUnaryCallable(createConversationTransportSettings, settings.createConversationSettings(), clientContext);
        this.listConversationsCallable = callableFactory.createUnaryCallable(listConversationsTransportSettings, settings.listConversationsSettings(), clientContext);
        this.listConversationsPagedCallable = callableFactory.createPagedCallable(listConversationsTransportSettings, settings.listConversationsSettings(), clientContext);
        this.getConversationCallable = callableFactory.createUnaryCallable(getConversationTransportSettings, settings.getConversationSettings(), clientContext);
        this.completeConversationCallable = callableFactory.createUnaryCallable(completeConversationTransportSettings, settings.completeConversationSettings(), clientContext);
        this.batchCreateMessagesCallable = callableFactory.createUnaryCallable(batchCreateMessagesTransportSettings, settings.batchCreateMessagesSettings(), clientContext);
        this.listMessagesCallable = callableFactory.createUnaryCallable(listMessagesTransportSettings, settings.listMessagesSettings(), clientContext);
        this.listMessagesPagedCallable = callableFactory.createPagedCallable(listMessagesTransportSettings, settings.listMessagesSettings(), clientContext);
        this.suggestConversationSummaryCallable = callableFactory.createUnaryCallable(suggestConversationSummaryTransportSettings, settings.suggestConversationSummarySettings(), clientContext);
        this.generateStatelessSummaryCallable = callableFactory.createUnaryCallable(generateStatelessSummaryTransportSettings, settings.generateStatelessSummarySettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateConversationRequest, Conversation> createConversationCallable() {
        return this.createConversationCallable;
    }

    @Override
    public UnaryCallable<ListConversationsRequest, ListConversationsResponse> listConversationsCallable() {
        return this.listConversationsCallable;
    }

    @Override
    public UnaryCallable<ListConversationsRequest, ConversationsClient.ListConversationsPagedResponse> listConversationsPagedCallable() {
        return this.listConversationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetConversationRequest, Conversation> getConversationCallable() {
        return this.getConversationCallable;
    }

    @Override
    public UnaryCallable<CompleteConversationRequest, Conversation> completeConversationCallable() {
        return this.completeConversationCallable;
    }

    @Override
    public UnaryCallable<BatchCreateMessagesRequest, BatchCreateMessagesResponse> batchCreateMessagesCallable() {
        return this.batchCreateMessagesCallable;
    }

    @Override
    public UnaryCallable<ListMessagesRequest, ListMessagesResponse> listMessagesCallable() {
        return this.listMessagesCallable;
    }

    @Override
    public UnaryCallable<ListMessagesRequest, ConversationsClient.ListMessagesPagedResponse> listMessagesPagedCallable() {
        return this.listMessagesPagedCallable;
    }

    @Override
    public UnaryCallable<SuggestConversationSummaryRequest, SuggestConversationSummaryResponse> suggestConversationSummaryCallable() {
        return this.suggestConversationSummaryCallable;
    }

    @Override
    public UnaryCallable<GenerateStatelessSummaryRequest, GenerateStatelessSummaryResponse> generateStatelessSummaryCallable() {
        return this.generateStatelessSummaryCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ConversationsClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

