/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.ConversationDataset;
import com.google.cloud.dialogflow.v2.ConversationDatasetsClient;
import com.google.cloud.dialogflow.v2.CreateConversationDatasetOperationMetadata;
import com.google.cloud.dialogflow.v2.CreateConversationDatasetRequest;
import com.google.cloud.dialogflow.v2.DeleteConversationDatasetOperationMetadata;
import com.google.cloud.dialogflow.v2.DeleteConversationDatasetRequest;
import com.google.cloud.dialogflow.v2.GetConversationDatasetRequest;
import com.google.cloud.dialogflow.v2.ImportConversationDataOperationMetadata;
import com.google.cloud.dialogflow.v2.ImportConversationDataOperationResponse;
import com.google.cloud.dialogflow.v2.ImportConversationDataRequest;
import com.google.cloud.dialogflow.v2.ListConversationDatasetsRequest;
import com.google.cloud.dialogflow.v2.ListConversationDatasetsResponse;
import com.google.cloud.dialogflow.v2.stub.ConversationDatasetsStub;
import com.google.cloud.dialogflow.v2.stub.ConversationDatasetsStubSettings;
import com.google.cloud.dialogflow.v2.stub.HttpJsonConversationDatasetsCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonConversationDatasetsStub
extends ConversationDatasetsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(ImportConversationDataOperationResponse.getDescriptor()).add(ConversationDataset.getDescriptor()).add(Empty.getDescriptor()).add(DeleteConversationDatasetOperationMetadata.getDescriptor()).add(CreateConversationDatasetOperationMetadata.getDescriptor()).add(ImportConversationDataOperationMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateConversationDatasetRequest, Operation> createConversationDatasetMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.v2.ConversationDatasets/CreateConversationDataset").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*}/conversationDatasets", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("conversationDataset", (Message)request.getConversationDataset(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetConversationDatasetRequest, ConversationDataset> getConversationDatasetMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.v2.ConversationDatasets/GetConversationDataset").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/conversationDatasets/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{name=projects/*/locations/*/conversationDatasets/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ConversationDataset.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListConversationDatasetsRequest, ListConversationDatasetsResponse> listConversationDatasetsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.v2.ConversationDatasets/ListConversationDatasets").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*}/conversationDatasets", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{parent=projects/*/locations/*}/conversationDatasets"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListConversationDatasetsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteConversationDatasetRequest, Operation> deleteConversationDatasetMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.v2.ConversationDatasets/DeleteConversationDataset").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/conversationDatasets/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ImportConversationDataRequest, Operation> importConversationDataMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.v2.ConversationDatasets/ImportConversationData").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/conversationDatasets/*}:importConversationData", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v2/{name=projects/*/locations/*/conversationDatasets/*}:importConversationData"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateConversationDatasetRequest, Operation> createConversationDatasetCallable;
    private final OperationCallable<CreateConversationDatasetRequest, ConversationDataset, CreateConversationDatasetOperationMetadata> createConversationDatasetOperationCallable;
    private final UnaryCallable<GetConversationDatasetRequest, ConversationDataset> getConversationDatasetCallable;
    private final UnaryCallable<ListConversationDatasetsRequest, ListConversationDatasetsResponse> listConversationDatasetsCallable;
    private final UnaryCallable<ListConversationDatasetsRequest, ConversationDatasetsClient.ListConversationDatasetsPagedResponse> listConversationDatasetsPagedCallable;
    private final UnaryCallable<DeleteConversationDatasetRequest, Operation> deleteConversationDatasetCallable;
    private final OperationCallable<DeleteConversationDatasetRequest, Empty, DeleteConversationDatasetOperationMetadata> deleteConversationDatasetOperationCallable;
    private final UnaryCallable<ImportConversationDataRequest, Operation> importConversationDataCallable;
    private final OperationCallable<ImportConversationDataRequest, ImportConversationDataOperationResponse, ImportConversationDataOperationMetadata> importConversationDataOperationCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ConversationDatasetsClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonConversationDatasetsStub create(ConversationDatasetsStubSettings settings) throws IOException {
        return new HttpJsonConversationDatasetsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonConversationDatasetsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonConversationDatasetsStub(ConversationDatasetsStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonConversationDatasetsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonConversationDatasetsStub(ConversationDatasetsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonConversationDatasetsStub(ConversationDatasetsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonConversationDatasetsCallableFactory());
    }

    protected HttpJsonConversationDatasetsStub(ConversationDatasetsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v2/{name=projects/*/operations/*}:cancel").addAdditionalBindings(HttpRule.newBuilder().setPost("/v2/{name=projects/*/locations/*/operations/*}:cancel").build()).build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v2/{name=projects/*/operations/*}").addAdditionalBindings(HttpRule.newBuilder().setGet("/v2/{name=projects/*/locations/*/operations/*}").build()).build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v2/{name=projects/*}/operations").addAdditionalBindings(HttpRule.newBuilder().setGet("/v2/{name=projects/*/locations/*}/operations").build()).build()).build());
        HttpJsonCallSettings createConversationDatasetTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createConversationDatasetMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getConversationDatasetTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getConversationDatasetMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listConversationDatasetsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listConversationDatasetsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteConversationDatasetTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteConversationDatasetMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings importConversationDataTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(importConversationDataMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createConversationDatasetCallable = callableFactory.createUnaryCallable(createConversationDatasetTransportSettings, settings.createConversationDatasetSettings(), clientContext);
        this.createConversationDatasetOperationCallable = callableFactory.createOperationCallable(createConversationDatasetTransportSettings, settings.createConversationDatasetOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getConversationDatasetCallable = callableFactory.createUnaryCallable(getConversationDatasetTransportSettings, settings.getConversationDatasetSettings(), clientContext);
        this.listConversationDatasetsCallable = callableFactory.createUnaryCallable(listConversationDatasetsTransportSettings, settings.listConversationDatasetsSettings(), clientContext);
        this.listConversationDatasetsPagedCallable = callableFactory.createPagedCallable(listConversationDatasetsTransportSettings, settings.listConversationDatasetsSettings(), clientContext);
        this.deleteConversationDatasetCallable = callableFactory.createUnaryCallable(deleteConversationDatasetTransportSettings, settings.deleteConversationDatasetSettings(), clientContext);
        this.deleteConversationDatasetOperationCallable = callableFactory.createOperationCallable(deleteConversationDatasetTransportSettings, settings.deleteConversationDatasetOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.importConversationDataCallable = callableFactory.createUnaryCallable(importConversationDataTransportSettings, settings.importConversationDataSettings(), clientContext);
        this.importConversationDataOperationCallable = callableFactory.createOperationCallable(importConversationDataTransportSettings, settings.importConversationDataOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createConversationDatasetMethodDescriptor);
        methodDescriptors.add(getConversationDatasetMethodDescriptor);
        methodDescriptors.add(listConversationDatasetsMethodDescriptor);
        methodDescriptors.add(deleteConversationDatasetMethodDescriptor);
        methodDescriptors.add(importConversationDataMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateConversationDatasetRequest, Operation> createConversationDatasetCallable() {
        return this.createConversationDatasetCallable;
    }

    @Override
    public OperationCallable<CreateConversationDatasetRequest, ConversationDataset, CreateConversationDatasetOperationMetadata> createConversationDatasetOperationCallable() {
        return this.createConversationDatasetOperationCallable;
    }

    @Override
    public UnaryCallable<GetConversationDatasetRequest, ConversationDataset> getConversationDatasetCallable() {
        return this.getConversationDatasetCallable;
    }

    @Override
    public UnaryCallable<ListConversationDatasetsRequest, ListConversationDatasetsResponse> listConversationDatasetsCallable() {
        return this.listConversationDatasetsCallable;
    }

    @Override
    public UnaryCallable<ListConversationDatasetsRequest, ConversationDatasetsClient.ListConversationDatasetsPagedResponse> listConversationDatasetsPagedCallable() {
        return this.listConversationDatasetsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteConversationDatasetRequest, Operation> deleteConversationDatasetCallable() {
        return this.deleteConversationDatasetCallable;
    }

    @Override
    public OperationCallable<DeleteConversationDatasetRequest, Empty, DeleteConversationDatasetOperationMetadata> deleteConversationDatasetOperationCallable() {
        return this.deleteConversationDatasetOperationCallable;
    }

    @Override
    public UnaryCallable<ImportConversationDataRequest, Operation> importConversationDataCallable() {
        return this.importConversationDataCallable;
    }

    @Override
    public OperationCallable<ImportConversationDataRequest, ImportConversationDataOperationResponse, ImportConversationDataOperationMetadata> importConversationDataOperationCallable() {
        return this.importConversationDataOperationCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ConversationDatasetsClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

