/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.Context;
import com.google.cloud.dialogflow.v2.ContextsClient;
import com.google.cloud.dialogflow.v2.CreateContextRequest;
import com.google.cloud.dialogflow.v2.DeleteAllContextsRequest;
import com.google.cloud.dialogflow.v2.DeleteContextRequest;
import com.google.cloud.dialogflow.v2.GetContextRequest;
import com.google.cloud.dialogflow.v2.ListContextsRequest;
import com.google.cloud.dialogflow.v2.ListContextsResponse;
import com.google.cloud.dialogflow.v2.UpdateContextRequest;
import com.google.cloud.dialogflow.v2.stub.ContextsStub;
import com.google.cloud.dialogflow.v2.stub.GrpcContextsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ContextsStubSettings
extends StubSettings<ContextsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final PagedCallSettings<ListContextsRequest, ListContextsResponse, ContextsClient.ListContextsPagedResponse> listContextsSettings;
    private final UnaryCallSettings<GetContextRequest, Context> getContextSettings;
    private final UnaryCallSettings<CreateContextRequest, Context> createContextSettings;
    private final UnaryCallSettings<UpdateContextRequest, Context> updateContextSettings;
    private final UnaryCallSettings<DeleteContextRequest, Empty> deleteContextSettings;
    private final UnaryCallSettings<DeleteAllContextsRequest, Empty> deleteAllContextsSettings;
    private static final PagedListDescriptor<ListContextsRequest, ListContextsResponse, Context> LIST_CONTEXTS_PAGE_STR_DESC = new PagedListDescriptor<ListContextsRequest, ListContextsResponse, Context>(){

        public String emptyToken() {
            return "";
        }

        public ListContextsRequest injectToken(ListContextsRequest payload, String token) {
            return ListContextsRequest.newBuilder((ListContextsRequest)payload).setPageToken(token).build();
        }

        public ListContextsRequest injectPageSize(ListContextsRequest payload, int pageSize) {
            return ListContextsRequest.newBuilder((ListContextsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListContextsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListContextsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Context> extractResources(ListContextsResponse payload) {
            return payload.getContextsList() == null ? ImmutableList.of() : payload.getContextsList();
        }
    };
    private static final PagedListResponseFactory<ListContextsRequest, ListContextsResponse, ContextsClient.ListContextsPagedResponse> LIST_CONTEXTS_PAGE_STR_FACT = new PagedListResponseFactory<ListContextsRequest, ListContextsResponse, ContextsClient.ListContextsPagedResponse>(){

        public ApiFuture<ContextsClient.ListContextsPagedResponse> getFuturePagedResponse(UnaryCallable<ListContextsRequest, ListContextsResponse> callable, ListContextsRequest request, ApiCallContext context, ApiFuture<ListContextsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONTEXTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ContextsClient.ListContextsPagedResponse.createAsync((PageContext<ListContextsRequest, ListContextsResponse, Context>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListContextsRequest, ListContextsResponse, ContextsClient.ListContextsPagedResponse> listContextsSettings() {
        return this.listContextsSettings;
    }

    public UnaryCallSettings<GetContextRequest, Context> getContextSettings() {
        return this.getContextSettings;
    }

    public UnaryCallSettings<CreateContextRequest, Context> createContextSettings() {
        return this.createContextSettings;
    }

    public UnaryCallSettings<UpdateContextRequest, Context> updateContextSettings() {
        return this.updateContextSettings;
    }

    public UnaryCallSettings<DeleteContextRequest, Empty> deleteContextSettings() {
        return this.deleteContextSettings;
    }

    public UnaryCallSettings<DeleteAllContextsRequest, Empty> deleteAllContextsSettings() {
        return this.deleteAllContextsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ContextsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcContextsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ContextsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ContextsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ContextsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listContextsSettings = settingsBuilder.listContextsSettings().build();
        this.getContextSettings = settingsBuilder.getContextSettings().build();
        this.createContextSettings = settingsBuilder.createContextSettings().build();
        this.updateContextSettings = settingsBuilder.updateContextSettings().build();
        this.deleteContextSettings = settingsBuilder.deleteContextSettings().build();
        this.deleteAllContextsSettings = settingsBuilder.deleteAllContextsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ContextsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListContextsRequest, ListContextsResponse, ContextsClient.ListContextsPagedResponse> listContextsSettings;
        private final UnaryCallSettings.Builder<GetContextRequest, Context> getContextSettings;
        private final UnaryCallSettings.Builder<CreateContextRequest, Context> createContextSettings;
        private final UnaryCallSettings.Builder<UpdateContextRequest, Context> updateContextSettings;
        private final UnaryCallSettings.Builder<DeleteContextRequest, Empty> deleteContextSettings;
        private final UnaryCallSettings.Builder<DeleteAllContextsRequest, Empty> deleteAllContextsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listContextsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONTEXTS_PAGE_STR_FACT);
            this.getContextSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createContextSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateContextSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteContextSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAllContextsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listContextsSettings, this.getContextSettings, this.createContextSettings, this.updateContextSettings, this.deleteContextSettings, this.deleteAllContextsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ContextsStubSettings settings) {
            super((StubSettings)settings);
            this.listContextsSettings = settings.listContextsSettings.toBuilder();
            this.getContextSettings = settings.getContextSettings.toBuilder();
            this.createContextSettings = settings.createContextSettings.toBuilder();
            this.updateContextSettings = settings.updateContextSettings.toBuilder();
            this.deleteContextSettings = settings.deleteContextSettings.toBuilder();
            this.deleteAllContextsSettings = settings.deleteAllContextsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listContextsSettings, this.getContextSettings, this.createContextSettings, this.updateContextSettings, this.deleteContextSettings, this.deleteAllContextsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ContextsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ContextsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ContextsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ContextsStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listContextsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getContextSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createContextSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateContextSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteContextSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteAllContextsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListContextsRequest, ListContextsResponse, ContextsClient.ListContextsPagedResponse> listContextsSettings() {
            return this.listContextsSettings;
        }

        public UnaryCallSettings.Builder<GetContextRequest, Context> getContextSettings() {
            return this.getContextSettings;
        }

        public UnaryCallSettings.Builder<CreateContextRequest, Context> createContextSettings() {
            return this.createContextSettings;
        }

        public UnaryCallSettings.Builder<UpdateContextRequest, Context> updateContextSettings() {
            return this.updateContextSettings;
        }

        public UnaryCallSettings.Builder<DeleteContextRequest, Empty> deleteContextSettings() {
            return this.deleteContextSettings;
        }

        public UnaryCallSettings.Builder<DeleteAllContextsRequest, Empty> deleteAllContextsSettings() {
            return this.deleteAllContextsSettings;
        }

        public ContextsStubSettings build() throws IOException {
            return new ContextsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

