/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest;
import com.google.cloud.dialogflow.v2beta1.AnalyzeContentResponse;
import com.google.cloud.dialogflow.v2beta1.CompileSuggestionRequest;
import com.google.cloud.dialogflow.v2beta1.CompileSuggestionResponse;
import com.google.cloud.dialogflow.v2beta1.CreateParticipantRequest;
import com.google.cloud.dialogflow.v2beta1.GetParticipantRequest;
import com.google.cloud.dialogflow.v2beta1.ListParticipantsRequest;
import com.google.cloud.dialogflow.v2beta1.ListParticipantsResponse;
import com.google.cloud.dialogflow.v2beta1.ListSuggestionsRequest;
import com.google.cloud.dialogflow.v2beta1.ListSuggestionsResponse;
import com.google.cloud.dialogflow.v2beta1.Participant;
import com.google.cloud.dialogflow.v2beta1.ParticipantsClient;
import com.google.cloud.dialogflow.v2beta1.SuggestArticlesRequest;
import com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse;
import com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersRequest;
import com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse;
import com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesRequest;
import com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse;
import com.google.cloud.dialogflow.v2beta1.Suggestion;
import com.google.cloud.dialogflow.v2beta1.UpdateParticipantRequest;
import com.google.cloud.dialogflow.v2beta1.stub.GrpcParticipantsStub;
import com.google.cloud.dialogflow.v2beta1.stub.ParticipantsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ParticipantsStubSettings
extends StubSettings<ParticipantsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final UnaryCallSettings<CreateParticipantRequest, Participant> createParticipantSettings;
    private final UnaryCallSettings<GetParticipantRequest, Participant> getParticipantSettings;
    private final PagedCallSettings<ListParticipantsRequest, ListParticipantsResponse, ParticipantsClient.ListParticipantsPagedResponse> listParticipantsSettings;
    private final UnaryCallSettings<UpdateParticipantRequest, Participant> updateParticipantSettings;
    private final UnaryCallSettings<AnalyzeContentRequest, AnalyzeContentResponse> analyzeContentSettings;
    private final UnaryCallSettings<SuggestArticlesRequest, SuggestArticlesResponse> suggestArticlesSettings;
    private final UnaryCallSettings<SuggestFaqAnswersRequest, SuggestFaqAnswersResponse> suggestFaqAnswersSettings;
    private final UnaryCallSettings<SuggestSmartRepliesRequest, SuggestSmartRepliesResponse> suggestSmartRepliesSettings;
    private final PagedCallSettings<ListSuggestionsRequest, ListSuggestionsResponse, ParticipantsClient.ListSuggestionsPagedResponse> listSuggestionsSettings;
    private final UnaryCallSettings<CompileSuggestionRequest, CompileSuggestionResponse> compileSuggestionSettings;
    private static final PagedListDescriptor<ListParticipantsRequest, ListParticipantsResponse, Participant> LIST_PARTICIPANTS_PAGE_STR_DESC = new PagedListDescriptor<ListParticipantsRequest, ListParticipantsResponse, Participant>(){

        public String emptyToken() {
            return "";
        }

        public ListParticipantsRequest injectToken(ListParticipantsRequest payload, String token) {
            return ListParticipantsRequest.newBuilder((ListParticipantsRequest)payload).setPageToken(token).build();
        }

        public ListParticipantsRequest injectPageSize(ListParticipantsRequest payload, int pageSize) {
            return ListParticipantsRequest.newBuilder((ListParticipantsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListParticipantsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListParticipantsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Participant> extractResources(ListParticipantsResponse payload) {
            return payload.getParticipantsList() == null ? ImmutableList.of() : payload.getParticipantsList();
        }
    };
    private static final PagedListDescriptor<ListSuggestionsRequest, ListSuggestionsResponse, Suggestion> LIST_SUGGESTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListSuggestionsRequest, ListSuggestionsResponse, Suggestion>(){

        public String emptyToken() {
            return "";
        }

        public ListSuggestionsRequest injectToken(ListSuggestionsRequest payload, String token) {
            return ListSuggestionsRequest.newBuilder((ListSuggestionsRequest)payload).setPageToken(token).build();
        }

        public ListSuggestionsRequest injectPageSize(ListSuggestionsRequest payload, int pageSize) {
            return ListSuggestionsRequest.newBuilder((ListSuggestionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSuggestionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSuggestionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Suggestion> extractResources(ListSuggestionsResponse payload) {
            return payload.getSuggestionsList() == null ? ImmutableList.of() : payload.getSuggestionsList();
        }
    };
    private static final PagedListResponseFactory<ListParticipantsRequest, ListParticipantsResponse, ParticipantsClient.ListParticipantsPagedResponse> LIST_PARTICIPANTS_PAGE_STR_FACT = new PagedListResponseFactory<ListParticipantsRequest, ListParticipantsResponse, ParticipantsClient.ListParticipantsPagedResponse>(){

        public ApiFuture<ParticipantsClient.ListParticipantsPagedResponse> getFuturePagedResponse(UnaryCallable<ListParticipantsRequest, ListParticipantsResponse> callable, ListParticipantsRequest request, ApiCallContext context, ApiFuture<ListParticipantsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PARTICIPANTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ParticipantsClient.ListParticipantsPagedResponse.createAsync((PageContext<ListParticipantsRequest, ListParticipantsResponse, Participant>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSuggestionsRequest, ListSuggestionsResponse, ParticipantsClient.ListSuggestionsPagedResponse> LIST_SUGGESTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListSuggestionsRequest, ListSuggestionsResponse, ParticipantsClient.ListSuggestionsPagedResponse>(){

        public ApiFuture<ParticipantsClient.ListSuggestionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSuggestionsRequest, ListSuggestionsResponse> callable, ListSuggestionsRequest request, ApiCallContext context, ApiFuture<ListSuggestionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SUGGESTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ParticipantsClient.ListSuggestionsPagedResponse.createAsync((PageContext<ListSuggestionsRequest, ListSuggestionsResponse, Suggestion>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateParticipantRequest, Participant> createParticipantSettings() {
        return this.createParticipantSettings;
    }

    public UnaryCallSettings<GetParticipantRequest, Participant> getParticipantSettings() {
        return this.getParticipantSettings;
    }

    public PagedCallSettings<ListParticipantsRequest, ListParticipantsResponse, ParticipantsClient.ListParticipantsPagedResponse> listParticipantsSettings() {
        return this.listParticipantsSettings;
    }

    public UnaryCallSettings<UpdateParticipantRequest, Participant> updateParticipantSettings() {
        return this.updateParticipantSettings;
    }

    public UnaryCallSettings<AnalyzeContentRequest, AnalyzeContentResponse> analyzeContentSettings() {
        return this.analyzeContentSettings;
    }

    public UnaryCallSettings<SuggestArticlesRequest, SuggestArticlesResponse> suggestArticlesSettings() {
        return this.suggestArticlesSettings;
    }

    public UnaryCallSettings<SuggestFaqAnswersRequest, SuggestFaqAnswersResponse> suggestFaqAnswersSettings() {
        return this.suggestFaqAnswersSettings;
    }

    public UnaryCallSettings<SuggestSmartRepliesRequest, SuggestSmartRepliesResponse> suggestSmartRepliesSettings() {
        return this.suggestSmartRepliesSettings;
    }

    public PagedCallSettings<ListSuggestionsRequest, ListSuggestionsResponse, ParticipantsClient.ListSuggestionsPagedResponse> listSuggestionsSettings() {
        return this.listSuggestionsSettings;
    }

    public UnaryCallSettings<CompileSuggestionRequest, CompileSuggestionResponse> compileSuggestionSettings() {
        return this.compileSuggestionSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ParticipantsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcParticipantsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ParticipantsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ParticipantsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ParticipantsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createParticipantSettings = settingsBuilder.createParticipantSettings().build();
        this.getParticipantSettings = settingsBuilder.getParticipantSettings().build();
        this.listParticipantsSettings = settingsBuilder.listParticipantsSettings().build();
        this.updateParticipantSettings = settingsBuilder.updateParticipantSettings().build();
        this.analyzeContentSettings = settingsBuilder.analyzeContentSettings().build();
        this.suggestArticlesSettings = settingsBuilder.suggestArticlesSettings().build();
        this.suggestFaqAnswersSettings = settingsBuilder.suggestFaqAnswersSettings().build();
        this.suggestSmartRepliesSettings = settingsBuilder.suggestSmartRepliesSettings().build();
        this.listSuggestionsSettings = settingsBuilder.listSuggestionsSettings().build();
        this.compileSuggestionSettings = settingsBuilder.compileSuggestionSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ParticipantsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateParticipantRequest, Participant> createParticipantSettings;
        private final UnaryCallSettings.Builder<GetParticipantRequest, Participant> getParticipantSettings;
        private final PagedCallSettings.Builder<ListParticipantsRequest, ListParticipantsResponse, ParticipantsClient.ListParticipantsPagedResponse> listParticipantsSettings;
        private final UnaryCallSettings.Builder<UpdateParticipantRequest, Participant> updateParticipantSettings;
        private final UnaryCallSettings.Builder<AnalyzeContentRequest, AnalyzeContentResponse> analyzeContentSettings;
        private final UnaryCallSettings.Builder<SuggestArticlesRequest, SuggestArticlesResponse> suggestArticlesSettings;
        private final UnaryCallSettings.Builder<SuggestFaqAnswersRequest, SuggestFaqAnswersResponse> suggestFaqAnswersSettings;
        private final UnaryCallSettings.Builder<SuggestSmartRepliesRequest, SuggestSmartRepliesResponse> suggestSmartRepliesSettings;
        private final PagedCallSettings.Builder<ListSuggestionsRequest, ListSuggestionsResponse, ParticipantsClient.ListSuggestionsPagedResponse> listSuggestionsSettings;
        private final UnaryCallSettings.Builder<CompileSuggestionRequest, CompileSuggestionResponse> compileSuggestionSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createParticipantSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getParticipantSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listParticipantsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PARTICIPANTS_PAGE_STR_FACT);
            this.updateParticipantSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.analyzeContentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.suggestArticlesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.suggestFaqAnswersSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.suggestSmartRepliesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSuggestionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SUGGESTIONS_PAGE_STR_FACT);
            this.compileSuggestionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createParticipantSettings, this.getParticipantSettings, this.listParticipantsSettings, this.updateParticipantSettings, this.analyzeContentSettings, this.suggestArticlesSettings, this.suggestFaqAnswersSettings, this.suggestSmartRepliesSettings, this.listSuggestionsSettings, this.compileSuggestionSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ParticipantsStubSettings settings) {
            super((StubSettings)settings);
            this.createParticipantSettings = settings.createParticipantSettings.toBuilder();
            this.getParticipantSettings = settings.getParticipantSettings.toBuilder();
            this.listParticipantsSettings = settings.listParticipantsSettings.toBuilder();
            this.updateParticipantSettings = settings.updateParticipantSettings.toBuilder();
            this.analyzeContentSettings = settings.analyzeContentSettings.toBuilder();
            this.suggestArticlesSettings = settings.suggestArticlesSettings.toBuilder();
            this.suggestFaqAnswersSettings = settings.suggestFaqAnswersSettings.toBuilder();
            this.suggestSmartRepliesSettings = settings.suggestSmartRepliesSettings.toBuilder();
            this.listSuggestionsSettings = settings.listSuggestionsSettings.toBuilder();
            this.compileSuggestionSettings = settings.compileSuggestionSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createParticipantSettings, this.getParticipantSettings, this.listParticipantsSettings, this.updateParticipantSettings, this.analyzeContentSettings, this.suggestArticlesSettings, this.suggestFaqAnswersSettings, this.suggestSmartRepliesSettings, this.listSuggestionsSettings, this.compileSuggestionSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ParticipantsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ParticipantsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ParticipantsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ParticipantsStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createParticipantSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getParticipantSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listParticipantsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateParticipantSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.analyzeContentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.suggestArticlesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.suggestFaqAnswersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.suggestSmartRepliesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listSuggestionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.compileSuggestionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateParticipantRequest, Participant> createParticipantSettings() {
            return this.createParticipantSettings;
        }

        public UnaryCallSettings.Builder<GetParticipantRequest, Participant> getParticipantSettings() {
            return this.getParticipantSettings;
        }

        public PagedCallSettings.Builder<ListParticipantsRequest, ListParticipantsResponse, ParticipantsClient.ListParticipantsPagedResponse> listParticipantsSettings() {
            return this.listParticipantsSettings;
        }

        public UnaryCallSettings.Builder<UpdateParticipantRequest, Participant> updateParticipantSettings() {
            return this.updateParticipantSettings;
        }

        public UnaryCallSettings.Builder<AnalyzeContentRequest, AnalyzeContentResponse> analyzeContentSettings() {
            return this.analyzeContentSettings;
        }

        public UnaryCallSettings.Builder<SuggestArticlesRequest, SuggestArticlesResponse> suggestArticlesSettings() {
            return this.suggestArticlesSettings;
        }

        public UnaryCallSettings.Builder<SuggestFaqAnswersRequest, SuggestFaqAnswersResponse> suggestFaqAnswersSettings() {
            return this.suggestFaqAnswersSettings;
        }

        public UnaryCallSettings.Builder<SuggestSmartRepliesRequest, SuggestSmartRepliesResponse> suggestSmartRepliesSettings() {
            return this.suggestSmartRepliesSettings;
        }

        public PagedCallSettings.Builder<ListSuggestionsRequest, ListSuggestionsResponse, ParticipantsClient.ListSuggestionsPagedResponse> listSuggestionsSettings() {
            return this.listSuggestionsSettings;
        }

        public UnaryCallSettings.Builder<CompileSuggestionRequest, CompileSuggestionResponse> compileSuggestionSettings() {
            return this.compileSuggestionSettings;
        }

        public ParticipantsStubSettings build() throws IOException {
            return new ParticipantsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"retry_policy_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)220000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)220000L)).setTotalTimeout(Duration.ofMillis((long)220000L)).build();
            definitions.put((Object)"retry_policy_2_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

