/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.Context;
import com.google.cloud.dialogflow.v2beta1.ContextName;
import com.google.cloud.dialogflow.v2beta1.ContextsSettings;
import com.google.cloud.dialogflow.v2beta1.CreateContextRequest;
import com.google.cloud.dialogflow.v2beta1.DeleteAllContextsRequest;
import com.google.cloud.dialogflow.v2beta1.DeleteContextRequest;
import com.google.cloud.dialogflow.v2beta1.GetContextRequest;
import com.google.cloud.dialogflow.v2beta1.ListContextsRequest;
import com.google.cloud.dialogflow.v2beta1.ListContextsResponse;
import com.google.cloud.dialogflow.v2beta1.PagedResponseWrappers;
import com.google.cloud.dialogflow.v2beta1.SessionName;
import com.google.cloud.dialogflow.v2beta1.UpdateContextRequest;
import com.google.cloud.dialogflow.v2beta1.stub.ContextsStub;
import com.google.cloud.dialogflow.v2beta1.stub.ContextsStubSettings;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ContextsClient
implements BackgroundResource {
    private final ContextsSettings settings;
    private final ContextsStub stub;

    public static final ContextsClient create() throws IOException {
        return ContextsClient.create(ContextsSettings.newBuilder().build());
    }

    public static final ContextsClient create(ContextsSettings settings) throws IOException {
        return new ContextsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ContextsClient create(ContextsStub stub) {
        return new ContextsClient(stub);
    }

    protected ContextsClient(ContextsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ContextsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ContextsClient(ContextsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ContextsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ContextsStub getStub() {
        return this.stub;
    }

    public final PagedResponseWrappers.ListContextsPagedResponse listContexts(SessionName parent) {
        ListContextsRequest request = ListContextsRequest.newBuilder().setParent(parent.toString()).build();
        return this.listContexts(request);
    }

    public final PagedResponseWrappers.ListContextsPagedResponse listContexts(ListContextsRequest request) {
        return (PagedResponseWrappers.ListContextsPagedResponse)((Object)this.listContextsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListContextsRequest, PagedResponseWrappers.ListContextsPagedResponse> listContextsPagedCallable() {
        return this.stub.listContextsPagedCallable();
    }

    public final UnaryCallable<ListContextsRequest, ListContextsResponse> listContextsCallable() {
        return this.stub.listContextsCallable();
    }

    public final Context getContext(ContextName name) {
        GetContextRequest request = GetContextRequest.newBuilder().setName(name.toString()).build();
        return this.getContext(request);
    }

    private final Context getContext(GetContextRequest request) {
        return (Context)this.getContextCallable().call((Object)request);
    }

    public final UnaryCallable<GetContextRequest, Context> getContextCallable() {
        return this.stub.getContextCallable();
    }

    public final Context createContext(SessionName parent, Context context) {
        CreateContextRequest request = CreateContextRequest.newBuilder().setParent(parent.toString()).setContext(context).build();
        return this.createContext(request);
    }

    public final Context createContext(CreateContextRequest request) {
        return (Context)this.createContextCallable().call((Object)request);
    }

    public final UnaryCallable<CreateContextRequest, Context> createContextCallable() {
        return this.stub.createContextCallable();
    }

    public final Context updateContext(Context context) {
        UpdateContextRequest request = UpdateContextRequest.newBuilder().setContext(context).build();
        return this.updateContext(request);
    }

    public final Context updateContext(UpdateContextRequest request) {
        return (Context)this.updateContextCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateContextRequest, Context> updateContextCallable() {
        return this.stub.updateContextCallable();
    }

    public final void deleteContext(ContextName name) {
        DeleteContextRequest request = DeleteContextRequest.newBuilder().setName(name.toString()).build();
        this.deleteContext(request);
    }

    private final void deleteContext(DeleteContextRequest request) {
        this.deleteContextCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteContextRequest, Empty> deleteContextCallable() {
        return this.stub.deleteContextCallable();
    }

    public final void deleteAllContexts(SessionName parent) {
        DeleteAllContextsRequest request = DeleteAllContextsRequest.newBuilder().setParent(parent.toString()).build();
        this.deleteAllContexts(request);
    }

    private final void deleteAllContexts(DeleteAllContextsRequest request) {
        this.deleteAllContextsCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteAllContextsRequest, Empty> deleteAllContextsCallable() {
        return this.stub.deleteAllContextsCallable();
    }

    public final void close() throws Exception {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

