/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.Conversation;
import com.google.cloud.dialogflow.cx.v3beta1.ConversationHistoryClient;
import com.google.cloud.dialogflow.cx.v3beta1.DeleteConversationRequest;
import com.google.cloud.dialogflow.cx.v3beta1.GetConversationRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListConversationsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListConversationsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.stub.ConversationHistoryStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.ConversationHistoryStubSettings;
import com.google.cloud.dialogflow.cx.v3beta1.stub.GrpcConversationHistoryCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcConversationHistoryStub
extends ConversationHistoryStub {
    private static final MethodDescriptor<ListConversationsRequest, ListConversationsResponse> listConversationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.ConversationHistory/ListConversations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListConversationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListConversationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetConversationRequest, Conversation> getConversationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.ConversationHistory/GetConversation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetConversationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Conversation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteConversationRequest, Empty> deleteConversationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.ConversationHistory/DeleteConversation").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteConversationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<ListConversationsRequest, ListConversationsResponse> listConversationsCallable;
    private final UnaryCallable<ListConversationsRequest, ConversationHistoryClient.ListConversationsPagedResponse> listConversationsPagedCallable;
    private final UnaryCallable<GetConversationRequest, Conversation> getConversationCallable;
    private final UnaryCallable<DeleteConversationRequest, Empty> deleteConversationCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ConversationHistoryClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcConversationHistoryStub create(ConversationHistoryStubSettings settings) throws IOException {
        return new GrpcConversationHistoryStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcConversationHistoryStub create(ClientContext clientContext) throws IOException {
        return new GrpcConversationHistoryStub(ConversationHistoryStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcConversationHistoryStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcConversationHistoryStub(ConversationHistoryStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcConversationHistoryStub(ConversationHistoryStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcConversationHistoryCallableFactory());
    }

    protected GrpcConversationHistoryStub(ConversationHistoryStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listConversationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listConversationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getConversationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getConversationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteConversationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteConversationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listConversationsCallable = callableFactory.createUnaryCallable(listConversationsTransportSettings, settings.listConversationsSettings(), clientContext);
        this.listConversationsPagedCallable = callableFactory.createPagedCallable(listConversationsTransportSettings, settings.listConversationsSettings(), clientContext);
        this.getConversationCallable = callableFactory.createUnaryCallable(getConversationTransportSettings, settings.getConversationSettings(), clientContext);
        this.deleteConversationCallable = callableFactory.createUnaryCallable(deleteConversationTransportSettings, settings.deleteConversationSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListConversationsRequest, ListConversationsResponse> listConversationsCallable() {
        return this.listConversationsCallable;
    }

    @Override
    public UnaryCallable<ListConversationsRequest, ConversationHistoryClient.ListConversationsPagedResponse> listConversationsPagedCallable() {
        return this.listConversationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetConversationRequest, Conversation> getConversationCallable() {
        return this.getConversationCallable;
    }

    @Override
    public UnaryCallable<DeleteConversationRequest, Empty> deleteConversationCallable() {
        return this.deleteConversationCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ConversationHistoryClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

