/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.CreateExperimentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeleteExperimentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.EnvironmentName;
import com.google.cloud.dialogflow.cx.v3beta1.Experiment;
import com.google.cloud.dialogflow.cx.v3beta1.ExperimentName;
import com.google.cloud.dialogflow.cx.v3beta1.ExperimentsSettings;
import com.google.cloud.dialogflow.cx.v3beta1.GetExperimentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListExperimentsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListExperimentsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.StartExperimentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.StopExperimentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.UpdateExperimentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.stub.ExperimentsStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.ExperimentsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ExperimentsClient
implements BackgroundResource {
    private final ExperimentsSettings settings;
    private final ExperimentsStub stub;

    public static final ExperimentsClient create() throws IOException {
        return ExperimentsClient.create(ExperimentsSettings.newBuilder().build());
    }

    public static final ExperimentsClient create(ExperimentsSettings settings) throws IOException {
        return new ExperimentsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ExperimentsClient create(ExperimentsStub stub) {
        return new ExperimentsClient(stub);
    }

    protected ExperimentsClient(ExperimentsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ExperimentsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ExperimentsClient(ExperimentsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ExperimentsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ExperimentsStub getStub() {
        return this.stub;
    }

    public final ListExperimentsPagedResponse listExperiments(EnvironmentName parent) {
        ListExperimentsRequest request = ListExperimentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listExperiments(request);
    }

    public final ListExperimentsPagedResponse listExperiments(String parent) {
        ListExperimentsRequest request = ListExperimentsRequest.newBuilder().setParent(parent).build();
        return this.listExperiments(request);
    }

    public final ListExperimentsPagedResponse listExperiments(ListExperimentsRequest request) {
        return (ListExperimentsPagedResponse)((Object)this.listExperimentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListExperimentsRequest, ListExperimentsPagedResponse> listExperimentsPagedCallable() {
        return this.stub.listExperimentsPagedCallable();
    }

    public final UnaryCallable<ListExperimentsRequest, ListExperimentsResponse> listExperimentsCallable() {
        return this.stub.listExperimentsCallable();
    }

    public final Experiment getExperiment(ExperimentName name) {
        GetExperimentRequest request = GetExperimentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getExperiment(request);
    }

    public final Experiment getExperiment(String name) {
        GetExperimentRequest request = GetExperimentRequest.newBuilder().setName(name).build();
        return this.getExperiment(request);
    }

    public final Experiment getExperiment(GetExperimentRequest request) {
        return (Experiment)this.getExperimentCallable().call((Object)request);
    }

    public final UnaryCallable<GetExperimentRequest, Experiment> getExperimentCallable() {
        return this.stub.getExperimentCallable();
    }

    public final Experiment createExperiment(EnvironmentName parent, Experiment experiment) {
        CreateExperimentRequest request = CreateExperimentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setExperiment(experiment).build();
        return this.createExperiment(request);
    }

    public final Experiment createExperiment(String parent, Experiment experiment) {
        CreateExperimentRequest request = CreateExperimentRequest.newBuilder().setParent(parent).setExperiment(experiment).build();
        return this.createExperiment(request);
    }

    public final Experiment createExperiment(CreateExperimentRequest request) {
        return (Experiment)this.createExperimentCallable().call((Object)request);
    }

    public final UnaryCallable<CreateExperimentRequest, Experiment> createExperimentCallable() {
        return this.stub.createExperimentCallable();
    }

    public final Experiment updateExperiment(Experiment experiment, FieldMask updateMask) {
        UpdateExperimentRequest request = UpdateExperimentRequest.newBuilder().setExperiment(experiment).setUpdateMask(updateMask).build();
        return this.updateExperiment(request);
    }

    public final Experiment updateExperiment(UpdateExperimentRequest request) {
        return (Experiment)this.updateExperimentCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateExperimentRequest, Experiment> updateExperimentCallable() {
        return this.stub.updateExperimentCallable();
    }

    public final void deleteExperiment(ExperimentName name) {
        DeleteExperimentRequest request = DeleteExperimentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteExperiment(request);
    }

    public final void deleteExperiment(String name) {
        DeleteExperimentRequest request = DeleteExperimentRequest.newBuilder().setName(name).build();
        this.deleteExperiment(request);
    }

    public final void deleteExperiment(DeleteExperimentRequest request) {
        this.deleteExperimentCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteExperimentRequest, Empty> deleteExperimentCallable() {
        return this.stub.deleteExperimentCallable();
    }

    public final Experiment startExperiment(ExperimentName name) {
        StartExperimentRequest request = StartExperimentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.startExperiment(request);
    }

    public final Experiment startExperiment(String name) {
        StartExperimentRequest request = StartExperimentRequest.newBuilder().setName(name).build();
        return this.startExperiment(request);
    }

    public final Experiment startExperiment(StartExperimentRequest request) {
        return (Experiment)this.startExperimentCallable().call((Object)request);
    }

    public final UnaryCallable<StartExperimentRequest, Experiment> startExperimentCallable() {
        return this.stub.startExperimentCallable();
    }

    public final Experiment stopExperiment(ExperimentName name) {
        StopExperimentRequest request = StopExperimentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.stopExperiment(request);
    }

    public final Experiment stopExperiment(String name) {
        StopExperimentRequest request = StopExperimentRequest.newBuilder().setName(name).build();
        return this.stopExperiment(request);
    }

    public final Experiment stopExperiment(StopExperimentRequest request) {
        return (Experiment)this.stopExperimentCallable().call((Object)request);
    }

    public final UnaryCallable<StopExperimentRequest, Experiment> stopExperimentCallable() {
        return this.stub.stopExperimentCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListExperimentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListExperimentsRequest, ListExperimentsResponse, Experiment, ListExperimentsPage, ListExperimentsFixedSizeCollection> {
        private ListExperimentsFixedSizeCollection(List<ListExperimentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListExperimentsFixedSizeCollection createEmptyCollection() {
            return new ListExperimentsFixedSizeCollection(null, 0);
        }

        protected ListExperimentsFixedSizeCollection createCollection(List<ListExperimentsPage> pages, int collectionSize) {
            return new ListExperimentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListExperimentsPage
    extends AbstractPage<ListExperimentsRequest, ListExperimentsResponse, Experiment, ListExperimentsPage> {
        private ListExperimentsPage(PageContext<ListExperimentsRequest, ListExperimentsResponse, Experiment> context, ListExperimentsResponse response) {
            super(context, (Object)response);
        }

        private static ListExperimentsPage createEmptyPage() {
            return new ListExperimentsPage(null, null);
        }

        protected ListExperimentsPage createPage(PageContext<ListExperimentsRequest, ListExperimentsResponse, Experiment> context, ListExperimentsResponse response) {
            return new ListExperimentsPage(context, response);
        }

        public ApiFuture<ListExperimentsPage> createPageAsync(PageContext<ListExperimentsRequest, ListExperimentsResponse, Experiment> context, ApiFuture<ListExperimentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListExperimentsPagedResponse
    extends AbstractPagedListResponse<ListExperimentsRequest, ListExperimentsResponse, Experiment, ListExperimentsPage, ListExperimentsFixedSizeCollection> {
        public static ApiFuture<ListExperimentsPagedResponse> createAsync(PageContext<ListExperimentsRequest, ListExperimentsResponse, Experiment> context, ApiFuture<ListExperimentsResponse> futureResponse) {
            ApiFuture<ListExperimentsPage> futurePage = ListExperimentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListExperimentsPage, ListExperimentsPagedResponse>(){

                public ListExperimentsPagedResponse apply(ListExperimentsPage input) {
                    return new ListExperimentsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListExperimentsPagedResponse(ListExperimentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListExperimentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

