/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.CreatePlaybookRequest;
import com.google.cloud.dialogflow.cx.v3beta1.CreatePlaybookVersionRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeletePlaybookRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeletePlaybookVersionRequest;
import com.google.cloud.dialogflow.cx.v3beta1.GetPlaybookRequest;
import com.google.cloud.dialogflow.cx.v3beta1.GetPlaybookVersionRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListPlaybookVersionsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListPlaybookVersionsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.ListPlaybooksRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListPlaybooksResponse;
import com.google.cloud.dialogflow.cx.v3beta1.Playbook;
import com.google.cloud.dialogflow.cx.v3beta1.PlaybookVersion;
import com.google.cloud.dialogflow.cx.v3beta1.PlaybooksClient;
import com.google.cloud.dialogflow.cx.v3beta1.UpdatePlaybookRequest;
import com.google.cloud.dialogflow.cx.v3beta1.stub.GrpcPlaybooksStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.HttpJsonPlaybooksStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.PlaybooksStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class PlaybooksStubSettings
extends StubSettings<PlaybooksStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final UnaryCallSettings<CreatePlaybookRequest, Playbook> createPlaybookSettings;
    private final UnaryCallSettings<DeletePlaybookRequest, Empty> deletePlaybookSettings;
    private final PagedCallSettings<ListPlaybooksRequest, ListPlaybooksResponse, PlaybooksClient.ListPlaybooksPagedResponse> listPlaybooksSettings;
    private final UnaryCallSettings<GetPlaybookRequest, Playbook> getPlaybookSettings;
    private final UnaryCallSettings<UpdatePlaybookRequest, Playbook> updatePlaybookSettings;
    private final UnaryCallSettings<CreatePlaybookVersionRequest, PlaybookVersion> createPlaybookVersionSettings;
    private final UnaryCallSettings<GetPlaybookVersionRequest, PlaybookVersion> getPlaybookVersionSettings;
    private final PagedCallSettings<ListPlaybookVersionsRequest, ListPlaybookVersionsResponse, PlaybooksClient.ListPlaybookVersionsPagedResponse> listPlaybookVersionsSettings;
    private final UnaryCallSettings<DeletePlaybookVersionRequest, Empty> deletePlaybookVersionSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, PlaybooksClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListPlaybooksRequest, ListPlaybooksResponse, Playbook> LIST_PLAYBOOKS_PAGE_STR_DESC = new PagedListDescriptor<ListPlaybooksRequest, ListPlaybooksResponse, Playbook>(){

        public String emptyToken() {
            return "";
        }

        public ListPlaybooksRequest injectToken(ListPlaybooksRequest payload, String token) {
            return ListPlaybooksRequest.newBuilder((ListPlaybooksRequest)payload).setPageToken(token).build();
        }

        public ListPlaybooksRequest injectPageSize(ListPlaybooksRequest payload, int pageSize) {
            return ListPlaybooksRequest.newBuilder((ListPlaybooksRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPlaybooksRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPlaybooksResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Playbook> extractResources(ListPlaybooksResponse payload) {
            return payload.getPlaybooksList();
        }
    };
    private static final PagedListDescriptor<ListPlaybookVersionsRequest, ListPlaybookVersionsResponse, PlaybookVersion> LIST_PLAYBOOK_VERSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListPlaybookVersionsRequest, ListPlaybookVersionsResponse, PlaybookVersion>(){

        public String emptyToken() {
            return "";
        }

        public ListPlaybookVersionsRequest injectToken(ListPlaybookVersionsRequest payload, String token) {
            return ListPlaybookVersionsRequest.newBuilder((ListPlaybookVersionsRequest)payload).setPageToken(token).build();
        }

        public ListPlaybookVersionsRequest injectPageSize(ListPlaybookVersionsRequest payload, int pageSize) {
            return ListPlaybookVersionsRequest.newBuilder((ListPlaybookVersionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPlaybookVersionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPlaybookVersionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PlaybookVersion> extractResources(ListPlaybookVersionsResponse payload) {
            return payload.getPlaybookVersionsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListPlaybooksRequest, ListPlaybooksResponse, PlaybooksClient.ListPlaybooksPagedResponse> LIST_PLAYBOOKS_PAGE_STR_FACT = new PagedListResponseFactory<ListPlaybooksRequest, ListPlaybooksResponse, PlaybooksClient.ListPlaybooksPagedResponse>(){

        public ApiFuture<PlaybooksClient.ListPlaybooksPagedResponse> getFuturePagedResponse(UnaryCallable<ListPlaybooksRequest, ListPlaybooksResponse> callable, ListPlaybooksRequest request, ApiCallContext context, ApiFuture<ListPlaybooksResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PLAYBOOKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PlaybooksClient.ListPlaybooksPagedResponse.createAsync((PageContext<ListPlaybooksRequest, ListPlaybooksResponse, Playbook>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListPlaybookVersionsRequest, ListPlaybookVersionsResponse, PlaybooksClient.ListPlaybookVersionsPagedResponse> LIST_PLAYBOOK_VERSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListPlaybookVersionsRequest, ListPlaybookVersionsResponse, PlaybooksClient.ListPlaybookVersionsPagedResponse>(){

        public ApiFuture<PlaybooksClient.ListPlaybookVersionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListPlaybookVersionsRequest, ListPlaybookVersionsResponse> callable, ListPlaybookVersionsRequest request, ApiCallContext context, ApiFuture<ListPlaybookVersionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PLAYBOOK_VERSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PlaybooksClient.ListPlaybookVersionsPagedResponse.createAsync((PageContext<ListPlaybookVersionsRequest, ListPlaybookVersionsResponse, PlaybookVersion>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, PlaybooksClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, PlaybooksClient.ListLocationsPagedResponse>(){

        public ApiFuture<PlaybooksClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PlaybooksClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreatePlaybookRequest, Playbook> createPlaybookSettings() {
        return this.createPlaybookSettings;
    }

    public UnaryCallSettings<DeletePlaybookRequest, Empty> deletePlaybookSettings() {
        return this.deletePlaybookSettings;
    }

    public PagedCallSettings<ListPlaybooksRequest, ListPlaybooksResponse, PlaybooksClient.ListPlaybooksPagedResponse> listPlaybooksSettings() {
        return this.listPlaybooksSettings;
    }

    public UnaryCallSettings<GetPlaybookRequest, Playbook> getPlaybookSettings() {
        return this.getPlaybookSettings;
    }

    public UnaryCallSettings<UpdatePlaybookRequest, Playbook> updatePlaybookSettings() {
        return this.updatePlaybookSettings;
    }

    public UnaryCallSettings<CreatePlaybookVersionRequest, PlaybookVersion> createPlaybookVersionSettings() {
        return this.createPlaybookVersionSettings;
    }

    public UnaryCallSettings<GetPlaybookVersionRequest, PlaybookVersion> getPlaybookVersionSettings() {
        return this.getPlaybookVersionSettings;
    }

    public PagedCallSettings<ListPlaybookVersionsRequest, ListPlaybookVersionsResponse, PlaybooksClient.ListPlaybookVersionsPagedResponse> listPlaybookVersionsSettings() {
        return this.listPlaybookVersionsSettings;
    }

    public UnaryCallSettings<DeletePlaybookVersionRequest, Empty> deletePlaybookVersionSettings() {
        return this.deletePlaybookVersionSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, PlaybooksClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public PlaybooksStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcPlaybooksStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonPlaybooksStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "dialogflow";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dialogflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return PlaybooksStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PlaybooksStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PlaybooksStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return PlaybooksStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected PlaybooksStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createPlaybookSettings = settingsBuilder.createPlaybookSettings().build();
        this.deletePlaybookSettings = settingsBuilder.deletePlaybookSettings().build();
        this.listPlaybooksSettings = settingsBuilder.listPlaybooksSettings().build();
        this.getPlaybookSettings = settingsBuilder.getPlaybookSettings().build();
        this.updatePlaybookSettings = settingsBuilder.updatePlaybookSettings().build();
        this.createPlaybookVersionSettings = settingsBuilder.createPlaybookVersionSettings().build();
        this.getPlaybookVersionSettings = settingsBuilder.getPlaybookVersionSettings().build();
        this.listPlaybookVersionsSettings = settingsBuilder.listPlaybookVersionsSettings().build();
        this.deletePlaybookVersionSettings = settingsBuilder.deletePlaybookVersionSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<PlaybooksStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreatePlaybookRequest, Playbook> createPlaybookSettings;
        private final UnaryCallSettings.Builder<DeletePlaybookRequest, Empty> deletePlaybookSettings;
        private final PagedCallSettings.Builder<ListPlaybooksRequest, ListPlaybooksResponse, PlaybooksClient.ListPlaybooksPagedResponse> listPlaybooksSettings;
        private final UnaryCallSettings.Builder<GetPlaybookRequest, Playbook> getPlaybookSettings;
        private final UnaryCallSettings.Builder<UpdatePlaybookRequest, Playbook> updatePlaybookSettings;
        private final UnaryCallSettings.Builder<CreatePlaybookVersionRequest, PlaybookVersion> createPlaybookVersionSettings;
        private final UnaryCallSettings.Builder<GetPlaybookVersionRequest, PlaybookVersion> getPlaybookVersionSettings;
        private final PagedCallSettings.Builder<ListPlaybookVersionsRequest, ListPlaybookVersionsResponse, PlaybooksClient.ListPlaybookVersionsPagedResponse> listPlaybookVersionsSettings;
        private final UnaryCallSettings.Builder<DeletePlaybookVersionRequest, Empty> deletePlaybookVersionSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, PlaybooksClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createPlaybookSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deletePlaybookSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listPlaybooksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PLAYBOOKS_PAGE_STR_FACT);
            this.getPlaybookSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updatePlaybookSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createPlaybookVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getPlaybookVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listPlaybookVersionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PLAYBOOK_VERSIONS_PAGE_STR_FACT);
            this.deletePlaybookVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createPlaybookSettings, this.deletePlaybookSettings, this.listPlaybooksSettings, this.getPlaybookSettings, this.updatePlaybookSettings, this.createPlaybookVersionSettings, this.getPlaybookVersionSettings, this.listPlaybookVersionsSettings, this.deletePlaybookVersionSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(PlaybooksStubSettings settings) {
            super((StubSettings)settings);
            this.createPlaybookSettings = settings.createPlaybookSettings.toBuilder();
            this.deletePlaybookSettings = settings.deletePlaybookSettings.toBuilder();
            this.listPlaybooksSettings = settings.listPlaybooksSettings.toBuilder();
            this.getPlaybookSettings = settings.getPlaybookSettings.toBuilder();
            this.updatePlaybookSettings = settings.updatePlaybookSettings.toBuilder();
            this.createPlaybookVersionSettings = settings.createPlaybookVersionSettings.toBuilder();
            this.getPlaybookVersionSettings = settings.getPlaybookVersionSettings.toBuilder();
            this.listPlaybookVersionsSettings = settings.listPlaybookVersionsSettings.toBuilder();
            this.deletePlaybookVersionSettings = settings.deletePlaybookVersionSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createPlaybookSettings, this.deletePlaybookSettings, this.listPlaybooksSettings, this.getPlaybookSettings, this.updatePlaybookSettings, this.createPlaybookVersionSettings, this.getPlaybookVersionSettings, this.listPlaybookVersionsSettings, this.deletePlaybookVersionSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(PlaybooksStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)PlaybooksStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PlaybooksStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(PlaybooksStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)PlaybooksStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)PlaybooksStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PlaybooksStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(PlaybooksStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createPlaybookSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deletePlaybookSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listPlaybooksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getPlaybookSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updatePlaybookSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createPlaybookVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getPlaybookVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listPlaybookVersionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deletePlaybookVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreatePlaybookRequest, Playbook> createPlaybookSettings() {
            return this.createPlaybookSettings;
        }

        public UnaryCallSettings.Builder<DeletePlaybookRequest, Empty> deletePlaybookSettings() {
            return this.deletePlaybookSettings;
        }

        public PagedCallSettings.Builder<ListPlaybooksRequest, ListPlaybooksResponse, PlaybooksClient.ListPlaybooksPagedResponse> listPlaybooksSettings() {
            return this.listPlaybooksSettings;
        }

        public UnaryCallSettings.Builder<GetPlaybookRequest, Playbook> getPlaybookSettings() {
            return this.getPlaybookSettings;
        }

        public UnaryCallSettings.Builder<UpdatePlaybookRequest, Playbook> updatePlaybookSettings() {
            return this.updatePlaybookSettings;
        }

        public UnaryCallSettings.Builder<CreatePlaybookVersionRequest, PlaybookVersion> createPlaybookVersionSettings() {
            return this.createPlaybookVersionSettings;
        }

        public UnaryCallSettings.Builder<GetPlaybookVersionRequest, PlaybookVersion> getPlaybookVersionSettings() {
            return this.getPlaybookVersionSettings;
        }

        public PagedCallSettings.Builder<ListPlaybookVersionsRequest, ListPlaybookVersionsResponse, PlaybooksClient.ListPlaybookVersionsPagedResponse> listPlaybookVersionsSettings() {
            return this.listPlaybookVersionsSettings;
        }

        public UnaryCallSettings.Builder<DeletePlaybookVersionRequest, Empty> deletePlaybookVersionSettings() {
            return this.deletePlaybookVersionSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, PlaybooksClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public PlaybooksStubSettings build() throws IOException {
            return new PlaybooksStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

