/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3.CreatePageRequest;
import com.google.cloud.dialogflow.cx.v3.DeletePageRequest;
import com.google.cloud.dialogflow.cx.v3.GetPageRequest;
import com.google.cloud.dialogflow.cx.v3.ListPagesRequest;
import com.google.cloud.dialogflow.cx.v3.ListPagesResponse;
import com.google.cloud.dialogflow.cx.v3.Page;
import com.google.cloud.dialogflow.cx.v3.PagesClient;
import com.google.cloud.dialogflow.cx.v3.UpdatePageRequest;
import com.google.cloud.dialogflow.cx.v3.stub.GrpcPagesStub;
import com.google.cloud.dialogflow.cx.v3.stub.HttpJsonPagesStub;
import com.google.cloud.dialogflow.cx.v3.stub.PagesStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class PagesStubSettings
extends StubSettings<PagesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final PagedCallSettings<ListPagesRequest, ListPagesResponse, PagesClient.ListPagesPagedResponse> listPagesSettings;
    private final UnaryCallSettings<GetPageRequest, Page> getPageSettings;
    private final UnaryCallSettings<CreatePageRequest, Page> createPageSettings;
    private final UnaryCallSettings<UpdatePageRequest, Page> updatePageSettings;
    private final UnaryCallSettings<DeletePageRequest, Empty> deletePageSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, PagesClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListPagesRequest, ListPagesResponse, Page> LIST_PAGES_PAGE_STR_DESC = new PagedListDescriptor<ListPagesRequest, ListPagesResponse, Page>(){

        public String emptyToken() {
            return "";
        }

        public ListPagesRequest injectToken(ListPagesRequest payload, String token) {
            return ListPagesRequest.newBuilder((ListPagesRequest)payload).setPageToken(token).build();
        }

        public ListPagesRequest injectPageSize(ListPagesRequest payload, int pageSize) {
            return ListPagesRequest.newBuilder((ListPagesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPagesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPagesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Page> extractResources(ListPagesResponse payload) {
            return payload.getPagesList() == null ? ImmutableList.of() : payload.getPagesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListPagesRequest, ListPagesResponse, PagesClient.ListPagesPagedResponse> LIST_PAGES_PAGE_STR_FACT = new PagedListResponseFactory<ListPagesRequest, ListPagesResponse, PagesClient.ListPagesPagedResponse>(){

        public ApiFuture<PagesClient.ListPagesPagedResponse> getFuturePagedResponse(UnaryCallable<ListPagesRequest, ListPagesResponse> callable, ListPagesRequest request, ApiCallContext context, ApiFuture<ListPagesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PagesClient.ListPagesPagedResponse.createAsync((PageContext<ListPagesRequest, ListPagesResponse, Page>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, PagesClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, PagesClient.ListLocationsPagedResponse>(){

        public ApiFuture<PagesClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PagesClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListPagesRequest, ListPagesResponse, PagesClient.ListPagesPagedResponse> listPagesSettings() {
        return this.listPagesSettings;
    }

    public UnaryCallSettings<GetPageRequest, Page> getPageSettings() {
        return this.getPageSettings;
    }

    public UnaryCallSettings<CreatePageRequest, Page> createPageSettings() {
        return this.createPageSettings;
    }

    public UnaryCallSettings<UpdatePageRequest, Page> updatePageSettings() {
        return this.updatePageSettings;
    }

    public UnaryCallSettings<DeletePageRequest, Empty> deletePageSettings() {
        return this.deletePageSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, PagesClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public PagesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcPagesStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonPagesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "dialogflow";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dialogflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return PagesStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PagesStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PagesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return PagesStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected PagesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listPagesSettings = settingsBuilder.listPagesSettings().build();
        this.getPageSettings = settingsBuilder.getPageSettings().build();
        this.createPageSettings = settingsBuilder.createPageSettings().build();
        this.updatePageSettings = settingsBuilder.updatePageSettings().build();
        this.deletePageSettings = settingsBuilder.deletePageSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<PagesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListPagesRequest, ListPagesResponse, PagesClient.ListPagesPagedResponse> listPagesSettings;
        private final UnaryCallSettings.Builder<GetPageRequest, Page> getPageSettings;
        private final UnaryCallSettings.Builder<CreatePageRequest, Page> createPageSettings;
        private final UnaryCallSettings.Builder<UpdatePageRequest, Page> updatePageSettings;
        private final UnaryCallSettings.Builder<DeletePageRequest, Empty> deletePageSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, PagesClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listPagesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGES_PAGE_STR_FACT);
            this.getPageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createPageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updatePageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deletePageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listPagesSettings, this.getPageSettings, this.createPageSettings, this.updatePageSettings, this.deletePageSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(PagesStubSettings settings) {
            super((StubSettings)settings);
            this.listPagesSettings = settings.listPagesSettings.toBuilder();
            this.getPageSettings = settings.getPageSettings.toBuilder();
            this.createPageSettings = settings.createPageSettings.toBuilder();
            this.updatePageSettings = settings.updatePageSettings.toBuilder();
            this.deletePageSettings = settings.deletePageSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listPagesSettings, this.getPageSettings, this.createPageSettings, this.updatePageSettings, this.deletePageSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(PagesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)PagesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PagesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(PagesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)PagesStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)PagesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PagesStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(PagesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listPagesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getPageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createPageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updatePageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deletePageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListPagesRequest, ListPagesResponse, PagesClient.ListPagesPagedResponse> listPagesSettings() {
            return this.listPagesSettings;
        }

        public UnaryCallSettings.Builder<GetPageRequest, Page> getPageSettings() {
            return this.getPageSettings;
        }

        public UnaryCallSettings.Builder<CreatePageRequest, Page> createPageSettings() {
            return this.createPageSettings;
        }

        public UnaryCallSettings.Builder<UpdatePageRequest, Page> updatePageSettings() {
            return this.updatePageSettings;
        }

        public UnaryCallSettings.Builder<DeletePageRequest, Empty> deletePageSettings() {
            return this.deletePageSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, PagesClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public PagesStubSettings build() throws IOException {
            return new PagesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

