/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3.CreateEntityTypeRequest;
import com.google.cloud.dialogflow.cx.v3.DeleteEntityTypeRequest;
import com.google.cloud.dialogflow.cx.v3.EntityType;
import com.google.cloud.dialogflow.cx.v3.EntityTypesClient;
import com.google.cloud.dialogflow.cx.v3.ExportEntityTypesMetadata;
import com.google.cloud.dialogflow.cx.v3.ExportEntityTypesRequest;
import com.google.cloud.dialogflow.cx.v3.ExportEntityTypesResponse;
import com.google.cloud.dialogflow.cx.v3.GetEntityTypeRequest;
import com.google.cloud.dialogflow.cx.v3.ImportEntityTypesMetadata;
import com.google.cloud.dialogflow.cx.v3.ImportEntityTypesRequest;
import com.google.cloud.dialogflow.cx.v3.ImportEntityTypesResponse;
import com.google.cloud.dialogflow.cx.v3.ListEntityTypesRequest;
import com.google.cloud.dialogflow.cx.v3.ListEntityTypesResponse;
import com.google.cloud.dialogflow.cx.v3.UpdateEntityTypeRequest;
import com.google.cloud.dialogflow.cx.v3.stub.EntityTypesStub;
import com.google.cloud.dialogflow.cx.v3.stub.GrpcEntityTypesStub;
import com.google.cloud.dialogflow.cx.v3.stub.HttpJsonEntityTypesStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class EntityTypesStubSettings
extends StubSettings<EntityTypesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final UnaryCallSettings<GetEntityTypeRequest, EntityType> getEntityTypeSettings;
    private final UnaryCallSettings<CreateEntityTypeRequest, EntityType> createEntityTypeSettings;
    private final UnaryCallSettings<UpdateEntityTypeRequest, EntityType> updateEntityTypeSettings;
    private final UnaryCallSettings<DeleteEntityTypeRequest, Empty> deleteEntityTypeSettings;
    private final PagedCallSettings<ListEntityTypesRequest, ListEntityTypesResponse, EntityTypesClient.ListEntityTypesPagedResponse> listEntityTypesSettings;
    private final UnaryCallSettings<ExportEntityTypesRequest, Operation> exportEntityTypesSettings;
    private final OperationCallSettings<ExportEntityTypesRequest, ExportEntityTypesResponse, ExportEntityTypesMetadata> exportEntityTypesOperationSettings;
    private final UnaryCallSettings<ImportEntityTypesRequest, Operation> importEntityTypesSettings;
    private final OperationCallSettings<ImportEntityTypesRequest, ImportEntityTypesResponse, ImportEntityTypesMetadata> importEntityTypesOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, EntityTypesClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListEntityTypesRequest, ListEntityTypesResponse, EntityType> LIST_ENTITY_TYPES_PAGE_STR_DESC = new PagedListDescriptor<ListEntityTypesRequest, ListEntityTypesResponse, EntityType>(){

        public String emptyToken() {
            return "";
        }

        public ListEntityTypesRequest injectToken(ListEntityTypesRequest payload, String token) {
            return ListEntityTypesRequest.newBuilder((ListEntityTypesRequest)payload).setPageToken(token).build();
        }

        public ListEntityTypesRequest injectPageSize(ListEntityTypesRequest payload, int pageSize) {
            return ListEntityTypesRequest.newBuilder((ListEntityTypesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEntityTypesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEntityTypesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<EntityType> extractResources(ListEntityTypesResponse payload) {
            return payload.getEntityTypesList() == null ? ImmutableList.of() : payload.getEntityTypesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListEntityTypesRequest, ListEntityTypesResponse, EntityTypesClient.ListEntityTypesPagedResponse> LIST_ENTITY_TYPES_PAGE_STR_FACT = new PagedListResponseFactory<ListEntityTypesRequest, ListEntityTypesResponse, EntityTypesClient.ListEntityTypesPagedResponse>(){

        public ApiFuture<EntityTypesClient.ListEntityTypesPagedResponse> getFuturePagedResponse(UnaryCallable<ListEntityTypesRequest, ListEntityTypesResponse> callable, ListEntityTypesRequest request, ApiCallContext context, ApiFuture<ListEntityTypesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENTITY_TYPES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EntityTypesClient.ListEntityTypesPagedResponse.createAsync((PageContext<ListEntityTypesRequest, ListEntityTypesResponse, EntityType>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, EntityTypesClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, EntityTypesClient.ListLocationsPagedResponse>(){

        public ApiFuture<EntityTypesClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EntityTypesClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetEntityTypeRequest, EntityType> getEntityTypeSettings() {
        return this.getEntityTypeSettings;
    }

    public UnaryCallSettings<CreateEntityTypeRequest, EntityType> createEntityTypeSettings() {
        return this.createEntityTypeSettings;
    }

    public UnaryCallSettings<UpdateEntityTypeRequest, EntityType> updateEntityTypeSettings() {
        return this.updateEntityTypeSettings;
    }

    public UnaryCallSettings<DeleteEntityTypeRequest, Empty> deleteEntityTypeSettings() {
        return this.deleteEntityTypeSettings;
    }

    public PagedCallSettings<ListEntityTypesRequest, ListEntityTypesResponse, EntityTypesClient.ListEntityTypesPagedResponse> listEntityTypesSettings() {
        return this.listEntityTypesSettings;
    }

    public UnaryCallSettings<ExportEntityTypesRequest, Operation> exportEntityTypesSettings() {
        return this.exportEntityTypesSettings;
    }

    public OperationCallSettings<ExportEntityTypesRequest, ExportEntityTypesResponse, ExportEntityTypesMetadata> exportEntityTypesOperationSettings() {
        return this.exportEntityTypesOperationSettings;
    }

    public UnaryCallSettings<ImportEntityTypesRequest, Operation> importEntityTypesSettings() {
        return this.importEntityTypesSettings;
    }

    public OperationCallSettings<ImportEntityTypesRequest, ImportEntityTypesResponse, ImportEntityTypesMetadata> importEntityTypesOperationSettings() {
        return this.importEntityTypesOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, EntityTypesClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public EntityTypesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcEntityTypesStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonEntityTypesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "dialogflow";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dialogflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return EntityTypesStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EntityTypesStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EntityTypesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return EntityTypesStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected EntityTypesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getEntityTypeSettings = settingsBuilder.getEntityTypeSettings().build();
        this.createEntityTypeSettings = settingsBuilder.createEntityTypeSettings().build();
        this.updateEntityTypeSettings = settingsBuilder.updateEntityTypeSettings().build();
        this.deleteEntityTypeSettings = settingsBuilder.deleteEntityTypeSettings().build();
        this.listEntityTypesSettings = settingsBuilder.listEntityTypesSettings().build();
        this.exportEntityTypesSettings = settingsBuilder.exportEntityTypesSettings().build();
        this.exportEntityTypesOperationSettings = settingsBuilder.exportEntityTypesOperationSettings().build();
        this.importEntityTypesSettings = settingsBuilder.importEntityTypesSettings().build();
        this.importEntityTypesOperationSettings = settingsBuilder.importEntityTypesOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<EntityTypesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetEntityTypeRequest, EntityType> getEntityTypeSettings;
        private final UnaryCallSettings.Builder<CreateEntityTypeRequest, EntityType> createEntityTypeSettings;
        private final UnaryCallSettings.Builder<UpdateEntityTypeRequest, EntityType> updateEntityTypeSettings;
        private final UnaryCallSettings.Builder<DeleteEntityTypeRequest, Empty> deleteEntityTypeSettings;
        private final PagedCallSettings.Builder<ListEntityTypesRequest, ListEntityTypesResponse, EntityTypesClient.ListEntityTypesPagedResponse> listEntityTypesSettings;
        private final UnaryCallSettings.Builder<ExportEntityTypesRequest, Operation> exportEntityTypesSettings;
        private final OperationCallSettings.Builder<ExportEntityTypesRequest, ExportEntityTypesResponse, ExportEntityTypesMetadata> exportEntityTypesOperationSettings;
        private final UnaryCallSettings.Builder<ImportEntityTypesRequest, Operation> importEntityTypesSettings;
        private final OperationCallSettings.Builder<ImportEntityTypesRequest, ImportEntityTypesResponse, ImportEntityTypesMetadata> importEntityTypesOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, EntityTypesClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getEntityTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEntityTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateEntityTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEntityTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listEntityTypesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENTITY_TYPES_PAGE_STR_FACT);
            this.exportEntityTypesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportEntityTypesOperationSettings = OperationCallSettings.newBuilder();
            this.importEntityTypesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importEntityTypesOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getEntityTypeSettings, this.createEntityTypeSettings, this.updateEntityTypeSettings, this.deleteEntityTypeSettings, this.listEntityTypesSettings, this.exportEntityTypesSettings, this.importEntityTypesSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(EntityTypesStubSettings settings) {
            super((StubSettings)settings);
            this.getEntityTypeSettings = settings.getEntityTypeSettings.toBuilder();
            this.createEntityTypeSettings = settings.createEntityTypeSettings.toBuilder();
            this.updateEntityTypeSettings = settings.updateEntityTypeSettings.toBuilder();
            this.deleteEntityTypeSettings = settings.deleteEntityTypeSettings.toBuilder();
            this.listEntityTypesSettings = settings.listEntityTypesSettings.toBuilder();
            this.exportEntityTypesSettings = settings.exportEntityTypesSettings.toBuilder();
            this.exportEntityTypesOperationSettings = settings.exportEntityTypesOperationSettings.toBuilder();
            this.importEntityTypesSettings = settings.importEntityTypesSettings.toBuilder();
            this.importEntityTypesOperationSettings = settings.importEntityTypesOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getEntityTypeSettings, this.createEntityTypeSettings, this.updateEntityTypeSettings, this.deleteEntityTypeSettings, this.listEntityTypesSettings, this.exportEntityTypesSettings, this.importEntityTypesSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(EntityTypesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)EntityTypesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EntityTypesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EntityTypesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)EntityTypesStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)EntityTypesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EntityTypesStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EntityTypesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getEntityTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createEntityTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateEntityTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteEntityTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listEntityTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.exportEntityTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.importEntityTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.exportEntityTypesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ExportEntityTypesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ExportEntityTypesMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.importEntityTypesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ImportEntityTypesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ImportEntityTypesMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetEntityTypeRequest, EntityType> getEntityTypeSettings() {
            return this.getEntityTypeSettings;
        }

        public UnaryCallSettings.Builder<CreateEntityTypeRequest, EntityType> createEntityTypeSettings() {
            return this.createEntityTypeSettings;
        }

        public UnaryCallSettings.Builder<UpdateEntityTypeRequest, EntityType> updateEntityTypeSettings() {
            return this.updateEntityTypeSettings;
        }

        public UnaryCallSettings.Builder<DeleteEntityTypeRequest, Empty> deleteEntityTypeSettings() {
            return this.deleteEntityTypeSettings;
        }

        public PagedCallSettings.Builder<ListEntityTypesRequest, ListEntityTypesResponse, EntityTypesClient.ListEntityTypesPagedResponse> listEntityTypesSettings() {
            return this.listEntityTypesSettings;
        }

        public UnaryCallSettings.Builder<ExportEntityTypesRequest, Operation> exportEntityTypesSettings() {
            return this.exportEntityTypesSettings;
        }

        public OperationCallSettings.Builder<ExportEntityTypesRequest, ExportEntityTypesResponse, ExportEntityTypesMetadata> exportEntityTypesOperationSettings() {
            return this.exportEntityTypesOperationSettings;
        }

        public UnaryCallSettings.Builder<ImportEntityTypesRequest, Operation> importEntityTypesSettings() {
            return this.importEntityTypesSettings;
        }

        public OperationCallSettings.Builder<ImportEntityTypesRequest, ImportEntityTypesResponse, ImportEntityTypesMetadata> importEntityTypesOperationSettings() {
            return this.importEntityTypesOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, EntityTypesClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public EntityTypesStubSettings build() throws IOException {
            return new EntityTypesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

