/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.CreateWebhookRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeleteWebhookRequest;
import com.google.cloud.dialogflow.cx.v3beta1.GetWebhookRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListWebhooksRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListWebhooksResponse;
import com.google.cloud.dialogflow.cx.v3beta1.UpdateWebhookRequest;
import com.google.cloud.dialogflow.cx.v3beta1.Webhook;
import com.google.cloud.dialogflow.cx.v3beta1.WebhooksClient;
import com.google.cloud.dialogflow.cx.v3beta1.stub.GrpcWebhooksStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.HttpJsonWebhooksStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.WebhooksStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class WebhooksStubSettings
extends StubSettings<WebhooksStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final PagedCallSettings<ListWebhooksRequest, ListWebhooksResponse, WebhooksClient.ListWebhooksPagedResponse> listWebhooksSettings;
    private final UnaryCallSettings<GetWebhookRequest, Webhook> getWebhookSettings;
    private final UnaryCallSettings<CreateWebhookRequest, Webhook> createWebhookSettings;
    private final UnaryCallSettings<UpdateWebhookRequest, Webhook> updateWebhookSettings;
    private final UnaryCallSettings<DeleteWebhookRequest, Empty> deleteWebhookSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, WebhooksClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListWebhooksRequest, ListWebhooksResponse, Webhook> LIST_WEBHOOKS_PAGE_STR_DESC = new PagedListDescriptor<ListWebhooksRequest, ListWebhooksResponse, Webhook>(){

        public String emptyToken() {
            return "";
        }

        public ListWebhooksRequest injectToken(ListWebhooksRequest payload, String token) {
            return ListWebhooksRequest.newBuilder((ListWebhooksRequest)payload).setPageToken(token).build();
        }

        public ListWebhooksRequest injectPageSize(ListWebhooksRequest payload, int pageSize) {
            return ListWebhooksRequest.newBuilder((ListWebhooksRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListWebhooksRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListWebhooksResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Webhook> extractResources(ListWebhooksResponse payload) {
            return payload.getWebhooksList() == null ? ImmutableList.of() : payload.getWebhooksList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListWebhooksRequest, ListWebhooksResponse, WebhooksClient.ListWebhooksPagedResponse> LIST_WEBHOOKS_PAGE_STR_FACT = new PagedListResponseFactory<ListWebhooksRequest, ListWebhooksResponse, WebhooksClient.ListWebhooksPagedResponse>(){

        public ApiFuture<WebhooksClient.ListWebhooksPagedResponse> getFuturePagedResponse(UnaryCallable<ListWebhooksRequest, ListWebhooksResponse> callable, ListWebhooksRequest request, ApiCallContext context, ApiFuture<ListWebhooksResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_WEBHOOKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return WebhooksClient.ListWebhooksPagedResponse.createAsync((PageContext<ListWebhooksRequest, ListWebhooksResponse, Webhook>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, WebhooksClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, WebhooksClient.ListLocationsPagedResponse>(){

        public ApiFuture<WebhooksClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return WebhooksClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListWebhooksRequest, ListWebhooksResponse, WebhooksClient.ListWebhooksPagedResponse> listWebhooksSettings() {
        return this.listWebhooksSettings;
    }

    public UnaryCallSettings<GetWebhookRequest, Webhook> getWebhookSettings() {
        return this.getWebhookSettings;
    }

    public UnaryCallSettings<CreateWebhookRequest, Webhook> createWebhookSettings() {
        return this.createWebhookSettings;
    }

    public UnaryCallSettings<UpdateWebhookRequest, Webhook> updateWebhookSettings() {
        return this.updateWebhookSettings;
    }

    public UnaryCallSettings<DeleteWebhookRequest, Empty> deleteWebhookSettings() {
        return this.deleteWebhookSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, WebhooksClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public WebhooksStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcWebhooksStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonWebhooksStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return WebhooksStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "dialogflow";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dialogflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return WebhooksStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(WebhooksStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(WebhooksStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return WebhooksStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected WebhooksStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listWebhooksSettings = settingsBuilder.listWebhooksSettings().build();
        this.getWebhookSettings = settingsBuilder.getWebhookSettings().build();
        this.createWebhookSettings = settingsBuilder.createWebhookSettings().build();
        this.updateWebhookSettings = settingsBuilder.updateWebhookSettings().build();
        this.deleteWebhookSettings = settingsBuilder.deleteWebhookSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<WebhooksStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListWebhooksRequest, ListWebhooksResponse, WebhooksClient.ListWebhooksPagedResponse> listWebhooksSettings;
        private final UnaryCallSettings.Builder<GetWebhookRequest, Webhook> getWebhookSettings;
        private final UnaryCallSettings.Builder<CreateWebhookRequest, Webhook> createWebhookSettings;
        private final UnaryCallSettings.Builder<UpdateWebhookRequest, Webhook> updateWebhookSettings;
        private final UnaryCallSettings.Builder<DeleteWebhookRequest, Empty> deleteWebhookSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, WebhooksClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listWebhooksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_WEBHOOKS_PAGE_STR_FACT);
            this.getWebhookSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createWebhookSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateWebhookSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteWebhookSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listWebhooksSettings, this.getWebhookSettings, this.createWebhookSettings, this.updateWebhookSettings, this.deleteWebhookSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(WebhooksStubSettings settings) {
            super((StubSettings)settings);
            this.listWebhooksSettings = settings.listWebhooksSettings.toBuilder();
            this.getWebhookSettings = settings.getWebhookSettings.toBuilder();
            this.createWebhookSettings = settings.createWebhookSettings.toBuilder();
            this.updateWebhookSettings = settings.updateWebhookSettings.toBuilder();
            this.deleteWebhookSettings = settings.deleteWebhookSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listWebhooksSettings, this.getWebhookSettings, this.createWebhookSettings, this.updateWebhookSettings, this.deleteWebhookSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(WebhooksStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)WebhooksStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)WebhooksStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(WebhooksStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)WebhooksStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)WebhooksStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)WebhooksStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(WebhooksStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listWebhooksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getWebhookSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createWebhookSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateWebhookSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteWebhookSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListWebhooksRequest, ListWebhooksResponse, WebhooksClient.ListWebhooksPagedResponse> listWebhooksSettings() {
            return this.listWebhooksSettings;
        }

        public UnaryCallSettings.Builder<GetWebhookRequest, Webhook> getWebhookSettings() {
            return this.getWebhookSettings;
        }

        public UnaryCallSettings.Builder<CreateWebhookRequest, Webhook> createWebhookSettings() {
            return this.createWebhookSettings;
        }

        public UnaryCallSettings.Builder<UpdateWebhookRequest, Webhook> updateWebhookSettings() {
            return this.updateWebhookSettings;
        }

        public UnaryCallSettings.Builder<DeleteWebhookRequest, Empty> deleteWebhookSettings() {
            return this.deleteWebhookSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, WebhooksClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return WebhooksStubSettings.getDefaultEndpoint();
        }

        public WebhooksStubSettings build() throws IOException {
            return new WebhooksStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

