/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.AgentName;
import com.google.cloud.dialogflow.cx.v3beta1.CreateGeneratorRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeleteGeneratorRequest;
import com.google.cloud.dialogflow.cx.v3beta1.Generator;
import com.google.cloud.dialogflow.cx.v3beta1.GeneratorName;
import com.google.cloud.dialogflow.cx.v3beta1.GeneratorsSettings;
import com.google.cloud.dialogflow.cx.v3beta1.GetGeneratorRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListGeneratorsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListGeneratorsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.UpdateGeneratorRequest;
import com.google.cloud.dialogflow.cx.v3beta1.stub.GeneratorsStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.GeneratorsStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GeneratorsClient
implements BackgroundResource {
    private final GeneratorsSettings settings;
    private final GeneratorsStub stub;

    public static final GeneratorsClient create() throws IOException {
        return GeneratorsClient.create(GeneratorsSettings.newBuilder().build());
    }

    public static final GeneratorsClient create(GeneratorsSettings settings) throws IOException {
        return new GeneratorsClient(settings);
    }

    public static final GeneratorsClient create(GeneratorsStub stub) {
        return new GeneratorsClient(stub);
    }

    protected GeneratorsClient(GeneratorsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GeneratorsStubSettings)settings.getStubSettings()).createStub();
    }

    protected GeneratorsClient(GeneratorsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final GeneratorsSettings getSettings() {
        return this.settings;
    }

    public GeneratorsStub getStub() {
        return this.stub;
    }

    public final ListGeneratorsPagedResponse listGenerators(AgentName parent) {
        ListGeneratorsRequest request = ListGeneratorsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGenerators(request);
    }

    public final ListGeneratorsPagedResponse listGenerators(String parent) {
        ListGeneratorsRequest request = ListGeneratorsRequest.newBuilder().setParent(parent).build();
        return this.listGenerators(request);
    }

    public final ListGeneratorsPagedResponse listGenerators(ListGeneratorsRequest request) {
        return (ListGeneratorsPagedResponse)((Object)this.listGeneratorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGeneratorsRequest, ListGeneratorsPagedResponse> listGeneratorsPagedCallable() {
        return this.stub.listGeneratorsPagedCallable();
    }

    public final UnaryCallable<ListGeneratorsRequest, ListGeneratorsResponse> listGeneratorsCallable() {
        return this.stub.listGeneratorsCallable();
    }

    public final Generator getGenerator(GeneratorName name) {
        GetGeneratorRequest request = GetGeneratorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGenerator(request);
    }

    public final Generator getGenerator(String name) {
        GetGeneratorRequest request = GetGeneratorRequest.newBuilder().setName(name).build();
        return this.getGenerator(request);
    }

    public final Generator getGenerator(GetGeneratorRequest request) {
        return (Generator)this.getGeneratorCallable().call((Object)request);
    }

    public final UnaryCallable<GetGeneratorRequest, Generator> getGeneratorCallable() {
        return this.stub.getGeneratorCallable();
    }

    public final Generator createGenerator(AgentName parent, Generator generator) {
        CreateGeneratorRequest request = CreateGeneratorRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setGenerator(generator).build();
        return this.createGenerator(request);
    }

    public final Generator createGenerator(String parent, Generator generator) {
        CreateGeneratorRequest request = CreateGeneratorRequest.newBuilder().setParent(parent).setGenerator(generator).build();
        return this.createGenerator(request);
    }

    public final Generator createGenerator(CreateGeneratorRequest request) {
        return (Generator)this.createGeneratorCallable().call((Object)request);
    }

    public final UnaryCallable<CreateGeneratorRequest, Generator> createGeneratorCallable() {
        return this.stub.createGeneratorCallable();
    }

    public final Generator updateGenerator(Generator generator, FieldMask updateMask) {
        UpdateGeneratorRequest request = UpdateGeneratorRequest.newBuilder().setGenerator(generator).setUpdateMask(updateMask).build();
        return this.updateGenerator(request);
    }

    public final Generator updateGenerator(UpdateGeneratorRequest request) {
        return (Generator)this.updateGeneratorCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateGeneratorRequest, Generator> updateGeneratorCallable() {
        return this.stub.updateGeneratorCallable();
    }

    public final void deleteGenerator(GeneratorName name) {
        DeleteGeneratorRequest request = DeleteGeneratorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteGenerator(request);
    }

    public final void deleteGenerator(String name) {
        DeleteGeneratorRequest request = DeleteGeneratorRequest.newBuilder().setName(name).build();
        this.deleteGenerator(request);
    }

    public final void deleteGenerator(DeleteGeneratorRequest request) {
        this.deleteGeneratorCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteGeneratorRequest, Empty> deleteGeneratorCallable() {
        return this.stub.deleteGeneratorCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListGeneratorsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGeneratorsRequest, ListGeneratorsResponse, Generator, ListGeneratorsPage, ListGeneratorsFixedSizeCollection> {
        private ListGeneratorsFixedSizeCollection(List<ListGeneratorsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGeneratorsFixedSizeCollection createEmptyCollection() {
            return new ListGeneratorsFixedSizeCollection(null, 0);
        }

        protected ListGeneratorsFixedSizeCollection createCollection(List<ListGeneratorsPage> pages, int collectionSize) {
            return new ListGeneratorsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGeneratorsPage
    extends AbstractPage<ListGeneratorsRequest, ListGeneratorsResponse, Generator, ListGeneratorsPage> {
        private ListGeneratorsPage(PageContext<ListGeneratorsRequest, ListGeneratorsResponse, Generator> context, ListGeneratorsResponse response) {
            super(context, (Object)response);
        }

        private static ListGeneratorsPage createEmptyPage() {
            return new ListGeneratorsPage(null, null);
        }

        protected ListGeneratorsPage createPage(PageContext<ListGeneratorsRequest, ListGeneratorsResponse, Generator> context, ListGeneratorsResponse response) {
            return new ListGeneratorsPage(context, response);
        }

        public ApiFuture<ListGeneratorsPage> createPageAsync(PageContext<ListGeneratorsRequest, ListGeneratorsResponse, Generator> context, ApiFuture<ListGeneratorsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGeneratorsPagedResponse
    extends AbstractPagedListResponse<ListGeneratorsRequest, ListGeneratorsResponse, Generator, ListGeneratorsPage, ListGeneratorsFixedSizeCollection> {
        public static ApiFuture<ListGeneratorsPagedResponse> createAsync(PageContext<ListGeneratorsRequest, ListGeneratorsResponse, Generator> context, ApiFuture<ListGeneratorsResponse> futureResponse) {
            ApiFuture<ListGeneratorsPage> futurePage = ListGeneratorsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListGeneratorsPagedResponse((ListGeneratorsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListGeneratorsPagedResponse(ListGeneratorsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGeneratorsFixedSizeCollection.createEmptyCollection());
        }
    }
}

