/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3.DetectIntentRequest;
import com.google.cloud.dialogflow.cx.v3.DetectIntentResponse;
import com.google.cloud.dialogflow.cx.v3.FulfillIntentRequest;
import com.google.cloud.dialogflow.cx.v3.FulfillIntentResponse;
import com.google.cloud.dialogflow.cx.v3.MatchIntentRequest;
import com.google.cloud.dialogflow.cx.v3.MatchIntentResponse;
import com.google.cloud.dialogflow.cx.v3.SessionsSettings;
import com.google.cloud.dialogflow.cx.v3.StreamingDetectIntentRequest;
import com.google.cloud.dialogflow.cx.v3.StreamingDetectIntentResponse;
import com.google.cloud.dialogflow.cx.v3.stub.SessionsStub;
import com.google.cloud.dialogflow.cx.v3.stub.SessionsStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class SessionsClient
implements BackgroundResource {
    private final SessionsSettings settings;
    private final SessionsStub stub;

    public static final SessionsClient create() throws IOException {
        return SessionsClient.create(SessionsSettings.newBuilder().build());
    }

    public static final SessionsClient create(SessionsSettings settings) throws IOException {
        return new SessionsClient(settings);
    }

    public static final SessionsClient create(SessionsStub stub) {
        return new SessionsClient(stub);
    }

    protected SessionsClient(SessionsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SessionsStubSettings)settings.getStubSettings()).createStub();
    }

    protected SessionsClient(SessionsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SessionsSettings getSettings() {
        return this.settings;
    }

    public SessionsStub getStub() {
        return this.stub;
    }

    public final DetectIntentResponse detectIntent(DetectIntentRequest request) {
        return (DetectIntentResponse)this.detectIntentCallable().call((Object)request);
    }

    public final UnaryCallable<DetectIntentRequest, DetectIntentResponse> detectIntentCallable() {
        return this.stub.detectIntentCallable();
    }

    public final BidiStreamingCallable<StreamingDetectIntentRequest, StreamingDetectIntentResponse> streamingDetectIntentCallable() {
        return this.stub.streamingDetectIntentCallable();
    }

    public final MatchIntentResponse matchIntent(MatchIntentRequest request) {
        return (MatchIntentResponse)this.matchIntentCallable().call((Object)request);
    }

    public final UnaryCallable<MatchIntentRequest, MatchIntentResponse> matchIntentCallable() {
        return this.stub.matchIntentCallable();
    }

    public final FulfillIntentResponse fulfillIntent(FulfillIntentRequest request) {
        return (FulfillIntentResponse)this.fulfillIntentCallable().call((Object)request);
    }

    public final UnaryCallable<FulfillIntentRequest, FulfillIntentResponse> fulfillIntentCallable() {
        return this.stub.fulfillIntentCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

